/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.grid;

import ca.infodata.ofys.ui.controls.grid.Cell;
import ca.infodata.ofys.ui.controls.grid.GridData;
import ca.infodata.ofys.ui.controls.grid.GridDataListener;
import ca.infodata.ofys.ui.controls.grid.GridSelection;
import ca.infodata.ofys.ui.controls.grid.Selection;
import ca.infodata.util1.IntegerRange;
import ca.infodata.util1.RangeNotation;
import java.util.ArrayList;
import java.util.List;

public final class DefaultGridData
implements GridData<Cell> {
    private int absoluteStartLine;
    private int absoluteEndLine;
    private int absoluteStartColumn;
    private int absoluteEndColumn;
    private List<GridDataListener> listeners = new ArrayList<GridDataListener>();
    private Selection<Cell> selection;

    public DefaultGridData(int nbLine, int nbColumn) {
        assert (nbLine > 0 && nbColumn > 0);
        this.absoluteStartLine = 0;
        this.absoluteEndLine = nbLine - 1;
        this.absoluteStartColumn = 0;
        this.absoluteEndColumn = nbColumn - 1;
        this.selection = new GridSelection<Cell>(this);
    }

    @Override
    public void addListener(GridDataListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(GridDataListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Cell getCell(int column, int line) {
        return new Cell(column, line);
    }

    @Override
    public void pushStartLine() {
        this.absoluteStartLine -= 10;
        this.absoluteEndLine -= 10;
        for (GridDataListener listener : this.listeners) {
            listener.linePushed(true, true);
        }
    }

    @Override
    public void pushEndLine() {
        this.absoluteStartLine += 10;
        this.absoluteEndLine += 10;
        for (GridDataListener listener : this.listeners) {
            listener.linePushed(true, true);
        }
    }

    @Override
    public void pushStartColumn() {
        this.absoluteStartColumn -= 10;
        this.absoluteEndColumn -= 10;
        for (GridDataListener listener : this.listeners) {
            listener.columnPushed(true, true);
        }
    }

    @Override
    public void pushEndColumn() {
        this.absoluteStartColumn += 10;
        this.absoluteEndColumn += 10;
        for (GridDataListener listener : this.listeners) {
            listener.columnPushed(true, true);
        }
    }

    @Override
    public int getAbsoluteEndColumn() {
        return this.absoluteEndColumn;
    }

    @Override
    public int getAbsoluteEndLine() {
        return this.absoluteEndLine;
    }

    @Override
    public int getAbsoluteStartColumn() {
        return this.absoluteStartColumn;
    }

    @Override
    public int getAbsoluteStartLine() {
        return this.absoluteStartLine;
    }

    @Override
    public int getColumnWidth(int column) {
        return 75;
    }

    @Override
    public int getLineHeigth(int line) {
        return 75;
    }

    @Override
    public int getSumColumnWidth(int startColumn, int endColumn) {
        return (endColumn - startColumn) * 75;
    }

    @Override
    public int getSumLineHeigth(int startLine, int endLine) {
        return (endLine - startLine) * 75;
    }

    @Override
    public Selection<Cell> getSelection() {
        return this.selection;
    }

    @Override
    public boolean contains(Cell cell) {
        return cell != null && new IntegerRange(Integer.valueOf(this.absoluteStartLine), Integer.valueOf(this.absoluteEndLine), RangeNotation.CLOSED).contains((Comparable)Integer.valueOf(cell.line)) && new IntegerRange(Integer.valueOf(this.absoluteStartColumn), Integer.valueOf(this.absoluteEndColumn), RangeNotation.CLOSED).contains((Comparable)Integer.valueOf(cell.column));
    }
}

