/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.grid;

public class Cell
implements Comparable<Cell> {
    public static final String TYPE = "normal";
    private int hashCode = 0;
    public final int line;
    public final int column;
    public final int spanx;
    public final int spany;
    private String type;

    public Cell(Cell cell) {
        this(cell.column, cell.line, cell.spanx, cell.spany, cell.type);
    }

    public Cell(int column, int line) {
        this(column, line, 1, 1, TYPE);
    }

    public Cell(int column, int line, int spanx, int spany, String type) {
        this.line = line;
        this.column = column;
        this.type = type;
        this.spanx = spanx;
        this.spany = spany;
    }

    @Override
    public int compareTo(Cell otherCell) {
        if (this.getLine() == otherCell.getLine()) {
            return this.getColumn() - otherCell.getColumn();
        }
        return this.getLine() - otherCell.getLine();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 1;
            result = 31 * result + this.getColumn();
            this.hashCode = result = 31 * result + this.getLine();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)obj;
        if (this.getColumn() != other.getColumn()) {
            return false;
        }
        return this.getLine() == other.getLine();
    }

    public String toString() {
        String simpleName = this.getClass().getSimpleName();
        if (simpleName.length() == 0) {
            simpleName = "Cell";
        }
        return String.format("%s (%d,%d)", simpleName, this.getColumn(), this.getLine());
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

