/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.form;

import ca.infodata.ofys.ui.controls.form.MyText;
import ca.infodata.ofys.util.MiscUtil;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ComplexNumberText
extends MyText {
    private Pattern pattern;
    private Integer precision;
    private Integer scale;
    private Double scalePow;
    private boolean allowNegative = true;

    private static Pattern computePattern(Integer precision, Integer scale, boolean allowNegative) {
        String format = allowNegative ? "^(-?\\d{0,%s}(\\.\\d{0,%s}))?|(-?\\d{0,%s}(\\.\\d{0,%s})?)$" : "^(\\d{0,%s}(\\.\\d{0,%s}))?|(\\d{0,%s}(\\.\\d{0,%s})?)$";
        String spattern = String.format(format, precision == null ? "" : precision, scale == null ? "" : scale, precision == null ? "" : precision, scale == null ? "" : scale);
        return Pattern.compile(spattern);
    }

    public ComplexNumberText(Composite parent, int style) {
        super(parent, style);
        this.setMaximumToDouble();
        this.computePattern();
        this.addVerifyListener(new PatternVerifyListener());
    }

    public ComplexNumberText(Composite parent, int style, FormToolkit formToolkit) {
        super(parent, null, style, formToolkit);
        this.setMaximumToDouble();
        this.computePattern();
        this.addVerifyListener(new PatternVerifyListener());
    }

    public void setMaximumToFloat() {
        this.setPrecision(Integer.MAX_VALUE);
    }

    public void setMaximumToDouble() {
        this.setPrecision(Integer.MAX_VALUE);
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
        this.computePattern();
    }

    private void computePattern() {
        this.pattern = ComplexNumberText.computePattern(this.precision, this.scale, this.allowNegative);
    }

    public void setScale(Integer scale) {
        this.scale = scale;
        this.scalePow = scale == null ? null : Double.valueOf(Math.pow(10.0, this.scale.intValue()));
        this.computePattern();
    }

    public void setAllowNegative(boolean allowNegative) {
        this.allowNegative = allowNegative;
        this.computePattern();
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public boolean getAllowNegative() {
        return this.allowNegative;
    }

    public void setNumber(Number number) {
        this.setNumber(number, false, true);
    }

    public void setNumberKeepSelection(Number number) {
        this.setNumber(number, true, false);
    }

    private void setNumber(Number number, boolean keepSelection, boolean force) {
        if ((number = this.fixNumber(number)) == null) {
            this.clear();
        } else if (force || this.isNumberDifferentFrom(number)) {
            Point oldSelection = this.getSelection();
            this.selectAll();
            this.setText(number.toString());
            if (keepSelection) {
                this.setSelection(oldSelection);
            }
        }
    }

    private boolean isNumberDifferentFrom(Number number) {
        return !MiscUtil.areObjectsEquals((Object)this.getNumber(), (Object)number);
    }

    private Number fixNumber(Number number) {
        if (number == null) {
            return null;
        }
        if (number instanceof Double || number instanceof Float || number instanceof BigDecimal) {
            double d = number.doubleValue();
            if (!this.allowNegative && d < 0.0) {
                return null;
            }
            if (this.scale == null) {
                return number;
            }
            if (this.scale != null && this.scalePow != null) {
                return (double)Math.round(d * this.scalePow) / this.scalePow;
            }
        }
        return number;
    }

    public Double getNumber() {
        String text = this.getText();
        if (this.pattern.matcher(text).matches()) {
            try {
                return Double.parseDouble(text);
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        Pattern pattern = ComplexNumberText.computePattern(null, null, true);
        ComplexNumberText.testTrue(pattern, "12");
        ComplexNumberText.testTrue(pattern, "-12");
        ComplexNumberText.testTrue(pattern, "-1.2");
        ComplexNumberText.testTrue(pattern, "1.2");
        ComplexNumberText.testTrue(pattern, "0.2");
        ComplexNumberText.testTrue(pattern, "-0.2");
        ComplexNumberText.testTrue(pattern, "-.2");
        ComplexNumberText.testTrue(pattern, ".2");
        ComplexNumberText.testTrue(pattern, "1.");
        ComplexNumberText.testTrue(pattern, "-1.");
        ComplexNumberText.testTrue(pattern, "-9999999999999999999999999999999999999999999999999999999999999999.99999999999999999999999999999999999999999");
        ComplexNumberText.testTrue(pattern, "9999999999999999999999999999999999999999999999999999999999999999.99999999999999999999999999999999999999999");
        ComplexNumberText.testFalse(pattern, "+1");
        ComplexNumberText.testFalse(pattern, "--1");
        ComplexNumberText.testFalse(pattern, "1..2");
        ComplexNumberText.testFalse(pattern, "1.2-");
        ComplexNumberText.testFalse(pattern, "1 2");
        pattern = ComplexNumberText.computePattern(null, null, false);
        ComplexNumberText.testFalse(pattern, "-12");
        ComplexNumberText.testFalse(pattern, "-1.2");
        ComplexNumberText.testFalse(pattern, "-0.2");
        ComplexNumberText.testFalse(pattern, "-.2");
        ComplexNumberText.testFalse(pattern, "-1.");
        pattern = ComplexNumberText.computePattern(2, 2, false);
        ComplexNumberText.testTrue(pattern, "12");
        ComplexNumberText.testTrue(pattern, "1.0");
        ComplexNumberText.testTrue(pattern, "0.1");
        ComplexNumberText.testTrue(pattern, ".11");
        ComplexNumberText.testTrue(pattern, "11.");
        ComplexNumberText.testTrue(pattern, "11.11");
        ComplexNumberText.testFalse(pattern, "111");
        ComplexNumberText.testFalse(pattern, "111.0");
        ComplexNumberText.testFalse(pattern, "0.111");
        ComplexNumberText.testFalse(pattern, ".111");
        ComplexNumberText.testFalse(pattern, "111.");
        ComplexNumberText.testFalse(pattern, "111.111");
        ComplexNumberText.testFalse(pattern, "11.111");
        ComplexNumberText.testFalse(pattern, "111.11");
        pattern = ComplexNumberText.computePattern(null, null, true);
        ComplexNumberText.testFalse(pattern, "27.777779249497462.1");
        pattern = ComplexNumberText.computePattern(6, 0, false);
        ComplexNumberText.testFalse(pattern, "1234567");
        ComplexNumberText.testFalse(pattern, "123456.1");
        ComplexNumberText.testFalse(pattern, "12345.1");
        ComplexNumberText.testFalse(pattern, "0.1");
        ComplexNumberText.testTrue(pattern, "123456");
        ComplexNumberText.testTrue(pattern, "12345");
        ComplexNumberText.testTrue(pattern, "0");
        pattern = ComplexNumberText.computePattern(4, 0, false);
        ComplexNumberText.testFalse(pattern, "12345");
        ComplexNumberText.testFalse(pattern, "123456.1");
        ComplexNumberText.testFalse(pattern, "12345.1");
        ComplexNumberText.testFalse(pattern, "0.1");
        ComplexNumberText.testTrue(pattern, "1234");
        ComplexNumberText.testTrue(pattern, "123");
        ComplexNumberText.testTrue(pattern, "12");
        ComplexNumberText.testTrue(pattern, "1");
        ComplexNumberText.testTrue(pattern, "0");
        pattern = ComplexNumberText.computePattern(6, 0, true);
        ComplexNumberText.testFalse(pattern, "-1234567");
        ComplexNumberText.testFalse(pattern, "1234567");
        ComplexNumberText.testFalse(pattern, "-123456.1");
        ComplexNumberText.testFalse(pattern, "123456.1");
        ComplexNumberText.testFalse(pattern, "12345.1");
        ComplexNumberText.testFalse(pattern, "-12345.1");
        ComplexNumberText.testFalse(pattern, "-0.1");
        ComplexNumberText.testFalse(pattern, "0.1");
        ComplexNumberText.testTrue(pattern, "123456");
        ComplexNumberText.testTrue(pattern, "-123456");
        ComplexNumberText.testTrue(pattern, "12345");
        ComplexNumberText.testTrue(pattern, "-12345");
        ComplexNumberText.testTrue(pattern, "0");
        pattern = ComplexNumberText.computePattern(4, 0, true);
        ComplexNumberText.testFalse(pattern, "12345");
        ComplexNumberText.testFalse(pattern, "-12345");
        ComplexNumberText.testFalse(pattern, "123456.1");
        ComplexNumberText.testFalse(pattern, "-123456.1");
        ComplexNumberText.testFalse(pattern, "12345.1");
        ComplexNumberText.testFalse(pattern, "-12345.1");
        ComplexNumberText.testFalse(pattern, "0.1");
        ComplexNumberText.testFalse(pattern, "-0.1");
        ComplexNumberText.testTrue(pattern, "1234");
        ComplexNumberText.testTrue(pattern, "-1234");
        ComplexNumberText.testTrue(pattern, "123");
        ComplexNumberText.testTrue(pattern, "-123");
        ComplexNumberText.testTrue(pattern, "12");
        ComplexNumberText.testTrue(pattern, "-12");
        ComplexNumberText.testTrue(pattern, "1");
        ComplexNumberText.testTrue(pattern, "-1");
        ComplexNumberText.testTrue(pattern, "0");
    }

    private static void testFalse(Pattern pattern, String input) {
        if (pattern.matcher(input).matches()) {
            System.err.println("Test failed. expected false but was true for input " + input);
        }
    }

    private static void testTrue(Pattern pattern, String input) {
        if (!pattern.matcher(input).matches()) {
            System.err.println("Test failed. expected true but was false for input " + input);
        }
    }

    private final class PatternVerifyListener
    implements VerifyListener {
        private PatternVerifyListener() {
        }

        public void verifyText(VerifyEvent event) {
            Point selection = ComplexNumberText.this.getSelection();
            String text = new StringBuilder(ComplexNumberText.this.getText()).replace(selection.x, selection.y, event.text).toString();
            event.doit = ComplexNumberText.this.pattern.matcher(text).matches();
        }
    }
}

