/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls.calendar.grid;

import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.text.ParseException;

final class BufferedLocalDateParser {
    private final StringBuilder buffer = new StringBuilder();

    public void feed(char c) {
        if (StringUtils.isNumeric((char)c)) {
            this.buffer.append(c);
        }
    }

    public LocalDate parseAndReset(LocalDate completionDate) {
        if (completionDate == null) {
            throw new IllegalArgumentException("completionDate cant be null");
        }
        LocalDate date = null;
        if (this.buffer.length() > 0) {
            date = BufferedLocalDateParser.parse(this.buffer.toString(), completionDate);
            this.reset();
        }
        return date;
    }

    private static LocalDate parse(String source, LocalDate completionDate) {
        LocalDate date = null;
        String pattern = BufferedLocalDateParser.guessPattern(source);
        if (pattern != null) {
            String completedSource = BufferedLocalDateParser.completeSource(source, pattern, completionDate);
            try {
                date = LocalDateFormat.parse((String)completedSource, (String)pattern);
            }
            catch (ParseException parseException) {}
        }
        return date;
    }

    private static String guessPattern(String source) {
        int length = source.length();
        if (length <= 6) {
            return "yyMMdd";
        }
        if (length <= 8) {
            return "yyyyMMdd";
        }
        return null;
    }

    private static String completeSource(String source, String pattern, LocalDate completionDate) {
        if (source.length() < 2) {
            source = "0" + source;
        }
        String formattedDate = LocalDateFormat.format((LocalDate)completionDate, (String)pattern);
        return String.valueOf(formattedDate.substring(0, formattedDate.length() - source.length())) + source;
    }

    public void reset() {
        this.buffer.setLength(0);
    }

    public String getBuffer() {
        return this.buffer.toString();
    }
}

