/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.controls;

import ca.infodata.ofys.ui.library.IRefreshFont;
import ca.infodata.ofys.ui.library.ResourceGetter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class FontAwareComposite
extends Composite
implements IRefreshFont {
    private int fontSizeIncrement = 0;
    private int fontStyle = 0;

    public FontAwareComposite(Composite parent, int style) {
        super(parent, style);
        this.setFont(this.fontSizeIncrement, this.fontStyle);
    }

    public void setFont(int fontSizeIncrement, int fontStyle) {
        this.fontSizeIncrement = fontSizeIncrement;
        this.fontStyle = fontStyle;
        this.setFont(ResourceGetter.getFont((int)fontSizeIncrement, (int)fontStyle));
    }

    public void refreshFont() {
        Control[] children = this.getChildren();
        this.setFont(this.fontSizeIncrement, this.fontStyle);
        FontAwareComposite.refreshFont(children);
    }

    public static void refreshFont(Control[] children) {
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            FontAwareComposite.refreshFont(c);
            ++n2;
        }
    }

    public static void refreshFont(Control c) {
        if (c instanceof StyledText) {
            Integer fontSizeIncrement = (Integer)c.getData("fontSizeIncrement");
            fontSizeIncrement = fontSizeIncrement == null ? 0 : fontSizeIncrement;
            Integer fontStyle = (Integer)c.getData("fontStyle");
            fontStyle = fontStyle == null ? 0 : fontStyle;
            c.setFont(ResourceGetter.getFont((int)fontSizeIncrement, (int)fontStyle));
        } else if (c instanceof IRefreshFont) {
            ((IRefreshFont)c).refreshFont();
        } else if (c instanceof Tree) {
            c.setFont(ResourceGetter.getFontNormal());
        } else if (c instanceof Table) {
            c.setFont(ResourceGetter.getFontNormal());
        } else if (c instanceof Composite) {
            FontAwareComposite.refreshFont(((Composite)c).getChildren());
        }
    }
}

