/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.browser.sonar;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class JettyServerRequest {
    private HttpServletRequest request;
    private Map<String, String> params;
    private Map<String, byte[]> parts;

    public JettyServerRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void parseMultipartFormData() throws Exception {
        String contentType = this.request.getContentType();
        if (contentType != null && contentType.toLowerCase().startsWith("multipart/form-data")) {
            this.parts = new HashMap<String, byte[]>();
            ServletInputStream inputStream = this.request.getInputStream();
            String boundary = this.extractBoundary(contentType);
            if (boundary == null) {
                throw new RuntimeException("No boundary found in content type: " + contentType);
            }
            this.parseParts((InputStream)inputStream, boundary);
        }
    }

    private String extractBoundary(String contentType) {
        int boundaryIndex = contentType.indexOf("boundary=");
        if (boundaryIndex != -1) {
            return contentType.substring(boundaryIndex + 9);
        }
        return null;
    }

    public void parseParts(InputStream inputStream, String boundary) throws Exception {
        byte[] content;
        int b;
        byte[] boundaryBytes = ("\r\n--" + boundary).getBytes();
        byte[] endBoundaryBytes = ("\r\n--" + boundary + "--\r\n").getBytes();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StringBuilder headerBuffer = new StringBuilder();
        boolean inPart = false;
        boolean inHeaders = true;
        String currentName = null;
        while ((b = inputStream.read()) != -1) {
            if (inPart) {
                buffer.write(b);
                if (buffer.size() >= endBoundaryBytes.length && this.startsWith(buffer.toByteArray(), endBoundaryBytes)) {
                    inPart = false;
                    inHeaders = true;
                    currentName = null;
                    buffer.reset();
                    continue;
                }
                if (buffer.size() < boundaryBytes.length || !this.startsWith(buffer.toByteArray(), boundaryBytes)) continue;
                content = new byte[buffer.size() - boundaryBytes.length];
                System.arraycopy(buffer.toByteArray(), 0, content, 0, content.length);
                this.parts.put(currentName, content);
                inPart = false;
                inHeaders = true;
                currentName = null;
                buffer.reset();
                continue;
            }
            if (inHeaders) {
                if (b == 10) {
                    int nameIndex;
                    String headerLine = headerBuffer.toString().trim();
                    if (headerLine.isEmpty()) {
                        inHeaders = false;
                        inPart = true;
                        buffer.reset();
                    } else if (headerLine.startsWith("Content-Disposition:") && (nameIndex = headerLine.indexOf("name=\"")) != -1) {
                        currentName = headerLine.substring(nameIndex + 6, headerLine.indexOf(34, nameIndex + 7));
                    }
                    headerBuffer.setLength(0);
                    continue;
                }
                headerBuffer.append((char)b);
                continue;
            }
            buffer.write(b);
        }
        if (inPart && buffer.size() > 0) {
            content = new byte[buffer.size()];
            System.arraycopy(buffer.toByteArray(), 0, content, 0, content.length);
            this.parts.put(currentName, content);
        }
    }

    private boolean startsWith(byte[] array, byte[] prefix) {
        if (array.length < prefix.length) {
            return false;
        }
        int i = 0;
        while (i < prefix.length) {
            if (array[i] != prefix[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Map<String, byte[]> getParts() {
        if (this.parts == null) {
            try {
                this.parseMultipartFormData();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.parts;
    }
}

