/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.b2b.simple;

import ca.infodata.ofys.data.dataaccess.callback.Callback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.util1.ClosureA;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClosureACallback<A>
extends Callback {
    private static final Logger logger = Logger.getLogger(ClosureACallback.class.getName());
    private ClosureA<A> onSuccess;
    private ClosureA<Throwable> onError;

    public ClosureACallback(ClosureA<A> onSuccess, ClosureA<Throwable> onError) {
        super(new IStatusHandler(){

            public IStatusHandler.State handle(IStatus status) {
                return IStatusHandler.State.HANDLED;
            }
        });
        this.onSuccess = onSuccess;
        this.onError = onError;
    }

    protected boolean handleStatus(ReturnObject response) {
        return true;
    }

    public void responseReceived(ReturnObject response) {
        try {
            MultiStatus status = response.getStatus();
            if (status.isOkToProceed()) {
                this.onSuccess.execute(response.getObj());
            } else {
                this.onError.execute((Object)new StatusException((IStatus)status));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error", e);
            this.onError.execute((Object)e);
        }
    }

    public void exception(Exception e) {
        this.onError.execute((Object)e);
    }
}

