/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.search;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.AppointmentAccessorClient;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriodType;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XSearchPeriodCriteria;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XSearchPeriodResult;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.control.StatisticCellRenderer;
import ca.infodata.ofys.ui.appointment.search.ISearchController;
import ca.infodata.ofys.ui.intro.DefaultStatusHandler;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SimpleSearchController
implements ISearchController {
    public static final int PROP_PROF = 0;
    public static final int PROP_SITE = 1;
    private XBaseProfessionnal professionnal;
    private XSite site;
    private List<XSearchPeriodResult> results = new CopyOnWriteArrayList<XSearchPeriodResult>();

    public XBaseProfessionnal getProfessionnal() {
        return this.professionnal;
    }

    public void setProfessionnal(XBaseProfessionnal professionnal) {
        this.professionnal = professionnal;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)0);
    }

    public XSite getSite() {
        return this.site;
    }

    public void setSite(XSite site) {
        this.site = site;
        PropertyListenerManager.firePropertyChanged((Object)this, (int)1);
    }

    @Override
    public void searchAsync() {
        this.searchAsync(this.getSearchPeriodCriteria());
    }

    public void searchAsyncFiltre() {
        XSearchPeriodCriteria c = this.getSearchPeriodCriteria();
        int[] excludedPeriodTypesPref = StatisticCellRenderer.getExcludedPeriodTypesPref();
        List<XAppointmentPeriodType> types = AppointmentPlugin.getDefault().getPeriodTypes();
        c.periodTypes = new ArrayList(types.size());
        for (XAppointmentPeriodType p : types) {
            c.periodTypes.add(p.getId());
        }
        for (XAppointmentPeriodType type : types) {
            int[] nArray = excludedPeriodTypesPref;
            int n = excludedPeriodTypesPref.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (type.getId() == i) {
                    c.periodTypes.remove(new Integer(i));
                }
                ++n2;
            }
        }
        this.searchAsync(c);
    }

    public void searchAsync(XSearchPeriodCriteria c) {
        JobCallback callback = new JobCallback(Messages.getString((String)"RECHERCHE", (String[])new String[0]), (IStatusHandler)DefaultStatusHandler.getInstance()){

            public void responseReceived(ReturnObject response) {
                List list = null;
                if (response != null) {
                    list = (List)response.getObj();
                }
                SimpleSearchController.this.results.clear();
                if (list != null) {
                    SimpleSearchController.this.results.addAll(list);
                }
                PropertyListenerManager.firePropertyChanged((Object)SimpleSearchController.this, (int)10);
            }

            public void exception(Exception e) {
                super.exception(e);
                SimpleSearchController.this.results.clear();
                PropertyListenerManager.firePropertyChanged((Object)SimpleSearchController.this, (int)10);
            }
        };
        try {
            AppointmentAccessorClient.getInstance().findAvailableAppointmentSpaces(c, this.hashCode(), Application.get().getGlobalInstances().getSession(), (ICallback)callback);
        }
        catch (Exception exception) {
            callback.kill();
        }
    }

    private XSearchPeriodCriteria getSearchPeriodCriteria() {
        XSearchPeriodCriteria c = new XSearchPeriodCriteria();
        if (this.professionnal != null) {
            c.professionnals = new ArrayList(1);
            c.professionnals.add(this.professionnal.getId());
        }
        if (this.site != null) {
            c.sites = new ArrayList(1);
            c.sites.add(this.site.getId());
        }
        c.fromDate = this.getFromDate();
        c.fromDateAfterHour = DateUtil.getMinutesFromMidnight();
        return c;
    }

    @Override
    public List<XSearchPeriodResult> getResult() {
        return new ArrayList<XSearchPeriodResult>(this.results);
    }

    public LocalDate getFromDate() {
        return LocalDate.today();
    }
}

