/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.search;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XSearchPeriodResult;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.mb.listener.property.IPropertyListener;
import ca.infodata.ofys.mb.listener.property.PropertyListenerManager;
import ca.infodata.ofys.ui.appointment.search.ComplexSearchControl;
import ca.infodata.ofys.ui.appointment.search.ComplexSearchController;
import ca.infodata.ofys.ui.appointment.search.ISearchController;
import ca.infodata.ofys.ui.appointment.search.SimpleSearchControl;
import ca.infodata.ofys.ui.appointment.search.SimpleSearchController;
import ca.infodata.ofys.ui.controls.FontAwareList;
import ca.infodata.ofys.ui.controls.FontAwareSection;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.ofys.ui.site.SitePlugin;
import ca.infodata.util1.date.DateUtil;
import ca.infodata.util1.date.LocalDate;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SearchComposite
extends Composite {
    private SimpleSearchController simpleController;
    private ComplexSearchController complexController;
    private SimpleSearchControl simpleSearchControl;
    private ComplexSearchControl complexSearchControl;
    private ControllerListener simpleControllerListener;
    private ControllerListener complexcControllerListener;
    private org.eclipse.swt.widgets.List listResult;
    private XSearchPeriodResult[] results = new XSearchPeriodResult[0];

    public SearchComposite(Composite parent, int style, FormToolkit toolkit) {
        super(parent, style);
        toolkit.adapt((Composite)this);
        FontAwareSection sectionSimple = new FontAwareSection((Composite)this, 2, toolkit);
        sectionSimple.setText(Messages.getString((String)"RECHERCHE_SIMPLE", (String[])new String[0]));
        toolkit.createCompositeSeparator((Composite)sectionSimple);
        this.simpleSearchControl = new SimpleSearchControl((Composite)sectionSimple, 0, toolkit);
        sectionSimple.setClient((Control)this.simpleSearchControl);
        FontAwareSection sectionComplex = new FontAwareSection((Composite)this, 2, toolkit);
        sectionComplex.setText(Messages.getString((String)"RECHERCHE_ELABOREE", (String[])new String[0]));
        toolkit.createCompositeSeparator((Composite)sectionComplex);
        this.complexSearchControl = new ComplexSearchControl((Composite)sectionComplex, 0, toolkit);
        sectionComplex.setClient((Control)this.complexSearchControl);
        Composite resultControl = toolkit.createComposite((Composite)this, 0);
        this.listResult = new FontAwareList(resultControl, 2816);
        resultControl.setLayout((Layout)new FillLayout());
        FormLayout layout = new FormLayout();
        layout.spacing = 5;
        this.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        sectionSimple.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)sectionSimple);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        sectionComplex.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)sectionComplex);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        resultControl.setLayoutData((Object)data);
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                SearchComposite.this.simpleSearchControl.layout(true);
            }
        });
    }

    public SimpleSearchController getSimpleController() {
        return this.simpleController;
    }

    public void setSimpleController(SimpleSearchController controller) {
        if (this.simpleController == null) {
            PropertyListenerManager.removeListener((IPropertyListener)this.simpleControllerListener);
        }
        this.simpleController = controller;
        if (this.simpleControllerListener == null) {
            this.simpleControllerListener = new ControllerListener();
        }
        this.simpleControllerListener.controller = controller;
        this.simpleSearchControl.setController(controller);
        PropertyListenerManager.addListener((Object)controller, (IPropertyListener)this.simpleControllerListener);
    }

    public ComplexSearchController getComplexController() {
        return this.complexController;
    }

    public void setComplexController(ComplexSearchController controller) {
        if (this.complexController == null) {
            PropertyListenerManager.removeListener((IPropertyListener)this.complexcControllerListener);
        }
        this.complexController = controller;
        if (this.complexcControllerListener == null) {
            this.complexcControllerListener = new ControllerListener();
        }
        this.complexcControllerListener.controller = controller;
        this.complexSearchControl.setController(controller);
        PropertyListenerManager.addListener((Object)controller, (IPropertyListener)this.complexcControllerListener);
    }

    public void refreshResults(List<XSearchPeriodResult> list) {
        int size = list.size();
        this.results = new XSearchPeriodResult[list == null ? 0 : size];
        String[] items = new String[list == null ? 0 : size];
        if (list != null) {
            PersonUiPlugin personPlugin = PersonUiPlugin.getDefault();
            int i = 0;
            while (i < size) {
                XSite site;
                XSearchPeriodResult r;
                this.results[i] = r = list.get(i);
                LocalDate date = LocalDate.fromDayFrom1970((int)r.date);
                String start = DateUtil.convertTimeToString((Short)r.startTime, (Character)Character.valueOf('h'));
                XBaseProfessionnal professionnal = personPlugin.getBaseProfessionnal(Integer.valueOf(r.idProfessionnal));
                String text = "Le " + date.formatTextual() + " \u00e0 " + start;
                if (professionnal != null) {
                    text = String.valueOf(text) + " (" + professionnal.getName() + ")";
                }
                if ((site = SitePlugin.getDefault().getSite(Integer.valueOf(r.idSite))) != null) {
                    text = String.valueOf(text) + " | " + site.getNameCommon();
                }
                items[i] = text;
                ++i;
            }
        }
        this.listResult.setItems(items);
    }

    public org.eclipse.swt.widgets.List getListResultControl() {
        return this.listResult;
    }

    public XSearchPeriodResult getResult(int i) {
        return this.results[i];
    }

    private class ControllerListener
    implements IPropertyListener {
        ISearchController controller;

        private ControllerListener() {
        }

        public void propertyChanged(int propertyId) {
            if (propertyId == 10) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchComposite.this.refreshResults(ControllerListener.this.controller.getResult());
                    }
                });
            }
        }
    }
}

