/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.menu;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.XImageDecorator;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XPatientStatus;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.preferences.FormatDateProvider;
import ca.infodata.ofys.mb.listener.property.IPropertyListener2;
import ca.infodata.ofys.ui.appointment.AppointmentPlugin;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerAdapter;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerListener;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.appointment.menu.AppointmentElementController;
import ca.infodata.ofys.ui.appointment.menu.AppointmentElements;
import ca.infodata.ofys.ui.appointment.menu.AppointmentTextElement;
import ca.infodata.ofys.ui.controls.BaseView;
import ca.infodata.ofys.ui.controls.ITreeElements;
import ca.infodata.ofys.ui.controls.IUserInteractionHelper;
import ca.infodata.ofys.ui.controls.JustLogUserInteractionHelper;
import ca.infodata.ofys.ui.library.IPastilleInfo;
import ca.infodata.ofys.ui.library.ResourceGetter;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.menu.DossierPlugin;
import ca.infodata.ofys.ui.menu.treeelements.LoadingElement;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocalDate;
import ca.infodata.util1.date.LocalDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;

public class ListTodayAppointments
implements ITreeElements,
IPropertyListener2,
IPastilleInfo,
IFontProvider {
    private static final Logger logger = Logger.getLogger(ListTodayAppointments.class.getName());
    private static final String RENDEZVOUS_DU_ = Messages.getString((String)"RENDEZVOUS_DU_", (String[])new String[0]);
    private XBaseProfessionnal professional;
    private ITreeElements[] children;
    private boolean isLoading;
    private boolean usingTabletPerspective;
    private AppointmentMainController controller;
    private AppointmentControllerListener controllerListener;
    public int childrenNumber = -1;

    public ListTodayAppointments(ITreeElements parent, XBaseProfessionnal prof) {
        if (prof == null || parent == null) {
            throw new IllegalArgumentException();
        }
        this.childrenNumber = -1;
        IWorkbenchPage page = BaseView.getPage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        this.usingTabletPerspective = perspective != null && perspective.getId().equals("ca.infodata.ofys.ui.menu.EncounterPerspective");
        this.professional = prof;
        this.buildController();
        if (this.usingTabletPerspective) {
            this.getChildren();
        }
    }

    private void buildController() {
        Log.logOperation((String)"AppointmentMainEditorInpu.buildController", (Object[])new Object[]{this});
        if (this.controller == null) {
            XBaseProfessionnal professionnal = this.professional;
            if (professionnal == null) {
                professionnal = this.getDefaultProfessional();
            }
            if (professionnal != null) {
                this.controller = new AppointmentMainController("ListTodayAppointments" + System.currentTimeMillis(), LocalDate.today(), professionnal.getId(), (IUserInteractionHelper)new JustLogUserInteractionHelper());
                this.controllerListener = new AppointmentControllerListenerImplementation();
                this.controller.addListener(this.controllerListener);
            }
        }
    }

    private XBaseProfessionnal getDefaultProfessional() {
        XBaseProfessionnal prof = PersonUiPlugin.getDefault().getSessionProfessionnal();
        if (prof != null && !prof.useAppointment) {
            prof = null;
        }
        return prof;
    }

    public Object[] getChildren() {
        if (this.notLoaded()) {
            this.fillAsLoading();
        }
        return this.children;
    }

    private void fillAsLoading() {
        this.isLoading = true;
        this.children = new ITreeElements[]{new LoadingElement((ITreeElements)this)};
        this.findTodayAppointmentsByProfessional();
    }

    private boolean notLoaded() {
        return this.children == null || this.isLoading;
    }

    private void findTodayAppointmentsByProfessional() {
        try {
            this.fill((List<? extends IAppointment>)this.controller.getAppointments(this.controller.getAppointmentDate(LocalDate.today())));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Erreur", e);
            this.fill(Collections.emptyList());
        }
    }

    private void fill(List<? extends IAppointment> appointments) {
        Collections.sort(appointments, AppointmentPlugin.getDefault().getXAppointmentComparator(false));
        ArrayList<Object> listChild = new ArrayList<Object>(appointments.size());
        boolean isPm = false;
        boolean isSoir = false;
        int nbApptActif = 0;
        for (IAppointment iAppointment : appointments) {
            String tooltip;
            String text;
            if (XPatientStatus.CANCEL.equals((Object)iAppointment.getPatientStatus()) || XPatientStatus.CANCEL_LESS_24H.equals((Object)iAppointment.getPatientStatus()) || iAppointment.getIsDeleted().booleanValue()) continue;
            ++nbApptActif;
            if (iAppointment.getStartTime().intValue() >= 720 && !isPm) {
                isPm = true;
                text = "--- " + Messages.getString((String)"APRES_MIDI", (String[])new String[0]) + " ---";
                tooltip = "...";
                listChild.add(new AppointmentTextElement(this, text, tooltip));
            }
            if (iAppointment.getStartTime().intValue() >= 1080 && !isSoir) {
                isSoir = true;
                text = "--- " + Messages.getString((String)"SOIREE", (String[])new String[0]) + " ---";
                tooltip = "...";
                listChild.add(new AppointmentTextElement(this, text, tooltip));
            }
            listChild.add(new AppointmentElements(this, new AppointmentElementController(this.controller, iAppointment)));
        }
        this.children = listChild.toArray(new ITreeElements[listChild.size()]);
        this.childrenNumber = nbApptActif;
        this.refreshTree(true);
        this.isLoading = false;
    }

    private void refreshTree(final boolean doExpand) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer treeViewer = DossierPlugin.getDefault().getTreeViewer();
                Tree tree = treeViewer.getTree();
                if (tree != null && !tree.isDisposed()) {
                    treeViewer.refresh((Object)ListTodayAppointments.this);
                    if (doExpand) {
                        treeViewer.setExpandedState((Object)ListTodayAppointments.this, true);
                    }
                }
            }
        });
    }

    public Object getParent() {
        return null;
    }

    public boolean hasChildren() {
        return true;
    }

    public String getText() {
        return String.valueOf(RENDEZVOUS_DU_) + LocalDateFormat.format((LocalDate)LocalDate.today(), (String)FormatDateProvider.getFormatDate().toString());
    }

    public String getTooltipText() {
        return this.getText();
    }

    public Image getImage() {
        return ResourceGetter.getImage((String)"images/rendez-vous.gif");
    }

    public XImageDecorator getDecorators() {
        return XImageDecorator.NULL_DECORATORS;
    }

    public void showContextMenu(Control control) {
    }

    public int hashCode() {
        return new String(this.getClass().getName()).hashCode();
    }

    public boolean equals(Object toCompare) {
        boolean ret = false;
        if (toCompare instanceof ListTodayAppointments && toCompare.hashCode() == this.hashCode()) {
            ret = true;
        }
        return ret;
    }

    public void doKeyListener(Control control, KeyEvent ke) {
    }

    public void propertyChanged(int propertyId, Object arg) {
        if (propertyId == 1 && arg instanceof IAppointment) {
            IAppointment appt = (IAppointment)arg;
            System.out.println("PROP_APPOINTMENT_NOTIFICATION: " + appt);
        }
    }

    public String getEditorClass() {
        return null;
    }

    public IEditorInput getEditorInput() {
        return null;
    }

    public int getChildrenNumberForPastille() {
        return this.childrenNumber;
    }

    public Font getFont(Object element) {
        return ResourceGetter.getFontNormal();
    }

    private final class AppointmentControllerListenerImplementation
    extends AppointmentControllerAdapter {
        private AppointmentControllerListenerImplementation() {
        }

        @Override
        public void currentAppointmentChanged(IAppointment appt) {
            this.refresh(appt);
        }

        private void refresh(final IAppointment appt) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    boolean expanded = DossierPlugin.getDefault().getTreeViewer().getExpandedState((Object)ListTodayAppointments.this);
                    if (expanded) {
                        IEditableDataObjectList<? extends IAppointment> appointments = ListTodayAppointments.this.controller.getAppointments(ListTodayAppointments.this.controller.getAppointmentDate(LocalDate.today()));
                        Collections.sort(appointments, AppointmentPlugin.getDefault().getXAppointmentComparator(false));
                        try {
                            ListTodayAppointments.this.fill(ListTodayAppointments.this.controller.getAppointments(ListTodayAppointments.this.controller.getAppointmentDate(LocalDate.today())));
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Error on currentAppointmentChangedEvent. " + StringUtils.safeToString((Logger)logger, (Object)appt), e);
                            ListTodayAppointments.this.fill(new ArrayList(0));
                        }
                    } else {
                        ListTodayAppointments.this.children = null;
                        ListTodayAppointments.this.refreshTree(false);
                    }
                }
            });
        }

        @Override
        public void appointmentsChanged() {
            this.refresh(null);
        }
    }
}

