/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor.controller;

import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDate;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IMinimalEditableDataObject;
import ca.infodata.ofys.ui.appointment.editor.controller.ConcurrentList;
import ca.infodata.util1.ClosureA;
import ca.infodata.util1.ClosureAR;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public class XObjectContainer2
implements Serializable {
    private static final Logger logger = Logger.getLogger(XObjectContainer2.class.getName());
    private static final long serialVersionUID = 1L;
    private final ConcurrentList<IMinimalEditableDataObject> list = new ConcurrentList(new ArrayList());

    public boolean replace(IMinimalEditableDataObject e) {
        int index = this.indexOfByTag(e);
        if (index == -1) {
            logger.info("object NOT replaced in clones " + e);
            return false;
        }
        if (e == null) {
            this.list.remove(index);
            logger.info("object removed from clones " + e);
        } else {
            IMinimalEditableDataObject old = this.list.set(index, e);
            logger.info("object " + old.getClass().getName() + " replaced by " + e.getClass().getName() + " in clones ");
            logger.info("object with id " + old.getId() + " replaced by " + e.getId() + " in clones ");
            logger.info("object with tag " + old.getTag() + " replaced by " + e.getTag() + " in clones ");
            logger.info("object with systemid " + System.identityHashCode(old) + " replaced by " + System.identityHashCode(e) + " in clones ");
        }
        return true;
    }

    protected void logInfo(String message) {
        logger.info(message);
    }

    private int indexOfByTag(IMinimalEditableDataObject o) {
        int index = this.indexOf(o);
        if (index != -1) {
            return index;
        }
        if (o == null) {
            int i = 0;
            while (i < this.list.size()) {
                if (this.list.get(i) == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.list.size()) {
                if (o.equalsByTag(this.list.get(i))) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean contains(IMinimalEditableDataObject e) {
        return e != null && this.list.contains(e);
    }

    public void add(IMinimalEditableDataObject e) {
        if (e != null) {
            this.list.add(e);
        }
    }

    public void remove(IMinimalEditableDataObject e) {
        if (e != null) {
            this.list.remove(e);
        }
    }

    public void removeAll(Collection<IMinimalEditableDataObject> c) {
        if (c != null) {
            this.list.removeAll(c);
        }
    }

    public List<IMinimalEditableDataObject> findDirtyObjects() {
        final ArrayList<IMinimalEditableDataObject> dirt = new ArrayList<IMinimalEditableDataObject>();
        this.list.iterator(new ClosureA<IMinimalEditableDataObject>(){

            public void execute(IMinimalEditableDataObject object) {
                if (object != null && object.isDirty()) {
                    dirt.add(object);
                }
            }
        });
        return dirt;
    }

    public List<IMinimalEditableDataObject> findNotDirtyObjects() {
        final ArrayList<IMinimalEditableDataObject> notDirty = new ArrayList<IMinimalEditableDataObject>();
        this.list.iterator(new ClosureA<IMinimalEditableDataObject>(){

            public void execute(IMinimalEditableDataObject object) {
                if (object != null && !object.isDirty()) {
                    notDirty.add(object);
                }
            }
        });
        return notDirty;
    }

    public boolean isDirty() {
        IMinimalEditableDataObject firstDirtyObject = this.list.find(new ClosureAR<IMinimalEditableDataObject, Boolean>(){

            public Boolean execute(IMinimalEditableDataObject object) {
                if (object != null && object.isDirty()) {
                    return Boolean.TRUE;
                }
                return false;
            }
        });
        return firstDirtyObject != null;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String toString() {
        return this.list.toString();
    }

    public void iterator(ClosureA<IMinimalEditableDataObject> c) {
        this.list.iterator(c);
    }

    public IMinimalEditableDataObject find(ClosureAR<IMinimalEditableDataObject, Boolean> c) {
        return this.list.find(c);
    }

    public int size() {
        return this.list.size();
    }

    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    public IMinimalEditableDataObject get(int index) {
        return this.list.get(index);
    }

    public void clear() {
        this.list.clear();
    }

    public IMinimalEditableDataObject remove(int index) {
        return this.list.remove(index);
    }

    public XAppointmentDate findAppointmentDate(final LocalDate date, final Integer professional) {
        if (date == null || professional == null) {
            return null;
        }
        IMinimalEditableDataObject findObject = this.list.find(new ClosureAR<IMinimalEditableDataObject, Boolean>(){

            public Boolean execute(IMinimalEditableDataObject e) {
                XAppointmentDate xdate;
                if (e instanceof XAppointmentDate && date.equals((Object)(xdate = (XAppointmentDate)e).getDate()) && professional.equals(xdate.getProfessional())) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
        if (findObject != null) {
            return (XAppointmentDate)findObject;
        }
        return null;
    }
}

