/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.editor;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XBaseProfessionnal;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.IVisualAppointment;
import ca.infodata.ofys.ui.appointment.control.IAppointmentMode;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentControllerAdapter;
import ca.infodata.ofys.ui.appointment.editor.controller.AppointmentMainController;
import ca.infodata.ofys.ui.controls.IUserInteractionHelper;
import ca.infodata.ofys.ui.controls.util.PreferencesSettings;
import ca.infodata.ofys.ui.library.log.Log;
import ca.infodata.ofys.ui.person.PersonUiPlugin;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class AppointmentMainEditorInput
implements IEditorInput {
    private static XBaseProfessionnal InMemoryLastUsedProfessionnal;
    private String id;
    private LocalDate date;
    private XBaseProfessionnal professional;
    private IAppointment appointment;
    private IAppointmentMode.Mode mode;
    private List<AppointmentControllerAdapterExtension> controllerListeners;
    private AppointmentMainController controller;

    public static void setInMemoryLastUsedProfessionnal(XBaseProfessionnal inMemoryLastUsedProfessionnal) {
        if (inMemoryLastUsedProfessionnal == null || inMemoryLastUsedProfessionnal.useAppointment) {
            InMemoryLastUsedProfessionnal = inMemoryLastUsedProfessionnal;
        }
    }

    public AppointmentMainEditorInput(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cant be null");
        }
        this.id = id;
        this.date = LocalDate.today();
        this.mode = IAppointmentMode.Mode.APPOINTMENT;
        this.controllerListeners = new ArrayList<AppointmentControllerAdapterExtension>(4);
    }

    public AppointmentMainController buildController(IUserInteractionHelper helper) {
        Log.logOperation((String)"AppointmentMainEditorInpu.buildController", (Object[])new Object[]{this});
        if (this.controller == null) {
            if (this.appointment != null) {
                this.controller = new AppointmentMainController(this.id, this.appointment, helper);
            } else {
                XBaseProfessionnal professionnal = this.professional;
                if (professionnal == null) {
                    professionnal = this.getDefaultProfessional();
                }
                this.controller = new AppointmentMainController(this.id, this.date, professionnal == null ? null : professionnal.getId(), helper);
            }
            AppointmentControllerAdapterExtension listener = new AppointmentControllerAdapterExtension(this, this.controller);
            this.controllerListeners.add(listener);
            this.controller.addListener(listener);
        }
        return this.controller;
    }

    private XBaseProfessionnal getDefaultProfessional() {
        XBaseProfessionnal prof = PersonUiPlugin.getDefault().getSessionProfessionnal();
        if (prof == null) {
            prof = InMemoryLastUsedProfessionnal;
        }
        if (prof != null && !prof.useAppointment) {
            prof = null;
        }
        return prof;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return Messages.getString((String)"RENDEZVOUS", (String[])new String[0]);
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }

    public Object getAdapter(Class klass) {
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.professional == null ? 0 : this.professional.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppointmentMainEditorInput)) {
            return false;
        }
        AppointmentMainEditorInput other = (AppointmentMainEditorInput)obj;
        return !(this.professional == null ? other.professional != null : !this.professional.equals((Object)other.professional));
    }

    public LocalDate getDate() {
        return this.date;
    }

    public XBaseProfessionnal getProfessional() {
        return this.professional;
    }

    public IAppointment getAppointment() {
        return this.appointment;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public void setProfessional(Integer professional) {
        this.setProfessional(PersonUiPlugin.getDefault().getBaseProfessionnal(professional));
    }

    public void setProfessional(XBaseProfessionnal professional) {
        this.professional = professional == null ? null : professional;
        PreferencesSettings.getInstance().put("appointment/last-opened-editor-type", "single-prof");
        PreferencesSettings.getInstance().put("appointment/single-prof-input", "" + (this.professional == null ? "" : this.professional.getId()));
    }

    public void setAppointment(IAppointment appointment) {
        this.appointment = appointment;
        if (appointment != null) {
            this.setDate(appointment.getDate());
            this.setProfessional(PersonUiPlugin.getDefault().getBaseProfessionnal(appointment.getIdProfessional()));
        }
    }

    public IAppointmentMode.Mode getMode() {
        return this.mode;
    }

    public void setMode(IAppointmentMode.Mode mode) {
        this.mode = mode;
    }

    public String toString() {
        return String.format("AppointmentMainEditorInput [id=%s, date=%s, professional=%s, appointment=%s, mode=%s, \ncontroller=%s]", new Object[]{this.id, this.date, this.professional, this.appointment, this.mode, this.controller});
    }

    private static final class AppointmentControllerAdapterExtension
    extends AppointmentControllerAdapter {
        private final AppointmentMainController controller;
        private final AppointmentMainEditorInput input;

        public AppointmentControllerAdapterExtension(AppointmentMainEditorInput input, AppointmentMainController controller) {
            this.input = input;
            this.controller = controller;
        }

        @Override
        public void currentProfessionalChanged() {
            this.input.setProfessional(this.controller.getCurrentProfessional());
            this.input.appointment = null;
            this.input.date = LocalDate.today();
        }

        @Override
        public void appointmentsChanged() {
            if (this.input.appointment != null) {
                this.input.appointment = (IAppointment)this.controller.getAppointment((IVisualAppointment)this.input.appointment);
            }
            super.appointmentsChanged();
        }
    }
}

