/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.ui.appointment.control;

import ca.infodata.ofys.data.middle.dataobjects.appointment.IAppointment;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentPeriod;
import ca.infodata.ofys.data.middle.dataobjects.site.XSite;
import ca.infodata.ofys.ui.appointment.control.AppointmentVisualStructure;
import ca.infodata.ofys.ui.appointment.control.BaseDrawer;
import ca.infodata.ofys.ui.site.SitePlugin;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class PeriodDrawer
extends BaseDrawer {
    private static final Logger logger = Logger.getLogger(PeriodDrawer.class.getName());
    private boolean newPeriodCreatedMustEnterResizeMode = false;
    private AppointmentVisualStructure.VsPoint oldMoveToVsPoint;
    private int oldResizeLine;

    public PeriodDrawer(Canvas canvas, ScrollBar scroll) {
        super(canvas, scroll);
    }

    @Override
    public void setSelection(int x, int y) {
        if (this.visualStructure != null && this.visualStructure.isUsable()) {
            AppointmentVisualStructure.VsPoint vsPoint = this.getVSPointFromGCPoint(new Point(x, y));
            if (this.isVisualStructurePointOnMargin(vsPoint)) {
                this.visualStructure.setSelection(AppointmentVisualStructure.NULL_SELECTION);
                return;
            }
            XAppointmentPeriod selectedPeriod = this.visualStructure.getPeriod(vsPoint.line);
            if (selectedPeriod == null) {
                this.internal_createNewPeriod(vsPoint.line);
            }
            this.visualStructure.setSelection(vsPoint);
        }
    }

    private XAppointmentPeriod internal_createNewPeriod(int line) {
        int startTime = this.visualStructure.getScale() * line + this.visualStructure.getStartTimeMinute();
        int endTime = startTime + this.visualStructure.getScale();
        XAppointmentPeriod period = this.createNewPeriod(this.visualStructure.getAppointmentDateTemplate(), startTime, endTime);
        if (period != null) {
            this.newPeriodCreatedMustEnterResizeMode = true;
        }
        return period;
    }

    protected abstract XAppointmentPeriod createNewPeriod(XAppointmentDateTemplate var1, int var2, int var3);

    @Override
    public void setFocus(boolean focus) {
        this.focus = focus;
    }

    @Override
    public Cursor getCursorForMouseLocation(int x, int y) {
        int line;
        Cursor cursor = null;
        if (this.visualStructure != null && this.visualStructure.isUsable() && this.visualStructure.isLineValid(line = this.getVSPointFromGCPoint((Point)new Point((int)x, (int)y)).line)) {
            if (this.newPeriodCreatedMustEnterResizeMode) {
                cursor = this.CURSOR_RESIZE;
                this.newPeriodCreatedMustEnterResizeMode = false;
            } else if (this.isOnPeriodBottomBorder(x, y)) {
                cursor = this.CURSOR_RESIZE;
            } else if (this.isOnPeriodMoveHook(x, y)) {
                cursor = this.CURSOR_MOVE;
            }
        }
        return cursor;
    }

    private boolean isOnPeriodBottomBorder(int x, int y) {
        XAppointmentPeriod period;
        int line = this.getVSPointFromGCPoint((Point)new Point((int)x, (int)y)).line;
        if (this.visualStructure.isLineValid(line) && (period = this.visualStructure.getPeriod(line)) != null && this.isOnLineBorder(x, y)) {
            boolean isOnLastPeriodLine = this.visualStructure.getLine(period) + this.visualStructure.getHeight(period) - 1 == line;
            return isOnLastPeriodLine;
        }
        return false;
    }

    private boolean isOnLineBorder(int x, int y) {
        return (float)(y += this.ymargin) % this.lineHeight < (float)this.borderSelectionMargin || (float)y % this.lineHeight > this.lineHeight - (float)this.borderSelectionMargin;
    }

    private boolean isOnPeriodMoveHook(int x, int y) {
        XAppointmentPeriod period;
        int line = this.getVSPointFromGCPoint((Point)new Point((int)x, (int)y)).line;
        return this.visualStructure.isLineValid(line) && (float)(y += this.ymargin) % this.lineHeight < this.lineHeight / 2.0f && (period = this.visualStructure.getPeriod(line)) != null && this.visualStructure.getLine(period) == line && (float)(this.drawingSpaceX - x) < this.lineHeight / 2.0f;
    }

    @Override
    public boolean resizeTo(int x, int y) {
        int resizingMargin;
        int line;
        boolean resized = false;
        if (this.visualStructure != null && this.visualStructure.isUsable() && ((float)y % this.lineHeight < (float)this.borderSelectionMargin || (float)y % this.lineHeight > this.lineHeight - (float)this.borderSelectionMargin) && (line = (int)((float)(y + (resizingMargin = 16)) / this.lineHeight + (float)this.firstVisibleLine)) != this.oldResizeLine) {
            this.oldResizeLine = line;
            XAppointmentPeriod selectedPeriod = this.visualStructure.getSelectedPeriod();
            if (selectedPeriod != null) {
                resized = this.visualStructure.resize(selectedPeriod, line) == 0;
            } else {
                logger.info("Cannot resize a null period. selection was lost");
            }
        }
        return resized;
    }

    @Override
    public boolean moveTo(int x, int y) {
        AppointmentVisualStructure.VsPoint vsPoint;
        boolean moved = false;
        if (this.visualStructure != null && this.visualStructure.isUsable() && (float)y % this.lineHeight < this.lineHeight / 2.0f && !(vsPoint = this.getVSPointFromGCPoint(new Point(x, y))).equals(this.oldMoveToVsPoint)) {
            this.oldMoveToVsPoint = vsPoint;
            XAppointmentPeriod selectedPeriod = this.visualStructure.getSelectedPeriod();
            if (selectedPeriod != null) {
                moved = this.visualStructure.move(selectedPeriod, vsPoint.line);
            } else {
                logger.warning("Cannot move a null period. selection was lost");
            }
        }
        return moved;
    }

    @Override
    protected int drawAppointmentMoveHook(boolean selected, IAppointment appointment, int x, int y, int width, int height) {
        return x + width;
    }

    @Override
    protected void drawPeriodMoveHook(XAppointmentPeriod period, int x, int y, int width, int height) {
        int lineWidth = this.gcBuffer.getLineWidth();
        Color background = this.gcBuffer.getBackground();
        Color foreground = this.gcBuffer.getForeground();
        Color darkenPeriodColor = this.getPeriodColor(period.getAppointmentPeriodType());
        Color colorBorder = this.getColor(50, 50, 50);
        this.gcBuffer.setLineWidth(2);
        this.gcBuffer.setForeground(colorBorder);
        this.gcBuffer.setBackground(darkenPeriodColor);
        this.gcBuffer.drawArc(x + width - (int)this.lineHeight / 2, y - (int)this.lineHeight / 2, (int)this.lineHeight, (int)this.lineHeight, 180, 90);
        this.gcBuffer.fillArc(x + width - (int)this.lineHeight / 2, y - (int)this.lineHeight / 2, (int)this.lineHeight, (int)this.lineHeight, 180, 90);
        this.gcBuffer.setLineWidth(1);
        this.gcBuffer.drawRectangle(x, y, width, height);
        this.gcBuffer.setLineWidth(lineWidth);
        this.gcBuffer.setBackground(background);
        this.gcBuffer.setForeground(foreground);
    }

    @Override
    protected void drawForeground() {
    }

    @Override
    protected void drawSelection() {
        AppointmentVisualStructure.VsPoint selection = this.visualStructure.getSelection();
        XAppointmentPeriod period = this.visualStructure.getSelectedPeriod();
        if (period != null && !this.isVisualStructurePointOnMargin(selection)) {
            int line = this.visualStructure.getLine(period);
            int height = this.visualStructure.getHeight(period);
            int line2 = line;
            while (line2 < line + height) {
                this.drawPeriod(line2, true);
                ++line2;
            }
        }
    }

    @Override
    protected void drawAppointments() {
    }

    protected void drawPeriod(int line, boolean selected) {
        if (this.visualStructure == null) {
            return;
        }
        XAppointmentPeriod period = this.visualStructure.getPeriod(line);
        if (period != null && !period.isStatusDeleted() && !period.isNonExisting()) {
            int periodLine = this.visualStructure.getLine(period);
            Color background = this.gcBuffer.getBackground();
            Color foreground = this.gcBuffer.getForeground();
            Font font = this.gcBuffer.getFont();
            int x = this.margin;
            int y = (int)((float)(line - this.firstVisibleLine) * this.lineHeight) + this.ymargin;
            int width = this.appointmentSpace;
            int height = (int)this.lineHeight;
            String text = (String)this.getPeriodLabelProvider().get((Object)period);
            if (period.isClosed()) {
                Color black = selected ? this.getColor(0, 0, 0) : this.getColor(75, 75, 75);
                this.gcBuffer.setBackground(black);
                this.gcBuffer.fillRectangle(x, y, width, height);
            } else {
                XSite site;
                Color colorTypePeriod = this.getPeriodColor(period.getAppointmentPeriodType());
                if (selected) {
                    colorTypePeriod = this.darkenColor(colorTypePeriod.getRGB());
                }
                this.gcBuffer.setBackground(colorTypePeriod);
                this.gcBuffer.fillRectangle(x, y, width, height);
                if (period.getIdSite() != null && (site = SitePlugin.getDefault().getSite(period.getIdSite())) != null && site.getColor() != null) {
                    Color siteColor = this.getColor(site.getColor());
                    this.gcBuffer.setBackground(siteColor);
                    this.gcBuffer.fillRectangle(x + 1, y + 1, this.siteMarkerWidth, height - 2);
                }
            }
            if (this.drawText && line == periodLine) {
                Color colorText = period.isClosed() ? this.getColor(255, 255, 255) : this.getColor(50, 50, 50);
                this.gcBuffer.setFont(this.fontNormal);
                this.gcBuffer.setForeground(colorText);
                this.gcBuffer.drawText(text, x + 4 + this.siteMarkerWidth, y + 6, true);
            }
            if (this.drawBorder) {
                Color colorBorder = this.getColor(50, 50, 50);
                Color colorWhitish = this.getColor(200, 200, 200);
                this.gcBuffer.setForeground(colorBorder);
                this.gcBuffer.drawRectangle(x, y, width, height);
                this.gcBuffer.setForeground(colorBorder);
                this.gcBuffer.drawLine(x, y, x + width, y);
                this.gcBuffer.setForeground(colorWhitish);
                this.gcBuffer.drawLine(x + 1, y - 1, x + width - 2, y - 1);
            } else {
                this.gcBuffer.drawRectangle(x - 1, y - 1, width + 1, height + 1);
            }
            if (line == periodLine) {
                this.drawPeriodMoveHook(period, x, y, width, height);
            }
            this.gcBuffer.setBackground(background);
            this.gcBuffer.setForeground(foreground);
            this.gcBuffer.setFont(font);
        }
    }

    @Override
    protected void drawPeriod(int line) {
        this.drawPeriod(line, false);
    }
}

