$(document).ready(function() {
	// Initialization
	$(document).on("click", '[data-ref]', getDefaultView);
	$(document).on("click", "[href*='insert='], [href*='cb='] ", getAjaxDefaultView)
});

function getDefaultView(event) {
	try {
		var requestUrl = $(this).attr("data-ref");
		if (requestUrl != "" && requestUrl != null) {
			getView(requestUrl);
		}
	} catch (e) {
		alert('Accès refusé: ' + e.message);
	}
}

function getView(url) {
	try {
		startJob("Recherche de ressource" + url);
		view(url, "", true, true);
	} catch (e) {
		alert('Accès refusé: ' + e.message);
		finishJob();
	}
}
function updateScript(data) {
	if (data.updateElement != null && data.updateElement != undefined
			&& data.updateElement != '') {
		$("#" + data.updateElement).html(data.view);
	}
	finishJob();
}

function finishJob() {
	deactivate($(".loader"));
}

function startJob(uniqueJobId) {
	activate($(".loader"));
	$(".loader").show();
}

// Server mimic of browser function insert mechanism
function getAjaxDefaultView(event) {
	event.preventDefault();
	var requestUrl = $(this).attr("href");
	getAjaxView(requestUrl);
}

function getAjaxView(requestUrl){
	startJob("Recherche de ressource" + requestUrl);
	$.ajax({
		method : "GET",
		url : requestUrl,
		contentType:"application/json; charset:utf-8"
	}).done(function(data) {
		var res = data;
		if(res.cb != null && res.cb != undefined && res.cb != ''){
			// find callback object
			var fn = window[res.cb];

			// if the callback is a function call it
			if (typeof fn === "function") fn.call(this, res);
		}
		updateScript(res);
	});
}