/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PaginatedList {
    public static <T> List<T> getPage(List<T> list, int pageNumber, int nbItemsPerPage) {
        return PaginatedList.getPage(list, pageNumber, nbItemsPerPage, 0);
    }

    public static <T> List<T> getPage(List<T> list, int pageNumber, int nbItemsPerPage, int offset) {
        List<T> pageItems;
        if (pageNumber <= 0) {
            throw new IllegalArgumentException("pageNumber should be >= 1");
        }
        if (nbItemsPerPage <= 0) {
            throw new IllegalArgumentException("nbItemsPerPage should be > 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset should be >= 0");
        }
        int size = list.size();
        if (size == 0) {
            pageItems = list;
        } else if (offset >= size) {
            pageItems = Collections.emptyList();
        } else if (nbItemsPerPage >= size) {
            pageItems = pageNumber == 1 ? (offset > 0 ? list.subList(offset, size) : list) : Collections.emptyList();
        } else {
            int count = size - offset;
            int lastPageItemCount = count % nbItemsPerPage;
            int nbPage = count / nbItemsPerPage;
            if (lastPageItemCount > 0) {
                ++nbPage;
            }
            if (nbPage == 1) {
                pageItems = offset > 0 ? list.subList(offset, size) : list;
            } else if (pageNumber > nbPage) {
                pageItems = Collections.emptyList();
            } else {
                int start = Math.min(offset + (pageNumber - 1) * nbItemsPerPage, size);
                int end = Math.min(offset + pageNumber * nbItemsPerPage, size);
                pageItems = list.subList(start, end);
            }
        }
        return pageItems;
    }

    public static <T> List<List<T>> getPages(List<T> list, int nbItemsPerPage) {
        List<T> page;
        if (nbItemsPerPage <= 0) {
            throw new IllegalArgumentException("nbItemsPerPage should be > 0");
        }
        ArrayList<List<T>> pages = new ArrayList<List<T>>();
        int pageNumber = 1;
        while (!(page = PaginatedList.getPage(list, pageNumber, nbItemsPerPage, 0)).isEmpty()) {
            pages.add(page);
            ++pageNumber;
        }
        return pages;
    }
}

