/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.prevalidator;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XContactInformation;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IPreValidator;
import java.util.regex.Pattern;

public class ContactInformationPreValidator
implements IPreValidator {
    private static final Pattern email = Pattern.compile(".+@.+\\.[a-z]+");
    private StringBuilder error = new StringBuilder();

    @Override
    public boolean validForDelete(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    @Override
    public boolean validForEdition(EditableDataObject dataObject, EditableDataObject editorInput) {
        return true;
    }

    @Override
    public boolean validForSave(EditableDataObject dataObject, EditableDataObject editorInput) {
        XContactInformation contactInformation = (XContactInformation)dataObject;
        boolean valid = true;
        this.error = new StringBuilder();
        if (contactInformation.getTypeContact().intValue() != XContactInformation.CONTACT_TYPE_EMAIL.intValue() && contactInformation.getTypeContact().intValue() != XContactInformation.CONTACT_TYPE_EMAILS_AUTRES.intValue()) {
            if (contactInformation.getContact().length() == 0 || contactInformation.getContact().length() < 10) {
                this.error.append(Messages.getString("ENTREZ_NUMERO_TELEPHONE_VALIDE", new String[0]));
                valid = false;
            }
        } else if (contactInformation.getContact().length() == 0 || !email.matcher(contactInformation.getContact()).matches()) {
            this.error.append(Messages.getString("ENTREZ_COURRIEL_VALIDE", new String[0]));
            valid = false;
        }
        return valid;
    }

    @Override
    public String getError() {
        return this.error.toString();
    }
}

