/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.medication;

import ca.infodata.ofys.data.middle.dataobjects.medication.XPrescription;
import ca.infodata.ofys.util.math.NumberUtils;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;

public class RxUtil {
    private static String defaultPattern = "yyyy/MM/dd";
    private static Locale locale = Locale.CANADA;
    private static String defaultQuantity = "30";
    public static String OD = "ID";
    public static String d = "j";
    public static String D = "J";
    public static String day = "jour";
    public static String _day = "/jour";
    public static String days = "jours";
    public static String Week = "Semaine";
    public static String week = "semaine";
    public static String weeks = "semaines";
    public static String Month = "Mois";
    public static String Months = "Mois";
    public static String months = "mois";
    public static String month = "mois";
    public static String mo = "mo";
    public static String w = "s";
    public static String W = "S";
    public static String m = "m";
    public static String M = "M";
    public static String Day = "Jour";
    public static String daily = "chaque jour";
    public static String _daily = "/jour";
    public static String once_daily = "chaque jour";
    public static String twice_daily = "deux fois par jour";
    public static String weekly = "chaque semaine";
    public static String _weekly = "/semaine";
    public static String monthly = "chaque mois";
    public static String _monthly = "/mois";
    public static String zero = "zero";
    public static String one = "un";
    public static String two = "deux";
    public static String three = "trois";
    public static String four = "quatre";
    public static String five = "cinq";
    public static String six = "six";
    public static String seven = "sept";
    public static String eight = "huit";
    public static String nine = "neuf";
    public static String ten = "dix";
    public static String Take = "Prendre";
    public static String take = "prendre";
    public static String Apply = "Appliquer";
    public static String apply = "appliquer";
    public static String Rub_well_in = "Frottez bien";
    public static String rub_well_in = "frottez bien";
    public static String[] zeroToTen = new String[]{"(?i)" + zero, "(?i)" + one, "(?i)" + two, "(?i)" + three, "(?i)" + four, "(?i)" + five, "(?i)" + six, "(?i)" + seven, "(?i)" + eight, "(?i)" + nine, "(?i)" + ten};
    public static String RUB_WELL_IN = "FROTTER BIEN";
    public static String Rub_Well_In = "Frotter Bien";
    public static String TAKE = "PRENDRE";
    public static String APPLY = "APPLIQUER";
    public static String Repeats = "Rep";
    public static String Qty = "Qte";

    public static void setDefaultQuantity(String quantity) {
        defaultQuantity = quantity;
    }

    public static String getDefaultQuantity() {
        return defaultQuantity;
    }

    public static Date StringToDate(String Expression) {
        return RxUtil.StringToDate(Expression, defaultPattern);
    }

    public static Date StringToDate(String Expression, String pattern) {
        try {
            FastDateFormat df = FastDateFormat.getInstance((String)pattern, (Locale)locale);
            return df.parse(Expression);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String DateToString(Date Expression) {
        return RxUtil.DateToString(Expression, defaultPattern);
    }

    public static String DateToString(Date Expression, String pattern) {
        if (Expression != null) {
            FastDateFormat df = FastDateFormat.getInstance((String)pattern, (Locale)locale);
            return df.format(Expression);
        }
        return "";
    }

    public static String DateToString(Date Expression, String pattern, Locale locale2) {
        if (Expression != null) {
            FastDateFormat df = FastDateFormat.getInstance((String)pattern, (Locale)locale2);
            return df.format(Expression);
        }
        return "";
    }

    public static Date Today() {
        return Calendar.getInstance().getTime();
    }

    public static int BoolToInt(boolean Expression) {
        if (Expression) {
            return 1;
        }
        return 0;
    }

    public static boolean IntToBool(int expression) {
        return expression != 0;
    }

    public static String FloatToString(float value) {
        Float f = new Float(value);
        NumberFormat fmt = NumberFormat.getNumberInstance();
        String s = fmt.format(f.doubleValue());
        return s;
    }

    public static float StringToFloat(String value) {
        return Float.parseFloat(value);
    }

    public static Object IIf(boolean Expression, Object TruePart, Object FalsePart) {
        if (Expression) {
            return TruePart;
        }
        return FalsePart;
    }

    public static String joinArray(Object[] array) {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            ret.append("'").append(String.valueOf(array[i])).append("'");
            if (i >= array.length - 1) continue;
            ret.append(", ");
        }
        return ret.toString();
    }

    public static String replace(String expression, String searchFor, String replaceWith) {
        if (expression != null) {
            StringBuilder buf = new StringBuilder(expression);
            int pos = -1;
            while ((pos = buf.indexOf(searchFor, pos)) > -1) {
                buf.delete(pos, pos + searchFor.length());
                buf.insert(pos, replaceWith);
                pos += replaceWith.length();
            }
            return buf.toString();
        }
        return null;
    }

    public static int getClcr(int age, double weight, double sCr, boolean female) throws Exception {
        if (age < 0) {
            throw new Exception("age must be greater than 0");
        }
        if (weight < 0.0) {
            throw new Exception("weight must be greater than 0");
        }
        if (sCr < 0.0) {
            throw new Exception("sCr must be greater than 0");
        }
        double Clcr = (double)(140 - age) * weight / (sCr * 0.8);
        if (female) {
            Clcr *= 0.85;
        }
        return (int)Math.round(Clcr);
    }

    public static double findNDays(String durationUnit) {
        double nDays = 0.0;
        if (durationUnit.equalsIgnoreCase("D") || durationUnit.equalsIgnoreCase("J")) {
            nDays = 1.0;
        } else if (durationUnit.equalsIgnoreCase("W") || durationUnit.equalsIgnoreCase("S")) {
            nDays = 7.0;
        } else if (durationUnit.equalsIgnoreCase("M")) {
            nDays = 30.0;
        }
        return nDays;
    }

    public static Double findNPerDay(String frequency, boolean fromItself) {
        if (frequency == null) {
            return null;
        }
        frequency = RxUtil.changeToStandardFrequencyCode(frequency);
        double nPerDay = 0.0;
        if (frequency.equalsIgnoreCase(OD) || frequency.equalsIgnoreCase("die")) {
            nPerDay = 1.0;
        } else if (frequency.equalsIgnoreCase("bid")) {
            nPerDay = 2.0;
        } else if (frequency.equalsIgnoreCase("tid")) {
            nPerDay = 3.0;
        } else if (frequency.equalsIgnoreCase("qid")) {
            nPerDay = 4.0;
        } else if (frequency.equalsIgnoreCase("Q1H")) {
            nPerDay = 24.0;
        } else if (frequency.equalsIgnoreCase("Q2H")) {
            nPerDay = 12.0;
        } else if (frequency.equalsIgnoreCase("Q1-2H")) {
            nPerDay = 24.0;
        } else if (frequency.equalsIgnoreCase("Q3-4H")) {
            nPerDay = 8.0;
        } else if (frequency.equalsIgnoreCase("Q4H")) {
            nPerDay = 6.0;
        } else if (frequency.equalsIgnoreCase("Q4-6H")) {
            nPerDay = 6.0;
        } else if (frequency.equalsIgnoreCase("Q6H")) {
            nPerDay = 4.0;
        } else if (frequency.equalsIgnoreCase("Q8H")) {
            nPerDay = 3.0;
        } else if (frequency.equalsIgnoreCase("Q12H")) {
            nPerDay = 2.0;
        } else if (frequency.equalsIgnoreCase("QAM")) {
            nPerDay = 1.0;
        } else if (frequency.equalsIgnoreCase("QPM")) {
            nPerDay = 1.0;
        } else if (frequency.equalsIgnoreCase("QHS")) {
            nPerDay = 1.0;
        } else if (frequency.equalsIgnoreCase("HS")) {
            nPerDay = 1.0;
        } else if (frequency.equalsIgnoreCase("Q1" + Week)) {
            nPerDay = 0.14285714285714285;
        } else if (frequency.equalsIgnoreCase("Q2" + Week)) {
            nPerDay = 0.07142857142857142;
        } else if (frequency.equalsIgnoreCase("Q1" + Month)) {
            nPerDay = 0.03333333333333333;
        } else if (frequency.equalsIgnoreCase("Q3" + Month)) {
            nPerDay = 0.011111111111111112;
        }
        if (nPerDay == 0.0 && !fromItself) {
            String[] ss = frequency.split(" ");
            if (ss.length > 0) {
                nPerDay = RxUtil.findNPerDay(ss[0], true);
            }
            if (!(ss.length <= 1 || !frequency.toLowerCase().contains("prn") || frequency.toLowerCase().contains(" et ") && frequency.toLowerCase().contains(" and ") && frequency.toLowerCase().contains(" + "))) {
                nPerDay /= 2.0;
            }
        }
        return new Double(nPerDay);
    }

    public static String getUnitNameFromQuantityText(String qStr) {
        String qNum;
        String qUnit;
        Pattern p1;
        Matcher m1;
        if (qStr != null && (m1 = (p1 = Pattern.compile("\\d+")).matcher(qStr)).find() && (qUnit = qStr.replace(qNum = qStr.substring(m1.start(), m1.end()), "").trim()) != null && qUnit.length() > 0) {
            return qUnit;
        }
        return null;
    }

    public static double getDoubleQuantityFromQuantityText(String qStr) {
        double poso = 100.0;
        if (qStr != null) {
            char[] p;
            String newPoso = "";
            for (char d : p = qStr.toCharArray()) {
                if (org.apache.commons.lang3.math.NumberUtils.isDigits((String)String.valueOf(d)) || d == '.' || d == ',') {
                    if (d == ',') {
                        d = '.';
                    }
                    newPoso = newPoso + d;
                    continue;
                }
                if (d == '/') {
                    newPoso = newPoso + d;
                    continue;
                }
                if (d != 32) continue;
                newPoso = newPoso + d;
            }
            if ((newPoso = newPoso.trim()).length() > 0) {
                String[] ps;
                for (String ss : ps = newPoso.split(" ")) {
                    if (ss.trim().length() <= 0) continue;
                    double value = 0.0;
                    try {
                        value = NumberUtils.fractionToDouble(ss.trim());
                    }
                    catch (Exception e) {
                        System.out.println("ss=" + ss + ":" + e.getMessage());
                    }
                    poso = value < poso ? value : poso;
                }
            }
        }
        return poso;
    }

    public static String getQuantityFromQuantityText(String qStr) {
        Pattern p1;
        Matcher m1;
        if (qStr != null && (m1 = (p1 = qStr.indexOf(47) != -1 ? Pattern.compile("((\\b[1-9])?/)?[1-9]\\b") : Pattern.compile("\\b(([0-9]+)?\\.)?[0-9]+\\b")).matcher(qStr)).find()) {
            StringBuilder qNum = new StringBuilder().append(qStr.substring(m1.start(), m1.end()));
            String addedValue = null;
            if (qStr.length() > m1.end() && (addedValue = RxUtil.getQuantityFromQuantityText(qStr.substring(m1.end()))) != null) {
                qNum.append(" ").append(addedValue);
            }
            return qNum.toString();
        }
        return null;
    }

    public static boolean isMitte(String qStr) {
        String[] durationUnits;
        boolean isMitte = false;
        for (String s : durationUnits = new String[]{"[0-9]+\\s+(?i)" + days + "\\s", "[0-9]+\\s+(?i)" + weeks + "\\s", "[0-9]+\\s+(?i)" + months + "\\s", "[0-9]+\\s+(?i)" + day + "\\s", "[0-9]+\\s+(?i)" + week + "\\s", "[0-9]+\\s+(?i)" + month + "\\s", "[0-9]+\\s+(?i)" + d + "\\s", "[0-9]+\\s+(?i)" + w + "\\s", "[0-9]+\\s+(?i)" + m + "\\s", "[0-9]+\\s+(?i)" + mo + "\\s", "[0-9]+\\s+(?i)" + days + "$", "[0-9]+\\s+(?i)" + weeks + "$", "[0-9]+\\s+(?i)" + months + "$", "[0-9]+\\s+(?i)" + day + "$", "[0-9]+\\s+(?i)" + week + "$", "[0-9]+\\s+(?i)" + month + "$", "[0-9]+\\s+(?i)" + d + "$", "[0-9]+\\s+(?i)" + w + "$", "[0-9]+\\s+(?i)" + m + "$", "[0-9]+\\s+(?i)" + mo + "$", "\\s[0-9]+(?i)" + days + "\\s", "\\s[0-9]+(?i)" + weeks + "\\s", "\\s[0-9]+(?i)" + months + "\\s", "\\s[0-9]+(?i)" + day + "\\s", "\\s[0-9]+(?i)" + week + "\\s", "\\s[0-9]+(?i)" + month + "\\s", "\\s[0-9]+(?i)" + d + "\\s", "\\s[0-9]+(?i)" + w + "\\s", "\\s[0-9]+(?i)" + m + "\\s", "\\s[0-9]+(?i)" + mo + "\\s", "\\s[0-9]+(?i)" + days + "$", "\\s[0-9]+(?i)" + weeks + "$", "\\s[0-9]+(?i)" + months + "$", "\\s[0-9]+(?i)" + day + "$", "\\s[0-9]+(?i)" + week + "$", "\\s[0-9]+(?i)" + month + "$", "\\s[0-9]+(?i)" + d + "$", "\\s[0-9]+(?i)" + w + "$", "\\s[0-9]+(?i)" + m + "$", "\\s[0-9]+(?i)" + mo + "$", "^[0-9]+(?i)" + days + "$", "^[0-9]+(?i)" + weeks + "$", "^[0-9]+(?i)" + months + "$", "^[0-9]+(?i)" + day + "$", "^[0-9]+(?i)" + week + "$", "^[0-9]+(?i)" + month + "$", "^[0-9]+(?i)" + d + "$", "^[0-9]+(?i)" + w + "$", "^[0-9]+(?i)" + m + "$", "^[0-9]+(?i)" + mo + "$", "^[0-9]+\\s+(?i)" + days + "$", "^[0-9]+\\s+(?i)" + weeks + "$", "^[0-9]+\\s+(?i)" + months + "$", "^[0-9]+\\s+(?i)" + day + "$", "^[0-9]+\\s+(?i)" + week + "$", "^[0-9]+\\s+(?i)" + month + "$", "^[0-9]+\\s+(?i)" + d + "$", "^[0-9]+\\s+(?i)" + w + "$", "^[0-9]+\\s+(?i)" + m + "$", "^[0-9]+\\s+(?i)" + mo + "$"}) {
            Pattern p = Pattern.compile(s);
            Matcher m = p.matcher(qStr);
            if (!m.find()) continue;
            String foundStr = qStr.substring(m.start(), m.end()).trim();
            qStr = qStr.replace(foundStr, "");
            if ((qStr = qStr.trim()).length() != 0) continue;
            isMitte = true;
            break;
        }
        return isMitte;
    }

    public static String getDurationFromQuantityText(String qStr) {
        String[] durationUnits;
        String retStr = "";
        for (String s : durationUnits = new String[]{"[0-9]+\\s+(?i)" + days + "\\s", "[0-9]+\\s+(?i)" + weeks + "\\s", "[0-9]+\\s+(?i)" + months + "\\s", "[0-9]+\\s+(?i)" + day + "\\s", "[0-9]+\\s+(?i)" + week + "\\s", "[0-9]+\\s+(?i)" + month + "\\s", "[0-9]+\\s+(?i)" + d + "\\s", "[0-9]+\\s+(?i)" + w + "\\s", "[0-9]+\\s+(?i)" + m + "\\s", "[0-9]+\\s+(?i)" + mo + "\\s", "[0-9]+\\s+(?i)" + days + "$", "[0-9]+\\s+(?i)" + weeks + "$", "[0-9]+\\s+(?i)" + months + "$", "[0-9]+\\s+(?i)" + day + "$", "[0-9]+\\s+(?i)" + week + "$", "[0-9]+\\s+(?i)" + month + "$", "[0-9]+\\s+(?i)" + d + "$", "[0-9]+\\s+(?i)" + w + "$", "[0-9]+\\s+(?i)" + m + "$", "[0-9]+\\s+(?i)" + mo + "$", "\\s[0-9]+(?i)" + days + "\\s", "\\s[0-9]+(?i)" + weeks + "\\s", "\\s[0-9]+(?i)" + months + "\\s", "\\s[0-9]+(?i)" + day + "\\s", "\\s[0-9]+(?i)" + week + "\\s", "\\s[0-9]+(?i)" + month + "\\s", "\\s[0-9]+(?i)" + d + "\\s", "\\s[0-9]+(?i)" + w + "\\s", "\\s[0-9]+(?i)" + m + "\\s", "\\s[0-9]+(?i)" + mo + "\\s", "\\s[0-9]+(?i)" + days + "$", "\\s[0-9]+(?i)" + weeks + "$", "\\s[0-9]+(?i)" + months + "$", "\\s[0-9]+(?i)" + day + "$", "\\s[0-9]+(?i)" + week + "$", "\\s[0-9]+(?i)" + month + "$", "\\s[0-9]+(?i)" + d + "$", "\\s[0-9]+(?i)" + w + "$", "\\s[0-9]+(?i)" + m + "$", "\\s[0-9]+(?i)" + mo + "$"}) {
            String duration;
            Pattern p = Pattern.compile(s);
            Matcher m = p.matcher(qStr);
            if (!m.find()) continue;
            String foundStr = qStr.substring(m.start(), m.end()).trim();
            Pattern p2 = Pattern.compile("[0-9]+");
            Matcher m2 = p2.matcher(foundStr);
            if (!m2.find()) break;
            retStr = duration = foundStr.substring(m2.start(), m2.end()).trim();
            break;
        }
        return retStr;
    }

    public static String getDurationUnitFromQuantityText(String qStr) {
        String[] durationUnits;
        String retStr = "";
        for (String s : durationUnits = new String[]{"[0-9]+\\s+(?i)" + days + "\\s", "[0-9]+\\s+(?i)" + weeks + "\\s", "[0-9]+\\s+(?i)" + months + "\\s", "[0-9]+\\s+(?i)" + day + "\\s", "[0-9]+\\s+(?i)" + week + "\\s", "[0-9]+\\s+(?i)" + month + "\\s", "[0-9]+\\s+(?i)" + d + "\\s", "[0-9]+\\s+(?i)" + w + "\\s", "[0-9]+\\s+(?i)" + m + "\\s", "[0-9]+\\s+(?i)" + mo + "\\s", "[0-9]+\\s+(?i)" + days + "$", "[0-9]+\\s+(?i)" + weeks + "$", "[0-9]+\\s+(?i)" + months + "$", "[0-9]+\\s+(?i)" + day + "$", "[0-9]+\\s+(?i)" + week + "$", "[0-9]+\\s+(?i)" + month + "$", "[0-9]+\\s+(?i)" + d + "$", "[0-9]+\\s+(?i)" + w + "$", "[0-9]+\\s+(?i)" + m + "$", "[0-9]+\\s+(?i)" + mo + "$", "\\s[0-9]+(?i)" + days + "\\s", "\\s[0-9]+(?i)" + weeks + "\\s", "\\s[0-9]+(?i)" + months + "\\s", "\\s[0-9]+(?i)" + day + "\\s", "\\s[0-9]+(?i)" + week + "\\s", "\\s[0-9]+(?i)" + month + "\\s", "\\s[0-9]+(?i)" + d + "\\s", "\\s[0-9]+(?i)" + w + "\\s", "\\s[0-9]+(?i)" + m + "\\s", "\\s[0-9]+(?i)" + mo + "\\s", "\\s[0-9]+(?i)" + days + "$", "\\s[0-9]+(?i)" + weeks + "$", "\\s[0-9]+(?i)" + months + "$", "\\s[0-9]+(?i)" + day + "$", "\\s[0-9]+(?i)" + week + "$", "\\s[0-9]+(?i)" + month + "$", "\\s[0-9]+(?i)" + d + "$", "\\s[0-9]+(?i)" + w + "$", "\\s[0-9]+(?i)" + m + "$", "\\s[0-9]+(?i)" + mo + "$"}) {
            Pattern p = Pattern.compile(s);
            Matcher ma = p.matcher(qStr);
            if (!ma.find()) continue;
            String foundStr = qStr.substring(ma.start(), ma.end()).trim();
            Pattern p2 = Pattern.compile("[0-9]+");
            Matcher m2 = p2.matcher(foundStr);
            if (!m2.find()) continue;
            String duration = foundStr.substring(m2.start(), m2.end()).trim();
            String durationUnit = foundStr.replace(duration, "").trim().toLowerCase();
            if (durationUnit.startsWith(d)) {
                retStr = d.toUpperCase();
                break;
            }
            if (durationUnit.startsWith(w)) {
                retStr = w.toUpperCase();
                break;
            }
            if (durationUnit.startsWith(m)) {
                retStr = m.toUpperCase();
                break;
            }
            retStr = "";
            break;
        }
        return retStr;
    }

    private static String changeToStandardFrequencyCode(String str) {
        if (str == null) {
            return null;
        }
        String retVal = str;
        if (str.equalsIgnoreCase(daily)) {
            retVal = OD;
        } else if (str.equalsIgnoreCase(once_daily)) {
            retVal = OD;
        } else if (str.equalsIgnoreCase(twice_daily)) {
            retVal = "BID";
        } else if (str.equalsIgnoreCase("3x" + _day)) {
            retVal = "TID";
        } else if (str.equalsIgnoreCase("3x" + _daily)) {
            retVal = "TID";
        } else if (str.equalsIgnoreCase("4x" + _day)) {
            retVal = "QID";
        } else if (str.equalsIgnoreCase("4x" + _daily)) {
            retVal = "QID";
        } else if (str.equalsIgnoreCase(weekly) || weekly.startsWith(str.toLowerCase()) || _weekly.startsWith(str.toLowerCase())) {
            retVal = "Q1" + Week;
        } else if (str.equalsIgnoreCase(monthly) || monthly.startsWith(str.toLowerCase()) || _monthly.startsWith(str.toLowerCase())) {
            retVal = "Q1" + Month;
        }
        return retVal;
    }

    private static String convertWordToNumerical(String s) {
        String retVal = s = s.trim();
        if (s != null && !s.equalsIgnoreCase("null")) {
            if (s.equalsIgnoreCase(zero)) {
                retVal = "0";
            } else if (s.equalsIgnoreCase(one)) {
                retVal = "1";
            } else if (s.equalsIgnoreCase(two)) {
                retVal = "2";
            } else if (s.equalsIgnoreCase(three)) {
                retVal = "3";
            } else if (s.equalsIgnoreCase(four)) {
                retVal = "4";
            } else if (s.equalsIgnoreCase(five)) {
                retVal = "5";
            } else if (s.equalsIgnoreCase(six)) {
                retVal = "6";
            } else if (s.equalsIgnoreCase(seven)) {
                retVal = "7";
            } else if (s.equalsIgnoreCase(eight)) {
                retVal = "8";
            } else if (s.equalsIgnoreCase(nine)) {
                retVal = "9";
            } else if (s.equalsIgnoreCase(ten)) {
                retVal = "10";
            } else if (!RxUtil.isStringToNumber(retVal)) {
                retVal = "0";
            }
        } else {
            retVal = "0";
        }
        return retVal;
    }

    private static String checkInstructionStr(String str) {
        String retVal = str;
        if (str.contains("3x day")) {
            retVal = retVal.replace("3x day", "");
        } else if (str.contains("4x day")) {
            retVal = retVal.replace("4x day", "");
        }
        return retVal;
    }

    public static void instrucParser(XPrescription rx) {
        if (rx == null) {
            return;
        }
        String instructions = rx.getNote();
        if (instructions == null) {
            instructions = "";
        }
        String route = "";
        String frequency = "";
        String duration = "0";
        String method = "";
        String durationUnit = "";
        String durationUnitSpec = "";
        boolean prn = false;
        String amountFrequency = "";
        String amountMethod = "";
        String takeMinFrequency = "";
        String takeMaxFrequency = "";
        String takeMinMethod = "";
        String takeMaxMethod = "";
        String takeMin = "0";
        String takeMax = "0";
        String durationSpec = "";
        boolean quantity = false;
        if (instructions.trim().length() != 0) {
            Matcher m;
            Pattern p;
            String instructionToCheck;
            Matcher m5;
            Pattern p5;
            String r2;
            String r1;
            Object str;
            String str3;
            String str2;
            Matcher m4;
            Pattern p4;
            Matcher m2;
            Pattern p2;
            Matcher matcher;
            Pattern p3;
            String[] prns;
            for (String s : prns = new String[]{"\\s(?i)prn$", "^(?i)prn\\s+", "\\s+(?i)prn\\s+"}) {
                Pattern prnP = Pattern.compile(s);
                String[] prnM = prnP.matcher(instructions);
                if (!prnM.find()) continue;
                prn = true;
            }
            String[] routes = new String[]{"\\s(?i)PO$", "\\s(?i)SL$", "\\s(?i)IM$", "\\s(?i)SC$", "\\s(?i)PATCH$", "\\s(?i)TOP\\.$", "\\s(?i)INH$", "\\s(?i)SUPP$", "\\s(?i)O.D.$", "\\s(?i)O.S.$", "\\s(?i)O.U.$", "\\s(?i)" + OD + "$", "\\s(?i)OS$", "\\s(?i)OU$", "\\s(?i)PO\\s", "\\s(?i)SL\\s", "\\s(?i)IM\\s", "\\s(?i)SC\\s", "\\s(?i)PATCH\\s", "\\s(?i)TOP\\.\\s", "\\s(?i)INH\\s", "\\s(?i)SUPP\\s", "\\s(?i)O.D.\\s", "\\s(?i)O.S.\\s", "\\s(?i)O.U.\\s", "\\s(?i)" + OD + "\\s", "\\s(?i)OS\\s", "\\s(?i)OU\\s"};
            String[] frequences = new String[]{"\\s(?i)" + OD + "\\s", "\\s(?i)BID\\s", "\\s(?i)TID\\s", "\\s(?i)QID\\s", "\\s(?i)Q1H\\s", "\\s(?i)Q2H\\s", "\\s(?i)Q1-2H\\s", "\\s(?i)Q3-4H\\s", "\\s(?i)Q4H\\s", "\\s(?i)Q4-6H\\s", "\\s(?i)Q6H\\s", "\\s(?i)Q8H\\s", "\\s(?i)Q12H\\s", "\\s(?i)QAM\\s", "\\s(?i)QPM\\s", "\\s(?i)QHS\\s", "\\s(?i)Q1" + Week + "\\s", "\\s(?i)" + weekly + "\\s", "\\s(?i)Q2" + Week + "\\s", "\\s(?i)Q1" + Month + "\\s", "\\s(?i)Q3" + Month + "\\s", "\\s(?i)" + monthly + "\\s", "\\s(?i)" + once_daily + "\\s", "\\s(?i)" + twice_daily + "\\s", "\\s(?i)3x " + _day + "\\s", "\\s(?i)4x " + _day + "\\s", "\\s(?i)3x" + _daily + "\\s", "\\s(?i)4x" + _daily + "\\s", "\\s(?i)" + OD + "$", "\\s(?i)BID$", "\\s(?i)TID$", "\\s(?i)QID$", "\\s(?i)Q1H$", "\\s(?i)Q2H$", "\\s(?i)Q1-2H$", "\\s(?i)Q3-4H$", "\\s(?i)Q4H$", "\\s(?i)Q4-6H$", "\\s(?i)Q6H$", "\\s(?i)Q8H$", "\\s(?i)Q12H$", "\\s(?i)QAM$", "\\s(?i)QPM$", "\\s(?i)QHS$", "\\s(?i)Q1" + Week + "$", "\\s(?i)" + weekly + "$", "\\s(?i)Q2" + Week + "$", "\\s(?i)Q1" + Month + "$", "\\s(?i)Q3" + Month + "$", "\\s(?i)" + monthly + "$", "\\s(?i)" + once_daily + "$", "\\s(?i)" + twice_daily + "$", "\\s(?i)3x" + _day + "$", "\\s(?i)4x" + _day + "$", "\\s(?i)3x" + _daily + "$", "\\s(?i)4x" + _daily + "$", "\\s(?i)" + daily + "\\s", "\\s(?i)" + daily + "$"};
            String[] methods = new String[]{"(?i)" + Take, "(?i)" + Apply, "(?i)" + Rub_well_in};
            String[] durationUnits = new String[]{"\\s+(?i)" + days + "\\s", "\\s+(?i)" + weeks + "\\s", "\\s+(?i)" + months + "\\s", "\\s+(?i)" + day + "\\s", "\\s+(?i)" + week + "\\s", "\\s+(?i)" + month + "\\s", "\\s+(?i)" + d + "\\s", "\\s+(?i)" + w + "\\s", "\\s+(?i)" + RxUtil.m + "\\s", "\\s+(?i)" + mo + "\\s", "\\s+(?i)" + days + "$", "\\s+(?i)" + weeks + "$", "\\s+(?i)" + months + "$", "\\s+(?i)" + day + "$", "\\s+(?i)" + week + "$", "\\s+(?i)" + month + "$", "\\s+(?i)" + d + "$", "\\s+(?i)" + w + "$", "\\s+(?i)" + RxUtil.m + "$", "\\s+(?i)" + mo + "$"};
            String[] durUnits2 = new String[]{"\\s[0-9]+(?i)" + days + "\\s", "\\s[0-9]+(?i)" + weeks + "\\s", "\\s[0-9]+(?i)" + months + "\\s", "\\s[0-9]+(?i)" + day + "\\s", "\\s[0-9]+(?i)" + week + "\\s", "\\s[0-9]+(?i)" + month + "\\s", "\\s[0-9]+(?i)" + d + "\\s", "\\s[0-9]+(?i)" + w + "\\s", "\\s[0-9]+(?i)" + RxUtil.m + "\\s", "\\s[0-9]+(?i)" + mo + "\\s", "\\s[0-9]+(?i)" + days + "$", "\\s[0-9]+(?i)" + weeks + "$", "\\s[0-9]+(?i)" + months + "$", "\\s[0-9]+(?i)" + day + "$", "\\s[0-9]+(?i)" + week + "$", "\\s[0-9]+(?i)" + month + "$", "\\s[0-9]+(?i)" + d + "$", "\\s[0-9]+(?i)" + w + "$", "\\s[0-9]+(?i)" + RxUtil.m + "$", "\\s[0-9]+(?i)" + mo + "$"};
            for (String s : routes) {
                p3 = Pattern.compile(s);
                matcher = p3.matcher(instructions);
                if (!matcher.find()) continue;
                route = instructions.substring(matcher.start(), matcher.end()).trim();
                if (!route.equalsIgnoreCase(OD)) break;
                RxUtil.p("route is OD");
                String part = instructions.substring(0, matcher.start()) + " " + instructions.substring(matcher.end());
                RxUtil.p("part is " + part);
                Pattern fPattern = Pattern.compile("\\s(?i)" + OD + "\\s*");
                Matcher fMatcher = fPattern.matcher(part);
                String frequencyStr = "";
                if (fMatcher.find()) {
                    frequencyStr = part.substring(fMatcher.start(), fMatcher.end());
                    break;
                }
                if (frequencyStr.equals("")) {
                    frequency = OD;
                    route = "";
                    continue;
                }
                frequency = frequencyStr;
                break;
            }
            RxUtil.p("route", route);
            if (route.equals("")) {
                // empty if block
            }
            block2: for (String s : frequences) {
                p3 = Pattern.compile(s);
                matcher = p3.matcher(instructions);
                if (!matcher.find()) continue;
                frequency = instructions.substring(matcher.start(), matcher.end()).trim();
                frequency = RxUtil.changeToStandardFrequencyCode(frequency);
                p2 = Pattern.compile("\\s*\\d*\\.*\\d+\\s+" + frequency);
                m2 = p2.matcher(instructions);
                p4 = Pattern.compile("\\s*\\d*\\.*\\d+-\\s*\\d*\\.*\\d+\\s+" + frequency);
                m4 = p4.matcher(instructions);
                if (m4.find()) {
                    str2 = instructions.substring(m4.start(), m4.end());
                    Pattern p52 = Pattern.compile("\\d*\\.*\\d+-\\s*\\d*\\.*\\d+");
                    Matcher m52 = p52.matcher(str2);
                    if (!m52.find()) break;
                    str3 = str2.substring(m52.start(), m52.end());
                    takeMinFrequency = str3.split("-")[0];
                    takeMaxFrequency = str3.split("-")[1];
                    break;
                }
                if (m2.find()) {
                    str = instructions.substring(m2.start(), m2.end());
                    Pattern p32 = Pattern.compile("\\d*\\.*\\d+");
                    Matcher m3 = p32.matcher((CharSequence)str);
                    if (!m3.find()) break;
                    amountFrequency = ((String)str).substring(m3.start(), m3.end());
                    break;
                }
                RxUtil.p("word amount");
                for (String word : zeroToTen) {
                    r1 = "\\s" + word + "\\s*" + frequency;
                    r2 = "^" + word + "\\s*" + frequency;
                    p5 = Pattern.compile(r1);
                    m5 = p5.matcher(instructions);
                    RxUtil.p("pattern word =" + r1);
                    if (m5.find()) {
                        amountFrequency = instructions.substring(m5.start(), m5.end());
                        amountFrequency = amountFrequency.replace(frequency, "").trim();
                        RxUtil.p("amountFreq=" + amountFrequency);
                        amountFrequency = RxUtil.convertWordToNumerical(amountFrequency);
                        RxUtil.p("num amountFreq=" + amountFrequency);
                        break block2;
                    }
                    p5 = Pattern.compile(r2);
                    m5 = p5.matcher(instructions);
                    if (!m5.find()) continue;
                    amountFrequency = instructions.substring(m5.start(), m5.end());
                    amountFrequency = amountFrequency.replace(frequency, "").trim();
                    RxUtil.p("amountFreq=" + amountFrequency);
                    amountFrequency = RxUtil.convertWordToNumerical(amountFrequency);
                    RxUtil.p("num amountFreq=" + amountFrequency);
                    break block2;
                }
                break;
            }
            block4: for (String s : methods) {
                p3 = Pattern.compile(s);
                Matcher m3 = p3.matcher(instructions);
                if (!m3.find()) continue;
                RxUtil.p("must be here");
                method = instructions.substring(m3.start(), m3.end());
                p2 = Pattern.compile(method + "\\s*\\d*\\.*\\d+\\s+");
                m2 = p2.matcher(instructions);
                p4 = Pattern.compile(method + "\\s*\\d*\\.*\\d+-\\s*\\d*\\.*\\d+\\s+");
                m4 = p4.matcher(instructions);
                if (m4.find()) {
                    RxUtil.p("else if 1");
                    str2 = instructions.substring(m4.start(), m4.end());
                    Pattern p53 = Pattern.compile("\\d*\\.*\\d+-\\s*\\d*\\.*\\d+");
                    Matcher m53 = p53.matcher(str2);
                    if (!m53.find()) break;
                    str3 = str2.substring(m53.start(), m53.end());
                    takeMinMethod = str3.split("-")[0];
                    takeMaxMethod = str3.split("-")[1];
                    break;
                }
                if (m2.find()) {
                    RxUtil.p("if 1");
                    str = instructions.substring(m2.start(), m2.end());
                    RxUtil.p("str1 ", (String)str);
                    Pattern p33 = Pattern.compile("\\d*\\.*\\d+");
                    Matcher m32 = p33.matcher((CharSequence)str);
                    if (!m32.find()) break;
                    RxUtil.p("found1");
                    amountMethod = ((String)str).substring(m32.start(), m32.end());
                    break;
                }
                RxUtil.p("word amount");
                for (String word : zeroToTen) {
                    r1 = method + "\\s+" + word + "\\s";
                    r2 = method + "\\s+" + word + "$";
                    p5 = Pattern.compile(r1);
                    m5 = p5.matcher(instructions);
                    RxUtil.p("pattern word =" + r1);
                    if (m5.find()) {
                        amountMethod = instructions.substring(m5.start(), m5.end());
                        amountMethod = amountMethod.replace(method, "").trim();
                        RxUtil.p("amountMethod=" + amountMethod);
                        amountMethod = RxUtil.convertWordToNumerical(amountMethod);
                        RxUtil.p("num amountMethod=" + amountMethod);
                        break block4;
                    }
                    p5 = Pattern.compile(r2);
                    m5 = p5.matcher(instructions);
                    RxUtil.p("pattern word =" + r2);
                    if (!m5.find()) continue;
                    amountMethod = instructions.substring(m5.start(), m5.end());
                    amountMethod = amountMethod.replace(method, "").trim();
                    RxUtil.p("amountMethod=" + amountMethod);
                    amountMethod = RxUtil.convertWordToNumerical(amountMethod);
                    RxUtil.p("num amountMethod=" + amountMethod);
                    break block4;
                }
                break;
            }
            if (!takeMinMethod.equals("") && takeMinFrequency.equals("")) {
                takeMin = takeMinMethod;
                takeMax = takeMaxMethod;
            } else if (takeMinMethod.equals("") && !takeMinFrequency.equals("")) {
                takeMin = takeMinFrequency;
                takeMax = takeMaxFrequency;
            } else if (!takeMinMethod.equals("") && !takeMinFrequency.equals("")) {
                takeMin = takeMinFrequency;
                takeMax = takeMaxFrequency;
            }
            if (!amountMethod.equals("") && amountFrequency.equals("")) {
                takeMax = takeMin = amountMethod;
            } else if (amountMethod.equals("") && !amountFrequency.equals("")) {
                takeMax = takeMin = amountFrequency;
            } else if (!amountMethod.equals("") && !amountFrequency.equals("")) {
                takeMin = amountFrequency;
                takeMax = amountFrequency;
            }
            for (String s : durationUnits) {
                instructionToCheck = RxUtil.checkInstructionStr(instructions);
                p = Pattern.compile(s);
                m = p.matcher(instructionToCheck);
                if (!m.find()) continue;
                RxUtil.p("FOUND");
                RxUtil.p("instructionToCheck==", instructionToCheck);
                RxUtil.p(s);
                durationUnitSpec = instructionToCheck.substring(m.start(), m.end()).trim();
                RxUtil.p("durationUnitSpec", durationUnitSpec);
                Pattern p1 = Pattern.compile("[0-9]+" + s);
                Matcher m1 = p1.matcher(instructionToCheck);
                if (!m1.find()) break;
                RxUtil.p("" + m1.start(), "" + m.start());
                durationSpec = instructionToCheck.substring(m1.start(), m.start());
                duration = durationSpec.trim();
                RxUtil.p("duration here1", duration);
                break;
            }
            if (durationUnitSpec.equals("")) {
                for (String s : durUnits2) {
                    instructionToCheck = RxUtil.checkInstructionStr(instructions);
                    p = Pattern.compile(s);
                    m = p.matcher(instructionToCheck);
                    if (!m.find()) continue;
                    RxUtil.p("FOUND");
                    RxUtil.p("instructionToCheck=" + instructionToCheck);
                    RxUtil.p(s);
                    String str1 = instructionToCheck.substring(m.start(), m.end());
                    Pattern p1 = Pattern.compile("[0-9]+");
                    Matcher m1 = p1.matcher(str1);
                    if (!m1.find()) continue;
                    duration = str1.substring(m1.start(), m1.end());
                    durationUnitSpec = str1.substring(m1.end()).trim();
                    break;
                }
            }
            if (durationUnitSpec.equals("")) {
                String[] freq1 = new String[]{"\\s*(?i)" + OD + "\\s*", "\\s*(?i)BID\\s*", "\\s*(?i)TID\\s*", "\\s*(?i)QID\\s*", "\\s*(?i)Q1H\\s*", "\\s*(?i)Q2H\\s*", "\\s*(?i)Q1-2H\\s*", "\\s*(?i)Q3-4H\\s*", "\\s*(?i)Q4H\\s*", "\\s*(?i)Q4-6H\\s*", "\\s*(?i)Q6H\\s*", "\\s*(?i)Q8H\\s*", "\\s*(?i)Q12H\\s*", "\\s*(?i)QAM\\s*", "\\s*(?i)QPM\\s*", "\\s*(?i)QHS\\s*", "\\s*(?i)" + once_daily + "\\s*", "\\s*(?i)" + twice_daily + "\\s*", "\\s*(?i)3x " + day + "\\s*", "\\s*(?i)4x " + day + "\\s*", "\\s*(?i)3x " + daily + "\\s*", "\\s*(?i)4x " + daily + "\\s*", "\\s*(?i)" + daily + "\\s*"};
                String[] freq2 = new String[]{"\\s*(?i)Q1" + Week + "\\s*", "\\s*(?i)Q2" + Week + "\\s*"};
                String[] freq3 = new String[]{"\\s*(?i)Q1" + Month + "\\s*", "\\s*(?i)Q3" + Month + "\\s*"};
                boolean found = false;
                for (String f1 : freq1) {
                    Pattern p6 = Pattern.compile(f1);
                    Matcher m6 = p6.matcher(frequency);
                    if (!m6.find()) continue;
                    durationUnit = D;
                    found = true;
                }
                if (!found) {
                    for (String f2 : freq2) {
                        Pattern p22 = Pattern.compile(f2);
                        Matcher m22 = p22.matcher(frequency);
                        if (!m22.find()) continue;
                        durationUnit = String.valueOf(Week.charAt(48));
                        found = true;
                    }
                }
                if (!found) {
                    for (String f3 : freq3) {
                        Pattern p34 = Pattern.compile(f3);
                        Matcher m3 = p34.matcher(frequency);
                        if (!m3.find()) continue;
                        durationUnit = M;
                        found = true;
                    }
                }
            } else if (durationUnitSpec.equalsIgnoreCase(week) || durationUnitSpec.equalsIgnoreCase(weeks) || durationUnitSpec.equalsIgnoreCase(w)) {
                durationUnit = String.valueOf(Week.toUpperCase().charAt(0));
            } else if (durationUnitSpec.equalsIgnoreCase(day) || durationUnitSpec.equalsIgnoreCase(days) || durationUnitSpec.equalsIgnoreCase(d)) {
                durationUnit = String.valueOf(Day.toUpperCase().charAt(0));
            } else if (durationUnitSpec.equalsIgnoreCase(month) || durationUnitSpec.equalsIgnoreCase(months) || durationUnitSpec.equalsIgnoreCase(RxUtil.m) || durationUnitSpec.equalsIgnoreCase(mo) || durationUnitSpec.equalsIgnoreCase(Month)) {
                durationUnit = String.valueOf(Month.toUpperCase().charAt(0));
            }
            if (takeMax.compareTo(takeMin) < 0) {
                String swap = takeMin;
                takeMin = takeMax;
                takeMax = swap;
            }
        }
    }

    public static boolean isStringToNumber(String s) {
        String numStr;
        String restStr;
        boolean retBool = false;
        Pattern p1 = Pattern.compile("\\d*\\.*\\d+");
        Matcher m1 = p1.matcher(s);
        retBool = m1.find() ? (restStr = s.replace(numStr = s.substring(m1.start(), m1.end()), "").trim()) == null || restStr.length() <= 0 : false;
        return retBool;
    }

    public static void p(String str, String s) {
        System.out.println(str + "=" + s);
    }

    public static void p(String str) {
        System.out.println(str);
    }
}

