/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.encounter;

import ca.infodata.ofys.data.middle.dataobjects.encounter.IEncounterRelated;
import ca.infodata.ofys.data.middle.dataobjects.encounter.IEncounterRelatedDelatableVersionnable;
import ca.infodata.ofys.data.middle.dataobjects.encounter.IHaveAnAnchor;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XBaseEncounter;
import ca.infodata.ofys.data.middle.dataobjects.encounter.XEncounterLabel;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import java.util.EnumSet;

public final class XMeasurement
extends EditableDataObject
implements IEncounterRelated,
IHaveAnAnchor,
IEncounterRelatedDelatableVersionnable {
    private static final long serialVersionUID = 1L;
    public Integer id;
    public Integer idAnchor;
    private Integer idNextModificationEntry;
    public Float height;
    public Float weight;
    public Float waistMeasurement;
    public Float headCirc;
    public Long timeVitalSign;
    public Long entryDatetime;
    public String note;
    public Boolean isDeleted;
    public XBaseEncounter encounter;
    private Boolean isFromEform;
    public Integer nbJrsPremature;
    public EnumSet<XEncounterLabel> encLabel = EnumSet.noneOf(XEncounterLabel.class);

    public EnumSet<XEncounterLabel> getEncLabel() {
        return this.encLabel;
    }

    public void setEncLabel(EnumSet<XEncounterLabel> status) {
        this.encLabel = status;
        this.setUpdated();
    }

    public void removeXEncounterLabel(XEncounterLabel x) {
        this.encLabel.remove(x);
        this.setUpdated();
    }

    public void addXEncounterLabel(XEncounterLabel x) {
        this.encLabel.add(x);
        this.setUpdated();
    }

    @Override
    @Deprecated
    public void initialize() {
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public Float getHeight() {
        return this.height;
    }

    public void setHeight(Float height) {
        this.height = height;
        this.setUpdated();
    }

    public Float getWeight() {
        return this.weight;
    }

    public void setWeight(Float weight) {
        this.weight = weight;
        this.setUpdated();
    }

    public Float getWaistMeasurement() {
        return this.waistMeasurement;
    }

    public void setWaistMeasurement(Float waistMeasurement) {
        this.waistMeasurement = waistMeasurement;
        this.setUpdated();
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
        this.setUpdated();
    }

    @Override
    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XMeasurement) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XMeasurement" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public XMeasurement clone() {
        XMeasurement c = (XMeasurement)super.clone();
        c.id = this.id;
        c.idAnchor = this.idAnchor;
        c.headCirc = this.headCirc;
        c.height = this.height;
        c.nbJrsPremature = this.nbJrsPremature;
        c.waistMeasurement = this.waistMeasurement;
        c.weight = this.weight;
        c.note = this.note;
        c.isDeleted = this.isDeleted;
        c.timeVitalSign = this.timeVitalSign;
        c.entryDatetime = this.entryDatetime;
        c.encLabel = this.encLabel.clone();
        return c;
    }

    public Float getHeadCirc() {
        return this.headCirc;
    }

    public void setHeadCirc(Float headCirc) {
        this.headCirc = headCirc;
        this.setUpdated();
    }

    public Long getTimeVitalSign() {
        return this.timeVitalSign;
    }

    public void setTimeVitalSign(Long timeVitalSign) {
        this.timeVitalSign = timeVitalSign;
        this.setUpdated();
    }

    public Long getEntryDatetime() {
        return this.entryDatetime;
    }

    public void setEntryDatetime(Long entryDatetime) {
        this.entryDatetime = entryDatetime;
        this.setUpdated();
    }

    public Double getIMC() {
        Double result = null;
        if (this.weight != null && this.height != null && this.weight.floatValue() > 0.0f && this.height.floatValue() > 0.0f) {
            result = (double)this.weight.floatValue() / Math.pow(this.height.floatValue() / 100.0f, 2.0);
        }
        return result;
    }

    @Override
    public XBaseEncounter getEncounter() {
        return this.encounter;
    }

    @Override
    public void setEncounter(XBaseEncounter encounter) {
        this.encounter = encounter;
        this.setUpdated();
    }

    @Override
    public String toString() {
        return String.format("XMeasurement [id=%s, idAnchor=%s, height=%s, weight=%s, waistMeasurement=%s, headCirc=%s, entryDatetime=%s, note=%s, isDeleted=%s, encounter=%s]", this.id, this.idAnchor, this.height, this.weight, this.waistMeasurement, this.headCirc, this.entryDatetime, this.note, this.isDeleted, this.encounter);
    }

    @Override
    public Integer getIdAnchor() {
        return this.idAnchor;
    }

    public void setIdAnchor(Integer idAnchor) {
        this.idAnchor = idAnchor;
        this.setUpdated();
    }

    @Override
    public final Integer getIdNextModificationEntry() {
        return this.idNextModificationEntry;
    }

    public final void setIdNextModificationEntry(Integer idNextModificationEntry) {
        this.idNextModificationEntry = idNextModificationEntry;
    }

    public Double calculIMC() {
        Double result = null;
        if (this.getWeight() != null && this.getHeight() != null && this.getWeight().floatValue() > 0.0f && this.getHeight().floatValue() > 0.0f) {
            result = (double)this.getWeight().floatValue() / Math.pow(this.getHeight().floatValue() / 100.0f, 2.0);
        }
        return result;
    }

    public Boolean getIsFromEform() {
        return this.isFromEform;
    }

    public void setIsFromEform(Boolean isFromEform) {
        this.isFromEform = isFromEform;
        this.setUpdated();
    }

    public final Integer getNbJrsPremature() {
        return this.nbJrsPremature;
    }

    public final void setNbJrsPremature(Integer nbJrsPremature) {
        this.nbJrsPremature = nbJrsPremature;
        this.setUpdated();
    }
}

