/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.appointment;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.appointment.XAppointmentDateTemplate;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IEditableDataObjectList;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ModificationStatus;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.util1.StringUtils;

public final class XAppointmentWeekTemplate
extends EditableDataObject {
    private static final long serialVersionUID = 1L;
    public EditableDataObject.Property<Integer> id = this.newProperty("id", null);
    public EditableDataObject.Property<String> note = this.newProperty("note", "");
    public EditableDataObject.Property<Integer> professionnal = this.newProperty("professionnal", null);
    public EditableDataObject.Property<Boolean> isDeleted = this.newProperty("isDeleted", false);
    public EditableDataObject.Property<XAppointmentDateTemplate> sunday = this.newProperty("sunday", null);
    public EditableDataObject.Property<XAppointmentDateTemplate> monday = this.newProperty("monday", null);
    public EditableDataObject.Property<XAppointmentDateTemplate> tuesday = this.newProperty("tuesday", null);
    public EditableDataObject.Property<XAppointmentDateTemplate> wednesday = this.newProperty("wednesday", null);
    public EditableDataObject.Property<XAppointmentDateTemplate> thursday = this.newProperty("thursday", null);
    public EditableDataObject.Property<XAppointmentDateTemplate> friday = this.newProperty("friday", null);
    public EditableDataObject.Property<XAppointmentDateTemplate> saturday = this.newProperty("saturday", null);

    @Override
    protected void childModified(Object object) {
        this.setModificationStatus(ModificationStatus.STATUS_UPDATED);
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XAppointmentWeekTemplate) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    public IEditableDataObjectList<XAppointmentDateTemplate> getWeek() {
        EditableDataObjectList<XAppointmentDateTemplate> list = new EditableDataObjectList<XAppointmentDateTemplate>(7);
        list.add(this.getSunday());
        list.add(this.getMonday());
        list.add(this.getTuesday());
        list.add(this.getWednesday());
        list.add(this.getThursday());
        list.add(this.getFriday());
        list.add(this.getSaturday());
        return list;
    }

    public XAppointmentDateTemplate getMonday() {
        return this.monday.get();
    }

    public XAppointmentDateTemplate getTuesday() {
        return this.tuesday.get();
    }

    public XAppointmentDateTemplate getWednesday() {
        return this.wednesday.get();
    }

    public XAppointmentDateTemplate getThursday() {
        return this.thursday.get();
    }

    public XAppointmentDateTemplate getFriday() {
        return this.friday.get();
    }

    public XAppointmentDateTemplate getSaturday() {
        return this.saturday.get();
    }

    public XAppointmentDateTemplate getSunday() {
        return this.sunday.get();
    }

    public XAppointmentDateTemplate setSunday(XAppointmentDateTemplate template) {
        XAppointmentDateTemplate old = this.sunday.get();
        this.sunday.set(template);
        return old;
    }

    public XAppointmentDateTemplate setMonday(XAppointmentDateTemplate template) {
        XAppointmentDateTemplate old = this.monday.get();
        this.monday.set(template);
        return old;
    }

    public XAppointmentDateTemplate setTuesday(XAppointmentDateTemplate template) {
        XAppointmentDateTemplate old = this.tuesday.get();
        this.tuesday.set(template);
        return old;
    }

    public XAppointmentDateTemplate setWednesday(XAppointmentDateTemplate template) {
        XAppointmentDateTemplate old = this.wednesday.get();
        this.wednesday.set(template);
        return old;
    }

    public XAppointmentDateTemplate setThursday(XAppointmentDateTemplate template) {
        XAppointmentDateTemplate old = this.thursday.get();
        this.thursday.set(template);
        return old;
    }

    public XAppointmentDateTemplate setFriday(XAppointmentDateTemplate template) {
        XAppointmentDateTemplate old = this.friday.get();
        this.friday.set(template);
        return old;
    }

    public XAppointmentDateTemplate setSaturday(XAppointmentDateTemplate template) {
        XAppointmentDateTemplate old = this.saturday.get();
        this.saturday.set(template);
        return old;
    }

    public XAppointmentDateTemplate getDay(int dayOfWeek) {
        switch (dayOfWeek) {
            case 0: {
                return this.getSunday();
            }
            case 1: {
                return this.getMonday();
            }
            case 2: {
                return this.getTuesday();
            }
            case 3: {
                return this.getWednesday();
            }
            case 4: {
                return this.getThursday();
            }
            case 5: {
                return this.getFriday();
            }
            case 6: {
                return this.getSaturday();
            }
        }
        throw new IllegalArgumentException("dayOfWeek : " + dayOfWeek + " not in [0..6]");
    }

    public XAppointmentDateTemplate setDateTemplate(int dayOfWeek, XAppointmentDateTemplate template) {
        switch (dayOfWeek) {
            case 0: {
                return this.setSunday(template);
            }
            case 1: {
                return this.setMonday(template);
            }
            case 2: {
                return this.setTuesday(template);
            }
            case 3: {
                return this.setWednesday(template);
            }
            case 4: {
                return this.setThursday(template);
            }
            case 5: {
                return this.setFriday(template);
            }
            case 6: {
                return this.setSaturday(template);
            }
        }
        throw new IllegalArgumentException("dayOfWeek : " + dayOfWeek + " not in [0..6]");
    }

    public int getDayOfWeek(XAppointmentDateTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template is null");
        }
        return this.getWeek().indexOf(template);
    }

    @Override
    public Integer getId() {
        return this.id.get();
    }

    public boolean getIsDeleted() {
        return this.isDeleted.get();
    }

    public String getNote() {
        return this.note.get();
    }

    public Integer getProfessionnal() {
        return this.professionnal.get();
    }

    public String getToolTipText() {
        return this.getNote();
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XAppointmentWeekTemplate" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.isDirty(this.getSunday()) || this.isDirty(this.getMonday()) || this.isDirty(this.getTuesday()) || this.isDirty(this.getWednesday()) || this.isDirty(this.getThursday()) || this.isDirty(this.getFriday()) || this.isDirty(this.getSaturday());
    }

    private boolean isDirty(XAppointmentDateTemplate template) {
        return template != null && template.isDirty();
    }

    @Override
    public IStatus valid() {
        MultiStatus status = new MultiStatus();
        status.add(super.valid());
        if (StringUtils.isBlank((CharSequence)this.getNote())) {
            status.add(new Status(IStatus.Severity.ERROR, Messages.getString("__ENTREZ_UNE_DESCRIPTION_DE_LA_SEMAINE", new String[0])));
        }
        return status;
    }

    @Override
    public void setId(Integer id) {
        this.id.set(id);
    }

    public void setIsDeleted(boolean isDeleted) {
        if (this.isNewOrNewUpdated()) {
            this.isDeleted.set((Boolean)isDeleted, ModificationStatus.STATUS_DELETED);
        } else {
            this.isDeleted.set(isDeleted);
        }
    }

    public void setNote(String note) {
        this.note.set(note);
    }

    public void setProfessionnal(Integer professionnal) {
        this.professionnal.set(professionnal);
    }

    @Override
    public void setTag() {
        super.setTag();
        this.setTag(this.getTag());
    }

    @Override
    public void setTag(Integer tag) {
        super.setTag(tag);
        this.setTag(this.getSunday(), tag);
        this.setTag(this.getMonday(), tag);
        this.setTag(this.getTuesday(), tag);
        this.setTag(this.getWednesday(), tag);
        this.setTag(this.getThursday(), tag);
        this.setTag(this.getFriday(), tag);
        this.setTag(this.getSaturday(), tag);
    }

    private void setTag(XAppointmentDateTemplate template, Integer tag) {
        if (template != null) {
            template.setTag();
        }
    }

    @Override
    public String toString() {
        return String.format("XAppointmentWeekTemplate [id=%s, idProf=%s, status=%s, tag=%s, version=%s]", this.getId(), this.getProfessionnal(), this.getModificationStatus(), this.getTag(), this.getVersion());
    }

    @Override
    public XAppointmentWeekTemplate clone() {
        XAppointmentWeekTemplate c = (XAppointmentWeekTemplate)super.clone();
        c.id = this.clonePropertyTo(c, this.id);
        c.note = this.clonePropertyTo(c, this.note);
        c.professionnal = this.clonePropertyTo(c, this.professionnal);
        c.isDeleted = this.clonePropertyTo(c, this.isDeleted);
        c.sunday = this.clonePropertyTo(c, this.sunday);
        c.monday = this.clonePropertyTo(c, this.monday);
        c.tuesday = this.clonePropertyTo(c, this.tuesday);
        c.wednesday = this.clonePropertyTo(c, this.wednesday);
        c.thursday = this.clonePropertyTo(c, this.thursday);
        c.friday = this.clonePropertyTo(c, this.friday);
        c.saturday = this.clonePropertyTo(c, this.saturday);
        return c;
    }
}

