/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.middle.dataobjects.appointment;

import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.EditableDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ICompletionComboItem;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.util.MiscUtil;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.LocaleProvider;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;

public final class XAppointmentPeriodType
extends EditableDataObject
implements ICompletionComboItem,
KryoSerializable {
    private static final long serialVersionUID = 1L;
    public static String type = "appointmentPeriodTypes";
    public Integer id;
    public int[] color = null;
    public String french = "";
    public String english = "";
    public String spanish = "";
    public Boolean isDeleted = false;
    public Boolean isDefault = false;
    public Boolean canHaveAppointment = true;
    public String code;
    public String message;
    public Integer duration;
    public Integer professionnal;

    @Override
    public void write(Kryo k, Output output) {
        int[] nArray;
        output.writeInt(MiscUtil.fromInt(this.getId()));
        if (this.color == null) {
            int[] nArray2 = new int[3];
            nArray2[0] = 255;
            nArray2[1] = 255;
            nArray = nArray2;
            nArray2[2] = 255;
        } else {
            nArray = this.color;
        }
        this.color = nArray;
        output.writeInt(MiscUtil.transfertIntegerArrayToInteger(this.color).intValue(), true);
        output.writeString(MiscUtil.fromString(this.getFrench()));
        output.writeString(MiscUtil.fromString(this.getEnglish()));
        output.writeString(MiscUtil.fromString(this.getSpanish()));
        output.writeBoolean(Boolean.TRUE.equals(this.getIsDeleted()));
        output.writeBoolean(Boolean.TRUE.equals(this.getIsDefault()));
        output.writeBoolean(Boolean.TRUE.equals(this.getCanHaveAppointment()));
        output.writeString(MiscUtil.fromString(this.code));
        output.writeString(MiscUtil.fromString(this.message));
        output.writeInt(MiscUtil.fromInt(this.duration));
        output.writeInt(MiscUtil.fromInt(this.professionnal));
        super.write(k, output);
    }

    @Override
    public void read(Kryo k, Input input) {
        this.id = MiscUtil.toInt(input.readInt());
        this.color = MiscUtil.transfertIntToIntegerArray(input.readInt(true));
        this.french = MiscUtil.toString(input.readString());
        this.english = MiscUtil.toString(input.readString());
        this.spanish = MiscUtil.toString(input.readString());
        this.isDeleted = input.readBoolean();
        this.isDefault = input.readBoolean();
        this.canHaveAppointment = input.readBoolean();
        this.code = MiscUtil.toString(input.readString());
        this.message = MiscUtil.toString(input.readString());
        this.duration = MiscUtil.toInt(input.readInt());
        this.professionnal = MiscUtil.toInt(input.readInt());
        super.read(k, input);
    }

    @Override
    public XAppointmentPeriodType clone() {
        XAppointmentPeriodType c = (XAppointmentPeriodType)super.clone();
        c.id = this.id;
        c.french = this.french;
        c.english = this.english;
        c.spanish = this.spanish;
        c.color = this.color;
        c.isDeleted = this.isDeleted;
        c.isDefault = this.isDefault;
        c.canHaveAppointment = this.canHaveAppointment;
        return c;
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof XAppointmentPeriodType) {
            equals = this.getId() == null ? super.equals(obj) : this.hashCode() == obj.hashCode();
        }
        return equals;
    }

    public Boolean getCanHaveAppointment() {
        return this.canHaveAppointment;
    }

    public int[] getColor() {
        return this.color;
    }

    public String getEnglish() {
        return this.english == null ? "" : this.english;
    }

    public String getSpanish() {
        return this.spanish == null ? "" : this.spanish;
    }

    public String getFrench() {
        return this.french == null ? "" : this.french;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        hashCode = this.getId() == null ? super.hashCode() : ("XAppointmentPeriodType" + this.getId().hashCode()).hashCode();
        return hashCode;
    }

    @Override
    @Deprecated
    public void initialize() {
    }

    @Override
    public IStatus valid() {
        MultiStatus status = new MultiStatus();
        status.add(super.valid());
        if (!this.getIsDeleted().booleanValue() && !this.isNonExisting() && StringUtils.isBlank((CharSequence)this.getFrench()) && StringUtils.isBlank((CharSequence)this.getEnglish()) && StringUtils.isBlank((CharSequence)this.getSpanish())) {
            status.add(new Status(IStatus.Severity.ERROR, Messages.getString("ENTREZ_UN_NOM_POUR_LE_TYPE_DE_PERIODE", new String[0])));
        }
        return status;
    }

    public void setCanHaveAppointment(Boolean canHaveAppointment) {
        this.canHaveAppointment = canHaveAppointment;
        this.setUpdated();
    }

    public void setColor(int[] color) {
        this.color = color;
        this.setUpdated();
    }

    public void setEnglish(String english) {
        this.english = english;
        this.setUpdated();
    }

    public void setSpanish(String spanish) {
        this.spanish = spanish;
        this.setUpdated();
    }

    public void setFrench(String french) {
        this.french = french;
        this.setUpdated();
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
        this.setUpdated();
    }

    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        this.setUpdated();
        if (isDeleted != null && isDeleted.booleanValue() && this.isNewOrNewUpdated()) {
            this.setDeleted();
        }
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        this.setUpdated();
    }

    @Override
    public String toString() {
        return String.format("XAppoitnmentPeriodType [id=%s, fr=%s, en=%s, sp=%s, appointment?=%s, color=%s, deleted?=%s]", this.getId(), this.getFrench(), this.getEnglish(), this.getSpanish(), this.getCanHaveAppointment(), this.getColor(), this.getIsDeleted());
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public String getText() {
        if (LocaleProvider.isEnglish()) {
            return this.getEnglish();
        }
        if (LocaleProvider.isSpanish()) {
            return this.getSpanish();
        }
        return this.getFrench();
    }

    @Override
    public boolean isActive() {
        return !Boolean.TRUE.equals(this.getIsDeleted());
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
        this.setUpdated();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.setUpdated();
    }

    public Integer getDuration() {
        return this.duration;
    }

    public Integer getDuree() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
        this.setUpdated();
    }

    public Integer getProfessionnal() {
        return this.professionnal;
    }

    public void setProfessionnal(Integer professionnal) {
        this.professionnal = professionnal;
        this.setUpdated();
    }

    public String getDescription() {
        boolean b = false;
        StringBuilder buffer = new StringBuilder();
        if (this.getFrench() != null) {
            buffer.append(this.getFrench());
            b = true;
        }
        if (this.getEnglish() != null && !this.getEnglish().equals(this.getFrench())) {
            if (b) {
                buffer.append(", ");
            }
            buffer.append(this.getEnglish());
            b = true;
        }
        if (this.getSpanish() != null && !this.getSpanish().equals(this.getEnglish()) && !this.getSpanish().equals(this.getFrench())) {
            if (b) {
                buffer.append(", ");
            }
            buffer.append(this.getSpanish());
        }
        return buffer.toString();
    }
}

