/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.callback;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.callback.IStatusHandler;
import ca.infodata.ofys.data.dataaccess.callback.JobCallback;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SaveCallback
extends JobCallback {
    private static final Logger logger = Logger.getLogger(SaveCallback.class.getName());
    private BaseAccessorClient accessorClient;
    private Serializable dataObject;
    private final XSession session;
    private SaveCallback askQuestionSaveCallback;

    public SaveCallback(XSession session) {
        this(session, BaseAccessorClient.defaultStatusHandler);
    }

    public SaveCallback(XSession session, IStatusHandler statusHandler) {
        super(Messages.getString((String)"SAUVEGARDER", (String[])new String[0]), statusHandler);
        this.session = session;
        this.askQuestionSaveCallback = this;
    }

    public XSession getSession() {
        return this.session;
    }

    public BaseAccessorClient getAccessorClient() {
        return this.accessorClient;
    }

    public Serializable getDataObject() {
        return this.dataObject;
    }

    @Override
    protected boolean handleStatus(ReturnObject response) {
        block3: {
            try {
                IStatusHandler handler = this.getStatusHandler();
                if (response == null || handler == null) break block3;
                logger.log(Level.FINE, String.valueOf(response.getStatus()));
                IStatusHandler.State state = handler.handle((IStatus)response.getStatus());
                if (state != IStatusHandler.State.HANDLED_POSITIVE) break block3;
                if (this.accessorClient == null) {
                    logger.log(Level.SEVERE, "accessor client is null in SaveCallback " + this.toString());
                    break block3;
                }
                this.saveOnAskQuestion();
                return false;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error in Callback status handling. " + this.toString(), e);
            }
        }
        return true;
    }

    @Override
    public void responseReceived(ReturnObject response) {
        super.responseReceived(response);
        if (response != null && response.getStatus() != null && response.getStatus().isOkToProceed() && response.getObj() instanceof IDataObject) {
            Application.get().getGlobalInstances().getNotificationSystem().sendDataObjectUpdatedNotification((IDataObject)response.getObj(), this.session);
        }
    }

    private void saveOnAskQuestion() {
        this.accessorClient.save(BaseAccessorClient.getNextUniqueKey2(), this.session, this.getAskQuestionSaveCallback(), this.dataObject, false);
    }

    public void setDataObject(Serializable dataObject) {
        this.dataObject = dataObject;
    }

    public void setAccessorClient(BaseAccessorClient accessorClient) {
        this.accessorClient = accessorClient;
    }

    @Override
    public String toString() {
        return String.format("%s {functionName=%s, killed=%s, wasUsedOnServer=%s, dataobject=%s}", this.getClass().getSimpleName(), this.getFunctionName(), this.killed(), this.wasUsedOnServer, this.dataObject);
    }

    public SaveCallback getAskQuestionSaveCallback() {
        return this.askQuestionSaveCallback;
    }

    public void setAskQuestionSaveCallback(SaveCallback askQuestionSaveCallback) {
        this.askQuestionSaveCallback = askQuestionSaveCallback;
    }
}

