/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.IPatientValueAccessor;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.data.middle.dataobjects.patient.XPatientValue;
import ca.infodata.ofys.ui.library.log.Log;

public class PatientValueAccessorClient
extends BaseAccessorClient {
    private static PatientValueAccessorClient instance;
    private final IPatientValueAccessor accessor;

    public static PatientValueAccessorClient getInstance() throws CannotConnectToServerException {
        return PatientValueAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static PatientValueAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new PatientValueAccessorClient(serverConnectionInfo);
        }
        return instance;
    }

    private PatientValueAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getPatientValueAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    public XPatientValue getPatientValueByKey(XSession session, String key, int idPatientAnchor) {
        String function = "PatientValueAccessorClient.getPatientValueByKey";
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject returnObject = PatientValueAccessorClient.instance.accessor.getPatientValue(idPatientAnchor, key);
                XPatientValue xPatientValue = (XPatientValue)(returnObject == null ? null : returnObject.getObj());
                return xPatientValue;
            }
            catch (Exception e) {
                Log.severe((String)"Erreur", (Exception)e);
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    protected IPatientValueAccessor getAccessor() {
        return this.accessor;
    }
}

