/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ConnectionInfo
implements IConnectionInfo {
    private static final Logger logger = Logger.getLogger(IConnectionInfo.class.getName());
    public static final IConnectionInfo localhostTest = new ConnectionInfo("http://127.0.0.1:8080/", (int)TimeUnit.SECONDS.toMillis(10L));
    public static final IConnectionInfo localhostSofiapayTest = new ConnectionInfo("http://127.0.0.1:8099/sofiapay", (int)TimeUnit.SECONDS.toMillis(10L));
    public static final IConnectionInfo rxVigilanceTest = new ConnectionInfo("https://rx.stg.vigilance.ca:443/", (int)TimeUnit.SECONDS.toMillis(10L));
    public int timeoutInMillis;
    public final URL serverUrl;
    public final URL serverUrlForAccessibilityTest;
    public final String serverAddress;
    private static HostnameVerifier initialDefaultHostnameVerifier;
    private static SSLSocketFactory initialDefaultSSLSocketFactory;

    public ConnectionInfo(String serverAddress) throws IllegalArgumentException {
        this(serverAddress, (int)TimeUnit.SECONDS.toMillis(10L));
    }

    public ConnectionInfo(String serverAddress, int timeoutInMillis) throws IllegalArgumentException {
        if (serverAddress == null) {
            throw new IllegalArgumentException("serverAddress cant be null");
        }
        if (timeoutInMillis < 0) {
            throw new IllegalArgumentException("timeoutInMillis cant be < 0");
        }
        try {
            this.serverUrl = new URL(serverAddress);
            this.serverUrlForAccessibilityTest = new URL(this.serverUrl, "ofys/test/ok.gif");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("serverAddress '" + serverAddress + "' is not a valid url", e);
        }
        if (this.serverUrl.getProtocol().length() == 0 || this.serverUrl.getHost().length() == 0 || this.serverUrl.getPort() == -1) {
            throw new IllegalArgumentException("serverAddress '" + serverAddress + "' is not a valid url");
        }
        this.serverAddress = serverAddress;
        this.timeoutInMillis = timeoutInMillis;
    }

    public void setTimeoutInMillis(int timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    public int getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    public URL getServerUrl() {
        return this.serverUrl;
    }

    public URL getServerUrlForAccessibilityTest() {
        return this.serverUrlForAccessibilityTest;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String toString() {
        return String.format("ConnectionInfo [URL:%s, TIMEOUT:%s]", this.serverAddress, this.timeoutInMillis);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.serverAddress == null ? 0 : this.serverAddress.hashCode());
        result = 31 * result + this.timeoutInMillis;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IConnectionInfo)) {
            return false;
        }
        IConnectionInfo other = (IConnectionInfo)obj;
        if (this.serverAddress == null ? other.getServerAddress() != null : !this.serverAddress.equals(other.getServerAddress())) {
            return false;
        }
        return this.timeoutInMillis == other.getTimeoutInMillis();
    }

    public boolean isAccessible() {
        return true;
    }

    public boolean isAccessible2() {
        boolean isAccessible = this.isAccessibleHttp();
        if (!isAccessible) {
            isAccessible = this.isAccessibleHttp2();
        }
        return isAccessible;
    }

    private boolean isAccessibleHttp() {
        boolean isAccessible = false;
        try {
            URLConnection connection = this.serverUrlForAccessibilityTest.openConnection();
            connection.setConnectTimeout(this.timeoutInMillis);
            if (connection instanceof HttpsURLConnection) {
                int code = ((HttpsURLConnection)connection).getResponseCode();
                isAccessible = code != -1 ? code >= 100 && code < 300 : connection.getInputStream() != null;
            } else if (connection instanceof HttpURLConnection) {
                int code = ((HttpURLConnection)connection).getResponseCode();
                isAccessible = code != -1 ? code >= 100 && code < 300 : connection.getInputStream() != null;
            }
        }
        catch (IOException e1) {
            logger.log(Level.SEVERE, e1.getMessage(), e1);
        }
        return isAccessible;
    }

    private boolean isAccessibleHttp2() {
        return ConnectionInfo.isAccessibleHttp2(this.serverUrl, this.timeoutInMillis);
    }

    public static boolean isAccessibleHttp2(URL url, int timeout) {
        boolean isAccessible = false;
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            connection.setConnectTimeout(timeout);
            if (connection instanceof HttpURLConnection) {
                int code = ((HttpURLConnection)connection).getResponseCode();
                isAccessible = code != -1 ? code >= 100 && code < 300 : connection.getInputStream() != null;
            } else if (connection instanceof HttpsURLConnection) {
                int code = ((HttpsURLConnection)connection).getResponseCode();
                isAccessible = code != -1 ? code >= 100 && code < 300 : connection.getInputStream() != null;
            }
        }
        catch (IOException iOException) {}
        return isAccessible;
    }

    public static void untrustAllHttpsServerCertificate() {
        if (initialDefaultSSLSocketFactory != null) {
            HttpsURLConnection.setDefaultSSLSocketFactory(initialDefaultSSLSocketFactory);
        }
        if (initialDefaultHostnameVerifier != null) {
            HttpsURLConnection.setDefaultHostnameVerifier(initialDefaultHostnameVerifier);
        }
    }

    public static void trustAllHttpsServerCertificate() {
        try {
            if (initialDefaultSSLSocketFactory == null) {
                initialDefaultSSLSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            }
            if (initialDefaultHostnameVerifier == null) {
                initialDefaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            }
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new TrustManager[]{new AllowAllTrustManager()}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(factory);
            HttpsURLConnection.setDefaultHostnameVerifier(new IgnoreHostNameVerifier());
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Failed to trustAllHttpsServerCertificate", ex);
        }
    }

    private static class AllowAllTrustManager
    implements X509TrustManager,
    TrustManager {
        private AllowAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    private static class IgnoreHostNameVerifier
    implements HostnameVerifier {
        private IgnoreHostNameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

