/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.data.dataaccess.BaseAccessorClient;
import ca.infodata.ofys.data.dataaccess.CannotConnectToServerException;
import ca.infodata.ofys.data.dataaccess.ICallback;
import ca.infodata.ofys.data.dataaccess.IChatMessageAccessor;
import ca.infodata.ofys.data.dataaccess.IConnectionInfo;
import ca.infodata.ofys.data.dataaccess.callback.DefaultCallback;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChatMessageAccessorClient
extends BaseAccessorClient {
    private static final Logger logger = Logger.getLogger(ChatMessageAccessorClient.class.getName());
    private static ChatMessageAccessorClient instance;
    private IChatMessageAccessor accessor;

    public static ChatMessageAccessorClient getInstance() throws CannotConnectToServerException {
        return ChatMessageAccessorClient.getInstance(Application.get().getGlobalInstances().getConnectionInfo());
    }

    public static ChatMessageAccessorClient getInstance(IConnectionInfo serverConnectionInfo) throws CannotConnectToServerException {
        if (instance == null || !instance.getConnectionInfo().equals(serverConnectionInfo)) {
            instance = new ChatMessageAccessorClient(serverConnectionInfo);
        } else if (!serverConnectionInfo.isAccessible()) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(serverConnectionInfo);
            logger.throwing(instance.getClass().getName(), "getInstance", e2);
            throw e2;
        }
        return instance;
    }

    private ChatMessageAccessorClient(IConnectionInfo connectionInfo) throws CannotConnectToServerException {
        super(connectionInfo);
        try {
            this.accessor = Application.get().getDataAccessors().getChatMessageAccessor();
        }
        catch (Exception e) {
            CannotConnectToServerException e2 = new CannotConnectToServerException(connectionInfo, (Throwable)e);
            logger.throwing(this.getClass().getName(), "cinit", e2);
            throw e2;
        }
    }

    protected IChatMessageAccessor getAccessor() {
        return this.accessor;
    }

    public ReturnObject getNewChatMessagesCountSync(int idUser, XSession session) throws Exception {
        String function = "ChatMessageAccessorClient.getNewChatMessagesCount" + idUser;
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject r;
                ReturnObject returnObject = r = ChatMessageAccessorClient.instance.accessor.getNewChatMessagesCount(idUser);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    public void findNewChatMessages(final ICallback callback, XSession session, final int idUser, final Integer fromId) {
        final String function = "ChatMessageAccessorClient.findNewChatMessages" + idUser;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findNewChatMessages(idUser, fromId));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void findPatientChatMessages(final int idPatient, final Integer fromId, final ICallback callback, XSession session) {
        final String function = "ChatMessageAccessorClient.findPatientChatMessages" + idPatient;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findPatientChatMessages(idPatient, fromId));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getOldestMessageYear(final ICallback callback, final int idUser, XSession session) {
        final String function = "ChatMessageAccessorClient.getOldestMessageYear" + idUser;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getOldestMessageYear(idUser));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject getArchivedChatMessageCount(XSession session, int idUser, int y, int m) throws Exception {
        DefaultCallback callback;
        String function = "ChatMessageAccessorClient.findArchivedChatMessage" + idUser;
        if (this.isOkToCallFunction(function, callback = new DefaultCallback())) {
            try {
                ReturnObject r = ChatMessageAccessorClient.instance.accessor.getArchivedMessageCount(idUser, Integer.valueOf(y), Integer.valueOf(m));
                callback.response(r);
                ReturnObject returnObject = r;
                return returnObject;
            }
            catch (Exception e) {
                callback.exception(e);
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
        return null;
    }

    public void findArchivedChatMessage(final ICallback callback, XSession session, final int idUser, final int y, final int m) throws Exception {
        final String function = "ChatMessageAccessorClient.findArchivedChatMessage" + idUser + "y" + y + "m" + m;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findArchivedChatMessage(idUser, Integer.valueOf(y), Integer.valueOf(m)));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject getSentChatMessageCount(XSession session, int idUser, int y, int m) throws Exception {
        DefaultCallback callback;
        String function = "ChatMessageAccessorClient.findArchivedChatMessage" + idUser;
        if (this.isOkToCallFunction(function, callback = new DefaultCallback())) {
            try {
                ReturnObject r = ChatMessageAccessorClient.instance.accessor.getSentMessageCount(idUser, Integer.valueOf(y), Integer.valueOf(m));
                callback.response(r);
                ReturnObject returnObject = r;
                return returnObject;
            }
            catch (Exception e) {
                callback.exception(e);
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded(function, callback);
            }
        }
        return null;
    }

    public void findSentChatMessageBetween(final ICallback callback, XSession session, final int idUser, final int y, final int m) throws Exception {
        final String function = "ChatMessageAccessorClient.findSentChatMessageBetween" + idUser + "y" + y + "m" + m;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.findSentMessageBetween(idUser, Integer.valueOf(y), Integer.valueOf(m)));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void getAndRead(final ICallback callback, XSession session, final int idMessage) {
        final String function = "ChatMessageAccessorClient.getAndRead" + idMessage;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.getAndRead(idMessage));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public void archive(final ICallback callback, XSession session, final int[] idMessages) {
        final String function = "ChatMessageAccessorClient.archive" + idMessages;
        if (this.isOkToCallFunction(function, callback)) {
            new BaseAccessorClient.DoThread(this){

                @Override
                public ICallback run() {
                    try {
                        try {
                            callback.response(instance.accessor.archive(idMessages));
                        }
                        catch (Exception e) {
                            callback.exception(e);
                            logger.log(Level.SEVERE, "Erreur", e);
                            ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                        }
                    }
                    finally {
                        ChatMessageAccessorClient.this.functionCallEnded(function, callback);
                    }
                    return callback;
                }
            };
        }
    }

    public ReturnObject archive(XSession session, int[] ids) throws Exception {
        String function = "ChatMessageAccessorClient.archive" + ids;
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject r;
                ReturnObject returnObject = r = ChatMessageAccessorClient.instance.accessor.archive(ids);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }

    public ReturnObject respondTo(XSession session, int id, String text, int idUser) throws Exception {
        String function = "ChatMessageAccessorClient.respondTo" + id;
        if (this.isOkToCallFunction(function)) {
            try {
                ReturnObject r;
                ReturnObject returnObject = r = ChatMessageAccessorClient.instance.accessor.respondTo(id, text, idUser);
                return returnObject;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Erreur", e);
            }
            finally {
                this.functionCallEnded(function);
            }
        }
        return null;
    }
}

