/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.signature;

import ca.infodata.dsq.signature.Pkcs7Signature;
import ca.infodata.dsq.signature.XmlSignature;
import ca.infodata.dsq.tools.DocumentBuilderFactoryCache;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JX509XmlSignature {
    public static final Logger logger = Logger.getLogger(JX509XmlSignature.class.getName());
    public static final String TYPE_INTERVENANT_EMETTEUR = "IntervenantEmetteur";
    public static final String TYPE_INTERVENANT_ORIGINE = "IntervenantOrigine";
    public static final String TYPE_SIGNATURE_JURIDIQUE = "SignatureJuridique";
    private KeyStore keyStore;
    private String alias;
    private String password;
    private boolean isConfigured;

    public void configure(KeyStore keyStore, String password, String alias) {
        this.keyStore = keyStore;
        this.password = password == null ? "triggerDialog" : password;
        this.alias = alias;
        this.isConfigured = keyStore != null && alias != null;
    }

    public boolean isConfigured() {
        return this.isConfigured;
    }

    private void checkConfigured() {
        if (!this.isConfigured) {
            throw new IllegalStateException("JX509XmlSignature is not configured");
        }
    }

    public SOAPMessageContext signE(SOAPMessageContext smc) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyStoreException, SAXException, GeneralSecurityException, TransformerException, IOException, SOAPException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (smc == null) {
            throw new NullPointerException("smc");
        }
        this.checkConfigured();
        SOAPEnvelope envelope = smc.getMessage().getSOAPPart().getEnvelope();
        SOAPHeader header = this.getHeader(envelope);
        SOAPHeaderElement securityElement = header.addHeaderElement(envelope.createName("Security", null, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd"));
        securityElement.setAttribute("S:actor", TYPE_INTERVENANT_EMETTEUR);
        XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM");
        CanonicalizationMethod inclusive = factory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        SignatureMethod rsasha1 = factory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        Transform enveloped = factory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        List<Transform> transforms = Collections.singletonList(enveloped);
        DigestMethod sha1 = factory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        envelope.getBody().setAttributeNS(null, "Id", "body0");
        Reference ref = factory.newReference("#body0", sha1, transforms, null, null);
        List<Reference> references = Collections.singletonList(ref);
        SignedInfo signer = factory.newSignedInfo(inclusive, rsasha1, references);
        KeyStore store = this.keyStore;
        ArrayList<Object> certs = new ArrayList<Object>();
        PrivateKey key = null;
        if (!store.isKeyEntry(this.alias)) {
            throw new KeyStoreException("alias " + this.alias + " is not a private key.");
        }
        KeyStore.PrivateKeyEntry e = (KeyStore.PrivateKeyEntry)store.getEntry(this.alias, new KeyStore.PasswordProtection(this.password.toCharArray()));
        X509Certificate cert = (X509Certificate)e.getCertificate();
        key = e.getPrivateKey();
        String name = cert.getSubjectDN().getName().replace("ST=", "S=");
        certs.add(name);
        certs.add(cert);
        KeyInfoFactory keyFactory = factory.getKeyInfoFactory();
        X509Data data = keyFactory.newX509Data(certs);
        List<X509Data> dataList = Collections.singletonList(data);
        KeyInfo keyInfo = keyFactory.newKeyInfo(dataList);
        DOMSignContext context = new DOMSignContext(key, (Node)securityElement);
        XMLSignature signature = factory.newXMLSignature(signer, keyInfo, null, null, null);
        signature.sign(context);
        return smc;
    }

    private SOAPHeader getHeader(SOAPEnvelope envelope) throws SOAPException {
        SOAPHeader header = envelope.getHeader();
        if (header == null) {
            header = envelope.addHeader();
        }
        return header;
    }

    public SOAPMessageContext addPkcs7Signature(SOAPMessageContext smc, Pkcs7Signature signature) throws SOAPException, UnsupportedEncodingException {
        if (signature == null) {
            throw new NullPointerException("signature");
        }
        if (smc == null) {
            throw new NullPointerException("smc");
        }
        this.checkConfigured();
        SOAPEnvelope envelope = smc.getMessage().getSOAPPart().getEnvelope();
        SOAPHeader header = this.getHeader(envelope);
        SOAPHeaderElement securityElement = header.addHeaderElement(envelope.createName("Security", null, "http://cais-icp.org/v1"));
        securityElement.setAttribute("S:actor", signature.getActor());
        securityElement.setValue(signature.getSignature());
        return smc;
    }

    public SOAPMessageContext addXmlSignature(SOAPMessageContext smc, XmlSignature signature) throws Exception {
        if (signature == null) {
            throw new NullPointerException("signature");
        }
        if (smc == null) {
            throw new NullPointerException("smc");
        }
        this.checkConfigured();
        SOAPEnvelope envelope = smc.getMessage().getSOAPPart().getEnvelope();
        SOAPHeader header = this.getHeader(envelope);
        Node securityNode = signature.getSecurityNode();
        if (securityNode == null) {
            throw new NullPointerException("Invalid signature. no security node");
        }
        Node securityNode2 = header.getOwnerDocument().importNode(securityNode, true);
        this.fixCrLf(JX509XmlSignature.getNode("SignatureValue", securityNode2));
        this.fixCrLf(JX509XmlSignature.getNode("X509Certificate", securityNode2));
        Node objectNode = JX509XmlSignature.getNode("Object", securityNode2);
        Node objectSignatureNode = JX509XmlSignature.getNode("Signature", objectNode);
        NamedNodeMap attributes = objectSignatureNode.getAttributes();
        Node attribute = attributes.getNamedItem("xmlns");
        if (attribute == null) {
            Attr attr = objectSignatureNode.getOwnerDocument().createAttribute("xmlns");
            attr.setNodeValue("");
            objectSignatureNode.getAttributes().setNamedItem(attr);
        }
        header.appendChild(securityNode2);
        return smc;
    }

    private void fixCrLf(Node node) {
        String value;
        String fixed = value = node.getFirstChild().getNodeValue();
        fixed = fixed.replace("\r\n", "\n");
        fixed = fixed.replace("\r", "\n");
        fixed = fixed.replace("&#xa;", "\n");
        fixed = fixed.replace("&#xA;", "\n");
        fixed = fixed.replace("&#xd;", "\n");
        fixed = fixed.replace("&#xD;", "\n");
        node.getFirstChild().setNodeValue(fixed);
    }

    private static Node getNode(String nodeName, Node node) {
        if (nodeName.equalsIgnoreCase(node.getNodeName())) {
            return node;
        }
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null && childNodes.getLength() > 0) {
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node n = JX509XmlSignature.getNode(nodeName, childNodes.item(j));
                if (n == null) continue;
                return n;
            }
        }
        return null;
    }

    private Node getRootNode(SOAPMessage soapMessage) throws SOAPException, ParserConfigurationException, SAXException, IOException {
        Node root = null;
        Source source = soapMessage.getSOAPPart().getContent();
        Document doc = null;
        if (source instanceof DOMSource) {
            root = ((DOMSource)source).getNode();
        } else if (source instanceof SAXSource) {
            InputSource inSource = ((SAXSource)source).getInputSource();
            DocumentBuilderFactory dbf = DocumentBuilderFactoryCache.getInstance(new DocumentBuilderFactoryCache.DocumentBuilderFactoryArg().setNamespaceAware(true));
            DocumentBuilder db = null;
            db = dbf.newDocumentBuilder();
            doc = db.parse(inSource);
            root = doc.getDocumentElement();
        }
        return root;
    }

    private void dumpDocument(Node root) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new DOMSource(root), new StreamResult(System.out));
    }
}

