/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.fco;

import ca.infodata.dsq.domain.ICandidate;
import ca.infodata.dsq.domain.NIU_U;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;

public final class CandidateConsentCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final NIU_U niu;
    private final long datetime;

    public CandidateConsentCriteria(ICandidate candidate, long datetimeUTC) {
        if (candidate == null) {
            throw new NullPointerException("candidate");
        }
        this.niu = candidate.getNiu();
        this.datetime = datetimeUTC;
    }

    public CandidateConsentCriteria(NIU_U niu, long datetimeUTC) {
        if (niu == null) {
            throw new NullPointerException("niu");
        }
        this.niu = niu;
        this.datetime = datetimeUTC;
    }

    public NIU_U getNiu() {
        return this.niu;
    }

    public long getDatetimeUTC() {
        return this.datetime;
    }

    public String toString() {
        return String.format("CandidateConsentCriteria [datetime=%s(%s), niu=%s]", Helper.formatFULLDATETIME(this.datetime), this.datetime, this.niu);
    }
}

