/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.service.dm.DMC0107Svc;

import ca.infodata.dsq.domain.ICandidate;
import ca.infodata.dsq.domain.fco.CandidateConsentDirective;
import ca.infodata.dsq.tools.Helper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hl7.v3.dm2.IssueFilterCode;
import org.hl7.v3.dm2.PrescriptionDispenseFilterCode;

public final class GetPrescriptionOrderSummaryCriteriaDM
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final ICandidate candidate;
    private final CandidateConsentDirective consentDirective;
    private Long administrationEffectivePeriodStart;
    private Long administrationEffectivePeriodEnd;
    private Long amendedInTimeRangeStart;
    private Long amendedInTimeRangeEnd;
    private List<PrescriptionDispenseFilterCode> rxDispenseIndicators = new ArrayList<PrescriptionDispenseFilterCode>();
    private IssueFilterCode issueFilterCode;
    private Integer limit;

    public GetPrescriptionOrderSummaryCriteriaDM(ICandidate candidate, CandidateConsentDirective consentDirective) {
        if (candidate == null) {
            throw new NullPointerException("candidate");
        }
        if (consentDirective == null) {
            throw new NullPointerException("consentDirective");
        }
        if (!consentDirective.hasAccepted()) {
            throw new IllegalArgumentException("candidate has refused consent to his data");
        }
        this.candidate = candidate;
        this.consentDirective = consentDirective;
    }

    public Long getAdministrationEffectivePeriodStart() {
        return this.administrationEffectivePeriodStart;
    }

    public Long getAdministrationEffectivePeriodEnd() {
        return this.administrationEffectivePeriodEnd;
    }

    public void setAdministrationEffectivePeriod(Long administrationEffectivePeriodStart, Long administrationEffectivePeriodEnd) {
        if (administrationEffectivePeriodStart == null && administrationEffectivePeriodEnd == null) {
            this.administrationEffectivePeriodStart = administrationEffectivePeriodStart;
            this.administrationEffectivePeriodEnd = administrationEffectivePeriodEnd;
        } else if (administrationEffectivePeriodStart != null && administrationEffectivePeriodEnd != null) {
            if (administrationEffectivePeriodStart > administrationEffectivePeriodEnd) {
                throw new IllegalArgumentException("start must be < end");
            }
            this.administrationEffectivePeriodStart = administrationEffectivePeriodStart;
            this.administrationEffectivePeriodEnd = administrationEffectivePeriodEnd;
        } else {
            throw new IllegalArgumentException("both start and end must be null or not null");
        }
    }

    public ICandidate getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return String.format("PrescriptionsNeverDispensedCriteria [administrationEffectivePeriodEnd=%s(%s), administrationEffectivePeriodStart=%s(%s), [amendedInTimeRangeStart=%s(%s), amendedInTimeRangeEnd=%s(%s), candidate=%s, rxDispenseIndicator=%sissueFilterCode=%slimit=%s]", new Object[]{Helper.formatFULLDATETIME(this.administrationEffectivePeriodEnd), this.administrationEffectivePeriodEnd, Helper.formatFULLDATETIME(this.administrationEffectivePeriodStart), this.administrationEffectivePeriodStart, Helper.formatFULLDATETIME(this.amendedInTimeRangeStart), this.amendedInTimeRangeStart, Helper.formatFULLDATETIME(this.amendedInTimeRangeEnd), this.amendedInTimeRangeEnd, this.candidate, this.rxDispenseIndicators, this.issueFilterCode, this.limit});
    }

    public List<PrescriptionDispenseFilterCode> getRxDispenseIndicators() {
        return this.rxDispenseIndicators;
    }

    public CandidateConsentDirective getConsentDirective() {
        return this.consentDirective;
    }

    public IssueFilterCode getIssueFilterCode() {
        return this.issueFilterCode;
    }

    public void setIssueFilterCode(IssueFilterCode issueFilterCode) {
        this.issueFilterCode = issueFilterCode;
    }

    public Long getAmendedInTimeRangeEnd() {
        return this.amendedInTimeRangeEnd;
    }

    public void setAmendedInTimeRangeEnd(Long amendedInTimeRangeEnd) {
        this.amendedInTimeRangeEnd = amendedInTimeRangeEnd;
    }

    public Long getAmendedInTimeRangeStart() {
        return this.amendedInTimeRangeStart;
    }

    public void setAmendedInTimeRangeStart(Long amendedInTimeRangeStart) {
        this.amendedInTimeRangeStart = amendedInTimeRangeStart;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

