/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain.imaging.pdf;

import ca.infodata.dsq.domain.Candidate;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.VIEW_MODE;
import ca.infodata.dsq.domain.imaging.ImagingResultExam;
import ca.infodata.dsq.domain.imaging.ImagingResultExamReport;
import ca.infodata.dsq.domain.labo.getreport.pdf.DsqFormatter;
import ca.infodata.util1.JoinList;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.DateUtil;
import com.lowagie.text.Document;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class ImagingResultExamPdf {
    private Candidate candidate;
    private ImagingResultExam result;
    private VIEW_MODE viewMode;
    private String printedBy;

    public ImagingResultExamPdf(Candidate candidate, ImagingResultExam imagingResultExam) {
        if (candidate == null) {
            throw new NullPointerException("candidate");
        }
        if (imagingResultExam == null) {
            throw new NullPointerException("ImagingResultExam");
        }
        this.candidate = candidate;
        this.result = imagingResultExam;
        this.viewMode = VIEW_MODE.VIEW;
    }

    public String getPrintedBy() {
        return this.printedBy;
    }

    public void setPrintedBy(String printedBy) {
        this.printedBy = printedBy;
    }

    public VIEW_MODE getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(VIEW_MODE viewMode) {
        this.viewMode = viewMode;
    }

    public void getPicture(OutputStream outputStream) throws Exception {
        if (outputStream == null) {
            throw new NullPointerException("outputStream");
        }
        ArrayList<byte[]> parts = new ArrayList<byte[]>();
        for (ImagingResultExamReport report : this.result.report) {
            parts.add(this.newPdf(report));
            if (!report.isApplicationPdfMimeType()) continue;
            byte[] reportPdf = Base64.getDecoder().decode(report.text);
            parts.add(reportPdf);
        }
        int pageCount = ImagingResultExamPdf.computePageCount(parts) + 1;
        if (this.viewMode == VIEW_MODE.PRINT) {
            parts.add(0, this.getCoverPageForPrint(pageCount));
        } else {
            parts.add(0, this.getCoverPageForViewer());
        }
        if (parts.size() > 0) {
            byte[] picture = this.joinPdfs((byte[][])parts.toArray((T[])new byte[0][]), pageCount);
            if (this.viewMode != VIEW_MODE.PRINT) {
                PdfReader reader = new PdfReader(picture);
                PdfStamper stamper = new PdfStamper(reader, outputStream);
                stamper.setEncryption(null, null, 0, 1);
                outputStream.flush();
                stamper.close();
                reader.close();
            } else {
                outputStream.write(picture);
                outputStream.flush();
            }
        }
    }

    private byte[] newPdf(ImagingResultExamReport report) throws Exception {
        Rectangle rect = new Rectangle(PageSize.LETTER);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(rect);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.open();
        document.open();
        Font font = new Font(2, 11.0f, 0, Color.black);
        JoinList list = new JoinList("\n\n");
        list.add((CharSequence)"Code de statut d'\u00e9volution du rapport");
        list.add((CharSequence)DsqFormatter.formatCode(report.code));
        list.add((CharSequence)"Date/heure du rapport");
        list.add((CharSequence)DateUtil.nonThreadSafeFormat((Long)report.effectiveTime, (String)"yyyy-MM-dd HH:mm"));
        list.add((CharSequence)"Intervenant / Interpr\u00e8te");
        list.add((CharSequence)DsqFormatter.formatAuthor(report.author));
        if (report.isApplicationPdfMimeType()) {
            list.add((CharSequence)"Contenu du rapport en format pdf. Voir le(s) page(s) suivante(s).");
        } else {
            list.add((CharSequence)"Contenu du rapport en format texte ISO 8859-01");
            list.add((CharSequence)(report.text == null ? "Aucun contenu" : report.text.trim()));
        }
        Paragraph p = new Paragraph(list.toString());
        p.setFont(font);
        p.setAlignment(1);
        document.add((Element)p);
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private static int computePageCount(List<byte[]> parts) throws IOException {
        int pageCount = 0;
        for (byte[] pdf : parts) {
            if (pdf == null) continue;
            PdfReader pdfReader = new PdfReader(pdf);
            pageCount += pdfReader.getNumberOfPages();
            pdfReader.close();
        }
        return pageCount;
    }

    private byte[] getCoverPageForViewer() throws Exception {
        return this.getCoverPageForPrint(-1);
    }

    private byte[] getCoverPageForPrint(int pageCount) throws Exception {
        Rectangle rect = new Rectangle(PageSize.LETTER);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document(rect);
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        writer.open();
        document.open();
        Font font = new Font(2, 11.0f, 0, Color.black);
        Font italic = new Font(2, 11.0f, 2, Color.black);
        String name = this.candidate.getFirstName() + " " + this.candidate.getLastName() + " (" + (Object)((Object)this.candidate.getGender()) + ") " + DateUtil.format((Long)this.candidate.getBirthDate(), (String)"yyyy/MM/dd");
        String nam = this.candidate.getNam() == null ? "" : this.candidate.getNam().value();
        String patientInformation = StringUtils.join((String)", ", (Object[])new Object[]{name, nam});
        Paragraph p = new Paragraph("Confidentiel");
        p.setFont(new Font(2, 20.0f, 0, Color.black));
        p.setAlignment(1);
        document.add((Element)p);
        p = new Paragraph("\n\n" + patientInformation);
        p.setFont(new Font(2, 16.0f, 1, Color.black));
        p.setAlignment(1);
        document.add((Element)p);
        JoinList list = new JoinList("\n\n");
        list.add((CharSequence)"Code de statut de l'\u00e9volution de l'examen");
        list.add((CharSequence)DsqFormatter.formatCode(this.result.status));
        list.add((CharSequence)"Code de l'examen");
        list.add((CharSequence)this.result.code.code);
        list.add((CharSequence)"Description de l'examen");
        list.add((CharSequence)this.result.code.text);
        list.add((CharSequence)"Date/heure de l'examen");
        list.add((CharSequence)DateUtil.nonThreadSafeFormat((Long)this.result.effectiveTime, (String)"yyyy-MM-dd HH:mm"));
        list.add((CharSequence)"Nom de l'ODS");
        list.add((CharSequence)this.result.performerODS.getName());
        list.add((CharSequence)"Nom du prescripteur");
        list.add((CharSequence)DsqFormatter.formatAuthor(this.result.prescriber));
        list.add((CharSequence)"Code(s) de modalit\u00e9");
        JoinList modality = new JoinList(", ");
        for (Code code : this.result.modality) {
            modality.add((CharSequence)code.code);
        }
        list.add((CharSequence)modality.toString());
        if (this.result.report != null && this.result.report.size() > 0) {
            list.add((CharSequence)"Code de statut d'\u00e9volution du rapport le plus r\u00e9cent");
            ImagingResultExamReport lastReport = this.result.report.get(this.result.report.size() - 1);
            list.add((CharSequence)DsqFormatter.formatCode(lastReport.code));
            list.add((CharSequence)"Date/heure du rapport le plus r\u00e9cent");
            list.add((CharSequence)DateUtil.nonThreadSafeFormat((Long)lastReport.effectiveTime, (String)"yyyy-MM-dd HH:mm"));
        } else {
            list.add((CharSequence)"Code de statut d'\u00e9volution du rapport le plus r\u00e9cent");
            list.add((CharSequence)"Cet examen ne comporte aucun rapport.");
        }
        list.add((CharSequence)"Identifiant de l\u2019examen (SIUID)");
        list.add((CharSequence)this.result.id.extension);
        p = new Paragraph(list.toString());
        p.setFont(font);
        p.setAlignment(1);
        document.add((Element)p);
        p = this.printedBy != null ? new Paragraph("\n\n\nCes donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)\n\n" + this.printedBy) : new Paragraph("\n\n\nCes donn\u00e9es sont extraites du DOSSIER SANT\u00c9 QU\u00c9BEC (DSQ)");
        p.setFont(italic);
        p.setAlignment(1);
        document.add((Element)p);
        if (pageCount > 0) {
            String pageInfo = String.format("Page %d de %d", 1, pageCount);
            PdfContentByte directContent = writer.getDirectContent();
            directContent.moveTo(document.left(), document.bottom(15.0f));
            directContent.lineTo(document.right(), document.bottom(15.0f));
            directContent.stroke();
            ColumnText.showTextAligned((PdfContentByte)directContent, (int)2, (Phrase)new Phrase(pageInfo, new Font(2, 12.0f, 0, Color.black)), (float)(document.right() - 2.0f), (float)document.bottom(), (float)0.0f);
        }
        writer.flush();
        document.close();
        writer.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }

    private byte[] joinPdfs(byte[][] pdfs, int pageCount) throws Exception {
        String name = this.candidate.getFirstName() + " " + this.candidate.getLastName() + " (" + (Object)((Object)this.candidate.getGender()) + ") " + DateUtil.format((Long)this.candidate.getBirthDate(), (String)"yyyy/MM/dd");
        String nam = this.candidate.getNam() == null ? "" : this.candidate.getNam().value();
        String patientInformation = StringUtils.join((String)", ", (Object[])new Object[]{name, nam});
        Font font = new Font(2, 12.0f, 0, Color.black);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Document document = new Document();
        PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)outputStream);
        document.open();
        int pageNumber = 1;
        for (byte[] pdf : pdfs) {
            if (pdf == null) continue;
            PdfReader pdfReader = new PdfReader(pdf);
            int n = pdfReader.getNumberOfPages();
            for (int page = 1; page <= n; ++page) {
                PdfImportedPage importedPage = pdfCopy.getImportedPage(pdfReader, page);
                Rectangle boundingBox = pdfReader.getPageSizeWithRotation(page);
                PdfCopy.PageStamp pageStamp = pdfCopy.createPageStamp(importedPage);
                PdfContentByte overContent = pageStamp.getOverContent();
                if (this.viewMode == VIEW_MODE.PRINT && pageNumber > 1) {
                    float footerBottom;
                    float headerRight;
                    float headerLeft;
                    float headerTop;
                    String pageInfo = String.format("Page %d de %d", pageNumber, pageCount);
                    String disclaimer = "Ces donn\u00c3\u00a9es sont extraites du DOSSIER SANT\u00c3\u2030 QU\u00c3\u2030BEC (DSQ)";
                    if (pdfReader.getPageRotation(page) == PdfPage.PORTRAIT.intValue()) {
                        headerTop = boundingBox.getTop() - 25.0f;
                        headerLeft = boundingBox.getLeft() + 25.0f;
                        headerRight = boundingBox.getRight() - 25.0f;
                        footerBottom = boundingBox.getBottom() + 25.0f;
                    } else {
                        headerTop = boundingBox.getTop() - 25.0f;
                        headerLeft = boundingBox.getLeft() + 25.0f;
                        headerRight = boundingBox.getRight() - 25.0f;
                        footerBottom = boundingBox.getBottom() + 25.0f;
                    }
                    ColumnText.showTextAligned((PdfContentByte)overContent, (int)0, (Phrase)new Phrase(patientInformation, font), (float)headerLeft, (float)headerTop, (float)0.0f);
                    overContent.moveTo(headerLeft, headerTop - 5.0f);
                    overContent.lineTo(headerRight, headerTop - 5.0f);
                    overContent.stroke();
                    overContent.moveTo(headerLeft, footerBottom + 15.0f);
                    overContent.lineTo(headerRight, footerBottom + 15.0f);
                    overContent.stroke();
                    ColumnText.showTextAligned((PdfContentByte)overContent, (int)2, (Phrase)new Phrase(pageInfo, font), (float)headerRight, (float)footerBottom, (float)0.0f);
                    ColumnText.showTextAligned((PdfContentByte)overContent, (int)0, (Phrase)new Phrase(disclaimer, font), (float)headerLeft, (float)footerBottom, (float)0.0f);
                    pageStamp.alterContents();
                }
                pdfCopy.addPage(importedPage);
                ++pageNumber;
            }
            pdfCopy.freeReader(pdfReader);
            pdfReader.close();
        }
        document.close();
        outputStream.flush();
        outputStream.close();
        return outputStream.toByteArray();
    }
}

