/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.dsq.domain;

import ca.infodata.dsq.domain.Code;

public enum RouteOfAdministration {
    AMNINJ("injection, amniotic fluid"),
    BILINJ("injection, biliary tract"),
    BLADINJ("injection, urinary bladder"),
    BLADINSTL("instillation, urinary catheter"),
    BLADIRR("irrigation, urinary bladder"),
    BLADIRRC("irrigation, urinary bladder, continuous"),
    BLADIRRT("irrigation, urinary bladder, tidal"),
    BUC("topical application, buccal"),
    CAPDINSTL("instillation, continuous ambulatory peritoneal dialysis port"),
    CECINSTL("instillation, cecostomy"),
    CERV("topical application, cervical"),
    CERVINJ("injection, cervical"),
    CERVINS("insertion, cervical (uterine)"),
    CHEW("chew, oral"),
    CHOLINJ("injection, for cholangiography"),
    CTINSTL("instillation, chest tube"),
    DEN("topical application, dental"),
    DENRINSE("rinse, dental"),
    DISSOLVE("dissolve, oral"),
    DOUCHE("douche, vaginal"),
    DRESS("topical application, soaked dressing"),
    EFT("instillation, enteral feeding tube"),
    ELECTOSMOS("electro-osmosis"),
    ENDOSININJ("injection, endosinusial"),
    ENEMA("enema, rectal"),
    ENTINSTL("instillation, enteral"),
    EPI("infusion, epidural"),
    EPIDURINJ("injection, epidural"),
    EPIINJ("injection, epidural, push"),
    EPINJSP("injection, epidural, slow push"),
    ETINSTL("instillation, endotracheal tube"),
    ETNEB("nebulization, endotracheal tube"),
    EXTCORPDIF("diffusion, extracorporeal"),
    EXTCORPINJ("injection, extracorporeal"),
    EXTRAMNINJ("injection, extra-amniotic"),
    GARGLE("gargle"),
    GBINJ("injection, gastric button"),
    GIN("topical application, gingival"),
    GINGINJ("injection, gingival"),
    GJT("instillation, gastro-jejunostomy tube"),
    GT("instillation, gastrostomy tube"),
    GUIRR("irrigation, genitourinary"),
    HAIR("topical application, hair"),
    HEMODIFF("diffusion, hemodialysis"),
    HEMOPORT("injection, hemodialysis port"),
    IA("infusion, intraarterial catheter"),
    IABDINJ("injection, intra-abdominal"),
    IAINJ("injection, intraarterial"),
    IAINJP("injection, intraarterial, push"),
    IAINJSP("injection, intraarterial, slow push"),
    IARTINJ("injection, intraarticular"),
    IBRONCHINSTIL("instillation, intrabronchial"),
    IBURSINJ("injection, intrabursal"),
    IC("infusion, intracardiac"),
    ICARDINJ("injection, intracardiac"),
    ICARDINJRP("injection, intracardiac, rapid push"),
    ICARDINJSP("injection, intracardiac, slow push"),
    ICARINJP("injection, intracardiac, push"),
    ICARTINJ("injection, intracartilaginous"),
    ICAUDINJ("injection, intracaudal"),
    ICAVINJ("injection, intracavernous"),
    ICAVITINJ("injection, intracavitary"),
    ICEREBINJ("injection, intracerebral"),
    ICISTERNINJ("injection, intracisternal"),
    ICOR("infusion, intracoronary"),
    ICORNTA("topical application, intracorneal"),
    ICORONINJ("injection, intracoronary"),
    ICORONINJP("injection, intracoronary, push"),
    ICORONTA("topical application, intracoronal (dental)"),
    ICORPCAVINJ("injection, intracorpus cavernosum"),
    IDIMPLNT("implantation, intradermal"),
    IDINJ("injection, intradermal"),
    IDISCINJ("injection, intradiscal"),
    IDOUDMAB("mucosal absorption, intraduodenal"),
    IDUCTINJ("injection, intraductal"),
    IDUODINSTIL("instillation, intraduodenal"),
    IDURINJ("injection, intradural"),
    IEPIDINJ("injection, intraepidermal"),
    IEPITHINJ("injection, intraepithelial"),
    IESOPHINSTIL("instillation, intraesophageal"),
    IESOPHTA("topical application, intraesophageal"),
    IGASTINSTIL("instillation, intragastric"),
    IGASTIRR("irrigation, intragastric"),
    IGASTLAV("lavage, intragastric"),
    IILEALINJ("instillation, intraileal"),
    IILEALTA("topical application, intraileal"),
    ILESINJ("injection, intralesional"),
    ILESIRR("irrigation, intralesional"),
    ILTOP("topical application, intralesional"),
    ILUMINJ("injection, intraluminal"),
    ILUMTA("topical application, intraluminal"),
    ILYMPJINJ("injection, intralymphatic"),
    IM("injection, intramuscular"),
    IMD("injection, intramuscular, deep"),
    IMZ("injection, intramuscular, z track"),
    IMEDULINJ("injection, intramedullary"),
    INSUF("insufflation"),
    INTERMENINJ("injection, interameningeal"),
    INTERSTITINJ("injection, interstitial"),
    IOINJ("injection, intraocular"),
    IOINSTL("instillation, intraocular"),
    IOIRR("irrigation, intraocular"),
    IONTO("topical application, iontophoresis"),
    IOSSC("infusion, intraosseous, continuous"),
    IOSSINJ("injection, intraosseous"),
    IOSURGINS("insertion, intraocular, surgical"),
    IOTOP("topical application, intraocular"),
    IOVARINJ("injection, intraovarian"),
    IPCARDINJ("injection, intrapericardial"),
    IPERINJ("injection, intraperitoneal"),
    IPINJ("injection, intrapulmonary"),
    IPLRINJ("injection, intrapleural"),
    IPPB("inhalation, intermittent positive pressure breathing (ippb)"),
    IPROSTINJ("injection, intraprostatic"),
    IPUMPINJ("injection, insulin pump"),
    ISININSTIL("instillation, intrasinal"),
    ISINJ("injection, intraspinal"),
    ISTERINJ("injection, intrasternal"),
    ISYNINJ("injection, intrasynovial"),
    IT("infusion, intrathecal"),
    ITENDINJ("injection, intratendinous"),
    ITESTINJ("injection, intratesticular"),
    ITHORINJ("injection, intrathoracic"),
    ITINJ("injection, intrathecal"),
    ITRACHINSTIL("instillation, intratracheal"),
    ITRACHMAB("mucosal absorption, intratracheal"),
    ITUBINJ("injection, intratubular"),
    ITUMINJ("injection, intratumor"),
    ITYMPINJ("injection, intratympanic"),
    IU("insertion, intrauterine"),
    IUINJ("injection, intrauterine"),
    IUINJC("injection, intracervical (uterus)"),
    IUINSTL("instillation, intrauterine"),
    IURETINJ("injection, intraureteral, retrograde"),
    IV("infusion, intravenous"),
    IVC("infusion, intravenous catheter"),
    IVCC("infusion, intravenous catheter, continuous"),
    IVCI("infusion, intravenous catheter, intermittent"),
    PCA("infusion, intravenous catheter, pca pump"),
    IVASCINFUS("infusion, intravascular"),
    IVASCINJ("injection, intravascular"),
    IVENTINJ("injection, intraventricular (heart)"),
    IVESINJ("injection, intravesicle"),
    IVFLUSH("flush, intravenous catheter"),
    IVINJ("injection, intravenous"),
    IVINJBOL("injection, intravenous, bolus"),
    IVPUSH("injection, intravenous, push"),
    IVRPUSH("injection, intravenous, rapid push"),
    IVSPUSH("injection, intravenous, slow push"),
    IVITIMPLNT("implantation, intravitreal"),
    IVITINJ("injection, intravitreal"),
    JJTINSTL("instillation, jejunostomy tube"),
    LARYNGINSTIL("instillation, laryngeal"),
    LARYNGTA("topical application, laryngeal"),
    LPINS("insertion, lacrimal puncta"),
    MUC("topical application, mucous membrane"),
    NAIL("topical application, nail"),
    NASAL("topical application, nasal"),
    NASALINSTIL("instillation, nasal"),
    NASINHL("inhalation, nasal"),
    NASINHLC("inhalation, nasal cannula"),
    NP("inhalation, nasal cannula"),
    NASOGASINSTIL("instillation, nasogastric"),
    NEB("inhalation, nebulization"),
    NASNEB("inhalation, nebulization, nasal"),
    ORNEB("inhalation, nebulization, oral"),
    NGT("instillation, nasogastric tube"),
    NTT("instillation, nasotracheal tube"),
    OCDRESTA("occlusive dressing technique"),
    OGT("instillation, orogastric tube"),
    OJJ("instillation, orojejunum tube"),
    OPTHALTA("topical application, ophthalmic"),
    ORALTA("topical application, oral"),
    ORINHL("inhalation, respiratory"),
    ORIFINHL("inhalation, oral intermittent flow"),
    REBREATH("inhalation, oral rebreather mask"),
    ORMUC("topical application, oromucosal"),
    OROPHARTA("topical application, oropharyngeal"),
    ORRINSE("inse, oral"),
    OT("instillation, otic"),
    PAINJ("injection, periarticular"),
    PARENTINJ("injection, parenteral"),
    PDONTINJ("injection, periodontal"),
    PDONTTA("topical application, periodontal"),
    PDPINJ("injection, peritoneal dialysis port"),
    PDPINSTL("instillation, peritoneal dialysis port"),
    PDURINJ("injection, peridural"),
    PERIANAL("topical application, perianal"),
    PERINEAL("topical application, perineal"),
    PNINJ("injection, perineural"),
    PNSINJ("injection, paranasal sinuses"),
    PNSINSTL("instillation, paranasal sinuses"),
    PO("swallow, oral"),
    PR("insertion, rectal"),
    RBINJ("injection, retrobulbar"),
    RECINSTL("instillation, rectal"),
    RECTINSTL("instillation, rectal tube"),
    RECIRR("irrigation, rectal"),
    RECTAL("topical application, rectal"),
    RETENEMA("enema, rectal retention"),
    SCALP("topical application, scalp"),
    SCINJ("injection, subconjunctival"),
    SHAMPOO("shampoo"),
    SININSTIL("instillation, sinus, unspecified"),
    SKIN("topical application, skin"),
    SL("dissolve, sublingual"),
    SLESINJ("injection, sublesional"),
    SMUCMAB("mucosal absorption, submucosal"),
    SOAK("immersion (soak)"),
    SOFTISINJ("injection, soft tissue"),
    SOFTISINSTIL("instillation, soft tissue"),
    SQ("injection, subcutaneous"),
    SQIMPLNT("implantation, subcutaneous"),
    SQINFUS("infusion, subcutaneous"),
    SQSURGINS("insertion, subcutaneous, surgical"),
    SUBARACHINJ("injection, subarachnoid"),
    SUBCONJTA("subconjunctival"),
    SUBMUCINJ("injection, submucosal"),
    SUCK("suck, oromucosal"),
    SWAB("topical application, swab"),
    SWISHSPIT("swish and spit out, oromucosal"),
    SWISHSWAL("swish and swallow, oromucosal"),
    TMUCTA("topical application, transmucosal"),
    TOPICAL("topical"),
    TRACH("inhalation, tracheostomy"),
    TRACHINSTL("instillation, tracheostomy"),
    TRNSDERM("transdermal"),
    TRNSDERMD("diffusion, transdermal"),
    TRNSLING("translingual"),
    TRPLACINJ("injection, transplacental"),
    TRTRACHINJ("injection, transtracheal"),
    TRTYMPINSTIL("instillation, transtympanic"),
    TTYMPTABSORP("topical absorption, transtympanic"),
    URETHINJ("injection, urethral"),
    URETHINS("insertion, urethral"),
    URETHINSTL("instillation, urethral"),
    URETHSUP("suppository, urethral"),
    URETINJ("injection, ureteral"),
    VAGINS("topical application, vaginal"),
    VAGINSI("insertion, vaginal"),
    VENT("inhalation, ventilator"),
    VENTMASK("inhalation, ventimask");

    private final String desc;

    private RouteOfAdministration(String desc) {
        this.desc = desc;
    }

    public String value() {
        return this.name();
    }

    public String description() {
        return this.desc;
    }

    public Code toCode() {
        return new Code(this.name(), this.description());
    }
}

