/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.AxisSplitterMedian;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeConstructor;
import org.ddogleg.nn.alg.KdTreeDistance;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.ddogleg.nn.alg.KdTreeSearch1;
import org.ddogleg.nn.alg.KdTreeSearchN;
import org.ddogleg.nn.alg.searches.KdTreeSearch1Standard;
import org.ddogleg.nn.alg.searches.KdTreeSearchNStandard;
import org.ddogleg.nn.wrap.KdTreeInternalSearch;

public class KdTreeNearestNeighbor<P>
implements NearestNeighbor<P> {
    KdTree tree;
    KdTreeConstructor<P> constructor;
    KdTreeSearch1<P> search1;
    KdTreeSearchN<P> searchN;
    AxisSplitter<P> splitter;
    KdTreeMemory<P> memory = new KdTreeMemory();

    public KdTreeNearestNeighbor(KdTreeSearch1<P> search1, KdTreeSearchN<P> searchN, AxisSplitter<P> splitter) {
        this.search1 = search1;
        this.searchN = searchN;
        this.splitter = splitter;
        this.constructor = new KdTreeConstructor<P>(this.memory, splitter);
    }

    public KdTreeNearestNeighbor(KdTreeDistance<P> distance) {
        this(new KdTreeSearch1Standard<P>(distance), new KdTreeSearchNStandard<P>(distance), new AxisSplitterMedian<P>(distance));
    }

    @Override
    public void setPoints(List<P> points, boolean trackIndicies) {
        if (this.tree != null) {
            this.memory.recycleGraph(this.tree);
        }
        this.tree = this.constructor.construct(points, trackIndicies);
    }

    @Override
    public NearestNeighbor.Search<P> createSearch() {
        return new InternalSearch(this.search1.copy(), this.searchN.copy());
    }

    private class InternalSearch
    extends KdTreeInternalSearch<P> {
        InternalSearch(KdTreeSearch1<P> search1, KdTreeSearchN<P> searchN) {
            super(search1, searchN);
        }

        @Override
        void setTree() {
            this.search1.setTree(KdTreeNearestNeighbor.this.tree);
            this.searchN.setTree(KdTreeNearestNeighbor.this.tree);
        }
    }
}

