/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.orientation;

import boofcv.abst.feature.orientation.ConfigAverageIntegral;
import boofcv.abst.feature.orientation.ConfigSiftOrientation;
import boofcv.abst.feature.orientation.ConfigSlidingIntegral;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.orientation.OrientationAverage;
import boofcv.alg.feature.orientation.OrientationHistogram;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.alg.feature.orientation.OrientationImageAverage;
import boofcv.alg.feature.orientation.OrientationSlidingWindow;
import boofcv.alg.feature.orientation.impl.ImplOrientationAverageGradientIntegral;
import boofcv.alg.feature.orientation.impl.ImplOrientationAverage_F32;
import boofcv.alg.feature.orientation.impl.ImplOrientationAverage_S16;
import boofcv.alg.feature.orientation.impl.ImplOrientationAverage_S32;
import boofcv.alg.feature.orientation.impl.ImplOrientationHistogram_F32;
import boofcv.alg.feature.orientation.impl.ImplOrientationHistogram_S16;
import boofcv.alg.feature.orientation.impl.ImplOrientationHistogram_S32;
import boofcv.alg.feature.orientation.impl.ImplOrientationImageAverageIntegral;
import boofcv.alg.feature.orientation.impl.ImplOrientationImageAverage_F32;
import boofcv.alg.feature.orientation.impl.ImplOrientationImageAverage_U8;
import boofcv.alg.feature.orientation.impl.ImplOrientationSlidingWindowIntegral;
import boofcv.alg.feature.orientation.impl.ImplOrientationSlidingWindow_F32;
import boofcv.alg.feature.orientation.impl.ImplOrientationSlidingWindow_S16;
import boofcv.alg.feature.orientation.impl.ImplOrientationSlidingWindow_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class FactoryOrientationAlgs {
    public static <T extends ImageGray<T>> OrientationHistogram<T> histogram(double objectToSample, int numAngles, int radius, boolean weighted, Class<T> derivType) {
        OrientationHistogram ret;
        if (derivType == GrayF32.class) {
            ret = new ImplOrientationHistogram_F32(objectToSample, numAngles, weighted);
        } else if (derivType == GrayS16.class) {
            ret = new ImplOrientationHistogram_S16(objectToSample, numAngles, weighted);
        } else if (derivType == GrayS32.class) {
            ret = new ImplOrientationHistogram_S32(objectToSample, numAngles, weighted);
        } else {
            throw new IllegalArgumentException("Unknown image type.");
        }
        ret.setObjectToSample(radius);
        return ret;
    }

    public static <T extends ImageGray<T>> OrientationImageAverage<T> nogradient(double objectToSample, int radius, Class<T> imageType) {
        OrientationImageAverage ret;
        if (imageType == GrayF32.class) {
            ret = new ImplOrientationImageAverage_F32(objectToSample, radius);
        } else if (imageType == GrayU8.class) {
            ret = new ImplOrientationImageAverage_U8(objectToSample, radius);
        } else {
            throw new IllegalArgumentException("Unknown image type.");
        }
        ret.setObjectRadius(radius);
        return ret;
    }

    public static <T extends ImageGray<T>> OrientationAverage<T> average(double objectToSample, int radius, boolean weighted, Class<T> derivType) {
        OrientationAverage ret;
        if (derivType == GrayF32.class) {
            ret = new ImplOrientationAverage_F32(objectToSample, weighted);
        } else if (derivType == GrayS16.class) {
            ret = new ImplOrientationAverage_S16(objectToSample, weighted);
        } else if (derivType == GrayS32.class) {
            ret = new ImplOrientationAverage_S32(objectToSample, weighted);
        } else {
            throw new IllegalArgumentException("Unknown image type.");
        }
        ret.setSampleRadius(radius);
        return ret;
    }

    public static <T extends ImageGray<T>> OrientationSlidingWindow<T> sliding(double objectRadiusToScale, int numAngles, double windowSize, int radius, boolean weighted, Class<T> derivType) {
        OrientationSlidingWindow ret;
        if (derivType == GrayF32.class) {
            ret = new ImplOrientationSlidingWindow_F32(objectRadiusToScale, numAngles, windowSize, weighted);
        } else if (derivType == GrayS16.class) {
            ret = new ImplOrientationSlidingWindow_S16(objectRadiusToScale, numAngles, windowSize, weighted);
        } else if (derivType == GrayS32.class) {
            ret = new ImplOrientationSlidingWindow_S32(objectRadiusToScale, numAngles, windowSize, weighted);
        } else {
            throw new IllegalArgumentException("Unknown image type.");
        }
        ret.setObjectRadius(radius);
        return ret;
    }

    public static <II extends ImageGray<II>> OrientationIntegral<II> average_ii(ConfigAverageIntegral config, Class<II> integralType) {
        if (config == null) {
            config = new ConfigAverageIntegral();
        }
        return new ImplOrientationAverageGradientIntegral(config.objectRadiusToScale, config.radius, config.samplePeriod, config.sampleWidth, config.weightSigma, integralType);
    }

    public static <II extends ImageGray<II>> OrientationIntegral<II> image_ii(double objectRadiusToScale, int sampleRadius, double samplePeriod, int sampleWidth, double weightSigma, Class<II> integralImage) {
        return new ImplOrientationImageAverageIntegral(objectRadiusToScale, sampleRadius, samplePeriod, sampleWidth, weightSigma, integralImage);
    }

    public static <II extends ImageGray<II>> OrientationIntegral<II> sliding_ii(ConfigSlidingIntegral config, Class<II> integralType) {
        if (config == null) {
            config = new ConfigSlidingIntegral();
        }
        config.checkValidity();
        return new ImplOrientationSlidingWindowIntegral(config.objectRadiusToScale, config.samplePeriod, config.windowSize, config.radius, config.weightSigma, config.sampleWidth, integralType);
    }

    public static <D extends ImageGray<D>> OrientationHistogramSift<D> sift(ConfigSiftOrientation config, Class<D> derivType) {
        if (config == null) {
            config = new ConfigSiftOrientation();
        }
        config.checkValidity();
        return new OrientationHistogramSift<D>(config.histogramSize, config.sigmaEnlarge, derivType);
    }
}

