/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.geo.bundle;

import boofcv.abst.geo.bundle.SceneStructureCommon;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.struct.FastQueue;

public class SceneStructureMetric
extends SceneStructureCommon {
    public FastQueue<View> views = new FastQueue<View>(View.class, true);
    public FastQueue<Rigid> rigids = new FastQueue<Rigid>(Rigid.class, true);
    public int[] lookupRigid;

    public SceneStructureMetric(boolean homogenous) {
        super(homogenous);
    }

    public void initialize(int totalCameras, int totalViews, int totalPoints) {
        this.initialize(totalCameras, totalViews, totalPoints, 0);
    }

    public void initialize(int totalCameras, int totalViews, int totalPoints, int totalRigid) {
        int i;
        this.cameras.resize(totalCameras);
        this.views.resize(totalViews);
        this.points.resize(totalPoints);
        this.rigids.resize(totalRigid);
        for (i = 0; i < this.cameras.size; ++i) {
            ((SceneStructureCommon.Camera[])this.cameras.data)[i].reset();
        }
        for (i = 0; i < this.points.size; ++i) {
            ((SceneStructureCommon.Point[])this.points.data)[i].reset();
        }
        for (i = 0; i < this.rigids.size; ++i) {
            this.rigids.get(i).reset();
        }
        this.lookupRigid = null;
    }

    public void assignIDsToRigidPoints() {
        if (this.lookupRigid != null) {
            return;
        }
        this.lookupRigid = new int[this.getTotalRigidPoints()];
        int pointID = 0;
        for (int i = 0; i < this.rigids.size; ++i) {
            Rigid r = ((Rigid[])this.rigids.data)[i];
            r.indexFirst = pointID;
            int j = 0;
            while (j < r.points.length) {
                this.lookupRigid[pointID] = i;
                ++j;
                ++pointID;
            }
        }
    }

    public boolean hasRigid() {
        return this.rigids.size > 0;
    }

    public void setView(int which, boolean fixed, Se3_F64 worldToView) {
        this.views.get((int)which).known = fixed;
        this.views.get((int)which).worldToView.set(worldToView);
    }

    public void setRigid(int which, boolean fixed, Se3_F64 worldToObject, int totalPoints) {
        Rigid rigid = new Rigid();
        ((Rigid[])this.rigids.data)[which] = rigid;
        Rigid r = rigid;
        r.known = fixed;
        r.objectToWorld.set(worldToObject);
        r.points = new SceneStructureCommon.Point[totalPoints];
        for (int i = 0; i < totalPoints; ++i) {
            r.points[i] = new SceneStructureCommon.Point(this.pointSize);
        }
    }

    public void connectViewToCamera(int viewIndex, int cameraIndex) {
        if (this.views.get((int)viewIndex).camera != -1) {
            throw new RuntimeException("View has already been assigned a camera");
        }
        this.views.get((int)viewIndex).camera = cameraIndex;
    }

    public int getUnknownCameraCount() {
        int total = 0;
        for (int i = 0; i < this.cameras.size; ++i) {
            if (((SceneStructureCommon.Camera[])this.cameras.data)[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownViewCount() {
        int total = 0;
        for (int i = 0; i < this.views.size; ++i) {
            if (this.views.get((int)i).known) continue;
            ++total;
        }
        return total;
    }

    public int getUnknownRigidCount() {
        int total = 0;
        for (int i = 0; i < this.rigids.size; ++i) {
            if (((Rigid[])this.rigids.data)[i].known) continue;
            ++total;
        }
        return total;
    }

    public int getTotalRigidPoints() {
        if (this.rigids == null) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < this.rigids.size; ++i) {
            total += ((Rigid[])this.rigids.data)[i].points.length;
        }
        return total;
    }

    @Override
    public int getParameterCount() {
        return this.getUnknownViewCount() * 6 + this.getUnknownRigidCount() * 6 + this.points.size * this.pointSize + this.getUnknownCameraParameterCount();
    }

    public FastQueue<View> getViews() {
        return this.views;
    }

    public FastQueue<Rigid> getRigids() {
        return this.rigids;
    }

    public static class Rigid {
        public boolean known = false;
        public Se3_F64 objectToWorld = new Se3_F64();
        public SceneStructureCommon.Point[] points;
        public int indexFirst;

        public void reset() {
            this.objectToWorld.reset();
            this.points = null;
            this.indexFirst = -1;
        }

        public void setPoint(int which, double x, double y, double z) {
            this.points[which].set(x, y, z);
        }

        public void setPoint(int which, double x, double y, double z, double w) {
            this.points[which].set(x, y, z, w);
        }

        public void getPoint(int which, Point3D_F64 p) {
            this.points[which].get(p);
        }

        public void getPoint(int which, Point4D_F64 p) {
            this.points[which].get(p);
        }

        public int getTotalPoints() {
            return this.points.length;
        }
    }

    public static class View {
        public boolean known = true;
        public Se3_F64 worldToView = new Se3_F64();
        public int camera = -1;
    }
}

