/*
 * Decompiled with CFR 0.152.
 */
package apple.finder.search.ui;

import apple.finder.search.ui.AbstractRow;
import apple.finder.search.ui.AppleFinderController;
import apple.finder.search.ui.CriteriaRow;
import apple.finder.search.ui.GroupRow;
import apple.finder.search.ui.IAppleFinderGridFactory;
import apple.finder.search.ui.ICriteriaField;
import apple.finder.search.ui.ICriteriaOperator;
import apple.finder.search.ui.IGetFactory;
import apple.finder.search.ui.ISetFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class AppleFinderGrid
extends Composite
implements AppleFinderController {
    private static final int levelMargin = 30;
    private Composite rowComp;
    private List<AbstractRow> rows = new ArrayList<AbstractRow>();
    private Map<String, AbstractRow> ids = new HashMap<String, AbstractRow>();
    private boolean deferRowLayout;
    private IAppleFinderGridFactory mainfactory;
    private boolean dirty;

    public AppleFinderGrid(Composite parent, int style) {
        super(parent, style);
        this.rowComp = this;
        this.setDirty(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroup(ISetFactory factory) {
        try {
            this.setDeferRowLayout(true);
            this.deleteAll();
            this.setGroup_f2(factory.items(factory.first()), factory);
        }
        finally {
            this.setDeferRowLayout(false);
        }
    }

    private void setGroup_f1(Object group, ISetFactory factory) {
        if (factory.isAndGroup(group)) {
            GroupRow row = this.addGroup(this.getLast());
            row.setAnd();
            this.setGroup_f2(factory.items(group), factory);
        } else if (factory.isOrGroup(group)) {
            GroupRow row = this.addGroup(this.getLast());
            row.setOr();
            this.setGroup_f2(factory.items(group), factory);
        } else if (factory.isNotGroup(group)) {
            GroupRow row = this.addGroup(this.getLast());
            row.setNot();
            this.setGroup_f2(factory.items(group), factory);
        } else if (factory.isCriteria(group)) {
            CriteriaRow row = this.addCriteria(this.getLast());
            row.selected(factory.getField(group));
            row.selectedOperator(factory.getOperator(group));
            row.setValueReference(factory.getValueReference(group));
        }
    }

    private void setGroup_f2(Iterator<Object> iterator, ISetFactory factory) {
        while (iterator.hasNext()) {
            Object g = iterator.next();
            this.setGroup_f1(g, factory);
        }
    }

    private AbstractRow getLast() {
        int size = this.rows.size();
        return size == 0 ? null : this.rows.get(size - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simplify() {
        try {
            this.setDeferRowLayout(true);
            int size = this.rows.size();
            for (int i = 0; i < size; ++i) {
                AbstractRow r = this.rows.get(i);
                if (!this.canBeSimplified(r)) continue;
                this.delete(r);
                i = 0;
                size = this.rows.size();
            }
            this.setDirty(true);
        }
        finally {
            this.setDeferRowLayout(false);
        }
    }

    private boolean canBeSimplified(AbstractRow r) {
        if (r instanceof GroupRow) {
            GroupRow gr = (GroupRow)r;
            int indexOf = this.rows.indexOf((Object)r);
            int groupCount = 0;
            for (int i = indexOf + 1; i < this.rows.size(); ++i) {
                AbstractRow row = this.rows.get(i);
                if (row.level != r.level + 1) break;
                if (row instanceof GroupRow) {
                    GroupRow gr2 = (GroupRow)row;
                    if (!gr.isSameType(gr2)) continue;
                    ++groupCount;
                    continue;
                }
                return false;
            }
            return groupCount <= 1;
        }
        return false;
    }

    public void getGroup(IGetFactory factory) {
        if (this.rows.size() > 0) {
            this.getGroup_f1(null, this.rows.listIterator(), 0, factory);
        }
    }

    private void getGroup_f1(Object parent, ListIterator<AbstractRow> iterator, int level, IGetFactory factory) {
        while (iterator.hasNext()) {
            AbstractRow row = iterator.next();
            if (row.level != level) {
                iterator.previous();
                return;
            }
            if (row instanceof GroupRow) {
                Object group = this.toGroup((GroupRow)row, factory);
                factory.addTo(parent, group);
                this.getGroup_f1(group, iterator, level + 1, factory);
            }
            if (!(row instanceof CriteriaRow)) continue;
            Object c = this.toCriteria((CriteriaRow)row, factory);
            factory.addTo(parent, c);
        }
    }

    private Object toGroup(GroupRow row, IGetFactory factory) {
        Object group = row.isAnd() ? factory.newAndGroup() : (row.isOr() ? factory.newOrGroup() : factory.newNotGroup());
        return group;
    }

    private Object toCriteria(CriteriaRow row, IGetFactory factory) {
        ICriteriaField field = row.getSelectedField();
        ICriteriaOperator operator = row.getSelectedOperator();
        Object valueReference = row.getValueReference();
        return factory.newCriteria(field, operator, valueReference);
    }

    @Override
    public boolean deleteAll() {
        for (AbstractRow row : this.rows) {
            row.dispose();
        }
        this.rows.clear();
        this.ids.clear();
        this.setDirty(true);
        this.layoutRows();
        return true;
    }

    @Override
    public void delete(AbstractRow source) {
        int indexOf = this.rows.indexOf((Object)source);
        for (int i = indexOf + 1; i < this.rows.size(); ++i) {
            AbstractRow row = this.rows.get(i);
            if (row.level <= source.level) break;
            --row.level;
        }
        source.dispose();
        this.rows.remove((Object)source);
        this.ids.remove(source.id);
        this.setDirty(true);
        this.layoutRows();
    }

    @Override
    public GroupRow addGroup(AbstractRow source) {
        int sourceLevel = source == null ? 0 : source.level;
        int addAtIndex = source == null ? this.rows.size() - 1 : this.rows.indexOf((Object)source);
        GroupRow row = new GroupRow(this.rowComp, 0);
        row.setController(this);
        row.level = source instanceof GroupRow ? sourceLevel + 1 : sourceLevel;
        this.rows.add(addAtIndex + 1, row);
        this.ids.put(row.id, row);
        this.setDirty(true);
        this.layoutRows();
        return row;
    }

    @Override
    public CriteriaRow addCriteria(AbstractRow source) {
        int sourceLevel = source == null ? 0 : source.level;
        int addAtIndex = source == null ? this.rows.size() - 1 : this.rows.indexOf((Object)source);
        CriteriaRow row = new CriteriaRow(this.rowComp, 0, this.mainfactory);
        row.setController(this);
        row.level = source instanceof GroupRow ? sourceLevel + 1 : sourceLevel;
        this.rows.add(addAtIndex + 1, row);
        this.ids.put(row.id, row);
        this.setDirty(true);
        this.layoutRows();
        return row;
    }

    @Override
    public void dragBeforeRow(String draggedId, String id) {
        AbstractRow draggedRow = this.ids.get(draggedId);
        if (draggedRow == null) {
            throw new NullPointerException("draggedRow");
        }
        AbstractRow row = this.ids.get(id);
        if (row == null) {
            throw new NullPointerException("row");
        }
        if (draggedRow == row) {
            return;
        }
        if (draggedRow instanceof GroupRow) {
            List<AbstractRow> children = this.getChildren(draggedRow);
            if (children.contains((Object)row)) {
                return;
            }
            this.rows.remove((Object)draggedRow);
            this.rows.removeAll(children);
            int index = this.rows.indexOf((Object)row);
            this.rows.add(index, draggedRow);
            this.rows.addAll(index + 1, children);
            int diff = row.level - draggedRow.level;
            draggedRow.level = row.level;
            for (AbstractRow child : children) {
                child.level += diff;
            }
            this.setDirty(true);
            this.layoutRows();
        } else if (draggedRow instanceof CriteriaRow) {
            this.rows.remove((Object)draggedRow);
            int rowIndex = this.rows.indexOf((Object)row);
            this.rows.add(rowIndex, draggedRow);
            draggedRow.level = row.level;
            this.setDirty(true);
            this.layoutRows();
        }
    }

    @Override
    public List<AbstractRow> getChildren(AbstractRow r) {
        ArrayList<AbstractRow> list = new ArrayList<AbstractRow>();
        int indexOf = this.rows.indexOf((Object)r);
        for (int i = indexOf + 1; i < this.rows.size(); ++i) {
            AbstractRow row = this.rows.get(i);
            if (row.level <= r.level) break;
            list.add(row);
        }
        return list;
    }

    @Override
    public void layoutRows() {
        if (this.deferRowLayout) {
            return;
        }
        this.deleteEmptyGroupRow();
        FormLayout layout = new FormLayout();
        layout.spacing = 3;
        this.rowComp.setLayout((Layout)layout);
        AbstractRow prev = null;
        for (AbstractRow row : this.rows) {
            if (row.isDisposed()) continue;
            FormData data = new FormData();
            data.top = prev == null ? new FormAttachment(0) : new FormAttachment(prev);
            data.left = new FormAttachment(0, row.level * 30);
            data.right = new FormAttachment(100);
            row.setLayoutData(data);
            prev = row;
        }
        this.rowComp.layout(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteEmptyGroupRow() {
        boolean deleted;
        ArrayList<AbstractRow> toDeletes = new ArrayList<AbstractRow>(4);
        for (AbstractRow row : this.rows) {
            if (!(row instanceof GroupRow) || this.getChildren(row).size() != 0) continue;
            toDeletes.add(row);
        }
        try {
            this.deferRowLayout = true;
            for (AbstractRow row : toDeletes) {
                this.delete(row);
            }
        }
        finally {
            this.deferRowLayout = false;
        }
        boolean bl = deleted = toDeletes.size() > 0;
        if (deleted) {
            this.deleteEmptyGroupRow();
        }
        return deleted;
    }

    @Override
    public boolean isDeferRowLayout() {
        return this.deferRowLayout;
    }

    @Override
    public void setDeferRowLayout(boolean b) {
        if (this.deferRowLayout != b) {
            this.deferRowLayout = b;
            if (!this.deferRowLayout) {
                this.layoutRows();
            }
        }
    }

    public IAppleFinderGridFactory getFactory() {
        return this.mainfactory;
    }

    public void setFactory(IAppleFinderGridFactory factory) {
        this.mainfactory = factory;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(wHint, hHint, changed);
    }
}

