/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;

public abstract class CleanupClass
extends JNIGenerator {
    String classSourcePath;
    String[] sourcePath;
    String classSource;
    Map<File, String> files;
    int usedCount;
    int unusedCount;

    String[] getArgNames(JNIMethod method) {
        int parantesesStart;
        int n_args = method.getParameters().length;
        if (n_args == 0) {
            return new String[0];
        }
        String name = method.getName();
        String params = "";
        int index = 0;
        while (true) {
            if (!Character.isWhitespace(this.classSource.charAt((index = this.classSource.indexOf(name, index + 1)) - 1))) {
                continue;
            }
            if (index == -1) {
                return null;
            }
            parantesesStart = this.classSource.indexOf("(", index);
            if (this.classSource.substring(index + name.length(), parantesesStart).trim().length() == 0) break;
        }
        int parantesesEnd = this.classSource.indexOf(")", parantesesStart);
        params = this.classSource.substring(parantesesStart + 1, parantesesEnd);
        String[] names = new String[n_args];
        StringTokenizer tk = new StringTokenizer(params, ",");
        int i = 0;
        while (i < names.length) {
            String s = tk.nextToken().trim();
            StringTokenizer tk1 = new StringTokenizer(s, " ");
            String s1 = null;
            while (tk1.hasMoreTokens()) {
                s1 = tk1.nextToken();
            }
            names[i] = s1.trim();
            ++i;
        }
        return names;
    }

    void loadClassSource() {
        if (this.classSourcePath == null) {
            return;
        }
        File f = new File(this.classSourcePath);
        this.classSource = this.loadFile(f);
    }

    void loadFiles() {
        if (this.sourcePath == null) {
            return;
        }
        this.files = new HashMap<File, String>();
        int i = 0;
        while (i < this.sourcePath.length) {
            File file = new File(this.sourcePath[i]);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    if (file.getAbsolutePath().endsWith(".java")) {
                        this.files.put(file, this.loadFile(file));
                    }
                } else {
                    this.loadDirectory(file);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String loadFile(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileReader fr = new FileReader(file);
                try {
                    String string;
                    block18: {
                        BufferedReader br = new BufferedReader(fr);
                        try {
                            StringBuffer str = new StringBuffer();
                            char[] buffer = new char[1024];
                            while (true) {
                                int read;
                                if ((read = br.read(buffer)) == -1) {
                                    fr.close();
                                    string = str.toString();
                                    return string;
                                }
                                str.append(buffer, 0, read);
                            }
                        }
                        finally {
                            if (br == null) break block18;
                            br.close();
                        }
                    }
                    if (fr != null) {
                        fr.close();
                    }
                    return string;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fr == null) throw throwable;
                    fr.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return "";
        }
    }

    void loadDirectory(File file) {
        String[] entries = file.list();
        int i = 0;
        while (i < entries.length) {
            String entry = entries[i];
            File f = new File(file, entry);
            if (!f.isDirectory()) {
                if (f.getAbsolutePath().endsWith(".java")) {
                    this.files.put(f, this.loadFile(f));
                }
            } else {
                this.loadDirectory(f);
            }
            ++i;
        }
    }

    @Override
    public void generate(JNIClass clazz) {
        this.loadFiles();
        this.loadClassSource();
    }

    public void setSourcePath(String[] sourcePath) {
        this.sourcePath = sourcePath;
        this.files = null;
    }

    public void setClassSourcePath(String classSourcePath) {
        this.classSourcePath = classSourcePath;
    }
}

