(function(){
	var user = angular.module("user", []);
	
	user.factory('UserAccessor', ['DashAPI','MessageLink', 'model','$filter','$translate',
	                      function(DashAPI, MessageLink, model, $filter, $translate) {
		function isUserClean(user){
			return (user.userName.indexOf('infodata') !== 0 &&
					 user.userName !== 'anonymous_communication' &&
					 user.userName !== 'Importation'
					);
		}
		function transformcitizenships(v){
			var currLanguage = DashAPI.lang;
			for(var i = 0; i < v.length; i++){
				if(currLanguage === 'en'){
					v[i].v = v[i].english;
				}else{
					v[i].v = v[i].french;
				}
			}
			return v;
		}
		var allCitizenships = [];
		var accessor = {
//			userDashboardCounts: function(callback, error){
//				DashAPI.get('/dashboard/User/ws/userDashboardCounts', callback, error);
//			},
			completionTypes: {citizenship: 'citizenship', city: 'city'},
			fillCompletion: function(type, callback, error){
				DashAPI.get('/dashboard/Complete/ws/data?type='+type, callback, error);
			},
			fillCompletionCity: function(data, callback, error){
				return DashAPI.get('/dashboard/Complete/ws/city?q='+ data.q + '&limit=' + data.limit, callback, error);
			},
			getAllCitizenships: function(callback){
				if(allCitizenships.length > 0){
					if (callback) callback(allCitizenships);
				}else{
					accessor.fillCompletion(accessor.completionTypes.citizenship, function(res){
						allCitizenships = transformcitizenships(res.data);
						if (callback) callback(allCitizenships);
					});
				}
			},
			getAllProfTypes : function (callback, error){// 0, 1=fait, 2=mettre histo, 3=1+2 (car ds bd=enumset) 
				if(accessor.allProfTypes){
					if (callback) callback(accessor.allProfTypes);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.professionnal.XProfessionnalType", function(res){
						delete res.data.className;
						accessor.allProfTypes = res.data;
						if (callback) callback(accessor.allProfTypes);
					}, error);
				}
			},
			getAllEmployeeTypes : function (callback, error){// 0, 1=fait, 2=mettre histo, 3=1+2 (car ds bd=enumset) 
				if(accessor.allEmployeeTypes){
					if (callback) callback(accessor.allEmployeeTypes);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.employee.XEmployeeType", function(res){
						delete res.data.className;
						accessor.allEmployeeTypes = res.data;
						if (callback) callback(accessor.allEmployeeTypes);
					}, error);
				}
			},
			getAllSpecialties : function (callback, error){// 0, 1=fait, 2=mettre histo, 3=1+2 (car ds bd=enumset) 
				if(accessor.allSpecialties){
					if (callback) callback(accessor.allSpecialties);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.XProfessionnalSpeciality", function(res){
						delete res.data.className;
						accessor.allSpecialties = res.data;
						if (callback) callback(accessor.allSpecialties);
					}, error);
				}
			},
			getAllRxVigilanceTypes : function (callback, error){// 0, 1=fait, 2=mettre histo, 3=1+2 (car ds bd=enumset) 
				if(accessor.allRxVigilanceTypes){
					if (callback) callback(accessor.allRxVigilanceTypes);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.professionnal.RxVigilanceLicenceType", function(res){
						delete res.data.className;
						accessor.allRxVigilanceTypes = res.data;
						if (callback) callback(accessor.allRxVigilanceTypes);
					}, error);
				}
			},
			getAllUserRoles : function (callback, error){// 0, 1=fait, 2=mettre histo, 3=1+2 (car ds bd=enumset) 
				if(accessor.allUserRoles){
					if (callback) callback(accessor.allUserRoles);
				}else{
					return DashAPI.get("/dashboard/encs/ws/enumlistobj?className=ca.infodata.ofys.data.middle.dataobjects.XUserRole", function(res){
						delete res.data.className;
						accessor.allUserRoles = res.data;
						if (callback) callback(accessor.allUserRoles);
					}, error);
				}
			},
			cleanAndSortUsers: function (userList){
				var available = $filter('filter')(userList, isUserClean);
				return $filter('orderBy')(available, 'personName');
			},
			groups: function(callback, error){
				DashAPI.get('/dashboard/User/ws/groups', callback, error);
			},
			listUsersForSelection: function(callback, error){
				if(accessor.allUsers){
					callback(accessor.allUsers);
				}else{
					return DashAPI.get("/dashboard/User/ws/listUsersForSelection", function(res){
						accessor.allUsers = {data: []};
						for(var i=0;i<res.data.length;i++) {
							if (res.data[i].personName) {
								res.data[i].personNameLc = res.data[i].personName.toLowerCase().removeAccentsLc();
							}
							accessor.allUsers.data.push(res.data[i]);
						}
						callback(accessor.allUsers);
					}, error);
//					DashAPI.get('/dashboard/User/ws/listUsersForSelection', callback, error);
				}
			},
			employeeTypesInUse: function(callback, error){
				DashAPI.get('/dashboard/User/ws/employee/typesinuse', callback, error);
			},
			objToParams: function (o){
				var paramStr = [];
				Object.keys(o).forEach(function(cur){
					paramStr.push(cur +"="+o[cur]);
				});
				return paramStr.join("&");
			},
			searchProfiles: function(data, callback, error){
				return DashAPI.post('/dashboard/User/ws/searchProfiles',data, callback, error);
			},
			getSearchProfilesPage: function(data, callback, error){
				return DashAPI.get('/dashboard/User/ws/getSearchProfilesPage?'+this.objToParams(data), callback, error);
			},
			employeeByIdPerson: function(idPerson, callback, error){
				DashAPI.get('/dashboard/User/ws/employee?idPerson='+ idPerson, callback, error);
			},
			allEmployees: function(callback, error){	// non appelé ici car appelé dans model pour mettre dans user.employee
				return DashAPI.get('/dashboard/User/ws/allemployees', callback, error);
			},
			metabaseToken: function(callback, error){
				DashAPI.get('/dashboard/User/ws/metabasetoken', callback, error);
			},
			metabaseToken4Question: function(q, callback, error){
				DashAPI.get('/dashboard/User/ws/metabasetoken?idQuestion=' + q, callback, error);
			},
			getMetabaseQuestion: function(callback, error){
				DashAPI.get('/dashboard/User/ws/metabasequestion', callback, error);
			},
			rxVigilanceToken: function(callback, error){
				DashAPI.get('/dashboard/User/ws/rxvigilancetoken', callback, error);
			},
			newRxVigilanceToken: function(callback, error){
				DashAPI.get('/dashboard/User/ws/newrxvigilancetoken', callback, error);
			},
			saveEmployee: function(prof, callback, error){
				return DashAPI.post('/dashboard/User/ws/employee/save', prof, callback, error);
			},
			unblockUser: function(idUserAnchor, callback, error){
				return DashAPI.get('/dashboard/User/ws/unblockUser?idUserAnchor='+idUserAnchor, callback, error);
			},
			person: function(idPerson, callback, error){
				if(model.user().persons[idPerson] !== undefined){
					res = {data: model.user().persons[idPerson]};
					callback(res);
				}else{
					DashAPI.get('/dashboard/User/ws/person?idPerson='+ idPerson, function(res){
						model.user().persons[idPerson] = res.data;
						callback(res);
					}, error);
				}
			},
			researchActivities: function(data, callback, error){
				return DashAPI.post('/dashboard/User/ws/researchActivities', data, callback, error);
			}
		}
		accessor.getAllEmployeeTypes(function(employeeTypes){
			model.allEmployeeTypes = Object.values(employeeTypes);
			model.allEmployeeTypes.sort(function(a, b){
				if(a.i18n > b.i18n){
					return 1;
				}else if(b.i18n > a.i18n){
					return -1;
				}
				return 0;
			})
		});
		accessor.getAllProfTypes(function(profTypes){
			model.allProfTypes = Object.values(profTypes);
			model.allProfTypes.sort(function(a, b){
				if(a.i18n > b.i18n){
					return 1;
				}else if(b.i18n > a.i18n){
					return -1;
				}
				return 0;
			})
		});
		accessor.getAllUserRoles();
		return accessor;
	}]);

	user.controller('UserController', 
		['$scope', 'model', '$log', '$stateParams', '$timeout','hotkeys','UserAccessor','QValidation','$filter', 'ProfAccessor',
		function ($scope, model, $log, $stateParams, $timeout, hotkeys, UserAccessor, QValidation, $filter, ProfAccessor) {
		
		model.activeController('pt');
		model.activeMenu('Patients');
		$scope.focusable = {};
		$scope.request = {isActiveSearch : true};
		$scope.isTreating = false;
		$scope.searchFilter = false;
		model.patient().q = "";
		$scope.patientListPlaceholder =  "findUser";
		$scope.updateListPlaceHolder = function(){
			if(model.patient().q.length > 0 && model.patient().q.length < 3){
				$scope.patientListPlaceholder = 'invalidSearch3Chars';
			} else {
				$scope.patientListPlaceholder = 'noPatients';
			}
		};
		
		$scope.activeState = [
			{val:true,name:'profActives'},
			{val:false,name:'profInactives'}
		]

		hotkeys.add({
			combo: 'alt+r',
			description: 'Rechercher un utilisateur par date',
			callback: function() {
				$scope.focusable.focusSearchInput();
			}
		});

		$scope.editorOptions = {
			showExit: true,
			exit: function(){
				model.user().tab.currUser = {};
			}
		}

		$timeout(function(){
			if($scope.focusable.focusSearchInput){
				$scope.focusable.focusSearchInput();
			}
			model.fosucSearchTimeout = 0;
		}, model.fosucSearchTimeout=== 0?0:600); //for first page load anything less than 500ms doesn't seem to work

		$scope.newPatientOptions = {
			showExit: true,
			exit: function(){
				model.patient().currPatient = {};
			}
		};
		$scope.patientViewMode=function(mode){
			model.patientViewMode = mode;
		};
		$scope.listSize = function() {
			return model.listPatSize();
		};
		$scope.userFct = {
			test: true,
		};
		$scope.popoverEdit = false;
		$scope.popoverEditMode = function(mode){
			$scope.popoverEdit = !$scope.popoverEdit;
		};
		$scope.popoverShowChart = false;
		$scope.popoverShowChartMode = function(mode){
			$scope.popoverShowChart = !$scope.popoverShowChart;
		};

		$scope.isLoadingList = false;
		$scope.searchResolved = false;
		$scope.showRecemmentConsultes = function() {
			return $scope.searchResolved===false && model.patient().currList.length>0;
		};
		var addedInQv = false;
		
		function checkIfActivePatientIsInList() {
			if (angular.isDefined(model.patient().currPatient) && model.patient().currPatient.id) {
				var lstPt = model.patient().currList.filterFast(function(a){return a.id===model.patient().currPatient.id;});
				if (lstPt.length===0) {
					model.patient().currPatient={};
				}
			}			
		}
		checkIfActivePatientIsInList();
		
		$scope.$on("$destroy", function handler() {
	        $log.log("UserController destroy");
	    });

		$scope.addNewUser = function(){
			var newUser = {isNew: true, className: "CUser"};
			$scope.viewOptions.select(newUser);
		};
		
		$scope.addNewEmployee = function(){
			var newUser = {isNew: true, className: "CEmployee"};
			$scope.viewOptions.select(newUser);
		};
		
		$scope.addNewProf = function(){
			var newUser = {isNew: true, className: "CProfessional"};
			$scope.viewOptions.select(newUser);
		};
		
		$scope.updateUserList = function(){
			makeRequest("search", {text: model.user().q, isDeleted: !$scope.request.isActiveSearch});
		};
		$scope.listProfessionals = function(){
			makeRequest("profs", {isProfessionnal: true, isDeleted: !$scope.request.isActiveSearch });
		};
		$scope.listProfessionalsSearch = function(){
//			makeRequest("profs", {isProfessionnal: true, text: model.user().q})
			makeProfRequest("profs", {
				isActive: $scope.request.isActiveSearch, 
				istreating: $scope.isTreating,
				text: model.user().q,
				types: null,
				useAppointment: false
			});
		};
		$scope.listEmployees = function(){
			makeRequest("employee", {isEmployee: true, isDeleted: !$scope.request.isActiveSearch});
		};
		$scope.listActiveUsers = function(){
			makeRequest("active", {isUserActive: true, isUser: true});
		};
		$scope.listBlockedUsers = function(){
			makeRequest("blocked", {isUserBlocked: true, isUserDeleted: false, isDeleted:!$scope.request.isActiveSearch});
		};
		$scope.listUser = function(){
			makeRequest("user", {isDeleted:!$scope.request.isActiveSearch, isUserDeleted: false});
		}

		$scope.listManager = {};

		function makeRequest(type, criteria){
			//clear previous data
			if (model.user().tab.currList) {
				model.user().tab.currList.length = 0;				
			}
			$scope.isLoadingList = true;
			
			$scope.listManager.criteria = criteria;
			$scope.listManager.type = type;
			// request[type].fn(scope.listManager);
			UserAccessor.searchProfiles($scope.listManager.criteria, function (searchResults){
				$scope.listManager.criteriaResponse = searchResults;
				UserAccessor.getSearchProfilesPage({referenceId: searchResults.referenceId, pageNumber: 1, nbItemsPerPage:searchResults.total }, function(res){
					model.user().tab.currList = res;
					$scope.isLoadingList = false;
					model.searchPtUpdated(true);
				});
			});
		}
		
		function makeProfRequest(type, criteria){
			//clear previous data
			if (model.user().tab.currList) {
				model.user().tab.currList.length = 0;
			}
			$scope.isLoadingList = true;
			
			$scope.listManager.criteria = criteria;
			$scope.listManager.type = type;
			ProfAccessor.search($scope.listManager.criteria, function(res){
				model.user().tab.currList = res.data;
				$scope.isLoadingList = false;
				model.searchPtUpdated(true);
			});
		}
		
		$scope.hasFoundToMany = function() {
			var clientPref = model.clientPreferences();
			return $scope.isLoadingList == false && clientPref.returnListLength <= model.user().tab.currList.length;
		};

		$scope.focusable.onListReady = function(){
			$timeout(function(){
				$scope.focusable.patientsListFocus(true);
			}, 150);
		};
		
		$scope.forceReload = function() {
			// $scope.patientIds = undefined;
			$scope.updateUserList();
			
		};
		
		$scope.searchProf = function() {
			$scope.listProfessionalsSearch();
		};

		$timeout(function() {
			if(model.patient().currPatient && model.patient().currPatient.lstScroll){
				model.patient().currPatient.lstScroll()
			}
		}, 400);

		$scope.viewOptions = {
			select: function(user){
				QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
					if(successful){
						if(model.user().tab.currUser.idPerson != user.idPerson) {
							model.user().tab.currUser = user;
							model.searchPtUpdated(true);
						} else if(user.idPerson === undefined){
							model.user().tab.currUser = user;
							model.searchPtUpdated(true);
						}
					}
				});
			}
		};
		
		$scope.select = function(user){
			if(user.className == "CBaseProfessionnal"){
				ProfAccessor.findProfById(user.id, function(res){
					$scope.viewOptions.select(res.data);
				});
			}else{
				$scope.viewOptions.select(user);	
			}
		};
		
		$scope.showPatientHtml = function(pat) {
			return patientShowTitles.showPatientHtml(pat);
		};

		$scope.isActive = function(user){
			return angular.isDefined(model.user().tab.currUser) && model.user().tab.currUser.idPerson === user.idPerson;
		};
		if ($stateParams.term_ids!==undefined) {
			
		}
		if ($stateParams.rev_ids!==undefined) {
			
		}
		if ($stateParams.rappel_ids!==undefined) {
			
		}
		var mergedData;
		$scope.patientIds = undefined;
		if ($stateParams.rev_ids!==undefined || 
			$stateParams.edits_ids!==undefined ||
			$stateParams.date_edits_ids!==undefined ||
			$stateParams.term_ids!==undefined || 
			$stateParams.attente_ids!==undefined || 
			$stateParams.rappel_ids!==undefined) {
			mergedData = _.clone($stateParams.rev_ids ? $stateParams.rev_ids : []);
			mergedData = $.merge(mergedData, _.clone($stateParams.edits_ids ? $stateParams.edits_ids : []));
			mergedData = $.merge(mergedData, _.clone($stateParams.date_edits_ids ? $stateParams.date_edits_ids : []));
			mergedData = $.merge(mergedData, _.clone($stateParams.term_ids ? $stateParams.term_ids : []));
			mergedData = $.merge(mergedData, _.clone($stateParams.attente_ids ? $stateParams.attente_ids : []));
			mergedData = $.merge(mergedData, _.clone($stateParams.rappel_ids ? $stateParams.rappel_ids : []));
			$scope.patientIds = mergedData;	// les id des patients à loader, séparés par ,
			model.patient().currList.length = 0;	// pour forcer une nouvelle liste.
			if (model.patient().q) model.patient().q = '';
			$scope.updatePatientList();
			cleanUpRouteIds();
		}

		function cleanUpRouteIds(){
			delete $stateParams.rev_ids
			delete $stateParams.edits_ids
			delete $stateParams.date_edits_ids
			delete $stateParams.term_ids
			delete $stateParams.attente_ids
			delete $stateParams.rappel_ids
		}
		model.callDashBoardCount();
		
	}]);

    user.directive('userData', ['model','PatientAccessor','FormAccessor',
         function (model, PatientAccessor, FormAccessor) {
        return {
			restrict: 'EA',
			templateUrl: '/dashboard/resources/ofys/user/user_data/userData.html?v=bh',
			link: function(scope, element, attrs){
                scope.resetData = function(){
                    if(!scope.user){
                        scope.user = model.user().sessionUser.user;
                    }
                    if(!scope.user.viewbag){
                        scope.user.viewbag = {userData: {allForms: [], forms: [], frm10:[],
                                loaded:{doneLoaded:0, allForms:2, forms:2, frm10:2}}};
                    }
                    updateData(scope.user, scope.user.viewbag.userData);
                    scope.actOptions = scope.quickViewData.options;
                }

				scope.filterAllForm = function(v) {
					return function(a) {
						return (v || scope.filterForm(a));
					};
                };
                
				scope.filterForm = function(l){
					var b = true;
					if (scope.searchTextRegExp) {
						b = matchInArray(l.date+'~'+l.author+'~'+l.form.name+'~'+l.resumeValue);
					}
					return b;
				};

                function updateData(usr, ud){

                    if (ud.loaded.allForms===2) {
                        updateForms(usr, ud);
                    }
                }

                var sortOnDate = PatientAccessor.sortOnDate;
                
                function updateForms(user, udata){
                    FormAccessor.userFormData(user.idPerson, function(resData){
                    // FormAccessor.userFormData(2297093, function(resData){
						// tous les form de l'utilisateur sont là.
						if(Array.isArray(resData)){
							udata.allForms = resData.sort(sortOnDate);
							scope.resetFormFilter(udata);
						}else if(resData && resData.data && !resData.data.success && resData.data.ms){
							model.notice.fail(resData.ms);
						}
						model.userDataUpdated(true);
                    });
                }

				scope.nbEventsToShow = function(t) {
					if (model.prefSettings().eventByDate===0) {
						return model.prefSettings().nbEvents;
					} else {
						// par date - donc nombre est dynamique
						return scope['limitD'+t];
					}
                };

                scope.resetFormFilter = function(udata){
					var filterDeleted = model.prefSettings('showDeletedForm')===true ? true: false;
					udata.forms = udata.allForms.filterFast(function(a){return a.form.type===10 && currentUserIsAuthor(a.idAuthor) &&(filterDeleted?true:a.deleted===false);});
					udata.frm10 = udata.allForms.filterFast(function(a){return a.form.type===10 && !currentUserIsAuthor(a.idAuthor) && fieldNoteconcernsUser(a) && (filterDeleted?true:a.deleted===false);});
					// udata.forms = udata.allForms.filterFast(function(a){return a.form.type===1 && (filterDeleted?true:a.deleted===false);});
					// udata.frm10 = udata.allForms.filterFast(function(a){return a.form.type===1 && (filterDeleted?true:a.deleted===false);});
					udata.loaded.allForms = 1;						
                    udata.loaded.forms = 1;						
                    udata.loaded.frm10 = 1;	
					udata.loaded.doneLoaded++;
                };
                
                function fieldNoteconcernsUser(a){
					if(a.dataJsonb !== undefined){
						var fieldNote = JSON.parse(a.dataJsonb);
						return oneOfProp(fieldNote, ['residentId', 'supervisorId', 'advisorId', 'secretaryId'],  scope.user.idPerson);
					}else{
						return false;
					}
				}
				
				function oneOfProp(obj, props, val){
					for (var i = 0; i < props.length; i++) {
						if(obj[props[i]] === val){
							return true;
						}
					}
					return false;
				}
                
                function currentUserIsAuthor(author){
					return scope.user.idPerson === author
                }

                scope.resetData();
            }
        }
	}]);

	user.directive('userSearch',['$q','utils', 'model','UserAccessor', '$rootScope','$timeout',
		 function($q, utils, model, UserAccessor, $rootScope, $timeout){
		return {
			restrict:'AE',
			link:function(scope, element, attrs){
				scope.vb = {};
				var userItemHtml;
				utils.getTemplate('/dashboard/resources/ofys/user/user_dataItem.html?v=bh', function(html){
					userItemHtml = html;
				})
				function filterUserSearchableByWorkSite(){
					var res = scope.userSearchable;
					if(model.prefSettings('user_settings_SiteMessages')){
						var workSiteId = model.user().session.workSite.id;
						res = res.filter(function(e){
							if(e && e.sessionSite && e.sessionSite.id){
								if(e.sessionSite.id === workSiteId){
									return true;
								}
								return false;
							}else{
								// if the user does not have a session site.. always display
								return true;
							}
						});
					}
					return res;
				}

				function searchUsers(query){
					var res;
					var initialList = filterUserSearchableByWorkSite()
					if(query){
						var q = query.toLowerCase().removeAccentsLc();
						res = [];
						for (var i = 0; i < initialList.length; i++) {
							elem = initialList[i];
							if ((elem.personNameLc && elem.personNameLc.indexOf(q) > -1)) {
								res.push(elem);
							}
						}
						// est ce plus optimisé ci-haut?
						//res = $filter('filter')(initialList, {personNameLc:q});
					}else{
						res = initialList;
					}
					return res;
				}

				$timeout(function(){
					if(scope.focusUserSearchInput){
						scope.focusUserSearchInput();
					}
				}, 50)

				UserAccessor.listUsersForSelection(function(res){
					scope.userSearchable = UserAccessor.cleanAndSortUsers(res.data);
				});

				scope.userSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					minChar: 0,
					trigger: 'focus',
					getAsyncData: function(query, assist){
						return $q(function(resolve, reject) { 
							resolve(searchUsers(query));
						});
					},
					getKey: function(recipient) {
						var newScope = $rootScope.$new();
						newScope.item = recipient;
						var res =  utils.compile(newScope, userItemHtml);
						// $timeout(function(){
						// 	if(!newScope.$$phase) {
						// 		newScope.$digest();
						// 	}
						// }, 0);
						return res;
					},
					selection: function(recipient, assistObject) {
						if(scope.setUser){
							scope.$apply(scope.setUser(recipient));
						}
						if(scope.$parent && scope.$parent.$hide){
							scope.$parent.$hide();
						}
						return "";
					},
				};
			}
		}
	}]);

	//Replacing professional table directive, also taking care of opening modal form for new professional
	user.directive('userEdit', ['model', 'UserAccessor','$timeout','ModificationStatus','PatientFormService','$filter','QConfirm','DashAPI', '$q',
		function(model, UserAccessor, $timeout, ModificationStatus, PatientFormService, $filter, QConfirm, DashAPI, $q){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/user/profil/user_edit.html?v=bh',
			scope: {
				base:'=',
				origBase:'=',
				formOptions: '='
			},
			link: function(scope, element, attrs){
				scope.model = model;
				scope.isUserAdmin = model.user().isUserAdmin;

				scope.validFromDateDynaDateOptions = {
					acceptFutureDate: true,
				}
				scope.validToDateDynaDateOptions = {
					acceptFutureDate: true,
				}
				scope.crisisRoleEndDynaDateOptions = {
					acceptFutureDate: true,
				}

				scope.unblockUser = function(){
					if(scope.base.user.isBlocked){
						UserAccessor.unblockUser(scope.base.user.id, function(res){
							scope.base.user.isBlocked = false;
							scope.base.user.lockUntilRefreshed = true;//Bug de version modif 
							model.notice().success($filter("translate")("unblockUserSuccess"))
						});
					}
				}

				scope.changeOwnPassword = function(){
					var qconfirmOptions = {templateUrl: 'changePasswordFrm_index.html',
                        changePass: {oldPassword:"", password: "", confirmPassword:""},
                        checkPasswordRegex: function(password){
							const regex = new RegExp(model.user().session.clientPreferences.passwordRegexp);
							return password && password.length > 4 && regex.test(password);
						},
						qconfirm: {
							hideNo: true,
							yesTitle: "Save",
							beforeYes: function(e, obj){
								e.prevent();
								if(obj.qconfirm.frm && obj.qconfirm.frm.$valid 
										&& obj.checkPasswordRegex(obj.changePass.password)){
									sendChangePassword(obj.changePass, obj.qconfirm.cancel);	
								}else{
									obj.qconfirm.frm.errorMsgs = PatientFormService.getFormErrors(obj.qconfirm.frm,null, 
										{compareTo: "Mismatch", minlength: "MinLength"});
									if(!obj.checkPasswordRegex(obj.changePass.password)){
										obj.qconfirm.frm.errorMsgs.push({
										    msg: "PatternPassword",
										    type: "error"
										})
									}
								}
							}
					}};
					QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(){});
				}

				function update2FAActiveConfigured(base, active, configured, suspend){
					base.user.twoFactorActive = active;
					base.user.twoFactorConfigured = configured;
					base.user.twoFactorSuspended = suspend;//reinitialise suspension state
				}

				function update2FAConfirmationEmail(base, active, configured){
					base.user.twoFactorEmail = active;
				}

				scope.deactivateTwoFactorAuth = function(success, fail){
					var isUserAccount = scope.base.user.id == model.user().sessionUser.user.id;
					return QConfirm.open({title: $filter('translate')(model.clientPreferences().twoFactorEnforced?(isUserAccount?'ConfirmRefreshTwoFactorUser':'ConfirmReconfigureTwoFactor'):'ConfirmDeactivateTwoFactor')}, {windowClass:'top-modal'}).then(function(ok){
						if(ok){
							var params = "?userId="+scope.base.user.id
							DashAPI.get("/dashboard/Login/ws/deleteTwoFactor"+params, function (res) {
								if(res){
									update2FAActiveConfigured(scope.base, model.clientPreferences().twoFactorEnforced, false, model.clientPreferences().twoFactorEnforced);//UI
									update2FAActiveConfigured(scope.origBase, model.clientPreferences().twoFactorEnforced, false, model.clientPreferences().twoFactorEnforced);//Model update
									if(isUserAccount){
										scope.base.user.twoFactorSuspended = false;
										scope.origBase.user.twoFactorSuspended = false
									}
								}
							});
						}
					});
				}

				scope.suspendTwoFactorAuth = function(){
					QConfirm.open({title: $filter('translate')('ConfirmSuspendTwoFactor')}, {windowClass:'top-modal'}).then(function(ok){
						if(ok){
							var params = "?userId="+scope.base.user.id
							DashAPI.get("/dashboard/Login/ws/suspendTwoFactor"+params, function (res) {
								if(res){
									scope.base.user.twoFactorSuspended = true;
									scope.origBase.user.twoFactorSuspended = true
								}
							});
						}
					});
				}

				scope.restoreTwoFactorAuth = function(){
					QConfirm.open({title: $filter('translate')('ConfirmUnSuspendTwoFactor')}, {windowClass:'top-modal'}).then(function(ok){
						if(ok){
							var params = "?userId="+scope.base.user.id
							DashAPI.get("/dashboard/Login/ws/restoreTwoFactorAuth"+params, function (res) {
								if(res){
									scope.base.user.twoFactorSuspended = false;
									scope.origBase.user.twoFactorSuspended = false
								}
							});
						}
					});
				}

				scope.activateTwoFactorAuthUserAdmin = function(){
					QConfirm.open({title: $filter('translate')('ConfirmActivateTwoFactorUserAdmin')}, {windowClass:'top-modal'}).then(function(ok){
						if(ok){
							DashAPI.post("/dashboard/Login/ws/saveTwoFactorConfig",{userId:scope.base.user.id}, function (res) {
								if(res){
									update2FAActiveConfigured(scope.base, true, false, false);//UI
									update2FAActiveConfigured(scope.origBase, true, false, false);//Model update
								}
							}, function(){
							});
						}
					});
				}

				function getTwoFactorSteps (reconfigure){
					var twoFactorFormCtrler = {
						steps:[
							{
								template: "download_configureTwoFactorFrm.html",
								next:function(step, twoFactorCtrler, modalCtrler){
									twoFactorCtrler.page += 1;
									if(twoFactorCtrler.code == undefined){
										DashAPI.get("/dashboard/Login/ws/configureTwoFactor", function (res) {
											if(res.qrCode != null){
												res.qrCodePng = "data:image/png;base64," +OfysUtils.byteArrayToBase64(res.qrCode);
												res.qrCodeTemplate = 'qr_configureTwoFactorFrmImageTemplate_index.html';
											}
											if(res.secret != null){
												res.secretReadable = res.secret.replace(/(.{4})/g,"$1 ").split(" ");
											}
											twoFactorCtrler.code = res;
											
										});
									}
									return true;
								}
							},
							{
								template: "qr_configureTwoFactorFrm.html",
								next:function(step, twoFactorCtrler, modalCtrler){
									if(!reconfigure){
										twoFactorCtrler.page += 1;
									}
									return !reconfigure;
								}
							},
							{
								template: "code_configureTwoFactorFrm.html",
								next:function(step, twoFactorCtrler, modalCtrler){
									twoFactorCtrler.validating = true;
									if(twoFactorCtrler.validationCode == undefined || 
										twoFactorCtrler.validationCode.length < 6 ||
										isNaN(twoFactorCtrler.validationCode)){
										twoFactorCtrler.codeInvalid = true;
										twoFactorCtrler.validating = false;
									}else{
										DashAPI.post("/dashboard/Login/ws/saveTwoFactorConfig", {code:twoFactorCtrler.validationCode , sec:twoFactorCtrler.code.secret}, function (res) {
											twoFactorCtrler.validating = false;
											twoFactorCtrler.codeInvalid = !res;
											if(res){

												update2FAActiveConfigured(scope.base, true, true, false);//UI
												update2FAActiveConfigured(scope.origBase, true, true, false);//Model update
												twoFactorCtrler.page += 1;
											}
										}, function(){
											twoFactorCtrler.validating = false;
										});
									}
									return true;
								}
							},
							{
								template: "recovery_configureTwoFactorFrm.html",
								sendConfirmationEmail: function(step, twoFactorCtrler){
									twoFactorCtrler.validating =true;
									var params = {email:twoFactorCtrler.recoveryEmail, lang: DashAPI.lang};
									DashAPI.post("/dashboard/Login/ws/sendTwoFactorCodeToEmail", params, function (res) {
										// $timeout(function(){// ensure that there is at least a visible laoding time to show the user that the action is being processed.
											// console.log(res);
											twoFactorCtrler.validating =false;
											twoFactorCtrler.recoveryEmailCodeSent = true;
											twoFactorCtrler.recoveryEmailCodeSentTo = params.email;
											twoFactorCtrler.emailValidationId = res;
											if(twoFactorCtrler.emailValidationId != null){
												twoFactorCtrler.emailValidationExpiry = moment().add(30, "m") //extend the default 30 seconds to 30 mins for email to account for email delivery wait times
											}
										// }, 200)
									}, function(){
										twoFactorCtrler.validating = false;
									});
								},
								skipRecoveryEmailStep:function(step, twoFactorCtrler){
									twoFactorCtrler.validating =false;
									twoFactorCtrler.page += 1;
								},
								emailWithCode: function(twoFactorCtrler){
									return twoFactorCtrler.recoveryEmailCodeSent && 
									twoFactorCtrler.recoveryEmailCodeSentTo == twoFactorCtrler.recoveryEmail;
								},
								next:function(step, twoFactorCtrler, modalCtrler){
									function clearErrorMsgs(){
										if(modalCtrler.qconfirm.frm == undefined){
											modalCtrler.qconfirm.frm = {};
										}
										modalCtrler.qconfirm.frm.errorMsgs = [];
									}
									function validFailed(){
										twoFactorCtrler.validating =false;
										clearErrorMsgs();
										modalCtrler.qconfirm.frm.errorMsgs.push({msg:"AUTH_2_FACTEUR_INVALIDE"});
									}
									function emailValidationFailed(){
										twoFactorCtrler.validating =false;
										clearErrorMsgs();
										modalCtrler.qconfirm.frm.errorMsgs.push({msg:"AUTH_2_FACTEUR_EMAIL_INVALIDE"});
									}


									twoFactorCtrler.validating =true;
									if(!this.emailWithCode(twoFactorCtrler)){
										if(twoFactorCtrler.recoveryEmail != null && twoFactorCtrler.recoveryEmail.length > 0){
											clearErrorMsgs();
											this.sendConfirmationEmail(step, twoFactorCtrler);
										}else{
											emailValidationFailed();
										}
									}else{
										if(twoFactorCtrler.recoveryEmailCode != null){
											var validationId = btoa(twoFactorCtrler.recoveryEmailCode);

											function saveEmailAndNext(code){
												clearErrorMsgs();
												DashAPI.post("/dashboard/Login/ws/saveTwoFactorConfigEmail", {email:twoFactorCtrler.recoveryEmail, code: code}, function (res) {
													if(res === false){
														validFailed();
													}else{
														twoFactorCtrler.validating =false;
														twoFactorCtrler.page += 1;
														
														update2FAConfirmationEmail(scope.base, twoFactorCtrler.recoveryEmail);//UI
														update2FAConfirmationEmail(scope.origBase, twoFactorCtrler.recoveryEmail);//Model update
													}
												}, function(){
													twoFactorCtrler.validating = false;
												});
											}

											//Valid and unexpired
											if(OfysUtils.isEmpty(twoFactorCtrler.emailValidationId) == false && 
												validationId == twoFactorCtrler.emailValidationId && 
												moment().isBefore(twoFactorCtrler.emailValidationExpiry)){
													saveEmailAndNext();
											}else if(OfysUtils.isEmpty(twoFactorCtrler.emailValidationId)){
												saveEmailAndNext(twoFactorCtrler.recoveryEmailCode);
											}else{
												validFailed();
											}
											
										}
									}
									return true;
								}
							},
							{
								template: "success_configureTwoFactorFrm.html",
								next:function(step, twoFactorCtrler, modalCtrler){
									return false;
								}
							},
						],
						page: 0
					}
					return twoFactorFormCtrler;
				}

				function openTwoFactorSteps(twoFactorFormCtrler){
					var qconfirmOptions = {templateUrl: '/dashboard/resources/ofys/user/configureTwoFactorFrm.html?v=bh',
					configObj: twoFactorFormCtrler,
					qconfirm: {
						hideNo: true,
						yesTitle: "Next",
						beforeYes: function(e, obj){
							var step = twoFactorFormCtrler.steps[twoFactorFormCtrler.page];
							
							if(step.next(step, twoFactorFormCtrler, obj)){
								e.prevent();
							}
							if(obj.configTwoFactorFrm){
								console.log(obj.configTwoFactorFrm);
							}
						}
					}};
					QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(){});
				}

				scope.activateTwoFactorAuth = function(reconfigure){
					var twoFactorFormCtrler = getTwoFactorSteps(reconfigure);
					openTwoFactorSteps(twoFactorFormCtrler);
				}

				scope.twoFactorEnforced = function(){
					return model.clientPreferences().twoFactorEnforced;
				}

				scope.addTwoFactorEmail = function(reconfigure){
					var twoFactorFormCtrler = getTwoFactorSteps(reconfigure);
					twoFactorFormCtrler.page = 3;//Recovery email step.
					twoFactorFormCtrler.changeEmail = true;
					openTwoFactorSteps(twoFactorFormCtrler);
				}

				scope.removeTwoFactorEmail = function(reconfigure){
					var qconfirmOptions = {title: $filter('translate')('CONFIRM_REMOVE_RECOVERY_EMAIL')};
					QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(proceed, function(){});
					function proceed(proceed){
						if(proceed){
							DashAPI.post("/dashboard/Login/ws/saveTwoFactorConfigEmail", {email:null}, function (res) {
								update2FAConfirmationEmail(scope.base, null);//UI
								update2FAConfirmationEmail(scope.origBase, null);//Model update
							});
						}
					}
				}

				function sendChangePassword(changePass, closeFn) {
//					if (frm.$valid) {
						DashAPI.post("/dashboard/Login/ws/changePassword", changePass, function (res) {
							model.notice().success($filter("translate")("passwordChangeSuccess"))
							closeFn();
							//console.log(res);
						});
//					} else {
//						model.notice().fail($filter('translate')("invalidOrIncomplet"))
//						return false;
//					}
				};

//				if(!scope.showUserForm){
//					return ;
//				}
				var defaultUser = {
					isNew: true,
					modificationStatus: ModificationStatus.STATUS_NEW,
					mustChangePassword: true,
					changePassword: true,
					role: []
				}
				var frmApi = {
					isDirty:function(){
						return scope.userform && scope.userform.$dirty
					},
					okToClose(){
						if(scope.base.isUser==false && scope.base.user && scope.base.user.isNew ){
							delete scope.base.user;
						}
						if(scope.userform && scope.userform.$dirty){
							if (scope.base.user) {
								if (scope.base.isUser==false) {
									scope.base.user.modificationStatus = ModificationStatus.STATUS_DELETED;
									scope.base.user.isDeleted = true;
								} else {
									if (scope.base.user.modificationStatus==undefined || scope.base.user.modificationStatus != ModificationStatus.STATUS_NEW) {
										scope.base.user.modificationStatus = ModificationStatus.STATUS_UPDATED;
									}
									scope.base.user.isDeleted = false;
								}
							}
						}
						
						if(scope.userform){
							scope.userFormErrors = PatientFormService.getFormErrors(scope.userform,null, {compareTo: "Mismatch"})
						}
						if(scope.userFormErrors && scope.userFormErrors.length > 0){
							return false;
						}
						return true;
					},
					reset: function(){
						if (scope.userform) {
							scope.userform.$setPristine();
							updateRoles();							
						}
					}
				};

				scope.updateFormOptions = function (){
					if(scope.formOptions && scope.formOptions.children){
						scope.formOptions.children.push(frmApi);
					}
				}
				
				scope.$watch(scope.formOptions, scope.updateFormOptions)
				
				scope.initUser = function (){
					if(scope.base && scope.base.isUser && !scope.base.user){
						scope.base.user = angular.copy(defaultUser);
						scope.base.user.basePerson = scope.base.idPerson;
					}
				}

				scope.changePassword = function(){
					if(!scope.base.user.changePassword){
						$timeout(scope.focusWritePassword, 100)
					}
					scope.base.user.changePassword = !scope.base.user.changePassword;
				}
				scope.selectedUserRoles = ["USER_MANAGEMENT", "ADMIN", "HEALTHCARE_PROVIDER", "STAGIAIRE", "BILLING"]
				scope.selectedUserEmployeeRoles = ["USER_MANAGEMENT", "ADMIN", "MEDICAL_SECRETARY", "SECRETARY","BILLING"]
				UserAccessor.getAllUserRoles(function(userRoles){
					scope.userRolesObj = userRoles
					scope.userRolesLst = scope.selectedUserRoles.map(function(role){
						return userRoles[role];
					});
					scope.userEmployeeRolesLst = scope.selectedUserEmployeeRoles.map(function(role){
						return userRoles[role];
					})
					
					scope.normalUserEmployeeRoles = {
						name: "roleSelector",
						list: scope.userEmployeeRolesLst,
						selectable: false,
						toModel: function(i){
							return i.type;     
						},
						selectorName:function (s) {
							return s.i18n;
						},
						setDirty: function(){
							scope.userform.$setDirty();
						},
						inputPlaceHolder: $filter("translate")("AddRole"),
					};

					scope.normalUserRoles = {
						name: "roleSelector",
						list: scope.userRolesLst,
						selectable: false,
						toModel: function(i){
							return i.type;     
						},
						selectorName:function (s) {
							return s.i18n;
						},
						setDirty: function(){
							scope.userform.$setDirty();
						},
						inputPlaceHolder: $filter("translate")("AddRole"),
					};
					
					scope.crisisUserEmployeeRoles = {
						name: "crisisRoleSelector",
						list: scope.userEmployeeRolesLst,
						selectable: false,
						toModel: function(i){
							return i.type;
						},
						selectorName:function (s) {
							return s.i18n;
						},
						inputPlaceHolder: $filter("translate")("AddRole"),
					};

					scope.crisisUserRoles = {
						name: "crisisRoleSelector",
						list: scope.userRolesLst,
						selectable: false,
						toModel: function(i){
							return i.type;
						},
						selectorName:function (s) {
							return s.i18n;
						},
						inputPlaceHolder: $filter("translate")("AddRole"),
					};
				});

				function updateRoles(){
					$timeout(function(){
						if(scope.normalUserRoles && scope.normalUserRoles.update){
							scope.normalUserRoles.update()
						}
						if(scope.crisisUserRoles && scope.crisisUserRoles.update){
							scope.normalUserRoles.update()
						}
						if(scope.normalUserEmployeeRoles && scope.normalUserEmployeeRoles.update){
							scope.normalUserEmployeeRoles.update()
						}
						if(scope.crisisUserEmployeeRoles && scope.crisisUserEmployeeRoles.update){
							scope.normalUserEmployeeRoles.update()
						}
					},50)
				}
				var profClassNames = ["CProfessional",'CBaseProfessionnal']
				function update(){
					if(scope.base){
						scope.isProf = profClassNames.includes(scope.base.className);
						scope.isUserOwnData = model.user().profil.id==scope.base.id;
					}
				}
				scope.$watch(function(){
					return scope.base
				}, update)
			}
		};
	}]);
	
})();