(function(){
	var site = angular.module('site');
	
	/**
	 * @ngdoc directive
	 * @name patient.directive:employeeEdit
	 * @restrict E
	 * @scope
	 * @param {object} patient Pass the patient we want the edit form to open on
	 * @Description
	 * Directive opening the patient edit and creation form.
	 * @example
	 * <patient-edit patient="model.patient().currPatient"><patient-edit>
	 */
	site.directive('siteEdit',
						['$q', '$timeout', 'model','SiteAccessor','ModificationStatus', 'DashWebSocket',
						 '$filter','PatientFormService','QConfirm','QValidation','utils','UserAccessor','FlView',
					function($q, $timeout, model, SiteAccessor, ModificationStatus, DashWebSocket,
							 $filter, PatientFormService, QConfirm, QValidation, utils,UserAccessor,FlView){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/site/site_edit.html',
			scope: {
				site: "=",
				options: "=?",
				userSearchable: "=?",
				qv: "=?"
			},
			link: function(scope, element, attrs){
				scope.model = model;
				scope.uiready = false;// required for loading lists otherwise refresh bugs appear.
				scope.isReadOnly = !model.user().isAdmin;//!model.user().isUserAdmin; //USER_MANAGEMENT||INFODATA  // !model.roles().hasOneOfRoles(["USER_MANAGEMENT"]);
				scope.isDirty = false;
				scope.isAdmin = model.roles().hasOneOfRoles(['ADMIN']);
				scope.editSiteStatus = false;
				//init patient for when its a new patient
				var defaultSiteData = {
					modificationStatus: ModificationStatus.STATUS_NEUTRAL,
					color: [255, 255, 255],//backend savable
					colorStr: "",//Front-end use
					province: {},
					siteColor: function(c){//Color conversion function.
						if(arguments.length > 0 ){
							//c should have the format rgb(124,5,78)
							this.color = c.slice(c.indexOf("(")+1, c.indexOf(")")).split(",").map(i=>parseInt(i.trim()));
						}
						this.colorStr = "rgb("+this.color.join(", ")+")";
						return this.colorStr;
					},
					active: function(a){
						if(arguments.length > 0 ){
							this.isDeleted = !a;
						}
						return !this.isDeleted;
					}
				};
				var defaultOptions = {
					showExit: false
				};

				if(!scope.options){
					scope.options = {};
				}

				scope.options =  OfysUtils.extendIfNotDefined(scope.options, angular.copy(defaultOptions));

				scope.openUrl = function(v) {
					if(model.isWeb()){
						var win = window.open(v, '_blank');
						win.focus();
					}else{
						DashWebSocket.send({url: "/dashboard", data:{url:v}});
					}
				};

				scope.cpicker = {
					options : {
						format:"rgb",
						alpha: false,
						case: ['upper', 'lower']
					}
				}

				scope.viewModeClass = "read";
				
				scope.changeViewModeClass = function(){
					scope.viewModeClass = scope.viewModeClass === "read"?"edit":"read"; 
				};
				var localizedCityTypes = {
					City: "Ville",
					Town: "Ville",
					Village: "Village",
					Hamlet: "Hameau",
					Municipality: "Municipalité"
				};

				function transformCity(city){
					if (city.type === "Unincorporated area") {
						city.type =  "Zone non-incorporée";
					}else {
						city.type = localizedCityTypes[city.type];
					}
					city.name = city.name.toUpperCase();
					return city;
				}
				scope.focusable = {};
				var listItemTemplate =  '/dashboard/resources/ofys/pat/profil/city_search_data_item.html?v=bh';
				utils.getTemplate(listItemTemplate);
				scope.citySearchAssist = {
					assistId: 'autocomplete_city',
					dynaType: document.getElementsByTagName("BODY")[0],
					hasDetails: false,
					hasHeader: false,
					getAsyncData: function(query, assist){
						return UserAccessor.fillCompletionCity({q:query, limit: 15});
					},
					getKey: function(city) {
						if(utils.isTemplateLoaded(listItemTemplate)){
							var newScope = scope.$new();
							newScope.city = transformCity(city);
							var res =  utils.getTemplateAndCompileSync(newScope,listItemTemplate);
							$timeout(function(){
								if(!newScope.$$phase) {
									newScope.$digest();
								}
							}, 0);
							return res;
						}else{
							return city.name;
						}
					},
					selection: function(city, assistObject) {
						scope.editSite.province.name = city.province;
						scope.editSite.city.name = city.name;
						if(scope.focusable && scope.focusable.focusAdressPostalCode){
							scope.focusable.focusAdressPostalCode();
						}
						if(!scope.$$phase) {
							scope.$digest();
						}
						return city.name;
					}
				};
				
				function elemInEdit(){
					return (scope.formOptions.inEditMode !== undefined && scope.formOptions.inEditMode > 0);
				}
				function elemsValid(){
					var isValid = true;
					for( var i = 0; i < scope.formOptions.inEditMode; i++){
						if(!scope.formOptions.inEditItems[i].viewbag.okToClose()){
							isValid = false;
						}else{
							scope.formOptions.inEditItems[i].viewbag.save();
						}
					};
					return isValid;
				}

				scope.closeView = function(){
					// if(scope.formOptions.inEditMode > 0){
					// 	model.notice().fail($filter('translate')('PatientSaveEditModeForm' ));
					// 	return;
					// }
					//if(scope.createform.$dirty || scope.isDirty || elemInEdit()){
					if(scope.formDirty() || elemInEdit()){
						QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}, {windowClass:'top-modal'})
						.then(function(save){
							if(save){
								scope.saveSite().then(exit); //should change the dirty state to make sure that the second time closing goes through
							}else{
								exit();
							}
						});
					}else{
						exit();
					}
				};
				//expose the close function to allow parent to close the patient edit.
				scope.options.close = scope.closeView;
				
				function exit(res){
					if(scope.options.exit){
						scope.options.exit();
						unregisterDirty();
					}
				}

				scope.userSearchAssist = {
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					minChar: 0,
					trigger: 'focus',
					updateDataSourceWithValues: function(assistObject){
						if(scope.userSearchable){
							assistObject.setData(scope.userSearchable);
						}
					},
					getAsyncData: function(query, assist){
						return $q(function(resolve, reject) {
							resolve(searchUsers(query));
						});
					},
					getKey: function(recipient) {
						var newScope = scope.$new();
						newScope.item = recipient;
						var res =  utils.getTemplateAndCompileSync(newScope, '/dashboard/resources/ofys/user/user_dataItem.html?v=bh');
						$timeout(function(){
							if(!newScope.$$phase) {
								newScope.$digest();
							}
						},0);
						return res;
					},
					selection: function(usr, assistObject) {
						scope.editSite.b2bInformations.notifiedUserId = usr.userId;
						scope.editSite.b2bInformations.notifiedUser = usr.personName;
						scope.setFormStatus("dirty");
						return usr.personName;
					},
				}
				
				scope.viewSiteLogs = function(){
					if(scope.editSite.b2bLogs){
						openSiteB2BLogViewer();
					}else{
						SiteAccessor.findSiteB2bLogs(scope.editSite, function(logs){
							scope.editSite.b2bLogs = logs;
							openSiteB2BLogViewer();
						})
					}
				}

				function openSiteB2BLogViewer(){
					FlView.open({
							templateUrl: "/dashboard/resources/ofys/site/site_synch_logs.html?v=bh",
							logs: scope.editSite.b2bLogs,
						}, 
						{backdrop: 'static',windowClass: "faxmodal"}).then(function(logsdata){ 

					});
				}

				scope.removeSyncResponsibleUser = function(){
					delete scope.editSite.b2bInformations.notifiedUserId;
					scope.editSite.b2bInformations.notifiedUser = undefined;
					scope.setFormStatus("dirty");
				}

				function searchUsers(query){
					var res = $filter('filter')(scope.userSearchable, {personName:query});
					return res;
				}
				//checks patientviewmode and format preferences
				if(model.patientViewMode == 1){
					setTimeout(function(){
						scope.preferences.popover=true;
						scope.preferences.picture=false;
					},0);
					
				}
				
				//sets modificationStatus
				// scope.editSite.modificationStatus= ModificationStatus.STATUS_UPDATED; // pourquoi??? on ne veut pas sauver tout à chaque fois...
				//get needed information in model.user
				scope.sessionUser = model.user().sessionUser;
				scope.lstUsers = model.user().list;
//				.sort(function(o1,o2) {
//                	if (o1.personName && o2.personName) {
//                		return o1.personName.toUpperCase().localeCompare(o2.personName.toUpperCase());
//                	}
//                	return o1.str.localeCompare(o2.str);
//				});
				
				//sets form status to dirty or pristine
				scope.setFormStatus = function(status){
					scope.formStatus(status);
					scope.editSite.modificationStatus = ModificationStatus.STATUS_UPDATED;
				};
				
				scope.formStatus = function(status){
					scope.isDirty = scope.createform.$dirty;

					if(status === "dirty"){
						scope.isDirty = true;
					}
					else if(status === "pristine"){
						scope.isDirty = false;
					}
				};

				var isFormDirty = false;
				scope.formDirty = function(){
					var dirty = scope.isDirty || 
						(scope.createform && scope.createform.$dirty) || 
						scope.formOptions.childrenDirty();
					if(isFormDirty !== dirty){
						if(dirty){
							registerDirty();
						}else{
							unregisterDirty();
						}
					}
					isFormDirty = dirty;
					return isFormDirty;
				};
				scope.options.dirty = scope.formDirty;
				
				scope.formOptions = {
					setFormStatus: scope.formStatus,
					isReadOnly: scope.isReadOnly,
					inEditMode: 0, 
					children: [],
					childrenDirty: function(){
						for (var i = 0; i < this.children.length; i++) {
							if(this.children[i].isDirty()){
								return true;
							}
						}
						return false;
					}, 
					childrenOkToClose: function (){
						var isOk = true;
						for(var j = 0; j < scope.formOptions.children.length; j++){
							if(!scope.formOptions.children[j].okToClose()){
								isOk = false;
							}
						}
						return isOk;
					},
					resetChildren: function (){
						for(var j = 0; j < scope.formOptions.children.length; j++){
							scope.formOptions.children[j].reset();
						}
					}

				};
				
				function loadSite(site){
					if(scope.site || site){ //if existing patient
						site = site ? site : scope.site;
						//To make sure all defaults are always present 
						scope.editSite = $.extend(angular.copy(defaultSiteData),angular.copy(site));
						scope.editSite.siteColor();
						if(scope.editSite.viewbag) delete scope.editSite.viewbag;
						if(scope.editSite.modificationStatus == ModificationStatus.STATUS_NEW)angular.element("#loadSite").focus();
						if(scope.editSite.b2bInformations && scope.editSite.b2bInformations.notifiedUserId && scope.userSearchable && scope.userSearchable.length > 0){
							let usr = scope.userSearchable.find((usr) => usr.userId == scope.editSite.b2bInformations.notifiedUserId)
							if (usr) scope.editSite.b2bInformations.notifiedUser = usr.personName;
						}
						scope.uiready = true;
						setDirty(false);
					}
				}

				var watchcount = 0;
				scope.$watch(function (){
					if(scope.site && scope.editSite && scope.site.id !== scope.editSite.id){
						watchcount++
					}
					return watchcount;
				}, function(){
					loadSite()
				});


				function prepForSave(){
//					if(scope.createform.$dirty){
					if(scope.formDirty()){
						scope.editSite.modificationStatus = ModificationStatus.STATUS_UPDATED;
						scope.editSite.siteColor(scope.editSite.colorStr);
					}
				}
				var registeredDirtyId;

				function registerDirty(){
					registeredDirtyId = "site_"+scope.editSite.id;
					QValidation.registerDirty(registeredDirtyId, scope.saveSite, function(){
						return true;
					});
				}
				
				function unregisterDirty(){
					if(registeredDirtyId){
						QValidation.unregisterDirty(registeredDirtyId);
						registeredDirtyId = undefined;
					}
				}
				function saving(isSaving){
					if(isSaving){
						scope.saving = true;
					}else{
						$timeout(function(){
							scope.saving = false;
						}, 2000);
					}
				}
				scope.saveSiteAndClose= function(close){
					scope.saveSite().then(close);
				}
				scope.saving = false;

				function setDirty(isDirty){
					if(isDirty){
						scope.isDirty = isDirty;
					}else{
						scope.createform.$setPristine();

						if(scope.cpicker && scope.cpicker.api){
							//Fix for a bug that causes dirty state by the color picker even when setPristine is called.
							// hacky code to by pass the color picker`s internal checkDirty function found : https://github.com/ruhley/angular-color-picker/blob/master/dist/angularjs-color-picker.js#:~:text=key%3A%20%27-,checkDirty,-%27%2C
							delete scope.cpicker.api.getScope().AngularColorPickerController.initialNgModel;
						}
						scope.isDirty = false;
						scope.formOptions.resetChildren();
					}
				}

				/**
				 *@ngdoc method
				 *@name 
				 *@methodOf patient.directive
				 *@description
				 *This method saves the patient.
				 *It sends its current patient.
				 *On the callback,it updates the current patient informations,sets form to pristine and sends a notice.
				 */
				scope.saveSite= function(){
					scope.createformErrors = PatientFormService.getFormErrors(scope.createform,null);
					if(scope.createform.$valid){
						if(!scope.saving){
							if((elemInEdit() && !elemsValid()) || !scope.formOptions.childrenOkToClose()){
								return $q.reject($filter('translate')('EditValidationFailed'));
							}
							// return false;
							saving(true);
							prepForSave();
							saving();
							// console.log(scope.editSite);
							// return ;
							return SiteAccessor.save(scope.editSite, function(res){
								var savedElem = res[0];
								
								scope.createform.$setPristine();
								scope.isDirty = false;
								scope.formOptions.resetChildren();

								loadSite(savedElem);
								OfysUtils.update(scope.site, savedElem, ['viewbag']);
								model.notice().success($filter('translate')('SaveSuccess'));
								scope.formDirty()//Certain cases the dirty state is not remove. Must be called to reset.
								model.user().sites[savedElem.id] = savedElem;
								if(scope.options && scope.options.onSave){
									scope.options.onSave(savedElem);
								}
								model.searchSiteUpdated(true);

								//unlock saving function
								saving();
							}, function(res){
								//unlock saving function
								saving();
								model.notice().fail(res.status + ' : ' + $filter('translate')('SaveFailed'));
							});
						}
					}else{
						var msg = 'PatientSaveInvalidForm';

						model.notice().fail($filter('translate')(msg));
						return $q(function(resolve, reject) {
							reject($filter('translate')(msg));
						});
					}
				};


			}
		};
	}]);
	

    site.controller('SiteLogsController', ['$scope', 'model','$filter','$timeout','SiteAccessor',
	function($scope, model, $filter, $timeout, SiteAccessor){
		$scope.loadingLog = false;
		$scope.selectLog = OfysUtils.singleClick(function(log){
			if(log.data == undefined){
				$scope.loadingLog = true;
				SiteAccessor.readB2bSyncLog(log.id, function(logData){
					$scope.loadingLog = false;
					log.data = logData.data;
					$scope.selectedLog = log;
				},function(){
					$scope.loadingLog = false;
				})
			}else{
				$scope.selectedLog = log;
			}
		});

		$scope.downloadLog = function(){
			if($scope.selectedLog != null){
				// Create element with <a> tag
				const link = document.createElement("a");

				// Create a blog object with the file content which you want to add to the file
				const file = new Blob([$scope.selectedLog.data], { type: 'text/plain' });

				// Add file content in the object URL
				link.href = URL.createObjectURL(file);

				// Add file name
				link.download = "b2bsync_" + $filter("date")($scope.selectedLog.createDatetime, "yyyy-MM-dd") + "_" +$scope.selectedLog.id + "_log.txt";

				// Add click event to <a> tag to save file.
				link.click();
				URL.revokeObjectURL(link.href);
			}
		}
	}]);
})();