(function(){
	var ressource = angular.module("ressource", ['widgets', 'financialReport']);
	
	ressource.factory('RessourceAccessor', ['DashAPI','DashWebSocket','MessageLink', 'model', 
								function(DashAPI,DashWebSocket, MessageLink, model) {
		var accessor = {
			secteurList : function (callback, error){
				DashAPI.get("/dashboard/ress/ws/secteur/list?withDeleted=true", callback,error);
			},
			patientlist: function (data, callback, error) {
				DashAPI.get('/dashboard/ress/ws/list/bypat?id=' + data.id, callback, error);
			},
			billingDefDataIdPtsList : function (data, callback, error){
				DashAPI.get("/dashboard/ress/ws/billingDefDataIdPts/list?idPts=" + data.idPatientAnchors.join(','), callback,error);
			},
			billingDefDataList : function (data, callback, error){
				DashAPI.get("/dashboard/ress/ws/billingDefData/list?idSecteur=" + data.idSecteur, callback,error);
			},
			defDataList : function (data, callback, error){
				DashAPI.get("/dashboard/ress/ws/defData/list?idSecteur=" + data.idSecteur, callback,error);
			},
			taxDefList : function (callback, error){
				DashAPI.get("/dashboard/ress/ws/tax/list?withDeleted=true", callback, error);
			},
			taxDefSave : function (data, callback, error){
				return DashAPI.post("/dashboard/ress/ws/tax/save", data, callback, error);
			},
			getRessByCriteria : function (data, callback, error){
				return DashAPI.post("/dashboard/ress/ws/ress/getByCriteria", data, callback, error);
			},
			getRessDefDataByCriteria : function (data, callback, error){
				return DashAPI.post("/dashboard/ress/ws/ressDefData/getByCriteria", data, callback, error);
			},
			secteurSave : function (data, callback, error){
				return DashAPI.post("/dashboard/ress/ws/secteur/save", data, callback, error);
			},
			ressourceSave : function (data, callback, error){
				return DashAPI.post("/dashboard/ress/ws/ress/save", data, callback, error);
			},
			billedSave : function (data, callback, error){
				return DashAPI.post("/dashboard/ress/ws/billed/save", data, callback, error);
			},
			sendByEmail : function (data, callback, error){
				DashAPI.post("/dashboard/ress/ws/billed/sendByEmail", data, callback, error);
			},
			searchReport : function (data, callback, error){
				DashAPI.post("/dashboard/ress/ws/getFinancialReport", data, callback, error);
			},
			saveRessourceBilling : function (data, callback, error){
				var type = 'ca.infodata.ofys.ui.dashboard.models.CBillingRessource';
				data.idRessourceDefData = data.ressourceDefData.id;
				data.idPatientAnchor = data.patient.id;
				var savedData = _.omit(data, 'patient','ressourceDefData');
				var sObj = JSON.stringify(data);
				return DashAPI.post('/dashboard/ress/ws/ressourceBilling/post', accessor.toUidObj(sObj, type), callback, error,  'json');
			},
			getRessBilled : function (data, callback, error){
				if (data!==undefined) {	// situation : quand formulaire sans patient
					if(model.billed().listBilled && model.billed().listBilled[data.id]){
						callback(model.billed().listBilled[data.id]);
					}else{
						DashAPI.get("/dashboard/ress/ws/billedDefIdPat/list?id=" + data.id, function(resData){
							model.billed().listBilled[data.id] = resData.data;
							callback(model.billed().listBilled[data.id]);
						}, error);
					}					
				} 
			},
			toUidObj:function(obj, type){
				return {'o': obj, 'u': DashWebSocket.clientUid, 't' : type};
			},
			// end useful code
			openEdit: function (id, callback, error){
				var params = angular.isDefined(id)? ("?id="+ id):"";
				DashAPI.get("/dashboard/ress/ws/edit"+ params, callback,error);
			},
			setPatientStatus: function (data, callback, error){
				var params = "?billingResDataId="+ data.id + "&statusId=" + data.statusId;
				DashAPI.get("/dashboard/ress/ws/setPatientStatus"+ params, callback,error);
			}
		};
		return accessor;
	}]);
	
	ressource.controller('RessourceController',
		['$location','$scope','$state','model', '$log',
		'RessourceAccessor','PatientAccessor', 'Notification', 
		'$log', 'patientShowTitles','hotkeys','$timeout','$uibModal','QValidation','$filter','Rights',
		function($location,$scope, $state, model, $log, 
			RessourceAccessor, PatientAccessor, Notification, 
			$log, patientShowTitles, hotkeys, $timeout, $uibModal, QValidation, $filter, Rights){
		
		// not connected yet?
		if (!model.user().profil) return;
		
		model.activeController('ress');
		model.activeMenu('Secteur');

		$scope.model = model;
		
		$scope.focusable = {};
		
		$scope.focusable.onListReady = function(){
			$timeout(function(){
				// ???
				if(model.ressource().currList.currPatient && model.patient().currPatient.lstScroll){
					model.ressource().currList.lstScroll()
				}else{
					$scope.focusable.patientsListFocus();
				}
			}, 50);
		};

		$scope.filterLieu = function(a) {
			return !a.nameFr.startsWith('S-');
//			return !a.nameFr.endsWith(' MD');
		};
		$scope.filterService = function(a) {
			return a.nameFr.startsWith('S-');
//			return a.nameFr.endsWith(' MD');
		};
		
		
		//peut être vide si les options par defaut sont toute bonne
		//Voir le fichier DynaDate pour tous les options par défaut
		//$scope.appointmentDynaDateOptions = {acceptFutureDate: true};
		
		$scope.$on("$destroy", function handler() {
	        $log.log("RessourceController destroy");
	        // if (model.patient().currPatient.id) {
	        // 	model.patientsInQv(model.patient().currPatient.id, null);	        	
	        // }
	    });		

		$scope.popoverEdit = false;
		$scope.popoverEditMode = function(mode){
			$scope.popoverEdit = !$scope.popoverEdit;
		};
		$scope.editPatientPopoverOptions = {
			showExit: true,
			exit:function(){
				$timeout(function() {
					angular.element('#btn-edit-patient').triggerHandler('click');
					$scope.popoverEdit = false;
				});
			}
		};
		$scope.patientData = function(pts, useBR) {
			var title = "";
			var lf = useBR===true ? "<br/>" : "\n";
			var arr = []
			for(i = 0; i < pts.length; i++){
				var pt = pts[i];
				arr.push(pt.lastName + ", " + pt.firstName + "(" + pt.birthDate + "/" + pt.gender + ")");
			}
			title = arr.join(lf);
			return title;
		};
		$scope.setCurrentSect = function(r) {
			model.currentSect(r);
			$scope.updateRessources();
		};
		$scope.listSize = function() {
			return model.listRessSize();
		};
				
		$scope.pickDate = function(){
			var pic = $('#appointmentDateTime').data('DateTimePicker');
			pic.toggle();
		};
		
		// plus tard
		$scope.compassnav = function(direction){
			var d = moment(model.ressource().currDate, OfysUtils.DATEFORMAT);
			if(direction === 'N'){
				model.ressource().currDate = d.add(1, 'days').format(OfysUtils.DATEFORMAT);
			}else if(direction === 'C'){
				model.ressource().currDate = moment().format(OfysUtils.DATEFORMAT);
			}else if(direction === 'S'){
				model.ressource().currDate = d.subtract(1, 'days').format(OfysUtils.DATEFORMAT);
			}
			$scope.updateRessources();
		};
		
		$scope.updateRessources = function(){
			model.ressource().currList = model.ress().defData.filterFast(function(a){return a.idSecteur===model.currentSect().id;});
			model.ressource().currList.forEach(function(d) {
				if (d.patients) {
					d.patients.length = 0;
				} else {
					d.patients=[];
				}
		    });

			RessourceAccessor.billingDefDataList({idSecteur:model.currentSect().id},
					function success(r1) { 
				// ici il faut obtenir les patients utilisant ces ressources.
				var idPts = [];
				var patients = {};
				if (r1.data && r1.data.length>0) {
					r1.data.forEach(function(entry) {
						idPts.push(entry.patient.id);
					    var d = model.ressource().currList.filterFast(function(a){return entry.ressourceDefData.id===a.id});
					    d.forEach(function(dd) {
					    	dd.patients.push(entry.patient);
					    	entry.patient.activeRess = dd.nameFr;
					    	patients[entry.patient.id] = entry.patient;
					    });
					});					
				}
				if (idPts.length>0) {	// only for services ? && model.currentSect().nameFr.startsWith('S-')
					RessourceAccessor.billingDefDataIdPtsList({idPatientAnchors:idPts},
							function success(r2) { 
						// on a obtenu toutes les ressources utilisées par ces patients. 
						if (r2.data && r2.data.length>0) {
							r2.data.forEach(function(entry) {	// entry est un CBillingRessource
								var pt = patients[entry.idPatientAnchor];
								if (pt && pt.activeRess!=entry.ressourceDefData.nameFr) { // on devrait tjrs le trouver...
									if (pt.ressDefDatas===undefined) pt.ressDefDatas = [];
									pt.ressDefDatas.push(entry);
								}
							});
							for (var key in patients) {
								var v = patients[key];
								if (v.ressDefDatas===undefined) continue;
								v.ressDefDatas.sort(function (a, b) {return a.dateTimeStart-b.dateTimeStart});	// tri pour le plus ancien en premier
								v.ressDefDatas.forEach(function(ee) {
									var sectName = model.ress().secteurObj[ee.ressourceDefData.idSecteur].nameFr;
									if (!sectName.startsWith('S-') && v.ressName===undefined) {
										// Pas un service et aussi, on espère que le premier item sera celui le plus ancien (p.ex. la chambre)
										ee.secteurName = sectName;
										v.ressName = ee.secteurName.toLowerCase() + ee.ressourceDefData.nameFr.toLowerCase();
									}									
								});
							}
						}
						//console.log(model.ressource().currList);
						model.ressource().currList.forEach(function (a) {
							a.patients.sort(function(c, d) {
								if (c.ressName < d.ressName) return -1;
								if (c.ressName > d.ressName) return 1;
								return 0;
							});							
						});
						model.ressource().currList.sort(function(a, b) {
							if (a.sectName < b.sectName) return -1;
							if (a.sectName > b.sectName) return 1;
							return 0;						
						});
						//console.log("trié: ")
						//console.log(model.ressource().currList);
						model.ressource().loaded = true;
						model.ressLstUpdated(true);
					});
				} else {
					model.ressource().loaded = true;
					model.ressLstUpdated(true);					
				}
				
			});
		};
				
		$scope.selectRessource = function(res, pt){
			if (pt===undefined) {
				model.ressource().currRessource = res;
				model.patient().currPatient = {};
				return;
			}
			model.ressource().currRessource.currPatient = pt;
			QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
				if(successful){
					if($scope.popoverEdit){
						$scope.editPatientPopoverOptions.exit();
					}
					$scope.patientConsentBlock = pt===undefined ? false : !Rights.userHasRight(pt);
					
					function setRessource(){
						$scope.model.patientAllDataTabs().activeTab='PatientData';
						model.ressource().currRessource = res;
						model.ressource().currRessource.currPatient = pt;
						if (pt!==undefined) {
							PatientAccessor.setAsUsed(pt.id);							
						}
						$("#slide").prop('checked', false);
					}

					if($scope.patientConsentBlock){
						model.patient().currPatient = {};
						setRessource();
						return;
					}
					setRessource();
				}
			});		
		};
		
		if (!model.ressource().loaded) {
			$timeout($scope.updateRessources(),1000);
		}
		
		$scope.isActive = function(res, pt){
			return angular.isDefined(model.ressource().currRessource) && model.ressource().currRessource.id === res.id && model.patient().currPatient.id==pt.id;
		};
		
		$scope.updateModelPatient = function(patient){
			model.patient().currPatient = patient;
			model.ressource().currRessource.currPatient = pt;
			$location.path('/PatientsIndex');
		};
		$scope.showPatientHtml = function(pat) {
			return patientShowTitles.showPatientHtml(pat);
		};
		$scope.getCurrentDate = function(){
			var res = model.ressource().currDate;
			return res;
		};
		
	}]);
	
	ressource.directive('addResource', ['model', '$filter', 'RessourceAccessor',
		function(model, $filter, RessourceAccessor){
		return {
			restrict: 'A',
			scope: true,
			link: function(scope, element, attrs){

				scope.addNewRessources = function () {
					if(scope.ressourceSelectorOptions.selectedList.length > 0){
						for (var i = 0; i < scope.ressourceSelectorOptions.selectedList.length; i++) {
							addResources(scope.ressourceSelectorOptions.selectedList[i]);
						}
					}
					model.actUpdated(true);
					scope.$hide();
				}

				function addResources(res){
					res = _.omit(res, 'obj', 'name')
					if(scope.patient.viewbag.patData.ress.length > 0){
						scope.patient.viewbag.patData.ress.unshift(res);
					}else{
						scope.patient.viewbag.patData.ress.push(res);
					}
					res.nbOrdered = 1;
//					console.log("res.ressourceDefData.unit=" + res.ressourceDefData.unit);
					// bogue qq part - toujours ITEM alors que devrait être HEURE
//					if (res.ressourceDefData.unit!='ITEM') {
						res.autoRepeat = true;
//					} else {
//						res.autoRepeat = false;	
//					}
					RessourceAccessor.saveRessourceBilling(res, function(reponse) {
						delete reponse.uid;
						$.extend(res, reponse);
					});
				};

				function getDefault(defData) {
					var mmnt = moment().valueOf()
					return {
						"className": "CBillingRessource",
						"dateTimeStart": mmnt,
						"createdDatetime": mmnt,
						'idPatientAnchor': scope.patient.id,
						ressourceDefData: defData,
						"patient": _.omit(scope.patient, 'viewbag'),
						editMode: true,
						uid: UUID.atomic(),
						viewbag: {}
					};
				}

				scope.ressourceSelectorOptions = {
					list:model.ress().defData,
					inputPlaceHolder: 'Rechercher une ressource',
					selectorName:function (item) {
						return item.nameFr;
					},
					onSelect: function(elem){
						elem = $.extend(elem, getDefault(elem.obj))
					}
				}
				
			}
		}
	}]);

	ressource.directive('sectView', ['model', '$filter', 'RessourceAccessor',
	                               function(model, $filter, RessourceAccessor){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/ressource_view.html?v=bh',
			scope: true,
			link: function(scope, element, attrs){
				scope.serv = {};
				
				scope.formatDate = function(reqDate, dateFormat){
					moment.locale(model.prefSettings('language'));
					return moment(reqDate).format(dateFormat);
				}
				
				function update(){
					scope.apps = scope.$eval(attrs.apps);
					if(Array.isArray(scope.apps) ){
						if(scope.appointments.length > 0)scope.app = scope.apps[0];
					}else{
						scope.app = scope.apps;
					}
					scope.app.viewbag = {};
					// var allTypes = model.clientPreferences().appointmentTypes;
					// if(scope.app.typeAppointment){
					// 	scope.app.viewbag.typeAppointment = allTypes.find(function(prof){
					// 		return prof.id === scope.app.typeAppointment;
					// 	});
					// }
					// AppointmentAccessor.updateMessageLink(scope.quickViewData.pat, scope);
					scope.linkManager = MessageLink.linkManager(RessourceAccessor, scope.quickViewData.pat, scope.ress.uid, scope)
					scope.viewOptions = scope.$eval(attrs.options);
				};
				
                if(scope.qv){
					scope.qv.isDirty = function(){
						return false;//does not support modifications yet
					};
				}
				scope.$watch(attrs.apps, update);
			}
		}
	}]);
	
	ressource.directive('tabRessEdit', ['model', 'ModificationStatus',
	                               function(model, ModificationStatus){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/tab_res_edit.html?v=ay',
			controller: 'ResEditController',
//			link: function(scope){
//			}
		}
	}]);
	
	ressource.directive('tabRessOther', ['model', 'ModificationStatus',
	                               function(model, ModificationStatus){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/tab_ress_other.html?v=ay',
			controller: 'ResEditController',
//			link: function(scope){
//			}
		}
	}]);
	
	ressource.controller('ResEditController',
		['$scope', 'model', 'RessourceAccessor', '$filter', '$translate', 'ModificationStatus', 'QValidation',
		function($scope, model, ressourceAccessor, $filter, $translate, ModificationStatus, QValidation){
			
			model.activeController('ress');
			model.activeMenu('ress');
			function init(){
				if(model.enums().ressServiceType){
					$scope.serviceTypeSearchList = angular.copy(Object.values(model.enums().ressServiceType));
//					$scope.selectedRess = angular.copy(model.ressource().edit.selectedRess);
//					if(model.ressource().edit.selectedRess){
//						$scope.selectedRessDefEdit = model.ressource().edit.selectedRess.lstRessourceDef.find(e => e.isDeleted == 0 && e.tarifFin >= moment().format('YYYYMMDD'));
//						for(let i=0; i < $scope.selectedRessDefEdit.serviceType.length; i++){
//							index = $scope.serviceTypeList.findIndex(x => x.type == $scope.selectedRessDefEdit.serviceType[i])
//							$scope.serviceTypeList[index].selected = true;
//						}
//					}
					$scope.lstProf = $filter('orderBy')(model.store.profs.filter.treating.list(), ['lastName', 'firstName']);
					$scope.responsablePmtList = angular.copy(Object.values(model.enums().responsablePmt));
					if(ressListWatcher)ressListWatcher();
				}
			}
			
			$scope.activeState = [
				{val:true,name:'profActives'},
				{val:false,name:'profInactives'}
			]
			
			$scope.dynaDateOption = {
				format: 'YYYY-MM-DD',
				acceptFutureDate: false,
				onDateSelected: function (mDate, dAssist) {
					if(!mDate){
						mDate = moment();
					}
					model.ressource().edit.search.date = mDate.valueOf();
					var m = mDate.format(dAssist.format);
					model.ressource().edit.search.dateS = m;
				}
			}
			
			$scope.getCurrTabName = function(){
				if(model.ressource().edit.currTab === 1){
					return 'Taxes'
				}else if(model.ressource().edit.currTab === 2){
					return 'Sectors'
				}
			}
			
			$scope.isSearching = false;
			$scope.getTaxes = function(){
				
				$scope.isSearching = true;
				QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
					if(successful){
						ressourceAccessor.taxDefList(function(res){
							$scope.isSearching = false;
							if(res.data.success===false){
								model.notice().warn(res.data.ms);
							}else{
								model.ressource().edit.taxDefList = res.data;
								model.billed().chosenTab = 3;
								model.ressource().edit.currTab = 1;
							}
						})
					}
				});
			}
			$scope.getSecteur = function(){
				QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
					if(successful){
						$scope.isSearching = true;
						ressourceAccessor.secteurList(function(res){
							$scope.isSearching = false;
							if(res.data.success===false){
								model.notice().warn(res.data.ms);
							}else{
								model.ressource().edit.secteurList = res.data;
								model.billed().chosenTab = 3;
								model.ressource().edit.currTab = 2;
							}
						})
					}
				});
			}
			$scope.openTab = function(tab){
				QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
					if(successful){
						model.billed().chosenTab = tab;
					}
				});
			}
			$scope.getResourceByCriteria = function(){
				QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
					$scope.isSearching = true;
					ressourceAccessor.getRessByCriteria(model.ressource().edit.search, function(res){
						$scope.isSearching = false;
						if(res.data.success===false){
							model.notice().warn(res.data.ms);
						}else{
							model.ressource().edit.resourceList = res.data;
						}
						model.actUpdated(true);
					})	
				});
			}
			
			$scope.selectResource = function(ress){
				QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
					if(successful){
//						model.ressource().edit.selectedRessDef = undefined;
						model.ressource().edit.selectedRess = ress;
//						$scope.selectedRess = angular.copy(model.ressource().edit.selectedRess);
//						$scope.selectedRessDefEdit = model.ressource().edit.selectedRess.lstRessourceDef.find(e => e.isDeleted == 0 && e.tarifFin >= moment().format('YYYYMMDD'));
//						$scope.serviceTypeList = angular.copy(Object.values(model.enums().ressServiceType));
//						for(let i=0; i < $scope.selectedRessDefEdit.serviceType.length; i++){
//							index = $scope.serviceTypeList.findIndex(x => x.type == $scope.selectedRessDefEdit.serviceType[i])
//							$scope.serviceTypeList[index].selected = true;
//						}
						initResponsablePmtList()
						model.ressource().edit.currTab = 3;
						model.actUpdated(true);
					}
				});
			}
			
			$scope.getResList = function(){
				return model.ressource().edit.resourceList;
			}
			
			$scope.isActive = function(ress){
				return model.ressource().edit.selectedRess == ress
			}
			
			function initResponsablePmtList(){
				for(let i=0; i < model.ressource().edit.selectedRess.responsablePmt.length; i++){
					index = $scope.responsablePmtList.findIndex(x => x.type == model.ressource().edit.selectedRess.responsablePmt[i])
					$scope.responsablePmtList[index].selected = true;
				}
			}
			$scope.newResource = function(){
				var ress = {
					code: "",
					isDeleted: false,
					lstRessourceDef: [
						{
							isDeleted: false,
							lstRessourceDefData: [],
							createdDatetime: Date.now(),
							modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
							nameFr: moment().format('YYYYMMDD'),
							nameEn: moment().format('YYYYMMDD'),
							serviceType : ["DISPENSATEUR"],
							tarifDebut: moment().format('YYYYMMDD'),
							tarifFin: 99999999,
						}
					],
					createdDatetime: Date.now(),
					modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
					nameFr: "",
					namen: "",
					responsablePmt : ["PATIENT"]
				}
				$scope.selectResource(ress)
			}
			
			$scope.getRessName = function(ress){
                if ($translate.use()=='en') {
                    return ress.nameEn;
                }
                return ress.nameFr;
			}
			$scope.getRespPmt = function(ress){
				let respPmt = "";
				for(let i = 0; i < ress.responsablePmt.length; i++){
					if(i !== 0){
						respPmt += ", "
					}
					respPmt += $filter('translate')(ress.responsablePmt[i])
				}
				return respPmt;
			}
			
			model.callDashBoardCount();
			var ressListWatcher = $scope.$watch('model.enums().ressServiceType', init);
	}]);
	
	ressource.directive('taxList', ['model', 'RessourceAccessor', 'ModificationStatus', 'QValidation', '$translate','$filter',
	                               function(model, RessourceAccessor, ModificationStatus, QValidation, $translate, $filter){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/tax_list.html?v=ay',
			scope: true,
			link: function(scope, element, attrs){
				scope.taxDefEditList = angular.copy(model.ressource().edit.taxDefList);
				scope.inactiveFilter = {
					taxDef:{
						actif: {val:true, name:'profActives', code: "actif"}
					},
					taxDefData:{
						actif: {val:true, name:'profActives', code: "actif"},
					}
				}
				scope.inactiveFilterTaxDefValue = scope.inactiveFilter.taxDef["actif"];
				scope.inactiveFilterTaxDefDataValue = scope.inactiveFilter.taxDefData["actif"];
				/**
				 * COMMENT: RESSEDIT EDITEMPLATE @function
				 *
				 * Façon simple de setup les QValidation, sert à vérifier si la form est "dirty" 
				 * À implémenter sur tout ce qui est édition
				 * 
				 */
				var registeredDirtyId;
				function registerDirty(){
					registeredDirtyId = "ressedit_tax";
					QValidation.registerDirty(registeredDirtyId, scope.saveTaxes, function(){
						return true;
					});
				}
				function unregisterDirty(){
					if(registeredDirtyId){
						QValidation.unregisterDirty(registeredDirtyId);
						registeredDirtyId = undefined;
					}
				}
				scope.isDirty = false;
				var isFormDirty = false;
				scope.formDirty = function(){
					var dirty = scope.isDirty
					if(isFormDirty !== dirty){
						if(dirty){
							registerDirty();
						}else{
							unregisterDirty();
						}
					}
					isFormDirty = dirty;
					return isFormDirty;
				};
				//fin du setup de la QValidation
				
				scope.updateList = function(){
					model.actUpdated(true);
				}
				
				scope.getLstTaxDef = function(){
					if(scope.taxDefEditList && scope.taxDefEditList.length > 0){
						if(scope.inactiveFilterTaxDefValue && scope.inactiveFilterTaxDefValue.code == "actif"){
							return scope.taxDefEditList.filter(e => !e.isDeleted)
						}else{
							return scope.taxDefEditList;
						}
					}
				}
				
				scope.getLstTaxDefData = function(lstTaxeDefDate){
					if(lstTaxeDefDate && lstTaxeDefDate.length > 0){
						if(scope.inactiveFilterTaxDefDataValue && scope.inactiveFilterTaxDefDataValue.code == "actif"){
							return lstTaxeDefDate.filter(e => !e.isDeleted)
						}else{
							return lstTaxeDefDate;
						}
					}
				}
				
				function getNameFr(taxDef){
					var nameFr = ""
					for(const taxDefData of taxDef.lstTaxeDefData){
						if(!taxDefData.isDeleted){
							if(nameFr!== ""){
								nameFr += ", "
							}
							nameFr += taxDefData.nameFr;
						}
					}
					return nameFr;
				}
				function getNameEn(taxDef){
					var nameEn = ""
					for(const taxDefData of taxDef.lstTaxeDefData){
						if(!taxDefData.isDeleted){
							if(nameEn!== ""){
								nameEn += ", "
							}
							nameEn += taxDefData.nameEn;
						}
					}
					return nameEn;
				}
				scope.getDescription = function(def, list){
					var name = "";
					if ($translate.use()=='en') {
	                    name = (list ? getNameEn(def) : def.nameEn);
	                    if(!name || name.length == 0){
							name = (list ? getNameFr(def) : def.nameFr);
						}
	                }else{
						name = (list ? getNameFr(def) : def.nameFr);
						if(!name || name.length == 0){
							 name = (list ? getNameEn(def) : def.nameEn);
						}
					}
	                return name;
				}
				
				scope.getRate = function(taxDef){
					var rate = 0;
					for(const taxDefData of taxDef.lstTaxeDefData){
						if(!taxDefData.isDeleted){
							rate += taxDefData.taux;
						}
					}
					return rate.toFixed(2);
				}
				
				scope.isActive = function(taxDef){
					return taxDef == model.ressource().edit.selectedTaxDef;
				}
				
				scope.selectTaxDef = function(taxDef){
					if(checkTaxesDefDataInEditMode()){
						if(taxDef == model.ressource().edit.selectedTaxDef){
							model.ressource().edit.selectedTaxDef = undefined;
						}else{
							model.ressource().edit.selectedTaxDef = taxDef;
						}
					}
					model.actUpdated(true);
				}
				
				scope.editTaxDef = function(taxDef){
					scope.isDirty = true;
					taxDef.editMode = true;
					model.actUpdated(true);
				}
				
				scope.copyTaxDef = function(taxDef){
					scope.isDirty = true;
					newSecteur = angular.copy(taxDef);
					delete newSecteur.id;
					newSecteur.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
					newSecteur.createdDatetime = Date.now();
					scope.taxDefEditList.push(newSecteur);
					model.actUpdated(true);
				}
				
				scope.newTaxDef = function(){
					taxDef = {
						isNew: true,
						code: "",
						debut: moment().format('YYYYMMDD'),
						fin: 99999999,
						isDeleted: false,
						lstTaxeDefData: [],
						createdDatetime: Date.now(),
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED
					}
					scope.taxDefEditList.push(taxDef);
					scope.editTaxDef(taxDef);
				}
				
				scope.deleteOrRecoverTaxDef = function(taxDef){
					scope.isDirty = true;
					taxDef.isDeleted = !taxDef.isDeleted;
					if(taxDef.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
						taxDef.modificationStatus = ModificationStatus.STATUS_UPDATED
					}
					if(taxDef == model.ressource().edit.selectedTaxDef){
						model.ressource().edit.selectedTaxDef = undefined;
					}
					model.actUpdated(true);
				}
				
				scope.editTaxDefData = function(taxDefData){
					scope.isDirty = true;
					taxDefData.editMode = true;
					model.actUpdated(true);
				}
				
				scope.copyTaxDefData = function(taxDefData){
					scope.isDirty = true;
					newSecteur = angular.copy(taxDefData);
					delete newSecteur.id;
					newSecteur.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
					newSecteur.createdDatetime = Date.now();
					model.ressource().edit.selectedTaxDef.lstTaxeDefData.push(newSecteur);
					model.actUpdated(true);
				}
				
				scope.newTaxDefData = function(){
					taxDefData = {
						isDeleted: false,
						isNew: true,
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
						createdDatetime: Date.now(),
						nameEn: "",
						nameEn: "",
						taux: 0,
					}
					model.ressource().edit.selectedTaxDef.lstTaxeDefData.push(taxDefData);
					scope.editTaxDefData(taxDefData);
				}
				
				scope.deleteOrRecoverTaxDefData = function(taxDefData){
					scope.isDirty = true;
					taxDefData.isDeleted = !taxDefData.isDeleted;
					if(taxDefData.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
						taxDefData.modificationStatus = ModificationStatus.STATUS_UPDATED
					}
					model.actUpdated(true);
				}
				
				scope.cancelTax = function(){
					QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
						if(successful){
							delete model.ressource().edit.taxDefList;
							model.ressource().edit.selectedTaxDef = undefined;
							model.ressource().edit.currTab = undefined;
							delete scope.taxDefEditList;
							scope.isDirty = false;
//							scope.ressEditFrm.$dirty = false;
//							scope.ressEditFrm.$setPristine();
							model.actUpdated(true);
						}
					});
				}
				
				scope.saveTaxes = function(){
					if(checkTaxesEditMode() && !checkCodeForDuplicate()){
						RessourceAccessor.taxDefSave(scope.taxDefEditList, function(res){
							if(!res.data){
								model.ressource().edit.taxDefList = res
								scope.taxDefEditList = angular.copy(model.ressource().edit.taxDefList)
								if(model.ressource().edit.selectedTaxDef && !model.ressource().edit.selectedTaxDef.id){
									model.ressource().edit.selectedTaxDef = scope.taxDefEditList.find((e)=> e.code == model.ressource().edit.selectedTaxDef.code)
								}
								model.notice().success($filter('translate')('SaveSuccess'));
								scope.isDirty = false;
								model.actUpdated(true);
							}else{
								model.notice().fail($filter('translate')(res.data.ms));
							}
						})
					}else if(!scope.taxDefInEditMode || !scope.taxDefDataInEditMode){
						model.notice().fail($filter('translate')("errorTaxCannotBeSaved"));
					}else{
						model.notice().fail($filter('translate')("errorDuplicateCodeTax"));
					}
					model.actUpdated(true);	
				}
				
				scope.taxDefInEditMode = true;
				scope.taxDefDataInEditMode = true;
				function checkTaxesEditMode(){
					scope.taxDefInEditMode = true;
					scope.taxDefDataInEditMode = true;
					for(let i = 0; i < scope.taxDefEditList.length; i++){
						if(scope.taxDefEditList[i].editMode){
							scope.taxDefInEditMode = scope.taxDefEditList[i].ok()
						}
					}
					return checkTaxesDefDataInEditMode();
				}
				function checkTaxesDefDataInEditMode(){
					if(model.ressource().edit.selectedTaxDef && model.ressource().edit.selectedTaxDef.lstTaxeDefData){
						for(let i = 0; i < model.ressource().edit.selectedTaxDef.lstTaxeDefData.length; i++){
							if(model.ressource().edit.selectedTaxDef.lstTaxeDefData[i].editMode){
								scope.taxDefDataInEditMode = model.ressource().edit.selectedTaxDef.lstTaxeDefData[i].ok();
							}
						}
					}
					return scope.taxDefDataInEditMode && scope.taxDefInEditMode;
				}
				
				function checkCodeForDuplicate(){
					let seen = new Set();
					var hasDuplicate = scope.taxDefEditList.some(function(taxes){
						return seen.size === seen.add(taxes.code).size;
					})
					return hasDuplicate;
				}
				
			}
		}
	}]);
	
	ressource.directive('taxDefEdit', ['model', 'ModificationStatus', '$timeout',
	                               function(model, ModificationStatus, $timeout){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/taxdef_edit.html?v=ay',
			scope:{
                def: '=',
                list: '='
            },
			link: function(scope, element, attrs){
				scope.taxDefEdit = angular.copy(scope.def);
				
				function focusOnOpen(){
					$timeout(function(){
						if(scope.focus){
							scope.focus();
						}
					},400);
				};
				
				scope.ok = function(){
					if(scope.taxDefFrm.$valid){
						scope.def.code = scope.taxDefEdit.code;
						scope.def.debut = scope.taxDefEdit.debut;
						scope.def.fin = scope.taxDefEdit.fin;
						scope.def.editMode = false;
						if(scope.def.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
							scope.def.modificationStatus = ModificationStatus.STATUS_UPDATED;
						}
						scope.def.isNew = false;
						delete scope.def.ok;
						delete scope.def.no;
						model.ressource().edit.selectedTaxDef = scope.def;
						model.actUpdated(true);
						return true;
					}else{
						return false;
					}
				}
				scope.def.ok = scope.ok;
				
				scope.no = function(){
					scope.def.editMode = false;
					if(scope.def.modificationStatus == ModificationStatus.STATUS_NEW_UPDATED && scope.def.isNew){
						const i = scope.list.findIndex(e => e == scope.def);
						if(i>-1){
							scope.list.splice(i,1);
						}
					}
					delete scope.def.ok;
					delete scope.def.no;
					model.actUpdated(true);
				}
				scope.def.no = scope.no;
				focusOnOpen();
			}
		}
	}]);
	
	ressource.directive('taxDefDataEdit', ['model', 'ModificationStatus', '$timeout',
	                               function(model, ModificationStatus, $timeout){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/taxdefdata_edit.html?v=ay',
			scope:{
                data: '=',
            },
			link: function(scope, element, attrs){
				scope.taxDefDataEdit = angular.copy(scope.data);
				scope.rateTooHigh = false;
				
				function focusOnOpen(){
					$timeout(function(){
						if(scope.focus){
							scope.focus();
						}
					},400);
				};
				
				scope.ok = function(){
					if(scope.taxDefFrm.$valid){
						if(scope.taxDefDataEdit.taux < 100){
							scope.rateTooHigh = false;
							scope.data.nameFr = scope.taxDefDataEdit.nameFr;
							scope.data.nameEn = scope.taxDefDataEdit.nameEn;
							if(scope.taxDefDataEdit.taux > 1){
								scope.taxDefDataEdit.taux = scope.taxDefDataEdit.taux/100;
							}
							scope.data.taux = scope.taxDefDataEdit.taux;
							scope.data.editMode = false;
							if(scope.data.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
								scope.data.modificationStatus = ModificationStatus.STATUS_UPDATED;
							}
							scope.data.isNew = false;
							delete scope.data.ok;
							delete scope.data.no;
							model.actUpdated(true);
							return true;
						}else{
							scope.rateTooHigh = true
							model.actUpdated(true);
							return false;
						}
					}
				}
				scope.data.ok = scope.ok;
				
				scope.no = function(){
					scope.data.editMode = false;
					if(scope.data.modificationStatus == ModificationStatus.STATUS_NEW_UPDATED && scope.data.isNew){
						const i = model.ressource().edit.selectedTaxDef.lstTaxeDefData.findIndex(e => e == scope.data);
						if(i>-1){
							model.ressource().edit.selectedTaxDef.lstTaxeDefData.splice(i,1);
						}
					}
					delete scope.data.ok;
					delete scope.data.no;
					model.actUpdated(true);
				}
				scope.data.no = scope.no;
				
				focusOnOpen();
			}
		}
	}]);
	
	ressource.directive('secteurList', ['model', 'ModificationStatus', 'QValidation', 'RessourceAccessor',
	                               function(model, ModificationStatus, QValidation, RessourceAccessor){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/secteur_list.html?v=ay',
			scope: true,
			link: function(scope, element, attrs){
				scope.secteurEditList = angular.copy(model.ressource().edit.secteurList);
				scope.inactiveFilter = {
					actif: {val:true, name:'profActives', code: "actif"},
				};
				scope.inactiveFilterValue = scope.inactiveFilter["actif"];
				
				/**
				 * COMMENT: RESSEDIT EDITEMPLATE @function
				 *
				 * Façon simple de setup les QValidation, sert à vérifier si la form est "dirty" 
				 * À implémenter sur tout ce qui est édition
				 * 
				 */
				var registeredDirtyId;
				function registerDirty(){
					registeredDirtyId = "ressedit_secteur";
					QValidation.registerDirty(registeredDirtyId, scope.saveSecteurs, function(){
						return true;
					});
				}
				function unregisterDirty(){
					if(registeredDirtyId){
						QValidation.unregisterDirty(registeredDirtyId);
						registeredDirtyId = undefined;
					}
				}
				scope.isDirty = false;
				var isFormDirty = false;
				scope.formDirty = function(){
					var dirty = scope.isDirty
					if(isFormDirty !== dirty){
						if(dirty){
							registerDirty();
						}else{
							unregisterDirty();
						}
					}
					isFormDirty = dirty;
					return isFormDirty;
				};
				//fin du setup de la QValidation
				
				scope.updateList = function(){
					model.actUpdated(true);
				}
				
				scope.getLstSecteur = function(){
					if(scope.secteurEditList){
						if(scope.inactiveFilterValue && scope.inactiveFilterValue.code == "actif"){
							return scope.secteurEditList.filter(e => !e.isDeleted)
						}else{
							return scope.secteurEditList;
						}
					}
				}
				
				scope.editSecteur = function(secteur){
					scope.isDirty = true;
					secteur.editMode = true;
					model.actUpdated(true);
				}
				
				scope.copySecteur = function(secteur){
					scope.isDirty = true;
					newSecteur = angular.copy(secteur);
					delete newSecteur.id;
					newSecteur.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
					scope.secteurEditList.push(newSecteur);
					model.actUpdated(true);
				}
				
				scope.deleteOrRecoverSecteur = function(secteur){
					scope.isDirty = true;
					secteur.isDeleted = !secteur.isDeleted;
					if(secteur.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
						secteur.modificationStatus = ModificationStatus.STATUS_UPDATED
					}
					model.actUpdated(true);
				}
				
				scope.newSecteur = function(){
					secteur = {
						nameFr: "",
						nameEn: "",
						note: "",
						isDeleted: false,
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED
					}
					scope.secteurEditList.push(secteur);
					scope.editSecteur(secteur);
				}
				
				scope.saveSecteurs = function(){
					if(checkSecteurEditMode()){
						RessourceAccessor.secteurSave(scope.secteurEditList, function(res){
							model.ressource().edit.secteurList = res
							scope.secteurEditList = angular.copy(model.ressource().edit.secteurList)
							scope.isDirty = false;
							model.actUpdated(true);
						})
					}
					model.actUpdated(true);	
				}
				
				scope.secteurInEditMode = false;
				function checkSecteurEditMode(){
					scope.secteurInEditMode = false;
					for(let i = 0; i < scope.secteurEditList.length; i++){
						if(scope.secteurEditList[i].editMode){
							scope.secteurInEditMode = true;
							return false;
						}
					}
					return true;
				}
				
			}
		}
	}]);
	
	ressource.directive('secteurEdit', ['model', 'ModificationStatus',
	                               function(model, ModificationStatus){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/secteur_edit.html?v=ay',
			scope:{
                def: '=',
                list: '=',
            },
			link: function(scope, element, attrs){
				scope.secteurEdit = angular.copy(scope.def);
				
				scope.ok = function(){
					scope.def.nameFr = scope.secteurEdit.nameFr;
					scope.def.nameEn = scope.secteurEdit.nameEn;
					scope.def.note = scope.secteurEdit.note;
					scope.def.editMode = false;
					if(scope.def.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
						scope.def.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					model.actUpdated(true);
				}
				
				scope.no = function(){
					scope.def.editMode = false;
					if(scope.def.modificationStatus == ModificationStatus.STATUS_NEW_UPDATED){
						const i = scope.list.findIndex(e => e == scope.def);
						if(i>-1){
							scope.list.splice(i,1);
						}
					}
					model.actUpdated(true);
				}
			}
		}
	}]);
	
	ressource.directive('ressEdit', ['model', 'ModificationStatus', '$filter', '$translate', 'QValidation', 'PatientFormService', 'FlView',
										'RessourceAccessor', 'QConfirm', '$timeout', '$q',
	                               function(model, ModificationStatus, $filter, $translate, QValidation, PatientFormService, FlView,
	                               			RessourceAccessor, QConfirm, $timeout, $q){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/ress_edit.html?v=ay',
			scope: true,
			link: function(scope, element, attrs){
				scope.lstProf = model.store.profs.filter.treating.list();
				scope.ressStatus = Object.values(model.enums().ressStatus);
				scope.ressUnit = Object.values(model.enums().ressUnit);
				scope.taxes = angular.copy(model.ress().taxes);
				scope.serviceTypeList = angular.copy(Object.values(model.enums().ressServiceType));
				scope.inactiveFilter = {
					actif: {val:true, name:'profActives', code: "actif"},
//					none: {val:true,name:'', code: "none"},
				};
				scope.inactiveFilterValue = scope.inactiveFilter["actif"];
				
				function loadRess(ress){
					scope.selectedRessEdit = angular.copy(model.ressource().edit.selectedRess);
					scope.selectedRessDefEdit = scope.selectedRessEdit.lstRessourceDef ? scope.selectedRessEdit.lstRessourceDef.find(e => e.isDeleted == 0 && e.tarifFin >= moment().format('YYYYMMDD')) : undefined;
					if(!scope.selectedRessDefEdit){
						scope.selectedRessEdit.lstRessourceDef = [
							{
								isDeleted: false,
								lstRessourceDefData: [],
								createdDatetime: Date.now(),
								modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
								nameFr: moment().format('YYYYMMDD'),
								nameEn: moment().format('YYYYMMDD'),
								serviceType : ["DISPENSATEUR"],
								tarifDebut: moment().format('YYYYMMDD'),
								tarifFin: 99999999,
							}
						]
						scope.selectedRessDefEdit = scope.selectedRessEdit.lstRessourceDef[0];
					}else if(scope.selectedRessDefEdit.lstRessourceDefData && scope.selectedRessDefEdit.lstRessourceDefData.length > 0){
						scope.selectedRessDefEdit.lstRessourceDefData.sort(function(a,b){
							var nameA = "";
							var nameB = "";
							if ($translate.use()=='en') {
			                    nameA = a.nameEn;
			                    if(!nameA || nameA.length == 0){
									nameA = a.nameFr;
								}
								nameB = b.nameEn;
								if(!nameB || nameB.length == 0){
									nameB = b.nameFr;
								}
			                }else{
								nameA = a.nameFr;
								if(!nameA || nameA.length == 0){
									 nameA = a.nameEn;
								}
								nameB = b.nameFr;
								if(!nameB || nameB.length == 0){
									 nameB = b.nameEn;
								}
							}
			                return nameA.localeCompare(nameB);
						})
					}
					scope.serviceTypeList = angular.copy(Object.values(model.enums().ressServiceType));
					if(scope.selectedRessDefEdit && scope.selectedRessDefEdit.serviceType){
						for(let i=0; i < scope.selectedRessDefEdit.serviceType.length; i++){
							index = scope.serviceTypeList.findIndex(x => x.type == scope.selectedRessDefEdit.serviceType[i])
							scope.serviceTypeList[index].selected = true;
						}
					}
					focusOnOpen();
					
				}
				
				function focusOnOpen(){
					$timeout(function(){
						if(scope.focus){
							scope.focus();
						}
					},400);
				};
				
				scope.$watch('model.ressource().edit.selectedRess', loadRess);
				
				/**
				 * COMMENT: RESSEDIT EDITEMPLATE @function
				 *
				 * Façon simple de setup les QValidation, sert à vérifier si la form est "dirty" 
				 * À implémenter sur tout ce qui est édition
				 * 
				 */
				var registeredDirtyId;
				function registerDirty(){
					registeredDirtyId = "ressedit_ress";
					QValidation.registerDirty(registeredDirtyId, scope.saveRess, function(){
						return true;
					});
				}
				function unregisterDirty(){
					if(registeredDirtyId){
						QValidation.unregisterDirty(registeredDirtyId);
						registeredDirtyId = undefined;
					}
				}
				scope.isDirty = false;
				var isFormDirty = false;
				scope.formDirty = function(){
					var dirty = scope.isDirty|| 
						(scope.ressEditFrm && scope.ressEditFrm.$dirty)
					if(isFormDirty !== dirty){
						if(dirty){
							registerDirty();
						}else{
							unregisterDirty();
						}
					}
					isFormDirty = dirty;
					return isFormDirty;
				};
				//fin du setup de la QValidation
				
				scope.updateList = function(){
					model.actUpdated(true);
				}
				
				scope.getLstRessDefData = function(){
					if(scope.selectedRessDefEdit && scope.selectedRessDefEdit.lstRessourceDefData){
						if(scope.inactiveFilterValue && scope.inactiveFilterValue.code == "actif"){
							return scope.selectedRessDefEdit.lstRessourceDefData.filter(e => !e.isDeleted)
						}else{
							return scope.selectedRessDefEdit.lstRessourceDefData
						}
					}
				}
				
				scope.copyRessDef = function(){
					var qconfirmOptions = {
						title: $filter('translate')('copyRessDefalert'),
						qconfirm: {hideCancel: true}
					};
					QConfirm.open(qconfirmOptions).then(function(proceed){
						if(proceed){
							newRess = angular.copy(scope.selectedRessDefEdit);
//							scope.selectedRessDefEdit.isDeleted = true;
							scope.selectedRessDefEdit.modificationStatus = ModificationStatus.STATUS_UPDATED;
							scope.selectedRessDefEdit.tarifFin = moment().subtract(1, "days").format('YYYYMMDD');
							delete newRess.id;
							for(let i=0; i < newRess.lstRessourceDefData.length; i++){
								newRess.lstRessourceDefData[i].modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
								delete newRess.lstRessourceDefData[i].id;
							}
							newRess.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
							newRess.tarifDebut = moment().format('YYYYMMDD');
							scope.selectedRessEdit.lstRessourceDef.push(newRess);
							scope.selectedRessDefEdit = newRess;
							scope.isDirty = true;
							model.actUpdated(true);
						}
					});
					
				}
				
				scope.deleteOrRecoverRessDef = function(ressDef){
					scope.isDirty = true;
					ressDef.isDeleted = !ressDef.isDeleted;
					if(ressDef.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
						ressDef.modificationStatus = ModificationStatus.STATUS_UPDATED
					}
					model.actUpdated(true);
				}
				
				scope.saveRess = function(){
					if(scope.ressEditFrm.$valid && checkRessEditMode()){
						if(scope.selectedRessEdit.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
							scope.selectedRessEdit.modificationStatus = ModificationStatus.STATUS_UPDATED;
						}
						if(scope.selectedRessDefEdit.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
							scope.selectedRessDefEdit.modificationStatus = ModificationStatus.STATUS_UPDATED;
						}
						scope.selectedRessEdit.nameEn = scope.selectedRessEdit.nameFr;
						scope.selectedRessDefEdit.serviceType = scope.serviceTypeList.filter(e=> e.selected).map(e=>e.type);
//						scope.selectedRessDefEdit = $scope.selectedRessEdit ? $scope.selectedRessEdit.lstRessourceDef.find(e => e.isDeleted == 0) : undefined;
						return RessourceAccessor.ressourceSave(scope.selectedRessEdit, function(res){
							if(!res.data){
								model.ressource().edit.resourceList = model.ressource().edit.resourceList ? model.ressource().edit.resourceList : [];
								index = model.ressource().edit.resourceList.indexOf(model.ressource().edit.selectedRess);
								model.ressource().edit.selectedRess = res
								if(index > -1){
									model.ressource().edit.resourceList.splice(index, 1, res)
								}else{
									model.ressource().edit.resourceList.push(res)
								}
								scope.selectedRessEdit = angular.copy(model.ressource().edit.selectedRess)
								scope.selectedRessDefEdit = scope.selectedRessEdit.lstRessourceDef.find(e => e.isDeleted == 0 && e.tarifFin >= moment().format('YYYYMMDD'));
								scope.serviceTypeList = angular.copy(Object.values(model.enums().ressServiceType));
								for(let i=0; i < scope.selectedRessDefEdit.serviceType.length; i++){
									index = scope.serviceTypeList.findIndex(x => x.type == scope.selectedRessDefEdit.serviceType[i])
									scope.serviceTypeList[index].selected = true;
								}
								model.notice().success($filter('translate')('SaveSuccess'));
								scope.isDirty = false;
								scope.ressEditFrm.$dirty = false;
								scope.ressEditFrm.$setPristine();
								model.actUpdated(true);
							}else{
								model.notice().fail($filter('translate')(res.data.ms));
							}
						}, function(res){
							model.notice().fail($filter('translate')(res.msg));
						});
						
					}else{
						return $q(function(resolve, reject) {
							model.notice().fail($filter('translate')('missingField'))
							reject();
						});
					}
				}
				
				scope.cancelRess = function(){
					QValidation.closeContext($filter('translate')('UnsavedChanges')).then(function(successful){
						if(successful){
							delete model.ressource().edit.selectedRess;
							model.ressource().edit.currTab = undefined;
							delete scope.selectedRessEdit;
							delete scope.selectedRessDefEdit;
							scope.serviceTypeList = angular.copy(Object.values(model.enums().ressServiceType));
							
							scope.isDirty = false;
							scope.ressEditFrm.$dirty = false;
							scope.ressEditFrm.$setPristine();
							model.actUpdated(true);
						}
					});
				}
				
				function checkRessEditMode(){
					scope.ressInEditMode = false;
					for(let i = 0; i < scope.selectedRessEdit.length; i++){
						if(scope.selectedRessEdit.lstRessourceDef[i].editMode){
							scope.taxDefInEditMode = true;
							return false;
						}
					}
					return true;
				}
				
				scope.getProfName = function(ressDefData){
					let name = "";
					if(ressDefData.idProfessionnalAnchor){
						prof = scope.lstProf.find(e => e.id == ressDefData.idProfessionnalAnchor);
						if(prof){
							name = prof.lastName+', '+prof.firstName;
						}
					}
					return name;
				}
				
				scope.getServiceType = function(ress){
					let type = ""
					for(let i=0; i < ress.serviceType.length; i++){
						if(i !== 0){
							type += ", "
						}
						type += $filter('translate')(ress.serviceType[i])
					}
					return type;
				}
				
				scope.getSecteurName = function(ressDefData){
					let name = ""
					if(ressDefData.idSecteur != null){
						if ($translate.use()=='en') {
		                    name = model.ress().secteurObj[ressDefData.idSecteur].nameEn;
		                    if(!name || name.length == 0){
								name = model.ress().secteurObj[ressDefData.idSecteur].nameFr;
							}
		                }else{
							name = model.ress().secteurObj[ressDefData.idSecteur].nameFr;
							if(!name || name.length == 0){
								name = model.ress().secteurObj[ressDefData.idSecteur].nameEn;
							}
						}
					}
					return name;
				}
				
				scope.getDescription = function(def){
					var name = "";
					if ($translate.use()=='en') {
	                    name = def.nameEn;
	                    if(!name || name.length == 0){
							name = def.nameFr;
						}
	                }else{
						name = def.nameFr;
						if(!name || name.length == 0){
							 name = def.nameEn;
						}
					}
	                return name;
				}
				
				scope.getPrice = function(data){
					if(data.prixBaseInitial && data.prixParUnit){
						return data.prixBaseInitial + " + " + data.prixParUnit + "/" +$filter('translate')(data.unit);
					}else if(data.prixBaseInitial){
						return data.prixBaseInitial
					}else if(data.prixParUnit){
						return data.prixParUnit + "/" +$filter('translate')(data.unit)
					}else{
						return 'variable';
					}
				}
				
				scope.$watch('responsablePmtList|filter:{selected:true}', function (nv) {
					scope.selectedRessEdit.responsablePmt = nv.map(function (option) {
				   		return option.type;
					});
				}, true);
				
				scope.copyRessDefData = function(ressDefData){
					scope.isDirty = true;
					newRess = angular.copy(ressDefData);
					delete newRess.id;
					newRess.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
					scope.selectedRessDefEdit.lstRessourceDefData.push(newRess);
					model.actUpdated(true);
				}
				
				scope.deleteOrRecoverRessDefData = function(ressDefData){
					scope.isDirty = true;
					ressDefData.isDeleted = !ressDefData.isDeleted;
					if(ressDefData.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
						ressDefData.modificationStatus = ModificationStatus.STATUS_UPDATED
					}
					model.actUpdated(true);
				}
				
				scope.newRessDefData = function(){
					ressDefData = {
						isDeleted: false,
						lstRessourceDefData: [],
						createdDatetime: Date.now(),
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
						nameFr: "",
						nameEn: "",
						unit: "ITEM",
						status: "DISPONIBLE",
						prixBaseInitial: 0,
						prixParUnit: 0,
						recycleTime: 0,
						escompteMax: 0,
						unitTime: 0,
					}
//					model.ressource().edit.selectedRessDef.lstRessourceDefData.push(ressDefData);
					scope.editRessDefData(ressDefData);
				}
				
				scope.editRessDefData = function(ressDefData){
					var qconfirmOptions = {
						templateUrl: "/dashboard/resources/ofys/ress/ressdefdata_edit.html?v=ay",
						orig: ressDefData,
						resDefData: angular.copy(ressDefData),
						ressStatus: scope.ressStatus,
						ressUnit: scope.ressUnit,
						showMoreOption: false,
						lstProf: $filter('orderBy')(model.store.profs.filter.treating.list(), ['lastName', 'firstName']),
						checkIfNew: function(resDefData){
							return resDefData.modificationStatus == ModificationStatus.STATUS_NEW_UPDATED;
						},
						focusOnOpen: function(){
							$timeout(function(){
								if(this.focus){
									this.focus();
								}
							},400);
						},
						fl: {},
						ok: function(e, obj){
							if(this.templateSectionFrm && this.templateSectionFrm.$valid && (this.resDefData.nameFr || this.resDefData.nameEn)){
								scope.isDirty = true;
								if(this.resDefData.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
									this.resDefData.modificationStatus = ModificationStatus.STATUS_UPDATED;
								}
								this.resDefData.prixBaseInitial = typeof this.resDefData.prixBaseInitial == 'string' ? this.resDefData.prixBaseInitial.replace(/,/g, '.') : this.resDefData.prixBaseInitial;
								this.resDefData.prixParUnit = typeof this.resDefData.prixParUnit == 'string' ? this.resDefData.prixParUnit.replace(/,/g, '.') : this.resDefData.prixParUnit;
								if(this.resDefData.escompteMax > 1){
									this.resDefData.escompteMax = this.resDefData.escompteMax/100;
								}
								let i = scope.selectedRessDefEdit.lstRessourceDefData.findIndex(e => e==this.orig);
								if(i > -1){
									scope.selectedRessDefEdit.lstRessourceDefData.splice(i, 1, this.resDefData);
								}else{
									scope.selectedRessDefEdit.lstRessourceDefData.push(this.resDefData);
								}
								this.fl.cancel();
								model.actUpdated(true);
								model.translationUpdate(true);
							}else if(!this.resDefData.nameFr && !this.resDefData.nameEn){
								this.fl.frm.errorMsgs = [{msg: 'errorNameSelected', type: 'error'}];
								model.actUpdated(true);
							}else{
								this.fl.frm.errorMsgs = PatientFormService.getFormErrors(this.fl.frm)
								model.actUpdated(true);
//								e.prevent();
							}
						},
					}
					FlView.open(qconfirmOptions, {windowClass:'top-modal', backdrop:'static'}).then(function(){});
				}
				
			}
		}
	}]);
	
	ressource.directive('ressDefEdit', ['model', 'ModificationStatus', '$translate',
	                               function(model, ModificationStatus, $translate){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/ressdef_edit.html?v=ay',
			scope:{
                def: '=',
                list: '=',
            },
			link: function(scope, element, attrs){
				scope.ressDefEdit = angular.copy(scope.def);
				scope.taxes = model.ress().taxes;
				scope.serviceTypeList = Object.values(model.enums().ressServiceType);
				
				scope.ok = function(){
					scope.def.nameFr = scope.ressDefEdit.nameFr;
					scope.def.nameEn = scope.ressDefEdit.nameEn;
					scope.def.serviceType = scope.ressDefEdit.serviceType;
					scope.def.taxeDef = scope.ressDefEdit.taxeDef;
					scope.def.tarifDebut = scope.ressDefEdit.tarifDebut;
					scope.def.tarifFin = scope.ressDefEdit.tarifFin;
					scope.def.editMode = false;
					if(scope.def.modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
						scope.def.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					model.actUpdated(true);
					model.translationUpdate(true);
				}
				
				scope.no = function(){
					scope.def.editMode = false;
					if(scope.def.modificationStatus == ModificationStatus.STATUS_NEW_UPDATED){
						const i = scope.list.findIndex(e => e == scope.def);
						if(i>-1){
							scope.list.splice(i,1);
						}
					}
					model.actUpdated(true);
				}
				
				function initServiceType(){
					for(let i=0; i < scope.ressDefEdit.serviceType.length; i++){
						index = scope.serviceTypeList.findIndex(x => x.type == scope.ressDefEdit.serviceType[i])
						scope.serviceTypeList[index].selected = true;
					}
				}
				initServiceType()
				
				scope.$watch('serviceTypeList|filter:{selected:true}', function (nv) {
					scope.ressDefEdit.serviceType = nv.map(function (option) {
				   		return option.type;
					});
				}, true);
			}
		}
	}]);
	
	ressource.controller('InvoiceController',
			['$scope', 'model', 'RessourceAccessor', '$timeout', '$popover', 'ModificationStatus', 'AppointmentAccessor', 'QValidation',
				'$filter',
			function($scope, model, ressourceAccessor, $timeout, $popover, ModificationStatus, appointmentAccessor, QValidation,
				$filter){
        
        $scope.currentTab = "history"
        model.billed().isEditable = false;
        
        $scope.init = function(pat, list){
			$scope.patient = pat;
			list = list.sort(function(a,b){
				return (+(b.status != "PMT_COMPLET")) - (+(a.status != "PMT_COMPLET")) || b.noFacture - a.noFacture
			})
			$scope.billedRessList = list;
			
			$scope.options = {
				fl : $scope.fl,
				switchTab : $scope.switchTab,
				addToList : addToList,
				selectBilled : selectBilled,
				selectBilledList : selectBilledList,
				registerDirty: registerDirty,
				unregisterDirty: unregisterDirty
			}
		}
        
        var menu;
		$scope.getFuturPatAppt = function(patient, e){
			if(menu)menu.destroy();
			appointmentAccessor.findFuturAppointmentPatient(patient.id, function(res){
				menu = $popover($(e.currentTarget),{
		            trigger:"focus",
		            autoClose: true,
		            placement: "auto right",
		            keyboard: false,
		            animation: "am-flip-x",
		            templateUrl: "/dashboard/resources/ofys/appointment/past_futur_appt_modal.html",
		            onShow: function(){
		            },
		        });
				menu.$scope.apptList = res.data.sort(function(a,b){
					return a.when-b.when;
				})
				menu.$scope.futur = true
				$timeout(function(){
					menu.show();
				}, 100)
			})
		}
		
		$scope.getPastPatAppt = function(patient, e){
			if(menu)menu.destroy();
			appointmentAccessor.findPastAppointmentPatient(patient.id, function(res){
				menu = $popover($(e.currentTarget),{
		            trigger:"focus",
		            autoClose: true,
		            placement: "auto right",
		            keyboard: false,
		            animation: "am-flip-x",
		            templateUrl: "/dashboard/resources/ofys/appointment/past_futur_appt_modal.html",
		            
		        });
				menu.$scope.apptList = res.data.sort(function(a,b){
					return b.when-a.when;
				})
				menu.$scope.futur = false
				$timeout(function(){
					menu.show();
				}, 100)
			})
		}
		
		/**
		 * COMMENT: INVOICE INVOICECONTROLLER @function
		 *
		 * Façon simple de setup les QValidation, sert à vérifier si la form est "dirty" 
		 * À implémenter sur tout ce qui est édition
		 * 
		 */
		var registeredDirtyId;
		function registerDirty(saveCallback){
			registeredDirtyId = "invoice";
			QValidation.registerDirty(registeredDirtyId, saveCallback, function(){
				return true;
			});
		}
		function unregisterDirty(){
			if(registeredDirtyId){
				QValidation.unregisterDirty(registeredDirtyId);
				registeredDirtyId = undefined;
			}
		}
//		$scope.options.isDirty = false;
		var isFormDirty = false;
		$scope.formDirty = function(){
			var dirty = $scope.options.isDirty
			if(isFormDirty !== dirty){
				if(dirty){
					registerDirty();
				}else{
					unregisterDirty();
				}
			}
			isFormDirty = dirty;
			return isFormDirty;
		};
		//find du setup de la QValidation
		
		$scope.addNewInvoice = function(){
			$scope.billed = {
				dateBilled: moment().valueOf(),
				dateBilledS: moment().format('YYYY-MM-DD HH:mm'),
				totalPreTaxe: 0,
				totalTaxe: 0,
				grandTotal: 0,
				solde: 0,
				idPatientAnchor: $scope.patient.idPatient,
				status: "NON_PAYE",
				lstBillingRessource: [],
				modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
			};
			$scope.switchTab('createInvoice');
		}
		
		$scope.switchTab = function(name){
			QValidation.closeContext($filter('translate')('UnsavedChanges'), registeredDirtyId).then(function(successful){
				if(successful){
					model.billed().isEditable = false;
					$scope.currentTab = name;
					model.invoiceUpdated(true);
				}
			});
		}
		
		function addToList(billedRess){
			let d = 1;
			let i = $scope.billedRessList.findIndex(e => e.id == billedRess.id);
			if(i == -1){
				i = 0;
				d = 0;
			}
			$scope.billedRessList.splice(i, d, billedRess);
			model.billed().listBilled[$scope.patient.idPatient] = angular.copy($scope.billedRessList);
		}
		
		function selectBilled(billedRess){
			$scope.billed = billedRess;
		}
		
		function selectBilledList(billedRessList){
			$scope.billedList = billedRessList;
		}
	        
	}]);
	
	ressource.directive('invoiceHistory', ['model', 'ModificationStatus', 'PatientAccessor', 'PrintAccessor', '$filter', 'QConfirm', 'RessourceAccessor',
	                               function(model, ModificationStatus, PatientAccessor, printAccessor, $filter, QConfirm, ressourceAccessor){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/invoice_history.html?v=ay',
			scope:{
                list: '=',
                options: '=',
                patient: '='
            },
			link: function(scope, element, attrs){
				
				scope.invoiceFilter = {
					overdue: {val:true, name:'overdue'},
					all: {val:true,name:'All_fem'},
					paid: {val:true,name:'Paids'},
				};
				
				scope.invoiceFilterValue = scope.invoiceFilter["all"];
				
				scope.updateList = function(){
					model.invoiceUpdated(true);
				}
				
				scope.getLstBilledRess = function(){
					if(scope.list){
						if(scope.invoiceFilterValue && scope.invoiceFilterValue.name == "overdue"){
							return scope.list.filter(e => e.status == "NON_PAYE" || e.status == "PMT_PARTIEL")
						} else if(scope.invoiceFilterValue && scope.invoiceFilterValue.name == "Paids"){
							return scope.list.filter(e => e.status == "PMT_AVEC_CREDIT" || e.status == "PMT_COMPLET")
						}else{
							return scope.list;
						}
					}
				}
				
				var lastClicked = undefined;
				scope.selectBilled = function(type){
					if(type == 'none' || lastClicked == type){
						scope.getLstBilledRess().forEach(obj => obj.selected = false);
						type = undefined;
					}else if(type == 'overdue'){
						scope.getLstBilledRess().forEach(function(obj){
							if(obj.status == "NON_PAYE" || obj.status == "PMT_PARTIEL"){
								obj.selected = true;
							}else{
								obj.selected = false;
							}
						});
					}else if(type == "all"){
						scope.getLstBilledRess().forEach(obj => obj.selected = true);
					}
					lastClicked = type;
				}
				
				scope.getBilledDate = function(date){
					return moment(date).format('YYYY-MM-DD');
				}
				
				scope.fixedIfDecimal = function(num){
					num = Number(num);
					if(num%1 == 0){
						return num;
					}else{
						return num.toFixed(2);
					}
				}
				
				scope.canCancelInvoice = function(billedRess){
					return (billedRess.status == "NON_PAYE")
				}
				
				scope.canPayInvoice = function(billedRess){
					return (billedRess.status == "NON_PAYE" || billedRess.status == "PMT_PARTIEL" )
				}
				
				scope.canCancelPaiment = function(billedRess){
					return (billedRess.status == "PMT_COMPLET" || billedRess.status == "PMT_PARTIEL" 
							|| billedRess.status == "PMT_AVEC_CREDIT")
				}
				
				scope.isCanceled = function(billedRess){
					return (billedRess.status == "ANNULE")
				}
				
				scope.cancelPaiement = function(billedRess){
					var qconfirmOptions = {
						templateUrl: 'cancelPaiement_index.html',
						billedRess: billedRess,
						getDate: function(date){
							return moment(date).format('YYYY-MM-DD')
						},
						fixedIfDecimal : scope.fixedIfDecimal,
						qconfirm: {
							hideNo: true,
							beforeYes: function(e, obj){
								let billedPaid = {
									createdDatetime: moment().valueOf(),
									isDeleted : false,
									paid : (-Math.abs(billedRess.grandTotal - billedRess.solde)),
									modePaiement : "ANNUL_PMT",
									note: "",
									modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
								}
								billedRess.lstBilledRessourcePaid.push(billedPaid);
								billedRess.modificationStatus = ModificationStatus.STATUS_UPDATED,
								billedRess.status = "NON_PAYE";
								billedRess.solde = billedRess.grandTotal;
								ressourceAccessor.billedSave([billedRess], function(res){
									for(i=0; i<res.length;i++){
										scope.options.addToList(res[i]);
									}
									model.invoiceUpdated(true);
								});
							},
						},
					};
					QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(proceed){});
				}
				
				scope.cancelBilled = function(billedRess){
					var qconfirmOptions = {
						templateUrl: 'cancelBilled_index.html',
						billedRess: billedRess,
						getDate: function(date){
							return moment(date).format('YYYY-MM-DD')
						},
						fixedIfDecimal : scope.fixedIfDecimal,
						qconfirm: {
							hideNo: true,
							beforeYes: function(e, obj){
								let billedPaid = {
									createdDatetime: moment().valueOf(),
									isDeleted : false,
									paid : billedRess.solde,
									modePaiement : "PERTE",
									note: "",
									modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
								}
								billedRess.lstBilledRessourcePaid.push(billedPaid);
								billedRess.modificationStatus = ModificationStatus.STATUS_UPDATED,
								billedRess.status = "ANNULE";
								billedRess.solde = 0;
								ressourceAccessor.billedSave([billedRess], function(res){
									billedRess = res[0];
									for(i=0; i<res.length;i++){
										scope.options.addToList(res[i]);
									}
									model.invoiceUpdated(true);
								});
							}
						},
						
					};
					QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(proceed){
					});
				}
				
				scope.selectBillToPay = function(billedRess){
					let listBilledRess;
					if(billedRess){
						listBilledRess = [billedRess]
					}else{
						listBilledRess = scope.getLstBilledRess().filter(e => e.selected);
					}
					if(listBilledRess && listBilledRess.length > 0){
						scope.options.selectBilledList(listBilledRess);
						scope.options.switchTab("pay");
					}
				}
				
				scope.editInvoice = function(billedRes){
					billedRes.modificationStatus = ModificationStatus.STATUS_UPDATED;
					billedRes.dateBilledS = moment(billedRes.dateBilled).format('YYYY-MM-DD HH:mm'),
					scope.options.selectBilled(billedRes);
					scope.options.switchTab("createInvoice");
				}
				
				scope.printBilled = function(billed){
					var billedList
					if(billed){
						billedList = [billed]
					}else{
						billedList = scope.getLstBilledRess().filter(e => e.selected);
					}
					if(billedList && billedList.length > 0){
						scope.isLoading = true;
						var data = {
							report : report = {
								id: "client_facturation",
								name: "Facturation",
								printMode: "ACTUAL_SIZE",
								properties: [],
							},
							type : "billedRessource",
							billed : billedList,
						}
						printAccessor.print(data, function(res){
							scope.isLoading = false;
							model.notice().success($filter('translate')("PRINT_SERVER_SUCCESS"));
						}, function(){
							scope.isLoading = false;
							model.notice().fail($filter('translate')(res.msg));
						});
					}else{
						model.notice().note($filter('translate')('err_no_app'));	
					}
				}
				scope.isLoading = false;
				scope.sendBilled = function(billed){
					var emailDetails = PatientAccessor.getPatientEmail(scope.patient);
//					console.log(scope.patient)
					if(emailDetails.hasAnEmail){
						var billedList
						if(billed){
							billedList = [billed]
						}else{
							billedList = scope.getLstBilledRess().filter(e => e.selected);
						}
						if(billedList && billedList.length > 0){
							scope.isLoading = true
							var data = {
								email: emailDetails.useContact.contact,
								idPat: scope.patient.idPatient,
								idSite: model.user().session.workSite.id,
								report : report = {
									id: "client_facturation",
									name: "Facturation",
									printMode: "ACTUAL_SIZE",
									properties: [],
								},
								type : "billedRessource",
								billed : billedList,
							}
							ressourceAccessor.sendByEmail(data, function(res){
								scope.isLoading = false;
								model.notice().success($filter('translate')("emailSendSuccess"));
							}, function(res){
								scope.isLoading = false;
								model.notice().fail($filter('translate')(res.msg));
							});
						}else{
							model.notice().fail($filter('translate')('noBilledChosen'));
						}
					}else{
						model.notice().fail($filter('translate')('noEmailForPatient'));
					}
					
				}
			}
		}
	}]);
	
	ressource.directive('invoiceCreate', ['model', 'ModificationStatus', '$translate', 'RessourceAccessor', '$filter', '$q',
	                               function(model, ModificationStatus, $translate, ressourceAccessor, $filter, $q){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/invoice_create.html?v=ay',
			scope:{
                billedorig: '=',
                options: '='
            },
			link: function(scope, element, attrs){
				scope.isAdmin = model.user().isAdmin;
//				scope.billed = angular.copy(scope.billedorig);
//				scope.isEditable = (scope.billed.status != "PMT_AVEC_CREDIT" && scope.billed.status != "PMT_COMPLET" 
//										&& scope.billed.status != "PMT_PARTIEL" && scope.billed.status != "ANNULE")
				scope.taxes = angular.copy(model.ress().taxes);
//				scope.newBillingTemplate = {
//					name: undefined,
//					dateTimeStartS: moment().format('YYYY-MM-DD HH:mm'),
//					dateTimeStart: moment().valueOf(),
//					nbOrdered:1,
//					autoRepeat: false,
//					idPatientAnchor: scope.billedorig.idPatientAnchor,
//					idSite: model.user().session.workSite.id,
//					billingRessourceDatas: [],
//					note: "",
//					modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
//				}
//				scope.newBilling = angular.copy(scope.newBillingTemplate);
				
				function init(){
					
					scope.billed = angular.copy(scope.billedorig);
					scope.isEditable = (scope.billed.status != "PMT_AVEC_CREDIT" && scope.billed.status != "PMT_COMPLET" 
											&& scope.billed.status != "PMT_PARTIEL" && scope.billed.status != "ANNULE")
					model.billed().isEditable = scope.isEditable;
					scope.newBillingTemplate = {
						name: undefined,
						dateTimeStartS: moment().format('YYYY-MM-DD HH:mm'),
						dateTimeStart: moment().valueOf(),
						nbOrdered:1,
						autoRepeat: false,
						idPatientAnchor: scope.billed.idPatientAnchor,
						idSite: model.user().session.workSite.id,
						billingRessourceDatas: [],
						note: "",
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
					}
					scope.newBilling = angular.copy(scope.newBillingTemplate);
					if(scope.billed.lstBillingRessource && scope.billed.lstBillingRessource.length > 0){
						for(let i=0; i<scope.billed.lstBillingRessource.length; i++){
							let ress = scope.billed.lstBillingRessource[i].ressourceDefData;
							scope.billed.lstBillingRessource[i].name = getRessName(ress);
							scope.billed.lstBillingRessource[i].nameSearch = getRessName(ress);
							scope.billed.lstBillingRessource[i].billingRessourceDatas[0].prixString = scope.getPriceString(ress)
							scope.billed.lstBillingRessource[i].billingRessourceDatas[0].getInitialPrice = (ress.prixBaseInitial && ress.prixParUnit) ? true:false
							if(scope.billed.lstBillingRessource[i].idProfessionnalAnchor){
								lastProfSelected = model.store.profs.get(scope.billed.lstBillingRessource[i].idProfessionnalAnchor);
								if(lastProfSelected){
									scope.billed.lstBillingRessource[i].professionnalFullName = lastProfSelected.lastName + ', '+ lastProfSelected.firstName;
								}
							}
						}
						updatePrice(scope.billed);
					}
					if(scope.isEditable){
						scope.options.registerDirty(scope.saveBilled);
					}
				}
				
				scope.billedDateDynaDateOptions = {
					format: 'YYYY-MM-DD HH:mm',
					acceptFutureDate: false,
					onDateSelected: function (mDate, dAssist) {
						if(!mDate){
							mDate = moment();
						}
						scope.billed.dateBilled = mDate.valueOf();
						var m = mDate.format(dAssist.format);
						scope.billed.dateBilledS = m;
					}
				}
				scope.newBillingDateDynaDateOptions = {
					format: 'YYYY-MM-DD HH:mm',
					acceptFutureDate: false,
					onDateSelected: function (mDate, dAssist) {
						if(!mDate){
							mDate = moment();
						}
						scope.newBilling.dateTimeStart = mDate.valueOf();
						var m = mDate.format(dAssist.format);
						scope.newBilling.dateTimeStartS = m;
					}
				}
				
				scope.getDynaOption = function(billingRess){
					var dynaOptions = {
						format: 'YYYY-MM-DD HH:mm',
						billingRess: billingRess,
						acceptFutureDate: false,
						onDateSelected: function (mDate, dAssist) {
							if(!mDate){
								mDate = moment();
							}
							billingRess.dateTimeStart = mDate.valueOf();
							var m = mDate.format(dAssist.format);
							billingRess.dateTimeStartS = m;
						}
					}
					return dynaOptions
				}
				
				scope.preventLineBreak = function(e){
					if (e.key === 'Enter') { e.preventDefault(); }
				}
				
				scope.getBilledDate = function(date){
					return moment(date).format('YYYY-MM-DD');
				}
				
				scope.deleteBillingRess = function(billingRess){
					const i = scope.billed.lstBillingRessource.findIndex(e => e == billingRess);
					if(i>-1){
						if(scope.billed.lstBillingRessource[i].id){
							scope.billed.lstBillingRessource[i].modificationStatus = ModificationStatus.STATUS_DELETED;
							scope.billed.lstBillingRessource[i].billingRessourceDatas[0].isDeleted = true;
							scope.billed.lstBillingRessource[i].billingRessourceDatas[0].modificationStatus = ModificationStatus.STATUS_DELETED;
						}else{
							scope.billed.lstBillingRessource.splice(i,1);
						}
						
					}
					updatePrice(scope.billed)
					model.invoiceUpdated(true);
				}
				
				scope.modifyRess = function(ress, billingRess){
					if(billingRess.modificationStatus == ModificationStatus.STATUS_NEUTRAL){
						billingRess.billingRessourceDatas[0].modificationStatus = ModificationStatus.STATUS_DELETED;
						billingRess.billingRessourceDatas[0].isDeleted = true;
						let i = scope.billed.lstBillingRessource.findIndex((e)=> e.id == billingRess.id)
						billingRess = angular.copy(billingRess)
						billingRess.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
						delete billingRess.id
						scope.billed.lstBillingRessource.splice(i, 0, billingRess);
					}
					billingRess.ressourceDefData = ress;
					billingRess.name = getRessName(ress);
					billingRess.nameSearch = getRessName(ress);
					let note = "";
					if(billingRess.billingRessourceDatas && billingRess.billingRessourceDatas.length>0
							&& billingRess.billingRessourceDatas[0].note){
						note = angular.copy(billingRess.billingRessourceDatas[0].note)
					}
					billingRess.billingRessourceDatas = []
					billingRess.billingRessourceDatas.push(createBillingRessData(ress, note));
					updatePrice(scope.billed)
					model.invoiceUpdated(true);
				}
				
				scope.addNewBillingOnTop = function(billingRess){
					var billingToAdd = angular.copy(scope.newBillingTemplate);
					let index = scope.billed.lstBillingRessource.findIndex(e => e === billingRess);
					scope.billed.lstBillingRessource.splice(index, 0, billingToAdd);
					model.invoiceUpdated(true);
				}
				
				scope.getOrigName = function(billingRess){
					billingRess.nameSearch = billingRess.name;
				}
				
				var lastProfSelected = undefined;
				scope.selectNewRess = function(ress){
					scope.noRessSelected = false;
					if(!scope.billed.lstBillingRessource){
						scope.billed.lstBillingRessource = [];
					}
					if(ress.serviceType && ress.serviceType.includes("DISPENSATEUR")){
						if(ress.idProfessionnalAnchor){
							lastProfSelected = model.store.profs.list().find(e => e.id == ress.idProfessionnalAnchor)
						}
						if(lastProfSelected){
							scope.newBilling.idProfessionnalAnchor = lastProfSelected.id;
							scope.newBilling.professionnalFullName = lastProfSelected.lastName + ', '+ lastProfSelected.firstName;
						}
					}
					scope.newBilling.ressourceDefData = ress;
					scope.newBilling.name = getRessName(ress);
					scope.newBilling.nameSearch = getRessName(ress);
					scope.newBilling.billingRessourceDatas = []
					scope.newBilling.billingRessourceDatas.push(createBillingRessData(ress, scope.newBilling.note));
					scope.billed.lstBillingRessource.push(scope.newBilling);
					scope.newBilling = angular.copy(scope.newBillingTemplate);
					updatePrice(scope.billed)
					model.invoiceUpdated(true);
				}
				
				scope.ressSerachOption = {
					fixPositioning:function(dxA){
                        if(dxA != null && dxA.assistElement != null ){
                            var position = dxA.assistElement[0].getBoundingClientRect();
                            var maincontainer = dxA.assistElement.find(".assist-main-div");
                            var width = maincontainer[0].offsetWidth;
                            var xEnd = (position.x + width);
                            dxA.assistElement.css("position","fixed");
                            dxA.assistElement.css("bottom","initial");
                            dxA.assistElement.css("z-index","100");
                            var leftpos = (position.x-(xEnd - window.innerWidth)-5);
                            dxA.assistElement.css("right",+leftpos+"px");
                        }
                    }
				}
				
				function getRessName(ress){
					var name = "";
					if ($translate.use()=='en') {
	                    name = ress.nameEn;
	                    if(!name || name.length == 0){
							name = ress.nameFr;
						}
	                }else{
						name = ress.nameFr;
						if(!name || name.length == 0){
							 name = ress.nameEn;
						}
					}
	                return name;
                }
                
                function createBillingRessData(ress, note){
					var ressData = {
						prix: scope.getPrice(ress),
						prixString: scope.getPriceString(ress),
						getInitialPrice : (ress.prixBaseInitial && ress.prixParUnit) ? true:false,
						escompte: 0,
						isDeleted: false,
						createdDatetime: moment().valueOf(),
						note: note,
						billingRessourceDataTaxes: [],
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
					}
					const tax = scope.taxes.find(tax => tax.id == ress.idTax);
					if(tax){
						ressData.billingRessourceDataTaxes = tax.lstTaxeDefData.filter(e=>!e.isDeleted);
						for(let i = 0; i < ressData.billingRessourceDataTaxes.length; i++){
							delete ressData.billingRessourceDataTaxes[i].id
							ressData.billingRessourceDataTaxes[i].modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
							ressData.billingRessourceDataTaxes[i].createdDatetime = moment().valueOf();
						}
					}
					return ressData;
				}
                
                scope.getPrice = function(data){
					if((data.prixBaseInitial && data.prixParUnit) || data.prixParUnit){
						return data.prixParUnit;
					}else if(data.prixBaseInitial){
						return data.prixBaseInitial;
					}
				}
				
				scope.getPriceString = function(data){
					if(data.prixBaseInitial && data.prixParUnit){
						return data.prixBaseInitial + " + " + data.prixParUnit +"/u";
					}else if(data.prixBaseInitial){
						return data.prixBaseInitial.toString();
					}else if(data.prixParUnit){
						return data.prixParUnit.toString();
					}
				}
				
				scope.canChangeTaux = function(billingRess){
					return !billingRess.ressourceDefData || (billingRess.ressourceDefData.prixBaseInitial>0 || billingRess.ressourceDefData.prixParUnit>0);
				}
				
				scope.canChangeEsc = function(billingRess){
					return !billingRess.ressourceDefData || !billingRess.ressourceDefData.escompteMax;
				}
				
				scope.canAddProf = function(billingRess){
					if(billingRess && billingRess.ressourceDefData && billingRess.ressourceDefData.serviceType){
						return billingRess.ressourceDefData.serviceType.includes("DISPENSATEUR")
					}else if(billingRess && billingRess.idProfessionnalAnchor){
						return true
					}else{
						return false
					}
				}
				
				scope.selectProf = function(prof, billingRess){
					billingRess.idProfessionnalAnchor = prof.id;
					billingRess.professionnalFullName = prof.lastName + ', '+ prof.firstName;
					lastProfSelected = prof;
					model.invoiceUpdated(true);
				}
				
				function roundNumber(num){
					return Math.round((num+ Number.EPSILON)*100)/100;
				}
				
				scope.checkEscMax = function(billingRess){
					if(billingRess.billingRessourceDatas[0].escompte > 1){
						billingRess.billingRessourceDatas[0].escompte = billingRess.billingRessourceDatas[0].escompte/100;
					}
					if(billingRess.billingRessourceDatas[0].escompte>billingRess.ressourceDefData.escompteMax){
						billingRess.billingRessourceDatas[0].escompte = 0;
						model.notice().warn(
							$filter('translate')('errorMustBeLowerThanEscMax') + billingRess.ressourceDefData.escompteMax, 
							{autoClose: 5000}
						);
					}
					updatePrice(scope.billed)
					model.invoiceUpdated(true);
				}
				
				scope.checkNbOrdered = function(billingRess){
					if(!billingRess.nbOrdered || billingRess.nbOrdered < 1){
						billingRess.nbOrdered = 1
					}
					updatePrice(scope.billed)
					model.invoiceUpdated(true);
				}
				
				scope.updateTaux = function(billingRess){
					if(!billingRess.billingRessourceDatas[0].prix || billingRess.billingRessourceDatas[0].prix < 0.01){
						billingRess.billingRessourceDatas[0].prix = 0
					}
					billingRess.billingRessourceDatas[0].prix = roundNumber(billingRess.billingRessourceDatas[0].prix);
					updatePrice(scope.billed)
					model.invoiceUpdated(true);
				}
				
				scope.getSelectedTaxesName = function(tax){
					var name = "";
					if ($translate.use()=='en') {
	                    name = tax.nameEn;
	                    if(!name || name.length == 0){
							name = tax.nameFr;
						}
	                }else{
						name = tax.nameFr;
						if(!name || name.length == 0){
							 name = tax.nameEn;
						}
					}
	                return name;
				}
				
				scope.showTaxesOnProduct = function(tax){
					return $filter('translate')('taxTypeMsg', {name: scope.getSelectedTaxesName(tax), taux: tax.taux, product: roundNumber(tax.taxableProduct).toFixed(2)});
				}
				
				scope.selectedTaxes = {};
				
				function updatePrice(billed){
					var totalPreTax = 0;
					var totalTax = 0;
					scope.selectedTaxes = {};
					for(i = 0; i<billed.lstBillingRessource.length; i++){
						for(j = 0; j<billed.lstBillingRessource[i].billingRessourceDatas.length; j++){
							if(!billed.lstBillingRessource[i].billingRessourceDatas[j].isDeleted){
								if(billed.lstBillingRessource[i].billingRessourceDatas[j].modificationStatus != ModificationStatus.STATUS_NEW_UPDATED){
									billed.lstBillingRessource[i].billingRessourceDatas[j].modificationStatus = ModificationStatus.STATUS_UPDATED;
								}
								let escompte = billed.lstBillingRessource[i].billingRessourceDatas[j].escompte;
								let productPrice = billed.lstBillingRessource[i].billingRessourceDatas[j].prix ? billed.lstBillingRessource[i].billingRessourceDatas[j].prix : 0;
								let productTax = 0
								let initialPrice = billed.lstBillingRessource[i].billingRessourceDatas[j].getInitialPrice ? billed.lstBillingRessource[i].ressourceDefData.prixBaseInitial : 0;
								billed.lstBillingRessource[i].totalProduct = ((productPrice * billed.lstBillingRessource[i].nbOrdered) + initialPrice).toFixed(2);
								productPrice = productPrice * billed.lstBillingRessource[i].nbOrdered + initialPrice;
								productPrice = productPrice - (productPrice * escompte);
								for(k = 0; k<billed.lstBillingRessource[i].billingRessourceDatas[j].billingRessourceDataTaxes.length; k++){
									let key = billed.lstBillingRessource[i].billingRessourceDatas[j].billingRessourceDataTaxes[k].nameFr ?
										billed.lstBillingRessource[i].billingRessourceDatas[j].billingRessourceDataTaxes[k].nameFr : billed.lstBillingRessource[i].billingRessourceDatas[j].billingRessourceDataTaxes[k].nameEn 
									scope.selectedTaxes[key] ? true : scope.selectedTaxes[key] = angular.copy(billed.lstBillingRessource[i].billingRessourceDatas[j].billingRessourceDataTaxes[k]);
									let tax = scope.selectedTaxes[key].taux;
									scope.selectedTaxes[key].totalTaxe ? scope.selectedTaxes[key].totalTaxe += productPrice * tax : scope.selectedTaxes[key].totalTaxe = productPrice * tax;
									scope.selectedTaxes[key].taxableProduct ? scope.selectedTaxes[key].taxableProduct += productPrice : scope.selectedTaxes[key].taxableProduct = productPrice;
									productTax += productPrice * tax;
								}
								totalTax += productTax;//72.37 12.15
								totalPreTax += productPrice;
							}
						}
					}
					billed.totalPreTaxe = roundNumber(totalPreTax).toFixed(2);
					billed.totalTaxe = roundNumber(totalTax).toFixed(2);
					billed.grandTotal = roundNumber(totalPreTax + totalTax).toFixed(2);
					billed.solde = roundNumber(totalPreTax + totalTax).toFixed(2);
				}
				
				scope.cancelEdit = function(){
					scope.options.unregisterDirty();
					scope.options.switchTab("history");
				}
				
				scope.saving = false				
				scope.saveBilled = function(){
					if(checkForError()){
						scope.saving = true;
						billedList = prepareBilledForSave();
						return ressourceAccessor.billedSave(billedList, function(res){
							scope.saving = false;
							scope.options.unregisterDirty();
							for(i=0; i<res.length;i++){
								res[i].lstBillingRessource = res[i].lstBillingRessource.filter((e)=>e.billingRessourceDatas && e.billingRessourceDatas.length>0);
								res[i].selected = true;
								restoreServiceType(res[i])
								scope.options.addToList(res[i]);
							}
							scope.options.switchTab("history");
							model.notice().success($filter('translate')("SaveSuccess"));
							model.invoiceUpdated(true);
						});
					}else{
						var msg = 'PatientSaveInvalidForm';
						model.invoiceUpdated(true);
//						model.notice().fail($filter('translate')(msg));
						return $q(function(resolve, reject) {
							reject($filter('translate')(msg));
						});
					}
				}
				scope.saveAndPayBilled = function(){
					if(checkForError()){
						scope.saving = true;
						billedList = prepareBilledForSave();
						return ressourceAccessor.billedSave(billedList, function(res){
							scope.saving = false;
							scope.options.unregisterDirty();
							for(i=0; i<res.length;i++){
								res[i].lstBillingRessource = res[i].lstBillingRessource.filter((e)=>e.billingRessourceDatas && e.billingRessourceDatas.length>0);
								restoreServiceType(res[i])
								scope.options.addToList(res[i]);
							}
							scope.options.selectBilledList(res);
							scope.options.switchTab("pay");
							model.notice().success($filter('translate')("SaveSuccess"));
							model.invoiceUpdated(true);
						});
					}else{
						var msg = 'PatientSaveInvalidForm';
						model.invoiceUpdated(true);
//						model.notice().fail($filter('translate')(msg));
						return $q(function(resolve, reject) {
							reject($filter('translate')(msg));
						});
					}
				}
				
				function restoreServiceType(res){
					for(let i=0; i < res.length; i++){
						res[i].ressourceDefData.serviceType = ressDataMap[res.ressourceDefData.id]
					}
				}
				
				scope.noRessSelected = false;
				scope.mustEnterRate = false;
				function checkForError(){
					containError = false;
					if(scope.saving) containError = true;
					if(!scope.invoiceFrm.$valid){
						containError = true;
						scope.mustEnterRate = true;
					}
					if(!scope.billed.lstBillingRessource || scope.billed.lstBillingRessource.length == 0){
						containError = true;
						scope.noRessSelected = true;
					}
					return !containError
				}
				
				var ressDataMap = {}
				function prepareBilledForSave(){
					var billedMap= {};
					for(i = scope.billed.lstBillingRessource.length - 1; i >= 0; i--){
						if(!ressDataMap[scope.billed.lstBillingRessource[i].ressourceDefData.id]){
							ressDataMap[scope.billed.lstBillingRessource[i].ressourceDefData.id] = scope.billed.lstBillingRessource[i].ressourceDefData.serviceType;
						}
						if(scope.billed.lstBillingRessource[i].billingRessourceDatas.length<1){
							delete scope.billed.lstBillingRessource[i];
						}else if(scope.billed.lstBillingRessource[i].idProfessionnalAnchor){
							key = scope.billed.lstBillingRessource[i].idProfessionnalAnchor
							if(!billedMap[key]){
								billedMap[key] = angular.copy(scope.billed)
								billedMap[key].idProfessionnalAnchor = key;
								billedMap[key].lstBillingRessource=[];
								if(scope.billed.idProfessionnalAnchor != key){
									delete billedMap[key].id
									billedMap[key].modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
								}
							}
							billedMap[key].lstBillingRessource.push(scope.billed.lstBillingRessource[i]);
						}else{
							if(!billedMap[0]){
								billedMap[0] = angular.copy(scope.billed)
								billedMap[0].lstBillingRessource = [];
								if(scope.billed.idProfessionnalAnchor){
									delete billedMap[0].id;
									delete billedMap[0].idProfessionnalAnchor;
									billedMap[0].modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
								}
							}
							billedMap[0].lstBillingRessource.push(scope.billed.lstBillingRessource[i])
						}
					}
					billedList = Object.values(billedMap)
					billedList.forEach(billed => updatePrice(billed));
					return billedList;
				}
				
//				init();
				scope.$watch('billedorig', init);
			}
		}
	}]);
	
	ressource.directive('invoicePay', ['model', 'ModificationStatus', '$filter', 'RessourceAccessor', 'PrintAccessor', '$q',
	                               function(model, ModificationStatus, $filter, ressourceAccessor, printAccessor, $q){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ress/invoice_pay.html?v=ay',
			scope:{
                list: '=',
                options: '='
            },
			link: function(scope, element, attrs){
				
				scope.modePaiement = Object.values(model.enums().modePaiement).filter((e)=>(e.type != "FRAIS" && e.type != "PERTE" && e.type != "ANNUL_PMT"));
				
				scope.billedPaid = {
					createdDatetime: moment().valueOf(),
					isDeleted : false,
//					paid : scope.billed.solde,
					modePaiement : "COMPTANT",
					note: "",
					modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
				}
				
				scope.getTotal = function(){
					let total = 0;
					for(let i = 0; i < scope.list.length; i++){
						total +=  scope.list[i].paid;
					}
					return total;
				}
				
				scope.cancelEdit = function(){
					scope.options.unregisterDirty();
					scope.options.switchTab("history");
				}
				
				scope.saving = false;
				scope.saveBilled = function(invoiceFrm){
					if(scope.invoiceFrm.$valid && !scope.saving){
						scope.saving = true;
						prepareBilledForSave()
						return ressourceAccessor.billedSave(scope.list, function(res){
							scope.saving = false;
							scope.options.unregisterDirty();
							updateList(res);
							scope.options.switchTab("history");
							model.notice().success($filter('translate')("SaveSuccess"));
							model.invoiceUpdated(true);
						});
					}else{
						var msg = 'PatientSaveInvalidForm';
						model.invoiceUpdated(true);
						model.notice().fail($filter('translate')(msg))
						return $q(function(resolve, reject) {
							reject($filter('translate')(msg));
						});
					}
				}
				
				scope.saveBilledAndPrint = function(){
					if(scope.invoiceFrm.$valid && !scope.saving){
						scope.saving = true;
						prepareBilledForSave()
						return ressourceAccessor.billedSave(scope.list, function(res){
							scope.saving = false;
							scope.options.unregisterDirty();
							printBilled(res)
							updateList(res);
							scope.options.switchTab("history");
							model.notice().success($filter('translate')("SaveSuccess"));
							model.invoiceUpdated(true);
						});
					}else{
						var msg = 'PatientSaveInvalidForm';
						model.invoiceUpdated(true);
						model.notice().fail($filter('translate')(msg));
						return $q(function(resolve, reject) {
							reject($filter('translate')(msg));
						});
					}
				}
				
				function roundNumber(num){
					return Math.round((num+ Number.EPSILON)*100)/100;
				}
				
				function prepareBilledForSave(){
					for(let i = 0; i < scope.list.length; i++){
						let billedPaid = angular.copy(scope.billedPaid)
						getBilledStatusAndSolde(scope.list[i], billedPaid);
						scope.list[i].modificationStatus = ModificationStatus.STATUS_UPDATED;
						if(!scope.list[i].lstBilledRessourcePaid){
							scope.list[i].lstBilledRessourcePaid = [];
						}
						scope.list[i].lstBilledRessourcePaid.push(billedPaid)
					}
				}
				
				function getBilledStatusAndSolde(billed, billedPaid){
					billedPaid.paid = billed.paid;
					if(billed.solde <= billedPaid.paid){
						billed.status = "PMT_COMPLET";
					}else if(billed.solde > billedPaid.paid){
						billed.status = "PMT_PARTIEL";
					}
					billed.solde = roundNumber(billed.solde - billedPaid.paid).toFixed(2);
					delete billed.paid;
				}
				
				function updateList(billedList){
					for(let i=0; i < billedList.length; i++){
						scope.options.addToList(billedList[i])
					}
				}
				
				function printBilled(billedList){
					if(billedList && billedList.length > 0){
						var data = {
							report : report = {
								id: "client_facturation",
								name: "Facturation",
								printMode: "ACTUAL_SIZE",
								properties: [],
							},
							type : "billedRessource",
							billed : billedList,
						}
						printAccessor.print(data, function(res){
							
						}, function(){
							model.notice().fail($filter('translate')(res.msg));
						});
					}
				}
				
				scope.getDateBilled = function(date){
					return moment(date).format('YYYY-MM-DD');
				}
				
				scope.options.registerDirty(scope.saveBilled);
				
			}
		}
	}]);
	
	ressource.directive('searchRessDef', ['$filter','$q', 'model','ProfAccessor', 'RessourceAccessor', '$translate', 'ModificationStatus', 'FlView',
							function($filter, $q, model, ProfAccessor, ressourceAccessor, $translate, ModificationStatus, FlView){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
                billing: '=?',
                options: '=?',
                showNew: '=?',
                blur: '=?',
                date: '=?',
			},
			template:'<span class="input-group input-group-md col-xs-12"><input type="text" data-ng-blur="getOrigName()" style="width:100%" data-dyna-assist="ressSearchAssist" data-ng-model="model" data-input-focus-function="focus" ignore-dirty>'+
			'<span id="addNewPatient" class="input-group-addon fa-button-group plus-data-item" data-ng-click="addRessDefData()" data-ng-if="showNew">'+
			'<i class="fa fa-plus fa-fw" aria-hidden="true"></i></span></span>',
			link: function(scope, element, attrs){

				scope.taxes = model.ress().taxes;
				function ressDefDataName(ress){
					var name = "";
					if ($translate.use()=='en') {
	                    name = ress.nameEn;
	                    if(!name || name.length == 0){
							name = ress.nameFr;
						}
	                }else{
						name = ress.nameFr;
						if(!name || name.length == 0){
							 name = ress.nameEn;
						}
					}
					var prix = 'variable';
					if(ress.prixBaseInitial && ress.prixParUnit){
						prix =  ress.prixBaseInitial + " + " + ress.prixParUnit + "/" +$filter('translate')(ress.unit);
					}else if(ress.prixBaseInitial){
						prix = ress.prixBaseInitial;
					}else if(ress.prixParUnit){
						prix = ress.prixParUnit + "/" +$filter('translate')(ress.unit)
					}
					tax = scope.taxes.find(e => e.id == ress.idTax);
	                return name + ', ' + ((tax && tax.code) ? (tax.code + ', '): "")  + prix;
                }
                
                function ressName(ress){
					var name = "";
					if ($translate.use()=='en') {
	                    name = ress.nameEn;
	                    if(!name || name.length == 0){
							name = ress.nameFr;
						}
	                }else{
						name = ress.nameFr;
						if(!name || name.length == 0){
							 name = ress.nameEn;
						}
					}
	                return name;
                }
                
                scope.getOrigName = function(){
					if(scope.blur){
						scope.blur(scope.billing)
					}
				}

                scope.options = $.extend(defaultOptions, scope.options);

				var defaultOptions = {
                    searchType: 'server',//['server', 'localCache']
                    minChar: 0,
                }
				
				scope.addRessDefData = function(){
					ressDefData = {
						isDeleted: false,
						lstRessourceDefData: [],
						createdDatetime: Date.now(),
						modificationStatus: ModificationStatus.STATUS_NEW_UPDATED,
						nameFr:($translate.use()!='en' && scope.model) ? scope.model : "",
						nameEn: ($translate.use()=='en' && scope.model) ? scope.model : "",
						unit: "ITEM",
						status: "DISPONIBLE",
						prixBaseInitial: 0,
						prixParUnit: 0,
						recycleTime: 0,
						escompteMax: 0,
						unitTime: 0,
					}
					var qconfirmOptions = {
						templateUrl: "/dashboard/resources/ofys/ress/ressdefdata_edit.html?v=ay",
						orig: ressDefData,
						resDefData: angular.copy(ressDefData),
						ressStatus: Object.values(model.enums().ressStatus),
						ressUnit: Object.values(model.enums().ressUnit),
						showMoreOption: false,
						select: function(ress){
							scope.ress = ress;
							scope.ressDef = ress.lstRessourceDef.find(e => e.isDeleted == 0 && e.tarifFin >= moment().format('YYYYMMDD'));
							return ressName(ress)
						},
						getRessDef: function(){
							return scope.ress ? scope.ress.lstRessourceDef : [];
						},
						checkIfNew: function(resDefData){
							return resDefData.modificationStatus == ModificationStatus.STATUS_NEW_UPDATED;
						},
						lstProf: $filter('orderBy')(model.store.profs.filter.treating.list(), ['lastName', 'firstName']),
						fl: {},
						ok: function(){
							if(this.templateSectionFrm && this.templateSectionFrm.$valid && scope.ress && (this.resDefData.nameFr || this.resDefData.nameEn)){
								let ressDefIndex = scope.ress.lstRessourceDef.indexOf(scope.ressDef);
								this.resDefData.prixBaseInitial = typeof this.resDefData.prixBaseInitial == 'string' ? this.resDefData.prixBaseInitial.replace(/,/g, '.') : this.resDefData.prixBaseInitial;
								this.resDefData.prixParUnit = typeof this.resDefData.prixParUnit == 'string' ? this.resDefData.prixParUnit.replace(/,/g, '.') : this.resDefData.prixParUnit;
								if(this.resDefData.escompteMax > 1){
									this.resDefData.escompteMax = this.resDefData.escompteMax/100;
								}
								scope.ress.lstRessourceDef[ressDefIndex].lstRessourceDefData.push(this.resDefData)
								scope.resDefData = this.resDefData;
								scope.ress.modificationStatus = ModificationStatus.STATUS_UPDATED;
								scope.cancel = this.fl.cancel;
								ressourceAccessor.ressourceSave(scope.ress, function(ress){
									if(scope.select){
			                            var ressDefData = ress.lstRessourceDef[ressDefIndex].lstRessourceDefData.find(e => e.createdDatetime == scope.resDefData.createdDatetime);
			                            scope.cancel();
			                            return scope.select(ressDefData, scope.billing);
									}
								})
							}else if(!this.resDefData.nameFr && !this.resDefData.nameEn){
								this.fl.frm.errorMsgs = [{msg: 'errorNameSelected', type: 'error'}];
								model.actUpdated(true);
							}else if(!scope.ress){
								this.fl.frm.errorMsgs = [{msg: 'errorCategorySelected', type: 'error'}];
							}else{
								this.fl.frm.errorMsgs = PatientFormService.getFormErrors(this.fl.frm)
								model.actUpdated(true);
							}
						},
					}
					FlView.open(qconfirmOptions, {windowClass:'editRessmodal', backdrop:'static'}).then(function(){});
				}
				
				scope.ressSearchAssist = {
					// assistId: "autocomplete_patient_professional",
					nextTabOnTab: true,
					hasDetails: false,
					hasHeader: false,
					keepOnScreen: true,
					dynaType: document.getElementsByTagName("BODY")[0],
//					detailsOnLeft:true,
					minChar: 0,
					trigger: 'focus',
					onOpen:function(dxA){
						if(scope.options && scope.options.fixPositioning){
							scope.options.fixPositioning(dxA);
						}
					},
					getAsyncData: function(query, assist){
                        return $q(function(resolve, reject) {
							let criteria = {
								name : query,
								activeDefData: true,
								date: scope.date ? scope.date : moment().valueOf(),
							}
							ressourceAccessor.getRessDefDataByCriteria(criteria, function(res){
								if(res.data.success===false){
									model.notice().warn(res.data.ms);
									resolve([])
								}else{
									resolve(res.data);
								}
							})
                        });
					},
					getKey: function(ress) {
						return ressDefDataName(ress);
					},
					selection: function(ress, assistObject) {
						if(scope.select){
                            if(!scope.$$phase) {
                                scope.$digest();
                            }
                            return scope.select(ress, scope.billing);
						}
                        return ressDefDataName(ress);
					}
				}
				
			}
        }
    }]);
    
    ressource.directive('searchRess', ['$filter','$q', 'model','ProfAccessor', 'RessourceAccessor', '$translate', 'ModificationStatus', 'FlView',
							function($filter, $q, model, ProfAccessor, ressourceAccessor, $translate, ModificationStatus, FlView){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
                options: '=?',
			},
			template:'<input type="text" style="width:100%" data-ng-blur="blur" data-dyna-assist="ressSearchAssist" data-ng-model="model" data-input-focus-function="focus" ignore-dirty>',
			link: function(scope, element, attrs){

				function ressName(ress){
					var name = "";
					if ($translate.use()=='en') {
	                    name = ress.nameEn;
	                    if(!name || name.length == 0){
							name = ress.nameFr;
						}
	                }else{
						name = ress.nameFr;
						if(!name || name.length == 0){
							 name = ress.nameEn;
						}
					}
	                return name;
                }

                scope.options = $.extend(defaultOptions, scope.options);

				var defaultOptions = {
                    searchType: 'server',//['server', 'localCache']
                    minChar: 0,
                }
				
				scope.ressSearchAssist = {
					// assistId: "autocomplete_patient_professional",
					nextTabOnTab: true,
					hasDetails: false,
					hasHeader: false,
					keepOnScreen: true,
					dynaType: document.getElementsByTagName("BODY")[0],
//					detailsOnLeft:true,
					minChar: 0,
					trigger: 'focus',
					getAsyncData: function(query, assist){
                        return $q(function(resolve, reject) {
							let criteria = {
								name : query,
								activeDefData: true,
							}
							ressourceAccessor.getRessByCriteria(criteria, function(res){
								if(res.data.success===false){
									model.notice().warn(res.data.ms);
									resolve([])
								}else{
									resolve(res.data);
								}
							})
                        });
					},
					getKey: function(ress) {
						return ressName(ress);
					},
					selection: function(ress, assistObject) {
						if(scope.select){
                            if(!scope.$$phase) {
                                scope.$digest();
                            }
                            return scope.select(ress, scope.billing);
						}
                        return ressName(ress);
					}
				}
				
			}
        }
    }]);
	
})();