(function(){
    var prof = angular.module('prof', []);

    prof.factory('ProfAccessor', ['DashAPI','MessageLink', 'model','Store','$translate',
        function(DashAPI, MessageLink, model, Store, $translate) {
            var accessor = {

                getSearchCriteria: function (q, type, isWebSearch, prov, returnOneOrNone){
                    type = type !== undefined ? type: -1;//TYPE_TREATING_ALL
                    isWebSearch =  isWebSearch  !== undefined ? isWebSearch: false;
                    prov =  prov  !== undefined ? prov : model.prefSettings('user_settings_SearchMdProvNB') ? 'NB':'QC';
                    returnOneOrNone =  returnOneOrNone  !== undefined ? returnOneOrNone : false;
                    return {
                        text: q,
                        //XProfessionnal TreatingType TYPE_TREATING_NONE = -1;TYPE_TREATING_ALL = 0;TYPE_TREATING_APPOINTMENT = 1;
                        //TYPE_TREATING_BILLING = 2;TYPE_TREATING_ENCOUNTER = 4;TYPE_TREATING_PRESCRIPTION = 8;TYPE_TREATING_AZIMUTH = 16;TYPE_TREATING_SCANNING = 32; 
                        type:type,
                        isWebSearch:isWebSearch,
                        returnOneOrNone:returnOneOrNone,
                        webProvince:prov, //QC(0), NB(1);
                        isActive: true
                    }
                },
                getCacheProfs:function(callback,error){
                    return DashAPI.get('dashboard/Prof/ws/profs' ,callback, error);
                },
                findBaseProfById:function(id,callback,error){
                    return DashAPI.get('/dashboard/Prof/ws/findBaseProfById?id='+id ,callback, error);
                },
                findProfById:function(id,callback,error){
                    return DashAPI.get('/dashboard/Prof/ws/findProfById?id='+id ,callback, error);
                },
                search:function(option,callback,error){
                    return DashAPI.post('/dashboard/Prof/ws/search',option,callback, error);
                },
                create: function(prof, callback, error){
                    return DashAPI.post('/dashboard/Prof/ws/create', prof, callback, error);
                },
                profTypesInUse: function(callback, error){
                    return DashAPI.get('/dashboard/Prof/ws/prof/typesinuse', callback, error);
                },
                save: function(data, callback, error){
                    return DashAPI.post('/dashboard/Prof/ws/save?question='+data.question, data.prof, callback, error);
                },
                getNbPatientToReplaceProv: function(fromId, callback, error){
                    return DashAPI.get('/dashboard/Prof/ws/getNbPatientToReplaceProv?from='+fromId, callback, error);
                },
                doPatientToReplaceProv: function(obj, callback, error){
                    return DashAPI.get('/dashboard/Prof/ws/doPatientToReplaceProv?from='+ obj.from +'&to=' + obj.to, callback, error);
                },
            }
        return accessor;
    }]);


	prof.directive('profPicker', ['Store', function(Store){
		return {
			restrict: 'E',
            templateUrl:'/dashboard/resources/ofys/prof/prof_picker.html?v=bh',
            scope:{
                onselect: '=',
                model: '=?',
                options: '=?',
            },
			link: function(scope, element, attrs){
                scope.list = Store.profs.filter.appointment.list().sort(function(a,b){
                    return a.lastName.localeCompare(b.lastName);
                });

                scope.select = function(md){
                    if(scope.onselect){
                        scope.onselect(md);
                    }
                    scope.model = md;
                }

            }
        }
    }]);


	prof.directive('multiProfPicker', ['Store', 'model','$timeout', 'AppointmentAccessor',function(Store, model, $timeout, AppointmentAccessor){
		return {
			restrict: 'E',
            templateUrl:'/dashboard/resources/ofys/prof/multi_prof_picker.html?v=bh',
            scope:{
                onselect: '=',
                add:'=',
                remove:'=',
                scheduleDate: '=?',
                model: '=?',
                config: '=?',
                options: '=?',
            },
			link: function(scope, element, attrs){
                scope.store = model.schedule().store;
                scope.list = Store.profs.filter.appointment.list().sort(function(a,b){
                    return a.lastName.localeCompare(b.lastName);
                });
                scope.selected = {};
                function updateSelectedList(){
                    if(scope.model != undefined && scope.model.length > 0){
                        for (let i = 0; i < scope.model.length; i++) {
                            scope.selected[scope.model[i].id] = true;
                        }
                    }
                }
                updateSelectedList();
                scope.select = function(md){
                    if(scope.onselect){
                        scope.onselect(md);
                    }
                    scope.model = md;
                }
                $timeout(function(){
                    if(scope.config != undefined){
                        scope.config.togglePicker = scope.toggleDropDown;
                    }
                }, 0);

                scope.toggleProfWithScheduleFilter = function(){
                    // scope.store.profWithSchedule =!scope.store.profWithSchedule;
                    AppointmentAccessor.getProfessionalsWithSchedule(scope.scheduleDate, function(list){
                        if(typeof list == "string"){
                            list = JSON.parse(list);
                        }
                        if(Array.isArray(list)){
                            var selectedProfs = Object.keys(scope.selected).filter(function(e){return scope.selected[e];});
                            for (let i = 0; i < selectedProfs.length; i++) {
                                scope.updateActiveProfs(Store.profs.filter.appointment.index[selectedProfs[i]])
                            }
                            for (let i = 0; i < list.length; i++) {
                                const prof = Store.profs.filter.appointment.index[list[i]] ;
                                if(prof != null && inSite(prof, model.user().session.workSite)){
                                    scope.updateActiveProfs(prof);
                                }
                            }
                        }
                    })
                }

                function inSite(prof, site){
                    if(site != null && site.id != null && prof.sites != null && prof.sites.length > 0){
                        for (let i = 0; i < prof.sites.length; i++) {
                            if(site.id == prof.sites[i].idSite){
                                return true;
                            }
                        }
                    }
                    return false;
                }
                function addSelected(item){
                    if(scope.model && scope.model.indexOf(item) == -1){
                        scope.model.push(item)
                    }
                    if(scope.add){
                        scope.add(item);
                    }
                }
                function removeSelected(item){
                    if(scope.model && scope.model.indexOf(item) == -1){
                        scope.model.push(item)
                    }
                    if(scope.remove){
                        scope.remove(item);
                    }
                }

                scope.updateActiveProfs = function(item){
                    if(!scope.selected[item.id]){
                        scope.selected[item.id] = true;
                        addSelected(item);
                    }else{
                        scope.selected[item.id] = false;
                        removeSelected(item);
                    }
                }

            }
        }
    }]);

	prof.directive('searchProf', ['$filter','$q', 'model','ProfAccessor',
		function($filter, $q, model, ProfAccessor){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
                filter: '=?',
                options: '=?',
				flview: '=?',
				obj: '=?'
				
			},
			template:'<input type="text" data-dyna-assist="professionalSearchAssist" data-ng-model="model" data-input-focus-function="focus" ignore-dirty></input>',
			link: function(scope, element, attrs){
				var lstProfs = model.store.profs.filter.treating.list();
				lstProfs = $filter('filter')(lstProfs, scope.filter, true);
				scope.lstProfs = $filter('orderBy')(lstProfs, ['lastName', 'firstName']);
				scope.lstProfs.splice(0, 0, {});
				function profName(prof){
					return prof.lastName + ', '+ prof.firstName;
                }
                
                var defaultOptions = {
                    searchType: 'localCache',//['server', 'localCache']
                    minChar: 0,
                }

                scope.options = $.extend(defaultOptions, scope.options);
				if(scope.flview){
					scope.focus();
				}
				
				var openProfSearch = function(){
					FlView
					.open({templateUrl: "/dashboard/resources/ofys/pat/profil/search_prof.html?v=bh"}, {windowClass:'top-modal1'})
					.then(function(prof){
						mObj.selectedProf.idProfessionnal = prof.id;
					});
				};
				
				scope.professionalSearchAssist = {
					// assistId: "autocomplete_patient_professional",
					nextTabOnTab: true,
					hasDetails: false,
					hasHeader: false,
					keepOnScreen: true,
					dynaType: document.getElementsByTagName("BODY")[0],
					// detailsOnLeft:true,
					minChar: scope.options.minChar,
					trigger: 'focus',
					getAsyncData: function(query, assist){
                        if(scope.options.searchType === 'server'){
                            return ProfAccessor.search(ProfAccessor.getSearchCriteria(query));
                        }else{
                            return $q(function(resolve, reject) {
                                resolve($filter('filter')(scope.lstProfs, query, scope.filter));
                            });
                        }
					},
					getKey: function(prof) {
						return prof.lastName + ', '+ prof.firstName + ' (' + prof.code + ')';
					},
					selection: function(prof, assistObject) {
						if(scope.select){
                            if(!scope.$$phase) {
                                scope.$digest();
                            }
                            return scope.select(prof, scope.obj);
						} 
                        return profName(prof);
					}
				}
			}
        }
    }]);

prof.directive('searchProfAll', ['$filter','$q', 'model','ProfAccessor', 'UserAccessor',
		function($filter, $q, model, ProfAccessor, UserAccessor){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
                filter: '=?',
                options: '=?',
			},
			template:'<input type="text" data-dyna-assist="professionalSearchAssist" data-ng-model="model" data-input-focus-function="focus" ignore-dirty></input>',
			link: function(scope, element, attrs){
//				var lstProfs = model.store.allProfs.list();
//				lstProfs = $filter('filter')(lstProfs, scope.filter, true);
//				scope.lstProfs = $filter('orderBy')(lstProfs, ['lastName', 'firstName']);
//				scope.lstProfs.splice(0, 0, {});
				function profName(prof){
					return prof.lastName + ', '+ prof.firstName;
                }
                
                var defaultOptions = {
                    searchType: 'localCache',//['server', 'localCache']
                    minChar: 0,
                }

                scope.options = $.extend(defaultOptions, scope.options);

				var openProfSearch = function(){
					FlView
					.open({templateUrl: "/dashboard/resources/ofys/pat/profil/search_prof.html?v=bh"}, {windowClass:'top-modal1'})
					.then(function(prof){
						mObj.selectedProf.idProfessionnal = prof.id;
					});
				};
				
				scope.professionalSearchAssist = {
					// assistId: "autocomplete_patient_professional",
					nextTabOnTab: true,
					hasDetails: false,
					hasHeader: false,
					keepOnScreen: true,
					dynaType: document.getElementsByTagName("BODY")[0],
					// detailsOnLeft:true,
					minChar: 2,
					trigger: 'focus',
					getAsyncData: function(query, assist){
						if(query.trim().length > 1){
	                        return $q(function(resolve, reject) {
								let criteria = {isProfessionnal: true, text: query}
								UserAccessor.searchProfiles(criteria, function (searchResults){
									UserAccessor.getSearchProfilesPage({referenceId: searchResults.referenceId, pageNumber: 1, nbItemsPerPage:searchResults.total }, function(res){
										resolve($filter('orderBy')(res, ['lastName', 'firstName']));
									});
								});
	                        });
                        }else{
							assist.config.emptyListText = $filter('translate')(query && isOk ? "PatientSearchEnterToSearch": "PatientSearchInvalid");								
							resolve([]);
						}
					},
					getKey: function(prof) {
						return prof.lastName + ', '+ prof.firstName + ' (' + prof.code + ')';
					},
					selection: function(prof, assistObject) {
						if(scope.select){
                            if(!scope.$$phase) {
                                scope.$digest();
                            }
                            return scope.select(prof);
						}
                        return profName(prof);
					}
				}
			}
        }
    }]);
    

	prof.controller('SearchProfController', ['$scope', 'model','ProfAccessor','$filter', 'QConfirm','$timeout',
        function($scope, model,ProfAccessor, $filter, QConfirm, $timeout){
        $scope.vb = {};
        $scope.submitProf = function(prof){
            if(prof && prof.id !== undefined){
                $scope.fl.ok(prof);
            }else {
                ProfAccessor.search( ProfAccessor.getSearchCriteria(prof.code), onResolveByCode);
                
                function onResolveByCode(res) {
                    if(!res || !res.data || res.data.length === 0){
                        QConfirm.open({title: $filter('translate')('webProfCreate')}).then(onConfirmCreate);
                    }else if(res && res.data && res.data.length > 0){
                        $scope.fl.ok(res.data[0]);
                    }
                }
                function onConfirmCreate(create) {
                    if(create){
                        ProfAccessor.create( prof, onCreate)
                    }else{
                        // continueAction();
                    }
                }
                function onCreate(res) {
                    if(res && res.data && res.data.id){
                        $scope.fl.ok(res.data);
                    }
                }
            }
            
        }

        $scope.localprofGridOptions = {
            data: [],
            multiSelect: false,
            enableRowSelection: true,
            enableRowHeaderSelection: false,
            noUnselect: true,
            modifierKeysToMultiSelect: false,
            columnDefs: [
                        //  { name: 'id', displayName: 'id' , width: "*"},
                        { name: 'firstName', displayName: $filter('translate')('FirstName'), width: "150"},
                        { name: 'lastName', displayName:  $filter('translate')('Name'), width: "150"},
                        { name: 'code', displayName:  $filter('translate')('code'), width: "80"},
                        { name: 'isProfTx', cellTemplate:'<div class="ui-grid-cell-contents center"><i ng-if="COL_FIELD" class="fa fa-check"></i></div>', displayName:  $filter('translate')('treating'), width: "100"},
                        { name: 'street', displayName:  $filter('translate')('Street'), width: "150"},
                        { name: 'cityName', displayName:  $filter('translate')('City'), width: "150"},
                        { name: 'note', displayName:  $filter('translate')('Note'), cellTooltip: function(row, col) {
                            return row.entity.note;
                        }, width: "*"},
                    ]
        };
        $scope.profGridOptions = angular.copy($scope.localprofGridOptions);
        $scope.webProfGridOptions = {
            data: [],
            multiSelect: false,
            enableRowSelection: true,
            enableRowHeaderSelection: false,
            noUnselect: true,
            modifierKeysToMultiSelect: false,
            columnDefs: [
                            { name: 'str', displayName: 'Result' , width: "*"}
                        ]
        };
        $scope.refreshOptions=function(){
            $scope.profGridOptions =  angular.copy($scope.localprofGridOptions);
            addApi($scope.profGridOptions)
        };
        $scope.search = function(valid){
            if(valid){
                ProfAccessor.search( ProfAccessor.getSearchCriteria($scope.q), function (res) {
                    if(res){
                        $scope.refreshOptions();
                        $scope.profGridOptions.data = res.data;
                        // $scope.gridApi.grid.refresh();
                    }
                })
            }
        }
        $scope.prov = model.prefSettings('user_settings_SearchMdProvNB') ? 'NB':'QC';
        $scope.searchProfessionnalWeb =function(valid){
            if(!model.hasAcceptedWebSearch){
                $scope.askForWebAccess = true;
            }
            if(valid && model.hasAcceptedWebSearch){
                ProfAccessor.search(ProfAccessor.getSearchCriteria($scope.q, -1, true), function (res) {
                    if(!res || !res.data){
                        res = {data: []};
                    }
                    $scope.profGridOptions = angular.copy($scope.webProfGridOptions);
                    addApi($scope.profGridOptions);
                    $scope.profGridOptions.data = res.data;
                });
            }
        };

        $scope.acceptWebSearch = function(){
            model.hasAcceptedWebSearch = true;
            $scope.askForWebAccess = false;
            $scope.searchProfessionnalWeb($scope.profSearch.$valid)
        }
        $scope.refuseWebSearch = function(){
            $scope.askForWebAccess = false;
        }

        $scope.searchFilter = function( renderableRows ){
            if($scope.q){
                var matchers = [];
                $scope.q.toLowerCase().split(' ').forEach( function(key) {
                    matchers.push(new RegExp(key));
                });
                
                renderableRows.forEach( function( row ) {
                    var columnVal = [row.entity.firstName, row.entity.lastName, row.entity.code, row.entity.note ].join(' ').toLowerCase();
                    
                    for(var i =0 ; i < matchers.length; i++){
                        if ( !columnVal.match(matchers[i]) ){
                            row.visible = false;
                            i = matchers.length;//Quit loop on first non match
                        }
                    }
                });
            }
            return renderableRows;
        };
        
        function addApi(gridOption){
            gridOption.onRegisterApi = function( gridApi ) {
                $scope.gridApi = gridApi;
                $scope.gridApi.grid.registerRowsProcessor($scope.searchFilter, 200);
                
                gridApi.selection.on.rowSelectionChanged($scope,function(row){
                    $scope.submitProf(row.entity);
                });
            };
        }
        addApi($scope.profGridOptions);
        $timeout(function(){
            if($scope.vb && $scope.vb.focusSearch){
                $scope.vb.focusSearch()
            }
        }, 50)
    }]);
})()