(function(){
	var patientForm = angular.module('patientForm', []);

	/**
	 * @ngdoc directive
	 * @name patient.directive:patientEdit
	 * @restrict E
	 * @scope
	 * @param {object} patient Pass the patient we want the edit form to open on
	 * @Description
	 * Directive opening the patient edit and creation form.
	 * @example
	 * <patient-edit patient="model.patient().currPatient"><patient-edit>
	 */
	patientForm.directive('patientEdit',
						['utils', '$q', '$timeout', 'model','PatientAccessor','FlView','ModificationStatus', 'ProfAccessor', 'AppointmentAccessor',
						 '$filter','PatientFormService','UserAccessor','QConfirm','QValidation','Rights','QuickView', 'Event', 'Notification',
						 'DashWebSocket', 'DashAPI',
					function(utils, $q, $timeout, model, PatientAccessor, FlView, ModificationStatus, ProfAccessor, AppointmentAccessor,
							 $filter, PatientFormService, UserAccessor, QConfirm, QValidation, Rights, QuickView, Event, Notification,
							 DashWebSocket, DashAPI){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patient_edit.html?v=bh',
			scope: {
				patient: "=",
				options: "=?",
				qv: "=?"
			},
			link: function(scope, element, attrs){
				scope.isReadOnly = false;
				scope.isDirty = false;
				// scope.isAdmin = model.roles().hasOneOfRoles(['ADMIN']); retourne tjrs false...
				scope.isAdmin = model.user().isAdmin;	// est bon.
				scope.editPatientStatus = false;
				//init patient for when its a new patient
				var defaultPatientData = {
					modificationStatus: ModificationStatus.STATUS_NEUTRAL,
					gender:'I',
					version:0,
					tag:0,
					maritalStatus: 0,
					race: 11,
					lstAddress:[],
					lstContactInformation:[],
					lstSites:[],
					viewSites: [],
					viewPharmacies: [],
					lstPatientAlerts:[],
					lstPatientProfessionnal:[],
					lstConsentement:[],
					lstPatientIdentifier:[],
					lstFusionPatient:[]
				};
				var defaultOptions = {
					showExit: false
				};

				if(!scope.options){
					scope.options = {};
				}

				scope.options =  OfysUtils.extendIfNotDefined(scope.options, angular.copy(defaultOptions));
				scope.editPatient = angular.copy(defaultPatientData);

				scope.languageCodes = [{val:0,name:'French'},{val:1,name:'English'},{val:2,name:'Spanish'},{val:3,name:'Other'}];
				scope.allRaces = [
					{val: 0, name: 'Caucasian'},
					{val: 1, name: 'Native'},
					{val: 2, name: 'African'},
					{val: 3, name: 'Latino'},
					{val: 4, name: 'Asian'},
					{val: 5, name: 'Chinese'},
					{val: 6, name: 'Filipino'},
					{val: 7, name: 'Arab'},
					{val: 8, name: 'Japanese'},
					{val: 9, name: 'Korean'},
					{val: 10, name:'Other'},
					{val: 11, name:'Unspecified'}
				];

				UserAccessor.getAllCitizenships(function(citizenships){
					scope.allCitizenships = citizenships;
				});

				scope.allmartialStatus = [
					{val: 0, name: 'N/A'},
					{val: 1, name: 'Single'},
					{val: 2, name: 'Partnership'},
					{val: 3, name: 'Married'},
					{val: 4, name: 'Divorced'},
					{val: 5, name: 'Widowed'}
				];
				var patientSearchTemplate = '/dashboard/resources/ofys/pat/profil/patient_searchItem.html?v=bh';
				utils.getTemplate(patientSearchTemplate);

				scope.getGenderi18n = function(gender){
					if(gender === 'M'){
						return 'SGenderM';
					}else if(gender === 'F'){
						return 'SGenderF';
					}else{
						return 'GenderI';
					}
				}

				var searchPtOptions = {
					onFetch: function (lst){
						if(lst && Array.isArray(lst)){
							var i = lst.findIndex(function(e){return e.id === scope.patient.id});
							if(i > -1){
								lst.splice(i, 1);
							}
						}
						return lst;
					}
				}
				
				var dsqSearchPatHandlerId = Notification.registerHandler('dsqFindCanditade', function(msg){
					scope.searchInDsq = false;
					var status = DashAPI.getSimpleStatus(msg.data.status);
					if(status.severity=='OK'){
						var qconfirmOptions = {
							templateUrl: 'updatePatientDsq_index.html',
							pat: msg.data.obj,
							showMother: !scope.editPatient.motherName,
							showFather: !scope.editPatient.fatherName,
							getDate: function(date){
								return moment(date).format('YYYY-MM-DD');
							},
							getParentName: function(type){
								if(type === 'MOTHER'){
									return $filter('translate')('Mother');
								}else if(type === 'FATHER'){
									return $filter('translate')('Father');
								}
							},
							getGenderName: function(type){
								if(type === 'MALE'){
									return $filter('translate')('SGenderM');
								}else if(type === 'FEMALE'){
									return $filter('translate')('SGenderF');
								}else{
									return $filter('translate')('GenderI')
								}
							},
							qconfirm: {
								yesTitle: "Yes"
							}
						};
						QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(save){
							if(save){
								scope.editPatient.firstName = msg.data.obj.firstName;
								scope.editPatient.lastName = msg.data.obj.lastName;
								scope.editPatient.healthInsuranceNumber = msg.data.obj.nam.value;
								if(msg.data.obj.gender === 'MALE'){
									scope.editPatient.gender = 'M';
								}else if(msg.data.obj.gender === 'FEMALE'){
									scope.editPatient.gender = 'F';
								}
								scope.editPatient.birthDate = moment(msg.data.obj.birthdate).format('YYYY-MM-DD');
								if(msg.data.obj.relations && msg.data.obj.relations.length > 0){
									for(let i=0;i<msg.data.obj.relations.length;i++){
										if(msg.data.obj.relations[i].type == "FATHER" && !scope.editPatient.fatherName){
											scope.editPatient.fatherName = msg.data.obj.relations[i].lastName + ', '+ msg.data.obj.relations[i].firstName;
										}else if(msg.data.obj.relations[i].type == "MOTHER" && !scope.editPatient.motherName){
											scope.editPatient.motherName = msg.data.obj.relations[i].lastName + ', '+ msg.data.obj.relations[i].firstName;
										}
									}
								}
								if(msg.data.obj.address){	
									let address = {
									    street: msg.data.obj.address.street,
									    postalCode: msg.data.obj.address.postalCode,
									    importance: 0,
									    city: {
									        name: msg.data.obj.address.city,
									        isDeleted: 0,
									        modificationStatus: ModificationStatus.STATUS_NEW_UPDATED
									    },
									    province: {
									        name: msg.data.obj.address.state,
									        isDeleted: 0,
									        modificationStatus: ModificationStatus.STATUS_NEW_UPDATED
									    },
									    country: {
									        name: msg.data.obj.address.country,
									        isDeleted: 0,
									        modificationStatus: ModificationStatus.STATUS_NEW_UPDATED
									    },
									    modificationStatus: ModificationStatus.STATUS_NEW_UPDATED
									}
									if(!scope.editPatient.lstAddress)scope.editPatient.lstAddress = [];						
									scope.editPatient.lstAddress.push(address)
								}
								scope.createform.$setDirty();
								setDirty(true);
								model.patientUpdated(true);
							}
						});
					}else{
						if(status.errors && status.errors[0]){
							model.notice().warn($filter('translate')(status.errors[0]));
						}else{
							model.notice().warn($filter('translate')(status.getMessage()));
						}
					}
				}, scope);
				
				scope.searchInDsq = false
				scope.findInDSQ = function(patient){
					scope.searchInDsq = true;
					candidateCriteria = {
						nam: patient.healthInsuranceNumber
					}
					DashWebSocket.sendRequest("/dashboard/dsq/ws/candidate/find", candidateCriteria);
				}

				// scope.patientSearchAssist = {
				// 	assistId: "autocomplete_mother",
				// 	nextTabOnTab: true,
				// 	nextTabOnEnter: true,
				// 	hasDetails: false,
				// 	hasHeader: false,
				// 	trigger: 'focus',
				// 	getAsyncData: function(query, assist){
				// 		query = query.replace(',', '');//make sure that composed names with commas are searchable too
				// 		return $q(function(resolve, reject) {
				// 			if(query.length > 2){
				// 				PatientAccessor.search(b64EncodeUnicode(query), function(res){
				// 					resolve(removeSelfRefPatient(res.data));
				// 				}, angular.noop);
				// 			}else{
				// 				resolve([]);
				// 			}
				// 		});
				// 	},
				// 	getKey: function(recipient) {
				// 		var newScope = scope.$new();
				// 		newScope.item = recipient;
				// 		var res =  utils.getTemplateAndCompileSync(newScope, patientSearchTemplate);
				// 		$timeout(function(){
				// 			if(!newScope.$$phase) {
				// 				newScope.$digest();
				// 			}
				// 		},0);
				// 		return res;
				// 	},
				// 	selection: function(pat, assistObject) {
				// 		scope.editPatient.mother = pat;
				// 		scope.editPatient.motherId = pat.id;
				// 		scope.editPatient.motherName = pat.lastName + ', '+ pat.firstName;
				// 		return scope.editPatient.motherName;
				// 	}
				// };
				scope.selectMother = function(pat){
					scope.editPatient.mother = pat;
					scope.editPatient.motherId = pat.id;
					scope.editPatient.motherName = pat.lastName + ', '+ pat.firstName;
					scope.editPatient.motherHin = pat.healthInsuranceNumber;
					return scope.editPatient.motherName;
				}

				scope.clearRelation = function(relation){
					delete scope.editPatient[relation];
					delete scope.editPatient[relation+"Id"];
					scope.editPatient[relation+"Name"] ="";
					scope.editPatient[relation+"Hin"] ="";
					scope.editPatient[relation+"SofyAccess"] = false;
					scope.editPatient[relation+"SofyAccessLocked"] = false;
					scope.editPatient[relation+"SofyAccessGranted"] = false;
					delete scope.editPatient[relation+"SofyAccessLockedStandby"];
				};

				scope.removeMother = function(){
					if(scope.editPatient.motherId){
						scope.clearRelation('mother')
						scope.createform.$setDirty();
					}
				};
				scope.searchMotherOptions = $.extend(angular.copy(searchPtOptions), {firstChange: scope.removeMother});

				// scope.fatherSearchAssist = angular.copy(scope.patientSearchAssist);
				// scope.fatherSearchAssist.selection = function(pat, assistObject){
				// 	scope.editPatient.father = pat;
				// 	scope.editPatient.fatherId = pat.id;
				// 	scope.editPatient.fatherName = pat.lastName + ', '+ pat.firstName;
				// 	return scope.editPatient.fatherName;
				// };
				scope.selectFather = function(pat){
					scope.editPatient.father = pat;
					scope.editPatient.fatherId = pat.id;
					scope.editPatient.fatherName = pat.lastName + ', '+ pat.firstName;
					scope.editPatient.fatherHin = pat.healthInsuranceNumber;
					return scope.editPatient.fatherName;
				};
				scope.removeFather = function(){
					if(scope.editPatient.fatherId){
						scope.clearRelation('father');
						scope.createform.$setDirty();
					}
				};
				
				scope.searchFatherOptions = $.extend(angular.copy(searchPtOptions), {firstChange: scope.removeFather});
				// scope.tutorSearchAssist = angular.copy(scope.patientSearchAssist);
				// scope.tutorSearchAssist.selection = function(pat, assistObject){
				// 	scope.editPatient.tutor = pat;
				// 	scope.editPatient.tutorId = pat.id;
				// 	scope.editPatient.tutorName = pat.lastName + ', '+ pat.firstName;
				// 	return scope.editPatient.tutorName;
				// };
				scope.selectTutor = function(pat, assistObject){
					scope.editPatient.tutor = pat;
					scope.editPatient.tutorId = pat.id;
					scope.editPatient.tutorName = pat.lastName + ', '+ pat.firstName;
					return scope.editPatient.tutorName;
				};
				scope.removeTutor = function(){
					if(scope.editPatient.tutorId){
						scope.clearRelation('tutor');
						scope.createform.$setDirty();
					}
				};
				scope.searchTutorOptions = $.extend(angular.copy(searchPtOptions), {firstChange: scope.removeTutor});
				// <input type="text" search-prof="selectTreating" data-dyna-assist="professionalSearchAssist"
				// 					data-ng-model="editPatient.treatingProfessionnalFullName"></input>
				scope.selectTreating = function(prof){
					scope.editPatient.treatingProfessionnalCode = prof.code;
					scope.editPatient.treatingProfessionnal = prof.id;
					scope.editPatient.treatingProfessionnalFullName = prof.lastName + ', '+ prof.firstName;
					scope.setFormStatus("dirty");
				}
				// scope.professionalSearchAssist = {
				// 	assistId: "autocomplete_patient_treating_professional",
				// 	nextTabOnTab: true,
				// 	nextTabOnEnter: true,
				// 	hasDetails: false,
				// 	hasHeader: false,
				// 	trigger: 'focus',
				// 	getAsyncData: function(query, assist){
				// 		return $q(function(resolve, reject) {
				// 			resolve($filter('filter')(scope.lstProfs, query));
				// 		});
				// 	},
				// 	getKey: function(prof) {
				// 		return prof.lastName + ', '+ prof.firstName + ' (' + prof.code + ')';
				// 	},
				// 	selection: function(prof, assistObject) {
				// 		scope.editPatient.treatingProfessionnalCode = prof.code;
				// 		scope.editPatient.treatingProfessionnal = prof.id;
				// 		return profName(prof);
				// 	}
				// };
				scope.removeTreating = function(){
					if(scope.editPatient.treatingProfessionnal){
						delete scope.editPatient.treatingProfessionnal;
						delete scope.editPatient.treatingProfessionnalCode;
						delete scope.editPatient.treatingProfessionnalFullName;
						scope.createform.$setDirty();
					}
				};

				scope.viewModeClass = "read";

				scope.changeViewModeClass = function(){
					scope.viewModeClass = scope.viewModeClass === "read"?"edit":"read";
				};

				scope.preferences= {};

				model.addPrefSettings([
					'language','dob', 'numerised', 'sensible','sofy', 'lastVerif', 'lastActivity', 'professional',
					'partner', 'mother', 'father', 'tutor', 'citizenship', 'race', 'civil', 'appMsg', 'childMsg',
					'address', 'contacts', 'otherProf', 'sites', 'ident', 'pharma', 'alerts', 'limitations', 'note',
					'inactive', 'isdead', 'gender', 'popover', 'fusion'
				], scope.preferences, 'ptedit_');

				function elemInEdit(){
					return (scope.formOptions.inEditMode !== undefined && scope.formOptions.inEditMode > 0);
				}
				function elemsValid(){
					var isValid = true;
					for( var i = 0; i < scope.formOptions.inEditMode;){// this is because the viewbag.() decrements the counter
						if(!scope.formOptions.inEditItems[i].viewbag.okToClose()){
							isValid = false;
							i++;// this is because the viewbag.save() decrements the counter
						}else{
							scope.formOptions.inEditItems[i].viewbag.save();
						}
					};
					return isValid;
				}

				scope.extraPatients = {
					files: [],
					current: null,
				}
				scope.extraPatientsByRole = {};
				scope.addNewExtraPatient = function(role){
					var newPatient = {isNew: true, className: "CPatient", viewbag: {limitations:Rights.getConsent()}};
					scope.editExtraPatient(newPatient, role, true);
				}

				scope.extraPatientAlert = false;
				
				function getExtraPatientName(patient, role){
					var res;
					if(patient){
						if(patient.isNew && patient.firstName == null){
							res = $filter('translate')('extraPatient'+role, patient);
						}else if(patient.firstName != null){
							res = $filter('translate')('extraPatient'+role, patient);
						}
					}
					return res;
				}
				scope.scrollTo = function(p) {
					var o = $(p)[0];
					if (o) {
						o.scrollIntoView(true);
					}
				};
				scope.editExtraPatient = function(patient, role, creation){
					if(patient){
						if(scope.extraPatientAlert){
							if(scope.extraPatients.files.length == 0){
								scope.extraPatients.files.push({
									origPat: scope.patient, 
									pat:scope.editPatient, 
									role: 'main',
									active:false, 
									title: getExtraPatientName(scope.editPatient, 'main')
								});
							}
							var currentExtraPatientIndex = scope.extraPatients.files.findIndex(function(e){
								return e.origPat == scope.patient;
							});
							var patientAlreadyOpen = scope.extraPatients.files.findIndex(pat => pat.origPat.id == patient.id) 
							// var extraPatientByRoleIndex = scope.extraPatients.files.findIndex(function(e){
							// 	return e.origPat == patient || (e.origPat);
							// });
							// if(extraPatientByRoleIndex == -1){
							
							if(patientAlreadyOpen == -1){
								var exPat = {
									origPat: patient, 
									role: role,
									originFileIndex: currentExtraPatientIndex,
									active: false,
									title: getExtraPatientName(patient, role)
								}
								scope.extraPatients.files.push(exPat);
								patientAlreadyOpen = scope.extraPatients.files.length - 1;
							}
							setCurrentExtraPatient(scope.extraPatients.files[patientAlreadyOpen], patient);
							scope.scrollTo(".patientEditFormTop")
							// }
						}else{
							scope.extraPatientAlert = true;
							var alertTranslationKey = creation?'extraPatientAlert':'extraPatientAlertEdit';
							var qconfirmOptions = {
								title: $filter('translate')(alertTranslationKey, {creation: creation, name : $filter('translate')('extraPatientAlert'+role, {})}),
								qconfirm: {hideCancel: true}
							};
							QConfirm.open(qconfirmOptions, {windowClass:'top-modal'})
							.then(function(process){
								if(process){
									scope.editExtraPatient(patient, role, creation);
								}
							});
						}
					}
				}

				function setCurrentExtraPatient(exPat, patient){
					if(canChangeExtraPatient()){
						clearActiveExtraPatient();
						setActiveExtraPatient(exPat);
						if(patient){
							loadPatient(patient)
						}
						return true;
					}
					QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}, {windowClass:'top-modal'})
					.then(function(save){
						if(save){
							scope.savePatient().then(e => {return setAndLoadPatient(exPat, patient)});
						} else {
							setAndLoadPatient(exPat, patient)
						}
					});
					return false;
				}
				
				function spliceAndLoadPatient(exPat, origPat){
					setAndLoadPatient(exPat, origPat)
					var i = scope.extraPatients.files.findIndex(function(e){return e == exPat});
					if(i > 0){
						scope.extraPatients.files.splice(i, 1);
					}
				}
				
				function setAndLoadPatient(exPat, patient){
					clearActiveExtraPatient();
					setActiveExtraPatient(exPat);
					if(patient){
						loadPatient(patient)
					} else {
						loadPatient(exPat.origPat);
					}
				}
				
				function canChangeExtraPatient(){
					if(scope.createform.$dirty || scope.isDirty || elemInEdit()){
						return false;
					}
					return true;
				}

				function clearActiveExtraPatient(){
					if(scope.extraPatients.current != null && scope.extraPatients.current > -1){
						scope.extraPatients.files[scope.extraPatients.current].active = false;
					}
					scope.extraPatients.current = null;
				}
				function setActiveExtraPatient(exPat){
					scope.extraPatients.current = scope.extraPatients.files.findIndex(function(e){return e == exPat});
					exPat.active = true;
				}
				scope.closeExtraPatient = function(extraPatient){
					if(canChangeExtraPatient()){
						clearActiveExtraPatient();
						setActiveExtraPatient(scope.extraPatients.files[0]);
						loadPatient(scope.extraPatients.files[0].origPat);
						var i = scope.extraPatients.files.findIndex(function(e){return e == extraPatient});
						if(i > 0){
							scope.extraPatients.files.splice(i, 1);
						}
						return true;
					}
					QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}, {windowClass:'top-modal'})
					.then(function(save){
						if(save){
							scope.savePatient().then(e => {return spliceAndLoadPatient(extraPatient, scope.extraPatients.files[0].origPat)});
						} else {
							spliceAndLoadPatient(extraPatient, scope.extraPatients.files[0].origPat)
						}
					});
					return false;
				}
				
				scope.loadExtraPatient = function(extraPatient){
					if(setCurrentExtraPatient(extraPatient)){
						loadPatient(extraPatient.origPat);
					}
				}

				scope.showPatientDependents = function(){
					// scope.editPatient.tutorSofyAccessLocked = true;
					// scope.editPatient.fatherSofyAccessLocked = true;
					// scope.editPatient.motherSofyAccessLocked = true;
					// scope.editPatient.tutorSofyAccessGranted = true;
					// scope.editPatient.fatherSofyAccessGranted = true;
					// scope.editPatient.motherSofyAccessGranted = true;
					scope.loadingPatientDependents = true;
					PatientAccessor.patientDependents(scope.editPatient.id, function(response){
						scope.editPatient.dependants = response.data;
						scope.loadingPatientDependents = false;
					});
				}

				scope.hasSofyAccess = function(pat){
					return PatientAccessor.hasSofyAccess(scope.editPatient, pat);
				}
				
				scope.checkAgeAndPermission = function(){
					if(scope.editPatient.birthDate != null && scope.editPatient.birthDate != ""){
						var age = moment().diff(scope.editPatient.birthDate, 'years');
						return  age < 14 || scope.editPatient.permanentSofyAccess;
					}else{
						return false;
					}
				}
				scope.unlockSofyAccess = function(guardian){
					scope.editPatient[guardian+"SofyAccessLockedStandby"] = true;
					scope.editPatient[guardian+"SofyAccessLocked"] = false;
					scope.createform.$setDirty();
					// scope.formOptions.setFormStatus("dirty");
				}
				scope.lockSofyAccess = function(guardian){
					scope.editPatient[guardian+"SofyAccessLockedStandby"] = true;
					scope.editPatient[guardian+"SofyAccessLocked"] = true;
					scope.createform.$setDirty();
					// scope.formOptions.setFormStatus("dirty");
				}
				scope.permanentSofyAccessPermission = function(){
					if(scope.editPatient.permanentSofyAccess != false){
						var qconfirmOptions = {
							title: $filter('translate')('sofyPermanentAccessDescription'),
							qconfirm: {hideCancel: true}
						};
						QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(proceed){
							if(!proceed){
								scope.editPatient.permanentSofyAccess = false;
							}
						});
					}
				}
				
				scope.sofyAccessPermission = function(access){
					if(scope.editPatient[access] != false){
						var qconfirmOptions = {
							title: $filter('translate')('sofyAccessDescription'),
							qconfirm: {hideCancel: true}
						};
						QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(proceed){
							if(!proceed){
								scope.editPatient[access] = false;
							}
						});
					}
				}

				scope.closeView = function(){
					// if(scope.formOptions.inEditMode > 0){
					// 	model.notice().fail($filter('translate')('PatientSaveEditModeForm' ));
					// 	return;
					// }
					if(scope.isLoading){
						return scope.waitingForFusionSave = $timeout(function(){
							scope.closeView()
						},50);
					}
					if(scope.createform.$dirty || scope.isDirty || elemInEdit()){
						QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}, {windowClass:'top-modal'})
						.then(function(save){
							if(save){
								scope.savePatient().then(exit); //should change the dirty state to make sure that the second time closing goes through
							}else{
								exit();
							}
						});
					}else{
						exit();
					}
				};
				//expose the close function to allow parent to close the patient edit.
				scope.options.close = scope.closeView;

				function exit(res){
					if(scope.options.exit){
						scope.options.exit();
						unregisterDirty();
					}
				}


                //This function should be normalized and put in quickview function as a helper function
                //It is useful for all quickview activities that need to listen to quickview events
                //especially ones that can have a dirty state
                // - forms, docs, laboratories and eventullly all other items that can be modified
                function addEventsEvent(){
					if(!scope.qv){
						return;// not in quickview mode
					}
					if(!QuickView.eventsActive(scope.qv)){
						return;// event have already been deleted (because of a close or one quickview that triggers another)
					}
                    //Si c'est la première ouverture, créer la variable d'événements
                    if(!scope.qv.ActiveEventsRef){
                        scope.qv.ActiveEventsRef = {};
                    }
                    //Make sure previously created evens are not referred to
                    //Very important to avoid leaks
                    QuickView.removeAllEventHandlers(scope);

                    function onMinimizeOrClose(event, fct) {
                        var act = event.mObj.quickViewData.qvActData;
                        if (registeredDirtyId) {
                            event.stopPropagation();
                            QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}).then(function(save){
                                function continueAction(res){
                                    unregisterDirty();
                                    scope.ignoreChanges = true;
                                    //Makes sure the original action is called again in 'fct()'
                                    //- if changeActivity was the origianl action it should be recalled and
                                    //   the second time the validation message is not shown because scope.ignoreChanges === true
                                    if (fct){
										fct();
									}
                                }
                                function saveFailedCanNotContinue(res){
                                    var errMsg = res.statusText ? res.statusText : "";
                                    model.notice().fail($filter('translate')('docFailedSaveErrMsg', {errMsg: errMsg}));
                                }
                                if(save){
                                    scope.savePatient().then(continueAction, saveFailedCanNotContinue);//should change the dirty state to make sure that the second time closing goes through
                                }else{
                                    exit();
                                    continueAction();
                                }
                            });
                            return true;
                        }
                        return false;
                    }

                    //L'événement existe donc il ne faut pas le recréer
                    if(!scope.qv.ActiveEventsRef.onQvClose){
                        //Ici elle est appeller ajouté aussi-tot que le viewer s'ouvre donc toujours active
                        //Comme le scope n'est pas passé en parametre, le handler est seulement detruit quand le quickview est fermer
                        scope.qv.ActiveEventsRef.onQvClose = Event.on(scope.qv.onQvClose,function(event){
                            onMinimizeOrClose(event, scope.qv.$$close);
                        });
                    }

                    if(!scope.qv.ActiveEventsRef.onQvMinimize){
                        scope.qv.ActiveEventsRef.onQvMinimize = Event.on(scope.qv.onQvMinimize, function(event){
                            if(onMinimizeOrClose(event, scope.qv.$$minimize)){
                                QuickView.removeAllEventHandlers(scope);
                            }
                        }, scope);
                    }

                    //événement de changement d'activité
                    if(!scope.qv.ActiveEventsRef.onQvActivityChange){
                        scope.qv.ActiveEventsRef.onQvActivityChange = Event.on(scope.qv.onQvActivityChange,function(event){
                            var newAct = event.newAct;
                            onMinimizeOrClose(event, function(){
                                if(scope.qv && scope.qv.$$changeActivity && scope.qv.$$changeActivity (newAct)){
                                    model.actUpdated(true);
                                    scope.ignoreChanges = false;
                                    QuickView.removeAllEventHandlers(scope);
                                }
                            });
                        }, scope);
                    }

                    if(!scope.qv.ActiveEventsRef.onQvExternalize){
                        scope.qv.ActiveEventsRef.onQvExternalize = Event.on(scope.qv.onQvExternalize,function(event){
                            QuickView.removeAllEventHandlers(scope);
                        }, scope);
                    }
				}

				//checks patientviewmode and format preferences
				if(model.patientViewMode == 1){
					setTimeout(function(){
						scope.preferences.popover=true;
						scope.preferences.picture=false;
					},0);

				}

				//sets modificationStatus
				// scope.editPatient.modificationStatus= ModificationStatus.STATUS_UPDATED; // pourquoi??? on ne veut pas sauver tout à chaque fois...
				//get needed information in model.user
				scope.sessionUser = model.user().sessionUser;
				scope.lstUsers = model.user().list;
//				.sort(function(o1,o2) {
//                	if (o1.personName && o2.personName) {
//                		return o1.personName.toUpperCase().localeCompare(o2.personName.toUpperCase());
//                	}
//                	return o1.str.localeCompare(o2.str);
//				});
				scope.lstProfs = $filter('orderBy')(model.store.profs.list(), ['lastName', 'firstName']);
//				scope.lstOtherProfs = $filter('orderBy')(model.store.allProfs.list(), ['lastName', 'firstName']);
				
				scope.lstProfs.splice(0, 0, {});
				scope.allsites = model.user().sites;

				//sets form status to dirty or pristine
				scope.setFormStatus = function(status){
					scope.formStatus(status);
					scope.editPatient.modificationStatus = ModificationStatus.STATUS_UPDATED;
				};

				scope.formStatus = function(status){
					scope.isDirty = scope.createform.$dirty;

					if(status === "dirty"){
						scope.isDirty = true;
					}
					else if(status === "pristine"){
						scope.isDirty = false;
					}
				};

				var isFormDirty = false;
				scope.formDirty = function(){
					var dirty = scope.isDirty || (scope.createform && scope.createform.$dirty);
					if(isFormDirty !== dirty){
						if(dirty){
							registerDirty();
						}else{
							unregisterDirty();
						}
					}
					isFormDirty = dirty;
					return isFormDirty;
				};
				scope.options.dirty = scope.formDirty;

				scope.formOptions = {
					setFormStatus: scope.formStatus,
					isReadOnly: scope.isReadOnly,
					inEditMode: 0
				};
				// scope.editAcif = false;
				//type could be 'deceased' or 'inactive'
				// scope.setInactive = function(type){
				// 	if(!scope.editAcif){
				// 		scope.modifyActive = getActiveOptions(type);
				// 		scope.editAcif = true;
				// 	}
				// };
				// scope.activeOptions = {
				// 	viewbag:{
				// 		data: {},
				// 		editFormUrl: '/dashboard/resources/ofys/pat/profil/deceased_modal.html',
				// 		save: function (savedItem) {

				// 		},
				// 		cancel: function () {
				// 			scope.editAcif = false;
				// 		},
				// 	}
				// };

				// function getActiveOptions(type){
				// 	var res = angular.copy(scope.activeOptions);
				// 	if(type === 'deceased')return res;
				// 	res.viewbag.editFormUrl = '/dashboard/resources/ofys/pat/profil/inactive_modal.html';
				// 	res.viewbag.save = function(savedItem){

				// 	};
				// 	return res;
				// }

				function setNoteInactiveText(reason, note){
					var allReasons = ["Other","Deceased","Moving"];
					note = note ? note : "";
					scope.editPatient.note = scope.editPatient.note ? scope.editPatient.note + ' ': scope.editPatient.note;
					scope.editPatient.note = scope.editPatient.note + $filter("translate")("InactiveReason")+
						" : " + $filter("translate")(allReasons[reason])+"/DATE : "+
						scope.editPatient.inactiveDate+"\n"+ note;
				}

				//Open modal if dead
				scope.isDead = function(value){
					var modalData;
					if(value=="false"){
						modalData = {
							editFormUrl: '/dashboard/resources/ofys/pat/profil/not_deceased_modal.html?v=bh',
							isNew: true,
						}
						PatientFormService.editModal(modalData, {backdrop: 'static'}).then(angular.noop, function (save){
							scope.createform.$setDirty();
//							scope.editPatient.isDeleted=false;
							scope.editPatient.inactiveRaison=null;
							scope.editPatient.inactiveDate="";
						});
					}
					else{
						AppointmentAccessor.list({patient:scope.editPatient.id, type:'CFA'}, function(res){
							let deleteAllAppAndRec = false
							if(res.data.haveAppointment || res.data.haveRecall)deleteAllAppAndRec = true
							modalData = {
								editFormUrl: '/dashboard/resources/ofys/pat/profil/deceased_modal.html?v=bh',
								isNew: true,
								data: {
									date: moment().format('YYYY-MM-DD'),
									deleteAllAppAndRec: deleteAllAppAndRec,
									futurApp: res.data.haveAppointment,
									futurRec: res.data.haveRecall
								},
								inactiveDynaDateOptions: {
									acceptFutureDate: true,
									// onDateSelected: function(selectedDate){
									// 	scope.editPatient.inactiveDate = selectedDate;
									// }
								}
							};
							PatientFormService.editModal(modalData, {backdrop: 'static'}).then(angular.noop, function (){
								//if clicked out
								scope.createform.$setDirty();
								scope.editPatient.inactiveRaison=2;
								scope.editPatient.inactiveDate = modalData.data.date;
								scope.editPatient.mustDeleteFutureAppointmentAndRecallOnDelete = modalData.data.deleteAllAppAndRec
								setNoteInactiveText(1);
//								scope.editPatient.note= $filter("translate")("InactiveReason")+" : "+$filter("translate")("Deceased")+"/DATE : "+scope.editPatient.inactiveDate;
							});
						});
					}
				};

				//Reactivates patient
				scope.reactivate=function(){
					scope.createform.$setDirty();
					scope.editPatient.isDeleted=false;
					if (scope.editPatient.inactiveRaison !== 2){	
						scope.editPatient.inactiveRaison=null;
					}
					scope.inactiveDate="";
				};

				//Opens modal to deactivation
				scope.openInactiveModal = function(){
					AppointmentAccessor.list({patient:scope.editPatient.id, type:'CFA'}, function(res){
						let deleteAllAppAndRec = false
						if(res.data.haveAppointment || res.data.haveRecall)deleteAllAppAndRec = true;
						var modalData = {
							editFormUrl: '/dashboard/resources/ofys/pat/profil/inactive_modal.html?v=bh',
							isNew: true,
							data:{ 
								reason: scope.editPatient.inactiveRaison == 2 ? 2 : 1, 
								note:"", 
								date: scope.editPatient.inactiveRaison == 2 ? scope.editPatient.inactiveDate : moment().format('YYYY-MM-DD'),
								futurApp: res.data.haveAppointment,
								futurRec: res.data.haveRecall,
								deleteAllAppAndRec: deleteAllAppAndRec,
							},
							reasonsList: [{val:1,name:'Other'},{val:2,name:'Deceased'},{val:3,name:'Moved'}],
							inactiveDynaDateOptions: {
								acceptFutureDate: true,
								// onDateSelected: function(selectedDate){
								// 	modalData.date = selectedDate;
								// }
							},
							isModal: true
						};
	
						PatientFormService.editModal(modalData, {backdrop: 'static'}).then(angular.noop, function (){
							scope.createform.$setDirty();
							scope.editPatient.isDeleted=true;
							scope.editPatient.mustDeleteFutureAppointmentAndRecallOnDelete = modalData.data.deleteAllAppAndRec
							scope.editPatient.inactiveDate = modalData.data.date;
							scope.editPatient.inactiveRaison = mObj.data.reason;
	
							if(mObj.data.reason > 0 && mObj.data.reason < 4){
								//make sure reason is in base 0 for required array
								setNoteInactiveText(mObj.data.reason - 1, mObj.data.note);
							}
						});
					});
				};
				
				scope.openSensibleAlert = function(){
					if(scope.editPatient.isSensible){
						var qconfirmOptions = {
							title: $filter('translate')('patientSensibleAlert'),
							qconfirm: {
								hideCancel: true,
							}
						};
						QConfirm.open(qconfirmOptions, {windowClass:'top-modal'}).then(function(proceed){
							if(!proceed){
								scope.editPatient.isSensible = false;
							}
						});
					}
				}

				/**
				 *@ngdoc method
				 *@name openProfSearch
				 *@methodOf patient.directive:
				 *@description
				 *This method opens the Professional search window.
				 *When one is selected, returns this professional ID to the patient
				 */
				scope.openProfSearch = function(){
					FlView.open({templateUrl: "/dashboard/resources/ofys/pat/profil/search_prof.html?v=bh"}, {windowClass:'top-modal'}).then(function(prof){
						scope.editPatient.treatingProfessionnal=prof.id;
						scope.setFormStatus("dirty");
					});
				};
				function profName(prof){
					return prof.lastName + ', '+ prof.firstName;
				}
				function loadLimitations(limitations){
					if(limitations && limitations.length > 0){
						limitations.forEach(function(limitation){
							limitation.keys = Rights.updateLimitationTypes(limitation.droits);
						});
					}
				}
				scope.isNotLimited = function(limitation){
					if(scope.patient && scope.patient.viewbag &&
						scope.patient.viewbag.limitations){
						return scope.patient.viewbag.limitations[limitation];
					}
					return false;
				}

				function loadPatient(patient){
					if(scope.patient || patient){ //if existing patient
						model.safeCall(addEventsEvent);
						patient = patient ? patient : scope.patient;

						/** 2024-03-06 This code is to fix an error in prod where the contacts of hub patient have empty entries.
						 * A fix to make sure that empty contacts are no longer added in the database was added in HubServiceBean ligne:645 
						 * Can be removed at a later date if no issues
						 */
						if(patient.isAdhocPatient == true && patient.lstContactInformation != null){
							//remove empty contacts for hub patients (otherwise causes the save patient to fail validations)
							patient.lstContactInformation = patient.lstContactInformation.filter(function(e){return e.contact != null && e.contact != "";})
						}


						if(patient.isNew !== true){
							PatientAccessor.updateMessageLink(patient,scope)
							scope.isReadOnly = patient.id < 0 || patient.viewOnly ? true: false;// Request to desactivate negative value id's for Patient-X some user are modifying and doing patient merges.	
						}else{
							$timeout(function(){
								if(scope.focusWriteName){
									scope.focusWriteName();
								}
							},10);
						}
						//To make sure all defaults are always present
						scope.editPatient = $.extend(angular.copy(defaultPatientData),angular.copy(patient));
						scope.editPatient.viewPharmacies = $filter('filter')(scope.editPatient.lstSites, {addedAs:"DRUG_STORE"});
						scope.editPatient.viewSites = $filter('filter')(scope.editPatient.lstSites, {addedAs:"WORK_SITE"});

						loadLimitations(scope.editPatient.lstConsentement)
						scope.editPatient.viewSites = $filter('filter')(scope.editPatient.lstSites, {addedAs:"WORK_SITE"});
						if(scope.editPatient.treatingProfessionnal){
							var prof = model.store.profs.get(scope.editPatient.treatingProfessionnal);
							if(prof){
								scope.editPatient.treatingProfessionnalFullName =  profName(prof);
								scope.editPatient.treatingProfessionnalCode = prof.code;
							}else{
								ProfAccessor.findProfById(scope.editPatient.treatingProfessionnal, function(res){
									scope.editPatient.treatingProfessionnalFullName =  profName(res.data);
									scope.editPatient.treatingProfessionnalCode = res.data.code;
								})
							}
						}
						if(scope.editPatient.viewbag) delete scope.editPatient.viewbag;

						if(scope.editPatient.motherId && !scope.editPatient.mother){
							PatientAccessor.getPatient(scope.editPatient.motherId, function(res){
								scope.editPatient.mother = res.data;
							});
						}
						if(scope.editPatient.fatherId && !scope.editPatient.father){
							PatientAccessor.getPatient(scope.editPatient.fatherId, function(res){
								scope.editPatient.father = res.data;
							});
						}
						if(scope.editPatient.tutorId && !scope.editPatient.tutor){
							PatientAccessor.getPatient(scope.editPatient.tutorId, function(res){
								scope.editPatient.tutor = res.data;
							});
						}
						if(patient.allIds && scope.isAdmin){
							PatientAccessor.getFusionPatient(scope.editPatient.idPatient, function(res){
								scope.lstFusionPatient = res.data;
								prepareLstFusionPatient(res.data)
							});
						} else {
							scope.lstFusionPatient = [];
						}
						if(patient.isAdhocPatient == true){
							setDirty(true);
						}else{
							setDirty(false);
						}
					}
				}
				scope.$watch(scope.patient, loadPatient);
				
				function prepareLstFusionPatient(data){
					scope.editPatient.lstFusionPatient = []
					if(data){
						data.forEach(basePatient => {
							scope.editPatient.lstFusionPatient.push({
								$$hashKey: basePatient.$$hashKey,
								editMode: false,
								id: basePatient.id,
								idPatient: basePatient.id,
								modificationStatus: ModificationStatus.STATUS_UPDATED,
								patientFullName: basePatient.str,
								viewPatient: basePatient
							})
						})
					}
				}

				function requiresSaveStatusCodeHandle(res, msgList){
					var res = [];
					// var needInfo = _.filter(msgList, function(e){return e && e.severity && e.severity === "NEED_MORE_INFO";})
					if(msgList !== undefined){
						for (var i = 0; i < msgList.length; i++) {
							if(msgList[i].code && handleSaveStatusCodes[msgList[i].code] !== undefined){
								res.push(msgList[i]);
							}
						}
					}
					function saveStatusCodeListPromis(j){
						if(j < res.length){
							handleSaveStatusCodes[res[j].code](res, res[j]).then(function(){
								saveStatusCodeListPromis(j+ 1);
							})
						}
					}
					saveStatusCodeListPromis(0);// start the save status resolution.
					return res;
				}

				var handleSaveStatusCodes = {
					"DUPLICATE_PATIENT": function(res, status){
						var qconfirmOptions = {
							templateUrl: 'selectSavePatient_index.html',
							patients: status.data,
							select: function(pat){
								setDirty(false);
								// if(scope.editPatient.isAdhocPatient && scope.options && scope.options.onSave){
								// 	scope.options.onSave(pat);
								// }
								// model.patient().currPatient = pat;
								processSave(pat,true);
								this.qconfirm.cancel();

							},
							qconfirm: {
								hideNo: true,
								yesTitle: "selectPatientDuplicateRiskNewClient",
								beforeYes: function(e, obj){
									scope.editPatient.askQuestion = false;
									scope.savePatient();
								}
							}
						};
						return QConfirm.open(qconfirmOptions, {windowClass:'top-modal'});
					},
					"IS_SENSIBLE": function(res, status){
						scope.saving = false;
						scope.editPatient.askQuestion = false;
						scope.savePatient();
						return Promise.resolve();
					}
					
				}

				function prepForSave(){
//					if(scope.editPatient.currItem){
//						scope.historyItem = scope.editPatient.currItem
//						delete scope.editPatient.currItem;
//					}
					if(scope.createform.$dirty){
						scope.editPatient.modificationStatus = ModificationStatus.STATUS_UPDATED;
					}
					if(scope.editPatient.healthInsuranceNumber){
						scope.editPatient.healthInsuranceNumber = scope.editPatient.healthInsuranceNumber.replaceAll(" ", "").replaceAll("-", "");
					}
					if(scope.editPatient.expirationCAM){
						scope.editPatient.expirationCAM = scope.editPatient.expirationCAM.replace("-", "").replace("/","")
					}
					if(scope.editPatient.lstConsentement && scope.editPatient.lstConsentement.length > 0 &&
						scope.editPatient.lstConsentement.findIndex(function(x){return x.modificationStatus !== "STATUS_DELETED"}) >-1){
						var usrid = model.user().sessionUser.user.id;
						var consent = scope.editPatient.lstConsentement.findIndex(function(e){return e.idUserAnchor == usrid && e.modificationStatus != "STATUS_DELETED"});
						if(consent < 0){
							scope.editPatient.lstConsentement.push({
							datetimeStart: new Date().getTime(),
							droits: 1,
							idUserAnchor: usrid,
							modificationStatus: "STATUS_NEW_UPDATED"})
						}
					}
					scope.editPatient.lstSites = scope.editPatient.viewSites.concat(scope.editPatient.viewPharmacies);
				}
				
				function prepForSaveLstFusion(){
					lstPat = [];
					scope.editPatient.lstFusionPatient.forEach( element => {
						if(element.modificationStatus != "STATUS_DELETED"){
							lstPat.push(element.viewPatient);
						}
					})
					return lstPat
				}
				
				var registeredDirtyId;

				function registerDirty(){
					registeredDirtyId = "pat_"+scope.editPatient.id;
					QValidation.registerDirty(registeredDirtyId, scope.savePatient, function(){
						return true;
					});
				}

				function unregisterDirty(){
					if(registeredDirtyId){
						QValidation.unregisterDirty(registeredDirtyId);
						registeredDirtyId = undefined;
					}
				}
				function saving(isSaving){
					if(isSaving){
						scope.saving = true;
						scope.isLoading = true;
					}else{
						scope.isLoading = false;
						$timeout(function(){
							scope.saving = false;
						}, 2000);
					}
				}
				scope.savePatientAndClose= function(close){
					scope.savePatient().then(close);
				}
				scope.saving = false;

				function setDirty(isDirty){
					if(isDirty){
						scope.isDirty = isDirty;
					}else{
						scope.createform && scope.createform.$setPristine();
						scope.isDirty = false;
					}
					scope.formDirty();
				}
				
				function saveIfFusionDeleted(){
					return scope.editPatient.lstFusionPatient.some(function(a){return a.modificationStatus == "STATUS_DELETED"});
				}

				/**
				 *@ngdoc method
				 *@name
				 *@methodOf patient.directive
				 *@description
				 *This method saves the patient.
				 *It sends its current patient.
				 *On the callback,it updates the current patient informations,sets form to pristine and sends a notice.
				 */
				scope.savePatient= function(){
					scope.createformErrors = PatientFormService.getFormErrors(scope.createform,null,{expirationcam: "Invalid"});
					if(scope.createform.$valid){
						if(!scope.saving){
							if(elemInEdit()){
								if(!elemsValid()){
									return $q.reject($filter('translate')('patientEditValidationFailed'));
								}
							}
							saving(true);
							prepForSave();
							// return ;
							return PatientAccessor.save(scope.editPatient, function(res){
								var savedElem = res[0];
								//Make sure that the new id is updated if in qv mode..
								//otherwise two groups are created when the patient is opened again.
								if(model.qv().group[scope.editPatient.id]){
									model.qv().group[savedElem.id] = model.qv().group[scope.editPatient.id];
									delete model.qv().group[scope.editPatient.id]
								}
								if(scope.lstFusionPatient && (scope.lstFusionPatient.length != scope.editPatient.lstFusionPatient.length || saveIfFusionDeleted())){		
									fusionPatients = {
										rootPatient: scope.editPatient,
										targetPatients: prepForSaveLstFusion()
									}
									PatientAccessor.saveFusion(fusionPatients, function(res){
										processSave(savedElem);
									}, function(res, msgList) {
										$timeout.cancel(scope.waitingForFusionSave);
										saving()
										let part1 = msgList[0].message.slice(0, 15)
										let part2 = msgList[0].message.slice(-28)
										let patName= msgList[0].message.slice(16, -29);
										model.notice().fail($filter('translate')(part1) + patName + $filter('translate')(part2));
									});
								}else{
									processSave(savedElem);
								}
							}, function(res, msgList){
								//unlock savingPatient function
								saving();
								var moreInfoSaveStatus = requiresSaveStatusCodeHandle(res, msgList);
								if(moreInfoSaveStatus.length === 0){
									model.notice().fail(res.status + ' : ' + $filter('translate')('PatientSaveFailed'));
								}
								throw("Unsaved patient "+res.status)// makes sure that subsequent chained promise functions are alerted of the failed promise.
							});
						}
					}else{
						var msg = 'PatientSaveInvalidForm';

						model.notice().fail($filter('translate')(msg));
						return $q(function(resolve, reject) {
							reject($filter('translate')(msg));
						});
					}
				};
				function roleValuesUpdated(role,pat1, pat2){
					if(pat1.origPat[role+"Id"] != pat2.origPat.id ||
						pat1.origPat[role+"Name"] != pat2.origPat.lastName + ', '+ pat2.origPat.firstName||
						pat1.origPat[role+"Hin"] != pat2.origPat.healthInsuranceNumber){
						return true;
					}else{
						return false;
					}

				}
				function processSave(savedElem, hideMessage){
					loadPatient(savedElem);
					if(scope.extraPatients.current && scope.extraPatients.current != 0){
						let i = scope.extraPatients.current;
						OfysUtils.update(scope.extraPatients.files[i].origPat, savedElem, ['viewbag']);
						if(scope.extraPatients.files[i] && scope.extraPatients.files[i].origPat 
							&& scope.extraPatients.files[i].origPat.viewbag){
							scope.extraPatients.files[i].origPat.viewbag.limitations = Rights.getSessionUserConsent(scope.patient);
						}
						let mainPat = scope.extraPatients.files[i].originFileIndex;
						let role = scope.extraPatients.files[i].role;
						
						if(roleValuesUpdated(role, scope.extraPatients.files[mainPat], scope.extraPatients.files[i])){
							scope.extraPatients.files[mainPat].origPat[role+"Id"] = scope.extraPatients.files[i].origPat.id;
							scope.extraPatients.files[mainPat].origPat[role] = scope.extraPatients.files[i].origPat;
							scope.extraPatients.files[mainPat].origPat[role+"Name"] = scope.extraPatients.files[i].origPat.lastName + ', '+ scope.extraPatients.files[i].origPat.firstName;
							scope.extraPatients.files[mainPat].origPat[role+"Hin"] = scope.extraPatients.files[i].origPat.healthInsuranceNumber;
							scope.extraPatients.files[mainPat].origPat.modificationStatus = ModificationStatus.STATUS_UPDATED;
							saving(true);
							PatientAccessor.save(scope.extraPatients.files[mainPat].origPat, function(res){
								saving();
								updateMainPatient(res[0]);
							}, function(res, msgList){
								saving();
								var moreInfoSaveStatus = requiresSaveStatusCodeHandle(res, msgList);
								if(moreInfoSaveStatus.length === 0){
									model.notice().fail(res.status + ' : ' + $filter('translate')('PatientSaveFailed'));
								}
								throw("Unsaved patient "+res.status)// makes sure that subsequent chained promise functions are alerted of the failed promise.
							})
						}
					}else if (scope.patient) {
						updateMainPatient(savedElem);
					}
					if(hideMessage == null || hideMessage == false){
						model.notice().success($filter('translate')('PatientSaveSuccess'));
					}
//					if(scope.historyItem){
//						scope.patient.viewOnly = true
//						scope.patient.currItem = scope.historyItem;
//					}
					// scope.formDirty()//Certain cases the dirty state is not remove. Must be called to reset.
					setDirty(false);
					model.patientUpdated(true);
					//ajouter au last seen
					if(scope.editPatient.isNew){
						PatientAccessor.setAsUsed(scope.patient.id);
					}

					//unlock savingPatient function
					saving();
					if(scope.options && scope.options.onSave){
						scope.options.onSave(scope.patient);
					}
				}

				function updateMainPatient(savedElem){
					OfysUtils.update(scope.patient, savedElem, ['viewbag', 'hasAnEmail','useContact']);
					if(scope.patient && scope.patient.viewbag){
						scope.patient.viewbag.limitations = Rights.getSessionUserConsent(scope.patient);
					}
				}
				
				scope.options.save = scope.savePatient

				var bCannotEditHin;
				scope.cannotEditHIN = function() {
					// au premier pass, le editPatient n'est pas toujours initialisé
					if (scope.editPatient.lastName && bCannotEditHin == undefined) {
						if (scope.editPatient.fromAppointment===true) {
							delete scope.editPatient.fromAppointment;
							bCannotEditHin = !_.isEmpty(scope.editPatient.healthInsuranceNumber);
						} else {
							bCannotEditHin = scope.options.fromAppointment===true && !_.isEmpty(scope.editPatient.healthInsuranceNumber);					
						}
					}
					return bCannotEditHin;
				};

				//Option object taking care of creating the preferences tooltip
				scope.patientInfoFilterOptions = {
					trigger: 'click',
					closeOnMouseleave: true,
					templateUrl: '/dashboard/resources/ofys/pat/profil/patientInfoFilter.html?v=bh',
					position: {
						x: 'right',
						y: 'center'
					},
					outside: 'x',
					onClose: function(){
						//scope.updateData();
					}
				};

			}
		};
	}]);

	function patientSubFormController($scope, PatientFormService) {
		$scope.qconfirm.okToClose = function(){
			return PatientFormService.okToClose($scope);
		};
		if($scope.selected && $scope.selected.viewbag){
			$scope.selected.viewbag.okToClose = $scope.qconfirm.okToClose;
		}
	}

	patientForm.controller('GenericPatientFrmController',['$scope', 'PatientFormService', patientSubFormController]);
	
	patientForm.factory('PatientFormService', ['QConfirm', '$filter', function(QConfirm, $filter) {
		var service = {
				editModal : function (modalData, opt){

					var modalOptions = {
						windowClass:'top-modal',
						templateUrl: "/dashboard/resources/ofys/pat/profil/editPatientModalForms.html?v=bh",
						backdrop : 'true',
					};

					//make sure options are created extend them with defaults
					opt = opt ? $.extend(modalOptions, opt): modalOptions;

					//Make sure the modal object is created
					modalData.modal = modalData.modal ? modalData.modal: {};
					modalData.qconfirm = modalData.qconfirm ? modalData.qconfirm : {};
					//activate Error messages updates
					modalData.qconfirm = $.extend({messages: {}}, modalData.qconfirm);

					modalData.modal.closing = function(event, reason, closed, modalScope){
						if((reason !== false) && modalScope.qconfirm.okToClose && !modalScope.qconfirm.okToClose()){
							event.preventDefault();
						}
					};

					return QConfirm.open(modalData, opt);
				},
				formStateManager: function (frm, options){
					var manager = this;
					var isDirty = false;
					manager.errors = [];
					
					manager.checkErrors = function(){
						manager.errors = service.getFormErrors(frm,null, options.errorObj);
					}
			
					manager.isValid = function(){
						return frm && frm.$valid;
					}
					// manager.onChange = function(){
					// 	options.onChange && options.onChange();
					// }
			
					function dirtyTransitioned(){
						if(options.registerDirty && options.unregisterDirty){
							isDirty ? options.registerDirty(): options.unregisterDirty();
						}
						(!isDirty) && frm && frm.$setPristine();
					}
					function syncDirty(dirty){
						if(isDirty !== dirty){
							isDirty = dirty;
							dirtyTransitioned();
						}
					}
					manager.dirty = function (status){
						if(arguments.length !== 0){
							syncDirty(status);
						}else{
							syncDirty(isDirty || (frm && frm.$dirty))// verify if the form was changed by user input.
							return isDirty;
						}
					}
					options.watch && options.watch()
					return manager;
				},
				/**
				 * Returns form errors found in the format. All inputs elements should have a name to be detected.
				 * @param {AngularForm} frm corresponds to the form object that is created by angular in the scope.[formname]
				 * @param {*} fnMap Optional: function that formats errors if none is provided the default msg and error type object is returned
				 * @param {*} prefix Optional: Object of prefex to use with different error types eg {errortype: "prefixUsed"}. This is useful to make the translated keys unique in certain contexts.
				 */
				getFormErrors: function(frm, fnMap, prefix){
					var prefixMap = {required: "Missing", min:"MinimalValue",max:"MaximalValue", tel: "Telephone", email: 'Email', maxlength: 'Maxlength', partialDate: 'Partial', checkNarcoticRenewal: 'checkNarcoticRenewal'};

					if(prefix){
						$.extend(prefixMap, prefix);
					}
					if(!fnMap){
						fnMap = function(input){
							if (input.startsWith("$")) {
								return [{msg:$filter('translate')("validationError"), type:'error'}];
							}else if (!frm[input]) {
								return [{msg:"checkint", type:'error'}];
							} else {
								var errorKey = input[0].toUpperCase()+input.substr(1);
								return Object.keys(frm[input].$error).map(function(input){
									var pre = prefixMap[input]?prefixMap[input]:"";
									return {msg:pre+errorKey, type: 'error'};
								});
							}
						};
					}
					var entries = Object.keys(frm).filter(function(elem, i, array){
						// var isInvalid = elem.startsWith("$valid") && frm[elem]===false;
						var isNotString = !elem.startsWith("$");
						if (isNotString===true) {
							return frm[elem].$invalid;
						} else if (elem.startsWith("$valid")){
							return frm[elem]===false;
						}
						return false;
					});

					if (frm.$error && frm.$error.checkint){
						entries.push("checkint");
					}

					if(entries.length > 0){
						entries = entries.map(fnMap)
						.reduce(function(pre,ele){
							return pre.concat(ele);
						});
					}
					return entries;
				},
				okToClose: function(scope){
					var canClose = true;
					var msgCarrier = scope.qconfirm?scope.qconfirm: scope;
					if(!scope.mForm && scope.encForm){
						scope.mForm = scope.encForm;
					}
					if(scope.mForm.$invalid){
						if(scope.qconfirm.isModal){
							if(!scope.$$phase){
								scope.$apply(function(){
									msgCarrier.messages.clearAndAdd(service.getFormErrors(scope.mForm));
								});
							}else{
								msgCarrier.messages.clearAndAdd(service.getFormErrors(scope.mForm));
							}

						}else{
							msgCarrier.messages.clearAndAdd(service.getFormErrors(scope.mForm));
							canClose = false;
						}
					}
					return canClose;
				}
		};

		return service;
	}]);


    patientForm.directive('formstatemanagerErrors', [function(){
            return {
                restrict: 'E',
                templateUrl: 'formstatemanager_errors_index.html',
                scope: {
					manager:"="
				}
            }
    }]);

	patientForm.directive('listTable', ['$compile','$translate','utils','ModificationStatus', '$timeout', 'model','EncounterAccessor',
		function($compile, $translate, utils, ModificationStatus, $timeout, model, EncounterAccessor){
		return {
			restrict: 'E',
			scope:{
				options: '=',
				list: '=',
				formOptions: '=',
				loaded: '='
			},
			compile: function(ele) {
				var transcludestring = ele.html();
				ele.html('');
				var templateString = utils.getTemplate('patientEditTable_index.html');

				return function(scope, element, attrs){

					var transclude = angular.element(angular.copy(transcludestring));
					var template = angular.element(angular.copy(templateString));
					var listItemTemplate = angular.element($(transclude).siblings('list-table-item'));
					if(listItemTemplate.length === 0 && transclude.length === 1){
						listItemTemplate = angular.element(transclude[0]);
					}
					$(template).find('.listTableItem').append(angular.copy(listItemTemplate));
					var listItemfooterTemplate = angular.element($(transclude).siblings('list-table-itemfooter'));
					if(listItemfooterTemplate.length > 0){
						$(template).find('.listTableItemfooter').append(angular.copy(listItemfooterTemplate));
					}
					$compile(template)(scope);
					element.append(template);

					var defaults = {
						hasOrder: false,
						showCount: false,
						hasEdit: true,
						addObject: true,
						hasDelete: true,
						hasAdd: true,
						hasRefresh: false,
						editReady: true,
						title: '',
						show: function(){return true;},
						orderListBy:'',
						filterList: function(){return true;},
						hasItemFooter: false,
					};

					scope.isNew=false;

					function update(){
						scope.options = $.extend(angular.copy(defaults), scope.options);
						if(!scope.options.itemActions){
							scope.options.itemActions = [];
						}
						function hasDelete(e){
							return e.title === 'Delete';
						}
						function hasEdit(e){
							return e.title === 'Edit';
						}
						if(scope.options.hasRefresh){
							scope.refreshElement = scope.options.dataEdit.refreshElement;
						}
						if(scope.options.hasDelete && _.findIndex(scope.options.itemActions,hasDelete ) === -1){
							scope.options.itemActions.push({
								title: 'Delete',
								class: 'fa-trash',
								type: 'popover',
								popoverUrl: "/dashboard/resources/ofys/widgets/confirmDelete.html?v=bh",
								act:angular.noop
							});
						}
						if(scope.options.hasEdit && _.findIndex(scope.options.itemActions,hasEdit ) === -1){
							scope.options.itemActions.push({
								title: 'Edit',
								class: 'fa-pencil',
								act: scope.editElement
							});
						}
						//Auto edit items on viewer open.
						if(scope.list){
							for (let i = 0; i < scope.list.length; i++) {
								const item = scope.list[i];
								if(item.viewbag && item.viewbag.editOnOpen){
									delete item.viewbag.editOnOpen;
									item.patientListScrollelemId = item.id + "li";
									notifyPresence(item);
									scope.editElement(item);
								}
							}
						}
					}

					scope.modifyImportance = function(options, list) {
						if (options.showImportance===true) {
							var arr = [];
							for (let i = 0; i < scope.list.length; i++) {
								const item = scope.list[i];
								if (item.importance!=item.importanceTemp)  {
									// il faut updater le serveur
									// obj = "lstDx" ou lstProb ou lstIntervention
									item.importance=item.importanceTemp;
									arr.push({id:item.id, importance:item.importance, idPatient:options.idPatient(), type:options.obj});
								}
							}
							if (arr.length>0) {
								EncounterAccessor.saveImportance(arr);
								list.sort(function (a, b) {
									return a.importance>b.importance ? -1 : 1;	// inverse
								});
							}
						} else {
							var bt = $translate.instant('IMPORTANCE_TTT');
							var msg = $translate.instant('IMPORTANCE_MSG_SAVE', {msg: bt});
							model.notice().info(msg);
						}
						options.showImportance=!options.showImportance;
					};

					scope.$watch(scope.options, update);

					scope.select = function(item){
						scope.selected = scope.selected === item ? undefined: item;

						if(scope.options.onSelect){
							scope.options.onSelect(item, scope.options);
						}
					};

					function getElement(item){
						if(!item){
							scope.isNew = true;
							if(scope.options.dataEdit.defaultItem){
								item=angular.copy(scope.options.dataEdit.defaultItem);
							}
						}else{
							scope.isNew = false;
						}
						item.viewbag = {edit: true,scrollable: {}, addObjectFn:function(){
							scope.editElement();
						}};
						item.editMode = true;
						return item;
					}

					scope.show = function(elem){
						return (scope.options.show && scope.options.show()) &&
							(elem.modificationStatus !== ModificationStatus.STATUS_DELETED);
					};

					function clearEditElem(options, elem){
						options.inEditMode -=1;
						var i = options.inEditItems.indexOf(elem);
						if(i > -1){
							options.inEditItems.splice(i, 1);
						}
					}

					scope.editElement = function(elem){
						//if onEdit is declared it must return true to progress.
						if(scope.options.onEdit && !scope.options.onEdit(elem, scope.list)){
							return;
						}

						var focusable = {};
						var selectedIndex, origVersion;
						if(elem){
							origVersion = angular.copy(elem);
						}

						function cleanViewbag(i){
							delete scope.options.modalData;
							scope.list[i].viewbag = {};
							scope.list[i].editMode = false;
							delete scope.list[i].viewbag;
						}

						function setItem(i, newItem){
							if(elem){
								scope.list[i] = newItem;
							}
						}
						var modalData = {
							selected : getElement(elem),
							isNew:scope.isNew,
							focusable: focusable,
							addObject: scope.options.addObject ,
							save: function () {
								selectedIndex = scope.list.indexOf(modalData.selected);
								scope.formOptions.setFormStatus("dirty");
								this.selected.modificationStatus = ModificationStatus.STATUS_UPDATED;

								if(this.onsave){
									this.onsave(this.selected);
								}

								if(scope.isNew){
									modalData.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
									scope.isNew = false;
								}
								setItem(selectedIndex, modalData.selected);
								cleanViewbag(selectedIndex);
								clearEditElem(scope.formOptions, modalData.selected)
							},
							cancel: function(){
								selectedIndex = scope.list.indexOf(modalData.selected);
								if(modalData.isNew){
									scope.list.splice(selectedIndex, 1);
								}else if(selectedIndex > -1){
									setItem(selectedIndex, origVersion);
									cleanViewbag(selectedIndex);
								}
								clearEditElem(scope.formOptions, modalData.selected)
							}
						};

						if(scope.options.dataEdit.onload){
							scope.options.dataEdit.onload(modalData, scope.options);
						}
						$.extend(modalData, scope.options.dataEdit);
						$.extend(modalData.selected.viewbag, modalData);
						scope.options.modalData = modalData;
						if(!scope.list){
							scope.list = [];
						}
						if(modalData.isNew){
							// add new item at the beginning. makes it more obvious for user - close to the + button.
							scope.list.unshift(modalData.selected);
							selectedIndex = 0;//scope.list.length-1;
						}else{
							selectedIndex = scope.list.indexOf(elem);
						}
						if(scope.formOptions && scope.formOptions.inEditMode !== undefined){
							scope.formOptions.inEditMode +=1;
							scope.formOptions.inEditItems = scope.formOptions.inEditItems ? scope.formOptions.inEditItems: [];
							scope.formOptions.inEditItems.push(modalData.selected);
						}
						if(typeof scope.options.dataEdit.formReady === 'function'){
							$timeout(function(){
								scope.options.dataEdit.formReady(scope.options);
							}, 30);
						}

						$timeout(function(){
							if(modalData && modalData.selected &&
								modalData.selected.viewbag &&
								modalData.selected.viewbag.scrollable &&
								modalData.selected.viewbag.scrollable.scrollToScreen){
								if(!OfysUtils.isScrolledIntoView(modalData.selected.viewbag.scrollable.scrollToScreenElem)){
									modalData.selected.viewbag.scrollable.scrollToScreen();
								}
							}

							if(modalData.selected.viewbag &&
								modalData.selected.viewbag.onChangeEditState){
								modalData.selected.viewbag.onChangeEditState(modalData.selected, modalData);
							}
						}, 500);//plus fiable a 500ms si c'est plus court il pourrait être moins fiable.
					};

					if(scope.options){
						scope.options.editElement = scope.editElement;
					}

					function updateOrder(list, itemIndex){
						if(list.length > 0 ){
							var hasModifiedOrder = false;
							for(var i = 0; i < list.length; i++){
								// must check too the special case of stopped Prescription
								if (list[i].modificationStatus == ModificationStatus.STATUS_UPDATED_ORDER) {
									hasModifiedOrder = true; break;
								}
							}
							if (hasModifiedOrder===true) {
								var imp = 0;
								for(var i = 0; i < list.length; i++){
									if (list[i].modificationStatus != ModificationStatus.STATUS_DELETED) {
										if (list[i].importance != imp) {
											list[i].importance = imp;									
											list[i].modificationStatus = ModificationStatus.STATUS_UPDATED_ORDER;
										}
										imp = imp + 256;										
									}
								}
							}
							
							scope.formOptions.setFormStatus("dirty");
						}
					}

					scope.moveUp = function(item){
						var index = scope.list.indexOf(item);
						if(index!=0){
							item.modificationStatus = ModificationStatus.STATUS_UPDATED_ORDER;									
							scope.list.splice(index,1);
							scope.list.splice(index-1,0,item);
							updateOrder(scope.list,index-1 );
						}
					};

					scope.moveDown=function(item){
						var index = scope.list.indexOf(item);
						if(index!=scope.list.length-1){
							item.modificationStatus = ModificationStatus.STATUS_UPDATED_ORDER;									
							scope.list.splice(index,1);
							scope.list.splice(index+1,0,item);
							updateOrder(scope.list, index+1);
						}
					};

					scope.deleteItem = function(item){
						//Without the timeout angular throws a remove error.
						//Probably requires time to close the confirmation dialog.
						$timeout(function(){
							if(!item.id){
								var index = scope.list.indexOf(item);
								scope.list.splice(index,1);
							}else{
								item.modificationStatus = ModificationStatus.STATUS_DELETED;
								item.isDeleted = true;
								updateOrder(scope.list);
								scope.formOptions.setFormStatus("dirty");
							}
						}, 50);
					};

					function notifyPresence(item){
						$timeout(function(){
							var seekAttention = $(".seekAttention");
							if(seekAttention.length > 0){
								seekAttention[0].scrollIntoView(false);
								seekAttention.addClass("seeknow");
								//Add color animation class which begins coloring the element.
								$timeout(function(){
									seekAttention.addClass("start");
								}, 1000);

								//Class clean up remove animation classes
								$timeout(function(){
									seekAttention.removeClass("seeknow");
									seekAttention.removeClass("start");
									delete item.patientListScrollelemId;
									if (item.viewbag && item.viewbag.item) delete item.viewbag.item.patientListScrollelemId;
								}, 2000);
							}
						}, 100);
					}
				};
			},
		};
	}]);

	patientForm.directive('listTableSuiviPrev', ['$compile','$translate','utils','ModificationStatus', '$timeout', 'model','EncounterAccessor',
		function($compile, $translate, utils, ModificationStatus, $timeout, model, EncounterAccessor){
		return {
			restrict: 'E',
			scope:{
				options: '=',
				list: '=',
				formOptions: '=',
				loaded: '='
			},
			compile: function(ele) {
				var transcludestring = ele.html();
				ele.html('');
				var templateString = utils.getTemplate('patientSuiviPrevTable_index.html');

				return function(scope, element, attrs){

					var transclude = angular.element(angular.copy(transcludestring));
					var template = angular.element(angular.copy(templateString));
					var listItemTemplate = angular.element($(transclude).siblings('list-table-item'));
					if(listItemTemplate.length === 0 && transclude.length === 1){
						listItemTemplate = angular.element(transclude[0]);
					}
					$(template).find('.listTableItem').append(angular.copy(listItemTemplate));
					var listItemfooterTemplate = angular.element($(transclude).siblings('list-table-itemfooter'));
					if(listItemfooterTemplate.length > 0){
						$(template).find('.listTableItemfooter').append(angular.copy(listItemfooterTemplate));
					}
					$compile(template)(scope);
					element.append(template);

					var defaults = {
						hasOrder: false,
						showCount: false,
						hasEdit: true,
						addObject: true,
						hasDelete: true,
						hasAdd: true,
						editReady: true,
						title: '',
						show: function(){return true;},
						orderListBy:'',
						filterList: function(){return true;},
						hasItemFooter: false,
					};

					scope.isNew=false;

					function update(){
						scope.options = $.extend(angular.copy(defaults), scope.options);
						if(!scope.options.itemActions){
							scope.options.itemActions = [];
						}
						function hasDelete(e){
							return e.title === 'Delete';
						}
						function hasEdit(e){
							return e.title === 'Edit';
						}
						if(scope.options.hasDelete && _.findIndex(scope.options.itemActions,hasDelete ) === -1){
							scope.options.itemActions.push({
								title: 'Delete',
								class: 'fa-trash',
								type: 'popover',
								popoverUrl: "/dashboard/resources/ofys/widgets/confirmDelete.html?v=bh",
								act:angular.noop
							});
						}
						if(scope.options.hasEdit && _.findIndex(scope.options.itemActions,hasEdit ) === -1){
							scope.options.itemActions.push({
								title: 'Edit',
								class: 'fa-pencil',
								act: scope.editElement
							});
						}
						//Auto edit items on viewer open.
						if(scope.list){
							for (let i = 0; i < scope.list.length; i++) {
								const item = scope.list[i];
								if(item.viewbag && item.viewbag.editOnOpen){
									delete item.viewbag.editOnOpen;
									item.patientListScrollelemId = item.id + "li";
									notifyPresence(item);
									scope.editElement(item);
								}
							}
						}
					}

					scope.modifyImportance = function(options, list) {
						if (options.showImportance===true) {
							var arr = [];
							for (let i = 0; i < scope.list.length; i++) {
								const item = scope.list[i];
								if (item.importance!=item.importanceTemp)  {
									// il faut updater le serveur
									// obj = "lstDx" ou lstProb ou lstIntervention
									item.importance=item.importanceTemp;
									arr.push({id:item.id, importance:item.importance, idPatient:options.idPatient(), type:options.obj});
								}
							}
							if (arr.length>0) {
								EncounterAccessor.saveImportance(arr);
								list.sort(function (a, b) {
									return a.importance>b.importance ? -1 : 1;	// inverse
								});
							}
						} else {
							var bt = $translate.instant('IMPORTANCE_TTT');
							var msg = $translate.instant('IMPORTANCE_MSG_SAVE', {msg: bt});
							model.notice().info(msg);
						}
						options.showImportance=!options.showImportance;
					};

					scope.$watch(scope.options, update);

					scope.select = function(item){
						scope.selected = scope.selected === item ? undefined: item;

						if(scope.options.onSelect){
							scope.options.onSelect(item, scope.options);
						}
					};

					function getElement(item){
						if(!item){
							scope.isNew = true;
							if(scope.options.dataEdit.defaultItem){
								item=angular.copy(scope.options.dataEdit.defaultItem);
							}
						}else{
							scope.isNew = false;
						}
						item.viewbag = {edit: true,scrollable: {}, addObjectFn:function(){
							scope.editElement();
						}};
						item.editMode = true;
						return item;
					}

					scope.show = function(elem){
						return (scope.options.show && scope.options.show()) &&
							(elem.modificationStatus !== ModificationStatus.STATUS_DELETED);
					};

					function clearEditElem(options, elem){
						options.inEditMode -=1;
						var i = options.inEditItems.indexOf(elem);
						if(i > -1){
							options.inEditItems.splice(i, 1);
						}
					}

					scope.editElement = function(elem){
						//if onEdit is declared it must return true to progress.
						if(scope.options.onEdit && !scope.options.onEdit(elem, scope.list)){
							return;
						}

						var focusable = {};
						var selectedIndex, origVersion;
						if(elem){
							origVersion = angular.copy(elem);
						}

						function cleanViewbag(i){
							delete scope.options.modalData;
							scope.list[i].viewbag = {};
							scope.list[i].editMode = false;
							delete scope.list[i].viewbag;
						}

						function setItem(i, newItem){
							if(elem){
								scope.list[i] = newItem;
							}
						}
						var modalData = {
							selected : getElement(elem),
							isNew:scope.isNew,
							focusable: focusable,
							addObject: scope.options.addObject ,
							save: function () {
								selectedIndex = scope.list.indexOf(modalData.selected);
								scope.formOptions.setFormStatus("dirty");
								this.selected.modificationStatus = ModificationStatus.STATUS_UPDATED;

								if(this.onsave){
									this.onsave(this.selected);
								}

								if(scope.isNew){
									modalData.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
									scope.isNew = false;
								}
								setItem(selectedIndex, modalData.selected);
								cleanViewbag(selectedIndex);
								clearEditElem(scope.formOptions, modalData.selected)
							},
							cancel: function(){
								selectedIndex = scope.list.indexOf(modalData.selected);
								if(modalData.isNew){
									scope.list.splice(selectedIndex, 1);
								}else if(selectedIndex > -1){
									setItem(selectedIndex, origVersion);
									cleanViewbag(selectedIndex);
								}
								clearEditElem(scope.formOptions, modalData.selected)
							}
						};

						if(scope.options.dataEdit.onload){
							scope.options.dataEdit.onload(modalData, scope.options);
						}
						$.extend(modalData, scope.options.dataEdit);
						$.extend(modalData.selected.viewbag, modalData);
						scope.options.modalData = modalData;
						if(!scope.list){
							scope.list = [];
						}
						if(modalData.isNew){
							// add new item at the beginning. makes it more obvious for user - close to the + button.
							scope.list.unshift(modalData.selected);
							selectedIndex = 0;//scope.list.length-1;
						}else{
							selectedIndex = scope.list.indexOf(elem);
						}
						if(scope.formOptions && scope.formOptions.inEditMode !== undefined){
							scope.formOptions.inEditMode +=1;
							scope.formOptions.inEditItems = scope.formOptions.inEditItems ? scope.formOptions.inEditItems: [];
							scope.formOptions.inEditItems.push(modalData.selected);
						}
						if(typeof scope.options.dataEdit.formReady === 'function'){
							$timeout(function(){
								scope.options.dataEdit.formReady(scope.options);
							}, 30);
						}

						$timeout(function(){
							if(modalData && modalData.selected &&
								modalData.selected.viewbag &&
								modalData.selected.viewbag.scrollable &&
								modalData.selected.viewbag.scrollable.scrollToScreen){
								if(!OfysUtils.isScrolledIntoView(modalData.selected.viewbag.scrollable.scrollToScreenElem)){
									modalData.selected.viewbag.scrollable.scrollToScreen();
								}
							}

							if(modalData.selected.viewbag &&
								modalData.selected.viewbag.onChangeEditState){
								modalData.selected.viewbag.onChangeEditState(modalData.selected, modalData);
							}
						}, 500);//plus fiable a 500ms si c'est plus court il pourrait être moins fiable.
					};

					if(scope.options){
						scope.options.editElement = scope.editElement;
					}

					function updateOrder(list, itemIndex){
						if(list.length > 0 ){
							var hasModifiedOrder = false;
							for(var i = 0; i < list.length; i++){
								// must check too the special case of stopped Prescription
								if (list[i].modificationStatus == ModificationStatus.STATUS_UPDATED_ORDER) {
									hasModifiedOrder = true; break;
								}
							}
							if (hasModifiedOrder===true) {
								var imp = 0;
								for(var i = 0; i < list.length; i++){
									if (list[i].modificationStatus != ModificationStatus.STATUS_DELETED) {
										if (list[i].importance != imp) {
											list[i].importance = imp;									
											list[i].modificationStatus = ModificationStatus.STATUS_UPDATED_ORDER;
										}
										imp = imp + 256;										
									}
								}
							}
							
							scope.formOptions.setFormStatus("dirty");
						}
					}

					scope.moveUp = function(item){
						var index = scope.list.indexOf(item);
						if(index!=0){
							item.modificationStatus = ModificationStatus.STATUS_UPDATED_ORDER;									
							scope.list.splice(index,1);
							scope.list.splice(index-1,0,item);
							updateOrder(scope.list,index-1 );
						}
					};

					scope.moveDown=function(item){
						var index = scope.list.indexOf(item);
						if(index!=scope.list.length-1){
							item.modificationStatus = ModificationStatus.STATUS_UPDATED_ORDER;									
							scope.list.splice(index,1);
							scope.list.splice(index+1,0,item);
							updateOrder(scope.list, index+1);
						}
					};

					scope.deleteItem = function(item){
						//Without the timeout angular throws a remove error.
						//Probably requires time to close the confirmation dialog.
						$timeout(function(){
							if(!item.id){
								var index = scope.list.indexOf(item);
								scope.list.splice(index,1);
							}else{
								item.modificationStatus = ModificationStatus.STATUS_DELETED;
								item.isDeleted = true;
								updateOrder(scope.list);
								scope.formOptions.setFormStatus("dirty");
							}
						}, 50);
					};

					function notifyPresence(item){
						$timeout(function(){
							var seekAttention = $(".seekAttention");
							if(seekAttention.length > 0){
								seekAttention[0].scrollIntoView(false);
								seekAttention.addClass("seeknow");
								//Add color animation class which begins coloring the element.
								$timeout(function(){
									seekAttention.addClass("start");
								}, 1000);

								//Class clean up remove animation classes
								$timeout(function(){
									seekAttention.removeClass("seeknow");
									seekAttention.removeClass("start");
									delete item.patientListScrollelemId;
									if (item.viewbag && item.viewbag.item) delete item.viewbag.item.patientListScrollelemId;
								}, 2000);
							}
						}, 100);
					}
				};
			},
		};
	}]);
	
	patientForm.directive('listTableHxRx', ['$compile','utils','ModificationStatus',
		function($compile, utils, ModificationStatus){
		return {
			restrict: 'E',
			scope:{
				options: '=',
				list: '=',
				formOptions: '=',
				loaded: '='
			},
			compile: function(ele) {
				var transcludestring = ele.html();
				ele.html('');
				var templateString = utils.getTemplate('patientEditTableHxRx_index.html');
				
				return function(scope, element, attrs){
					var transclude = angular.element(angular.copy(transcludestring));
					var template = angular.element(angular.copy(templateString));
					var listItemTemplate = angular.element($(transclude).siblings('list-table-item'));
					if(listItemTemplate.length === 0 && transclude.length === 1){
						listItemTemplate = angular.element(transclude[0]);
					}
					$(template).find('.listTableItem').append(angular.copy(listItemTemplate));
					var listItemfooterTemplate = angular.element($(transclude).siblings('list-table-itemfooter'));
					if(listItemfooterTemplate.length > 0){
						$(template).find('.listTableItemfooter').append(angular.copy(listItemfooterTemplate));
					}
					$compile(template)(scope);
					element.append(template);
					
					var defaults = {
							hasOrder: false,
							showCount: false,
							hasEdit: false,
							addObject: false,
							hasDelete: false,
							hasAdd: false,
							editReady: false,
							title: '',
							show: function(){return true;},
							orderListBy:'',
							filterList: function(){return true;},
							hasItemFooter: false,
					};
					
					scope.isNew=false;
					
					function update(){
						scope.options = $.extend(angular.copy(defaults), scope.options);
						if(!scope.options.itemActions){
							scope.options.itemActions = [];
						}
					}
					
					scope.$watch(scope.options, update);
					
					scope.select = function(item){
						scope.selected = scope.selected === item ? undefined: item;

						if(scope.options.onSelect){
							scope.options.onSelect(item, scope.options);
						}
					};
					
					scope.show = function(elem){
						return (scope.options.show && scope.options.show()) &&
						(elem.modificationStatus !== ModificationStatus.STATUS_DELETED);
					};
					
				};
			},
		};
	}]);
	
	//ses table directive, also taking care of opening modal form for ses
	patientForm.directive('patientAddresses', [ 'PatientAccessor','PatientFormService','ModificationStatus','$q','UserAccessor','utils','$rootScope','$timeout',
			function(PatientAccessor, PatientFormService, ModificationStatus, $q, UserAccessor, utils, $rootScope, $timeout){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patientAddresses.html?v=bh',
			scope:{
				addresses:'=',
				formOptions: '='
			},
			link: function(scope, element, attrs){
				var localizedCityTypes = {
					City: "Ville",
					Town: "Ville",
					Village: "Village",
					Hamlet: "Hameau",
					Municipality: "Municipalité"
				};

				function transformCity(city){
					if (city.type === "Unincorporated area") {
						city.type =  "Zone non-incorporée";
					}else {
						city.type = localizedCityTypes[city.type];
					}
					city.name = city.name.toUpperCase();
					return city;
				}

				// scope.testEligibility=function(address){
				// 	return (address.modificaOtionStatus !== ModificationStatus.STATUS_DELETED);
				// };

				var listItemTemplate =  '/dashboard/resources/ofys/pat/profil/city_search_data_item.html?v=bh';
				utils.getTemplate(listItemTemplate);


				scope.options = {
					hasOrder: true,
					// data: scope.addresses,
					hasItemFooter: true,
					title: 'Address',
					dataEdit: {
						defaultItem :{
							country:{name: "CANADA"},
							province:{name: "QC"}
						},
						formReady: function(frm){
							frm.modalData.focusable.focusAdressStreet && frm.modalData.focusable.focusAdressStreet();
						},
						// idNext: 'idNextAddress',
						editFormUrl: '/dashboard/resources/ofys/pat/profil/address_modal.html?v=bh',
						citySearchAssist : {
							assistId: 'autocomplete_city',
							dynaType: document.getElementsByTagName("BODY")[0],
							hasDetails: false,
							hasHeader: false,
							getAsyncData: function(query, assist){
								return UserAccessor.fillCompletionCity({q:query, limit: 15});
							},
							getKey: function(city) {
								if(utils.isTemplateLoaded(listItemTemplate)){
									var newScope = $rootScope.$new();
									newScope.city = transformCity(city);
									var res =  utils.getTemplateAndCompileSync(newScope,listItemTemplate);
									$timeout(function(){
										if(!newScope.$$phase) {
											newScope.$digest();
										}
									}, 0);
									return res;
								}else{
									return city.name;
								}
							},
							selection: function(city, assistObject) {
								scope.options.modalData.selected.province.name = city.province;
								scope.options.modalData.selected.city.name = city.name;
								scope.options.modalData.focusable.focusAdressPostalCode();
								if(!scope.$$phase) {
									scope.$digest();
								}
								return city.name;
							}
						},
						onsave: function (savedItem) {
							//sets modificationStatus to STATUS_NEW if empty,undefined or null
							if(savedItem.city && !savedItem.city.modificationStatus)
							savedItem.city.modificationStatus = ModificationStatus.STATUS_NEW;

							if(savedItem.country && !savedItem.country.modificationStatus)
							savedItem.country.modificationStatus = ModificationStatus.STATUS_NEW;

							if(savedItem.province && !savedItem.province.modificationStatus)
							savedItem.province.modificationStatus = ModificationStatus.STATUS_NEW;
						},
					},
				};
			}
		};
	}]);

	//Contact table directive, also taking care of opening modal form for contact
	patientForm.directive('patientContact', [ 'PatientAccessor','PatientFormService', 'ModificationStatus',
		function(PatientAccessor, PatientFormService, ModificationStatus){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patientContact.html?v=bh',
			scope: {
				contacts:'=',
				formOptions: '='
			},
			link: function(scope, element, attrs){
				scope.contactTypes = [
					{val:0,name:'Phone'},
					{val:1,name:'MainEmail'},
					{val:2,name:'Fax'},
					{val:3,name:'Pager'},
					{val:4,name:'OtherEmail'},
					{val:5,name:'CellphoneText'},
					{val:6,name:'OtherCellphone'},
					{val:7,name:'IPhoneId'},
					{val:8,name:'OtherPhone'},
				];
				var cntTypes = [];
				for(var i = 0; i < scope.contactTypes.length; i++){
					cntTypes.push(scope.contactTypes[i].name);
				}

				scope.options = {
					hasOrder: true,
					// data: scope.contacts,
					typeContact: cntTypes,
					hasItemFooter: true,
					title: 'Contact',
					dataEdit: {
						defaultItem :{typeContact: 0},
						formReady: function(frm){
							frm.modalData.focusable.focusContactValue && frm.modalData.focusable.focusContactValue();
						},
						onsave: function(elem){
							if((elem.typeContact == 1 || elem.typeContact == 4) && elem.contact){
								elem.contact = elem.contact.toLowerCase();
							}
						},
						editFormUrl: '/dashboard/resources/ofys/pat/profil/contact_modal.html?v=bh',
						contactsTypes:scope.contactTypes
					}
				};
			}
		};
	}]);

	patientForm.directive('contactvalidator', function($filter, model) {
		return {
		  require: 'ngModel',
		  link: function(scope, elm, attrs, ctrl) {

			var validators = {
				tel: function(modelValue, viewValue){
					//Valide seulement les contacts telephone
					if(scope.isNotPhone)return true;

					if(modelValue){
						var val = modelValue+"";
						val = val.replaceAll("(", "");
						val = val.replaceAll(")", "");
						val = val.replaceAll(" ", "");
						val = val.replaceAll("-", "");
						if(modelValue != val){
							ctrl.$setViewValue(val);
							ctrl.$render();
							// ctrl.$validate();
						}

						var isValid = !(modelValue.match(/[^0-9]/) ||
							!(
								modelValue.length === 7 ||
								modelValue.length === 10 ||
								modelValue.length === 11 ||
								modelValue.length === 12
							)
						   );
						return isValid;
					}
					return true;
				},
				email: function(modelValue, viewValue){
					//valider seuelement pour les contacts de type courriel
					if(scope.isNotEmail)return true;

					if(modelValue){
						var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
						var isValid = re.test(modelValue);
						return isValid;
					}
					return false;
				}
			};
			function parseTel(v){
				var res = v.replaceAll('(').replaceAll(')').replaceAll('-').replace(' ');
				return res;
			}
			function telMask(v){
				if(v && v.length < 13 && v.length > 0){
					v = '('+v;
					v = v.length > 3 ? v.splice(4, 0, ') '): v;
					v = v.length > 8 ? v.splice(9, 0, '-'): v;
					return v;
				}
				return v;
			}
			//init validators
			ctrl.$validators.tel = validators.tel;
			ctrl.$validators.email = validators.email;
			// ctrl.$formatters.push(telMask);

			// ctrl.$parsers.push(function(v){
			// 	v = parseTel(v);
			// 	var msk = telMask(v);
			// 	ctrl.$setViewValue(msk);
			// 	var res = parseTel(v);
			// 	console.log("value is : "+ v);
			// 	console.log("mask is : "+ msk);
			// 	return v;
			// });

			elm.on('blur.contactvalidator', function() {
				ctrl.$validate();

				if(scope.isPhone && ctrl.$valid && ctrl.$modelValue && ctrl.$modelValue.length === 7){
					ctrl.$setViewValue(model.clientPreferences('defaultRegionalCode') + ctrl.$modelValue);
					ctrl.$render();
				}
			});

			function updatevalidator(){
				scope.currentValidator = scope.$eval(attrs.contactvalidator);
				/*Contact types
				{val:0,name:'Phone'},
				{val:1,name:'MainEmail'},
				{val:2,name:'Fax'},
				{val:3,name:'Pager'},
				{val:4,name:'OtherEmail'},
				{val:5,name:'CellphoneText'},
				{val:6,name:'OtherCellphone'},
				{val:7,name:'IPhoneId'}
				{val:8,name:'OtherPhone'}
			*/
				scope.isPhone = [0,2,3,5,6].indexOf(scope.currentValidator) > -1;
				scope.isNotPhone = !scope.isPhone;
				scope.isNotEmail =  [1,4,7].indexOf(scope.currentValidator) === -1;

				var contactTypes = scope.$eval(attrs.contactTypes);
				ctrl.$validate();
			}
			scope.$watch(attrs.contactvalidator, updatevalidator);
		  }
		};
	});


	patientForm.directive('searchEncType', ['$filter','$q', 'model',
		function($filter, $q, model){
		return {
			restrict: 'E',
			scope: {
				select: '=',
				focus: '=?',
				model: '=?',
				filter: '=?'
			},
			template:'<input type="text" data-dyna-assist="SearchAssistOptions" data-ng-model="model" data-input-focus-function="focus"></input>',
			link: function(scope, element, attrs){
				scope.userEncTypes = [];
				_.chain(EncounterAccessor.allEncTypes).omit(function(value, key, object) {
					return parseInt(key) < 10;
				}).each(function(v, k, list){
					scope.userEncTypes.push({k: parseInt(k), v: v});
				});
				scope.userEncTypes = $filter('orderBy')(scope.userEncTypes, 'v');


				function print(selection){
					return selection.v;
				}

				scope.SearchAssistOptions = {
					// assistId: "autocomplete_patient_professional",
					nextTabOnTab: true,
					nextTabOnEnter: true,
					hasDetails: false,
					hasHeader: false,
					minChar: 0,
					trigger: 'focus',
					getAsyncData: function(query, assist){
						return $q(function(resolve, reject) {
							resolve($filter('filter')(scope.userEncTypes, query, scope.filter));
						});
					},
					getKey: function(item) {
						return item.v;
					},
					selection: function(selection, assistObject) {
						if(scope.select){
							scope.select(selection);
						}
						if(!scope.$$phase) {
							scope.$digest();
						}
						return print(selection);
					}
				}
			}
				}
	}]);

	//Other professional table directive, also taking care of opening modal form for new professional
	patientForm.directive('patientProfessionnals', ['model', 'ProfAccessor','PatientFormService','FlView',  'ModificationStatus','$q','$filter',
	function(model, ProfAccessor, PatientFormService,FlView, ModificationStatus, $q, $filter){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patientProfessionnals.html?v=bh',
			scope: {
				profs: '=',
				patient:'=',
				professionals:'=',
				allsites:'=',
				formOptions: '='
			},
			link: function(scope, element, attrs){
				function profName(prof){
					return prof.lastName + ', '+ prof.firstName;
				}
				scope.options = {
					hasOrder: false,
					// data: scope.professionals,
					allsites: scope.allsites,
					hasItemFooter: true,
					title: 'OtherProf',
					isLoading: false,
					getName: function(idProf){
						var prof = model.store.profs.get(idProf);
						if(!prof && !scope.options.isLoading){
							scope.options.isLoading = true;
							ProfAccessor.findProfById(idProf, function(res){
								scope.options.isLoading = false;
								return profName(res.data);
							})
						}else if(!scope.options.isLoading){
							return profName(prof);
						}
					},
					getTel: function(idProf){
						var prof = model.store.profs.get(idProf);
						return prof ? prof.tel : undefined;
						
					},
					getFax: function(idProf){
						var prof = model.store.profs.get(idProf);
						return prof ? prof.fax : undefined;
					},
					dataEdit: {
						defaultItem :{idPatient: scope.patient.id},
						formReady: function(frm){
							if(frm.modalData.selected.idProfessionnal){
								frm.modalData.selected.viewProf = model.store.profs.get(frm.modalData.selected.idProfessionnal);
								frm.modalData.selected.professionnalFullName = profName(model.store.profs.get(frm.modalData.selected.idProfessionnal));
							}
							frm.modalData.focusable.focusPatientProfessional &&frm.modalData.focusable.focusPatientProfessional();
						},
						editFormUrl: '/dashboard/resources/ofys/pat/profil/professionnal_modal.html?v=bh',
//						lstProfs: model.store.allProfs.index,
						// openProfSearch: openProfSearch,
						selectProf: function(prof){
							scope.options.modalData.selected.viewProf = prof;
							scope.options.modalData.selected.idProfessionnal = prof.id;
							scope.options.modalData.selected.professionnalFullName = prof.lastName + ', '+ prof.firstName;
						},
						removeViewProf: function(){
							delete scope.options.modalData.selected.viewProf;
							scope.options.modalData.selected.professionnalFullName = "";
							delete scope.options.modalData.selected.idProfessionnal;
							scope.options.modalData.focusable.focusPatientProfessional();
						},
						allsites: OfysUtils.ObjectValuesAsArray(model.user().sites),
					}
				};

			}
		};
	}]);

	//Sites table directive, also taking care of opening modal form for sites
	patientForm.directive('patientSites', [ 'PatientAccessor','PatientFormService','model',  'ModificationStatus','$filter',
	function(PatientAccessor, PatientFormService,model, ModificationStatus, $filter){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patientSites.html?v=bh',
			scope:{
				patientSites:'=',
				allsites:'=',
				formOptions: '='
			},
			link: function(scope, element, attrs){

				scope.options = {
					hasOrder: false,
					// data: scope.patientSites,
					hasItemFooter: true,
					title: 'Sites',
					allsites: scope.allsites,
					dataEdit: {
						defaultItem :{},
						formReady: function(frm){
							frm.modalData.focusable.focusPatientSite && frm.modalData.focusable.focusPatientSite();
						},
						onsave: function(item){
							item.addedAs =  "WORK_SITE";
						},
						editFormUrl: '/dashboard/resources/ofys/pat/profil/sites_modal.html?v=bh',
						allsites: OfysUtils.ObjectValuesAsArray(model.user().sites),
					}
				};
			}
		};
	}]);

	//Pharma table directive, also taking care of opening modal form for Pharmacies
	patientForm.directive('patientPharma', [ 'PatientAccessor','PatientFormService',  'ModificationStatus','model','$filter',
		function(PatientAccessor, PatientFormService, ModificationStatus, model, $filter){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patientPharma.html?v=bh',
			scope:{
				patientPharmacies:'=',
				allsites:'=',
				formOptions: '='
			},
			link: function(scope, element, attrs){
				scope.options = {
					hasOrder: false,
					// data: scope.patientPharmacies,
					hasItemFooter: true,
					title: 'Pharmacies',
					allsites: scope.allsites,
					dataEdit: {
						defaultItem :{},
						formReady: function(frm){
							if(frm.modalData.selected.idSite){
								frm.modalData.selected.viewbag.nameCommon = scope.allsites[frm.modalData.selected.idSite].nameCommon;
							}
							frm.modalData.focusable.focusPatientSite && frm.modalData.focusable.focusPatientSite();
						},
						selectPharma: function(site){
							scope.options.modalData.selected.idSite = site.id;
							scope.options.modalData.selected.viewbag.nameCommon = site.nameCommon;
						},
						removePharma: function(){
							delete scope.options.modalData.selected.idSite;
							scope.options.modalData.selected.viewbag.nameCommon = "";
						},
						onsave: function(item){
							item.addedAs = "DRUG_STORE";
						},
						editFormUrl: '/dashboard/resources/ofys/pat/profil/pharma_modal.html?v=bh',
						allsites: OfysUtils.ObjectValuesAsArray(model.user().sites),
					}
				};
			}
		};
	}]);

	//Ident table directive, also taking care of opening modal form for Idents
	patientForm.directive('patientIdent', ['PatientAccessor','PatientFormService','$http',  'ModificationStatus',
		function(PatientAccessor, PatientFormService,$http, ModificationStatus){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patientIdent.html?v=bh',
			scope:{
				patientidents:'=',
				formOptions: '='
			},
			link: function(scope, element, attrs){
				var allIdentType = [];

				scope.options = {
					hasOrder: false,
					// data: scope.patientidents,
					hasItemFooter: true,
					title: 'Idents',
					dataEdit: {
						defaultItem :{},
						formReady: function(frm){
							frm.modalData.focusable && 
								frm.modalData.focusable.focusIdentifier && 
								frm.modalData.focusable.focusIdentifier();
						},
						editFormUrl: '/dashboard/resources/ofys/pat/profil/ident_modal.html?v=bh',
						allIdentType: allIdentType
					}
				};

				PatientAccessor.getIdentifiers(null, function(res){
					var c = scope.options;
					scope.options = {};// Make sure the values are updated in the table because of shallow watch
					c.dataEdit.allIdentType = res.data;
					scope.options = c;
				});
			}
		};
	}]);
	
		//Ident table directive, also taking care of opening modal form for fusion
	patientForm.directive('patientFusion', ['PatientAccessor','PatientFormService','$http',  'ModificationStatus',
		function(PatientAccessor, PatientFormService,$http, ModificationStatus){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patientFusion.html?v=bh',
			scope:{
				fusions:'=',
				formOptions: '=',
				admin: '=',
				patient: '='
			},
			link: function(scope, element, attrs){
				
				let hasDelete = false;
				let hasAdd = false;
				let editReady = false;
				if(scope.admin && !scope.patient.isDeleted){
					hasDelete = true;
					hasAdd = true;
					editReady = true;
				}
				
				function prepareLstFusionPatient(data){
					scope.fusions = []
					if(data){
						data.forEach(basePatient => {
							scope.fusions.push({
								$$hashKey: basePatient.$$hashKey,
								editMode: false,
								id: basePatient.id,
								idPatient: basePatient.id,
								modificationStatus: ModificationStatus.STATUS_UPDATED,
								patientFullName: basePatient.str,
								viewPatient: basePatient
							})
						})
					}
				}
					
				scope.options = {
					hasOrder: false,
					hasItemFooter: false,
					title: 'Fusion',
					hasDelete: hasDelete,
					hasAdd: hasAdd,
					hasRefresh: true,
					editReady: editReady,
					dataEdit: {
						defaultItem :{},
						searchFusionOptions: {
							onFetch: function (lst){
								if(lst && Array.isArray(lst)){
									lst = lst.filter(function(e){return e.id !== scope.patient.id && e.idPatient > -1 && !e.inactiveRaison});
								}
								return lst;
							}
						},
						refreshElement: function(){
							PatientAccessor.getFusionPatient(scope.patient.idPatient, function(res){
								scope.fusions = res.data;
								prepareLstFusionPatient(res.data)
							});
						},
						editFormUrl: '/dashboard/resources/ofys/pat/profil/patientFusion_modal.html?v=bh',
						selectPatient: function(patient){
							scope.options.modalData.selected.viewPatient = patient;
							scope.options.modalData.selected.idPatient = patient.id;
							scope.options.modalData.selected.patientFullName = patient.lastName + ', '+ patient.firstName;
						},
						removeViewPatient: function(){
							delete scope.options.modalData.selected.viewPatient;
							scope.options.modalData.selected.patientFullName = "";
							delete scope.options.modalData.selected.idPatient;
							scope.options.modalData.focusable.focusPatientFusion();
						},
					}
				};
			}
		};
	}]);


	//Alerts table directive, also taking care of opening modal form for Alerts
	patientForm.directive('patientAlerts', [ 'PatientAccessor','PatientFormService',  'ModificationStatus',
		function(PatientAccessor, PatientFormService, ModificationStatus){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patientAlerts.html?v=bh',
			scope: {
				alerts:'=',
				formOptions: '='
			},
			link: function(scope, element, attrs){
				scope.options = {
					hasOrder: false,
					// data: scope.alerts,
					hasItemFooter: false,
					isAlert: true,
					title: 'Alerts',
					dataEdit: {
						defaultItem :{},
						formReady: function(frm){
							frm.modalData.focusable.focusAlert();
						},
						editFormUrl: '/dashboard/resources/ofys/pat/profil/alerts_modal.html?v=bh',
					}
				};
			}
		};
	}]);

	patientForm.directive('patientLimit',
		[ 'PatientAccessor','PatientFormService','UserAccessor','$q',
		'$filter','utils','$timeout', 'ModificationStatus', 'Rights',
		function(PatientAccessor, PatientFormService, UserAccessor, $q,
			$filter, utils, $timeout, ModificationStatus, Rights){
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/pat/profil/patientLimit.html?v=bh',
			scope:{
				limitations:'=',
				users:'=',
				formOptions: '='
			},
			link: function(scope, element, attrs){

				var limitDefaults = {
					ClientSection:false,
					Appointment:false,
					Forms:false,
					LabResults:false,
					ContactMeans:false,
					NonCliData:false,
					Address:false,
					Billing:false,
					Documents:false,
					ClinicalFile:false
				};

				scope.isNew=false;

				scope.deleteLimitation=function(limitation){
					if(OfysUtils.isEmpty(limitation.id)){
						var index = scope.limitations.indexOf(limitation);
						scope.limitations.splice(index,1);
					}
					else{
						limitation.modificationStatus= ModificationStatus.STATUS_DELETED;
					}
					scope.formOptions.setFormStatus("dirty");
				};

				scope.testEligibility=function(limitation){
					if(limitation.modificationStatus== ModificationStatus.STATUS_DELETED)
						return false;
					return true;
				};

				function getElement(limitation){
					if(!limitation){
						scope.isNew=true;
						limitation = angular.copy(limitDefaults);
						Rights.buildRightsBool(0);
					} else{
						scope.isNew = false;
						limitation.personName = scope.users[limitation.idUserAnchor].personName;
						$.extend(limitation, Rights.buildRightsBool(limitation.droits));
					}
					return limitation;
				}

				scope.userSearchable = [];
				UserAccessor.listUsersForSelection(function(res){
				 	scope.userSearchable = UserAccessor.cleanAndSortUsers(res.data);
				});

				function getToogleTo(selected){
					var all = Object.keys(selected);
					for (let i = 0; i < all.length; i++) {
						const e = all[i];
						if(!selected[e]){
							return true;
						}
					}
					return false;
				}

				scope.editElement = function(elem){
					var modalData = {
						selected:getElement(elem),
						toggleFullAccess: function(){
							var toggleTo = getToogleTo(this.selected);
							var all = Rights.limitations;
							for (let i = 0; i < all.length; i++) {
								this.selected[all[i]] = toggleTo;
							}
						},
						editFormUrl: '/dashboard/resources/ofys/pat/profil/limit_modal.html?v=bh',
						isNew:scope.isNew,
						users:scope.users,
						formReady: function(frm){
							frm.modalData.focusable.focusPatientProfessional();
						},
						qconfirm: {
							beforeCancel: function(){
								modalData.selected.droits = Rights.buildRightsInt(modalData.selected);
								if(modalData.selected.droits === 0) delete modalData.selected.droits;
							}
						},
						userSearchAssist: {
							assistId: "autocomplete_userLimitation",
							nextTabOnTab: true,
							nextTabOnEnter: true,
							hasDetails: false,
							hasHeader: false,
							minChar: 0,
							trigger: 'focus',
							updateDataSourceWithValues: function(assistObject){
								if(scope.userSearchable){
									assistObject.setData(scope.userSearchable);
								}
							},
							getAsyncData: function(query, assist){
								return $q(function(resolve, reject) {
									resolve(searchUsers(query));
								});
							},
							getKey: function(recipient) {
								var newScope = scope.$new();
								newScope.item = recipient;
								var res =  utils.getTemplateAndCompileSync(newScope, '/dashboard/resources/ofys/user/user_dataItem.html?v=bh');
								$timeout(function(){
									if(!newScope.$$phase) {
										newScope.$digest();
									}
								},0);
								return res;
							},
							selection: function(usr, assistObject) {
								scope.$apply(function(){
									modalData.selected.idUserAnchor = usr.userId;
								});
								return usr.personName;
							},
						},
					};

					function searchUsers(query){
						var res = $filter('filter')(scope.userSearchable, {personName:query});
						return res;
					}

					PatientFormService.editModal(modalData).then(angular.noop, function () {
						scope.formOptions.setFormStatus("dirty");
						modalData.selected.modificationStatus= ModificationStatus.STATUS_UPDATED;
						modalData.selected.keys = Rights.updateLimitationTypes(modalData.selected.droits);
						if(scope.isNew){
							modalData.selected.modificationStatus = ModificationStatus.STATUS_NEW_UPDATED;
							scope.limitations.push(modalData.selected);
							scope.isNew=false;
							modalData.selected.datetimeStart = new Date().getTime();
						}
					});
				};
			}
		};
	}]);

})();