(function(){
	var comm = angular.module("dashboard.websocket", []);

	// comm.factory('clientUid', myClientUid);
	// myClientUid.$inject = ['$cookies'];	// pour qu'un reload ne force pas un nouveau backend, mais reprend celui lié au cookie.

	// function myClientUid($cookies) {
	// 	var uid = generateUIDNotMoreThan1million();//Used
	// 	// var cookieSyra = "ofys_cookie_infodata";
	// 	// var uid = $cookies.get(cookieSyra);
	// 	// if (!angular.isDefined(uid)) {
	// 	// 	uid = generateUIDNotMoreThan1million();
	// 	// 	$cookies.put(cookieSyra,uid, {expires:new Date('2099-12-31T12:00:00')});
	// 	// }
	// 	return uid;
	// }


	// 5 ctrs, 4m de possibilités. C'est suffisant pour nos besoins
	function generateUIDNotMoreThan1million() {
		return ("00000" + (Math.random()*Math.pow(36,5) << 0).toString(36)).slice(-5)
	}

	comm.factory('Notification', ['$log', function($log) {
		var accessor = {
			channels : {
				'taskUpdate' : {filter: /\"wsTarget\":\"task.update\"/, handlers:{}},
				'billingResourceUpdate' : {filter: /\"wsTarget\":\"billing.resource.update\"/, handlers:{}},
				'patientUpdate' : {filter: /\"wsTarget\":\"patient.update\"/, handlers:{}},
				'patientImageUpdate' : {filter: /\"wsTarget\":\"patient.image.update\"/, handlers:{}},
				'laboResultsProfessionnalUpdate' : {filter: /\"wsTarget\":\"labo.results.professionnal.update\"/, handlers:{}},
				// OFF 'sessionLock' : {filter: /wsTarget\":\"session.lock\"/, handlers:{}},
				'pingPulse' : {filter: /\"wsTarget\":\"ping.pulse\"/, handlers:{}},
				'INFO' : {filter: /severity\":\"INFO/, handlers:{}},
				'WARN' : {filter: /severity\":\"WARN/, handlers:{}},
				'dsqResponseUpdate' : {filter: /\"wsTarget\":\"dsq.response.update\"/, handlers:{}},
				//Response wrapper object SonarWSResponse should now be sent with all websocket calls
				//Target should use the dot. notation to specify target path and
				//the id of the target should use the camelcase of the dot. notation
				'error' : {filter: /\"wsTarget\":\"error\"/, handlers:{}},
				'dsqCandidateSearch' : {filter: /\"wsTarget\":\"dsq.candidate.search\"/, handlers:{}},
				'dsqDocSearch' : {filter: /\"wsTarget\":\"dsq.doc.search\"/, handlers:{}},
				'dsqSommhospSearch' : {filter: /\"wsTarget\":\"dsq.sommhosp.search\"/, handlers:{}},
				'dsqDocItem' : {filter: /\"wsTarget\":\"dsq.doc.item\"/, handlers:{}},
				'dsqSommhospItem' : {filter: /\"wsTarget\":\"dsq.sommhosp.get\"/, handlers:{}},
				'dsqDocSearchConsent' : {filter: /wsTarget\":\"dsq.doc.search.consent\"/, handlers:{}},
				'dsqLabSearch' : {filter: /\"wsTarget\":\"dsq.lab.search\"/, handlers:{}},
				'dsqLabSearchConsent' : {filter: /\"wsTarget\":\"dsq.lab.search.consent\"/, handlers:{}},
				'dsqGestionSignatures' : {filter: /\"wsTarget\":\"dsq.gestion.signatures\"/, handlers:{}},
				'dsqAllSearch' : {filter: /\"wsTarget\":\"dsq.all.search\"/, handlers:{}},
				'dsqAllSearchProgress' : {filter: /\"wsTarget\":\"dsq.all.search.progress\"/, handlers:{}},
				'dsqPtAllSearchProgress' : {filter: /\"wsTarget\":\"dsq.pt.all.search.progress\"/, handlers:{}},
				'dsqPtAllSearch' : {filter: /\"wsTarget\":\"dsq.pt.all.search\"/, handlers:{}},
				'dsqAllSearchConsent' : {filter: /\"wsTarget\":\"dsq.all.search.consent\"/, handlers:{}},
				'dsqLabItem' : {filter: /\"wsTarget\":\"dsq.lab.item\"/, handlers:{}},
				'dsqSqimCacheResponse' : {filter: /\"wsTarget\":\"dsq.sqim.cache.response\"/, handlers:{}},
				'dsqSearchProf' : {filter: /\"wsTarget\":\"dsq.prof.search\"/, handlers:{}},
				'dsqFindCanditade' : {filter: /\"wsTarget\":\"dsq.candidate.find\"/, handlers:{}},
//				'dsqEncFavsResponse' : {filter: /\"wsTarget\":\"dsq.enc.favs.response\"/, handlers:{}},
				'patientOpenFile' : {filter: /\"wsTarget\":\"patient.openFile\"/, handlers:{}},
				'courrielOpenPage' : {filter: /\"wsTarget\":\"courriel.openPage\"/, handlers:{}},
				'courrielCreateNew' : {filter: /\"wsTarget\":\"courriel.createNew\"/, handlers:{}},
				'sessionLoggedout' : {filter: /\"wsTarget\":\"session.loggedout\"/, handlers:{}},
				'app' : {filter: /\"wsTarget\":\"app.update\"/, handlers:{}},
				'appReservation' : {filter: /\"wsTarget\":\"app.reserved\"/, handlers:{}},
				'appDate' : {filter: /\"wsTarget\":\"app.date\"/, handlers:{}},
				'schdlDatetemplateUpdate' : {filter: /\"wsTarget\":\"schdl.datetemplate.update\"/, handlers:{}},
				'schdlWeektemplateUpdate' : {filter: /\"wsTarget\":\"schdl.weektemplate.update\"/, handlers:{}},
				'schdlAppointmentperiodtypeUpdate' : {filter: /\"wsTarget\":\"schdl.appointmentperiodtype.update\"/, handlers:{}},
				'schdlBaseAppointmentDateUpdate' : {filter: /\"wsTarget\":\"schdl.baseappointmentdate.update\"/, handlers:{}},
				'schdlDateKeyUpdate' : {filter: /\"wsTarget\":\"schdl.datekey.update\"/, handlers:{}},
				'mailNew' : {filter: /\"wsTarget\":\"mail.new\"/, handlers:{}},
				'mailAlert' : {filter: /\"wsTarget\":\"mail.alert\"/, handlers:{}},
				'suiviprevProf' : {filter: /\"wsTarget\":\"suiviprev.prof\"/, handlers:{}},
				'suiviprevPat' : {filter: /\"wsTarget\":\"suiviprev.pat\"/, handlers:{}},
				'siteUpdate' : {filter: /\"wsTarget\":\"site.update\"/, handlers:{}},
				'personGroupUpdate' : {filter: /\"wsTarget\":\"personGroup.update\"/, handlers:{}},
			},
			registerHandler: function(key, callback, scope){
				if(accessor.channels[key] == undefined){
					throw new Error("The requested notification channel '"+ key +"' is not defined.");
				}
				var handlerId;
				while(accessor.channels[key].handlers[handlerId = generateUIDNotMoreThan1million()] !== undefined);
				accessor.channels[key].handlers[handlerId] = {cb : callback, scope : scope};

				if(scope != undefined){
					scope.$on('$destroy', function() {
						accessor.removeHandler(handlerId, key);
			        });
				}
				return {'id' : handlerId, 'key': key};
			},
			removeHandler: function(id, key){
				if(accessor.channels[key].handlers[id] !== undefined){
					delete accessor.channels[key].handlers[id];
				}
			}
		}

		return accessor;
	}]);


	//Application wide event service. Can be called by any angular component.
	comm.factory('Event', ['$log', function($log) {
		var eventDefinitionDefaults = {handlers:{}};

		var events = {};

		//Called after every emit. Cleans up event state and calls success or error callbacks
		function emitEnd(eventName, emitDefinition, success, error){
			if(success && !emitDefinition.$$exitEvent){
				success();//successful callback
				if(emitDefinition.$$deleteAfterSuccessfullEmit){
					accessor.removeEvent(eventName);
				}
				return true;
			}else if(error && emitDefinition.$$exitEvent){
				error();//error callback
				if(emitDefinition.$$deleteAfterFailedEmit){
					accessor.removeEvent(eventName);
				}
			}
			return false;
		}

		var accessor = {
			addEvent: function(eventName, eventDefinition, scope){
				//To avoid accidental override of channels, an error is thrown if the event channel already exist.
				if(events[eventName] !== undefined){
					throw new Error("The requested event '"+ eventName +"' is already defined."+
							" To redefine the event call Event.removeEvent(eventName) then "+
							"Event.addEvent(eventName, eventDefinition, scope)");
				}
				//Add defaults that may have not been added
				var evDef = $.extend(true, eventDefinition, eventDefinitionDefaults);
				events[eventName] = evDef;

				//quickview
				if(scope != undefined){
					scope.$on('$destroy', function() {
						accessor.removeEvent(eventName);
					});
				}
			},
			removeEvent: function(eventName){
				delete events[eventName];
			},
			emit: function(eventName, emitDefinition, success, error){
				if(events[eventName]){
					var handlers = Object.keys(events[eventName].handlers);
					$log.log("Emitting event : "+ eventName + " with "+ handlers.length + " handler functions.");

					emitDefinition.stopPropagation = function(){
						emitDefinition.$$exitEvent = true;
					}
					for(var j = 0 ; j < handlers.length; j++){
						var handle = events[eventName].handlers[handlers[j]];
						//Call the event handler function.
						handle.cb(emitDefinition);
						if(emitDefinition.$$exitEvent){
							return emitEnd(eventName, emitDefinition, success, error);
						}
					}
				}
				return emitEnd(eventName, emitDefinition, success, error);
			},
			//Adds an event handler
			on: function(eventName, callback, scope){
				if(events[eventName] == undefined){
					throw new Error("The requested event channel '"+ eventName +"' is not defined.");
				}
				var handlerId;
				//find new Id.
				while(events[eventName].handlers[handlerId = generateUIDNotMoreThan1million()] !== undefined);
				events[eventName].handlers[handlerId] = {cb : callback, scope : scope};

				if(scope != undefined){
					scope.$on('$destroy', function() {
						accessor.off({id: handlerId,eventName: eventName});
			        });
				}
				return {'id' : handlerId, 'eventName': eventName};
			},
			//Removes an event handler
			off: function(eventRef){
				if(events[eventRef.eventName] && events[eventRef.eventName].handlers[eventRef.id] !== undefined){
					delete events[eventRef.eventName].handlers[eventRef.id];
				}
			}
		}

		return accessor;
	}]);


	comm.factory('DashWebSocket', ['$websocket','$http', '$filter', '$log', '$timeout',  'model', '$window', 'Notification',
	                               function($websocket, $http, $filter, $log, $timeout, model, $window, Notification) {

		function generateUIDNotMoreThan1million() {
			return ("00000" + (Math.random()*Math.pow(36,5) << 0).toString(36)).slice(-5);
		}
	      // Open a WebSocket connection
		var that = this;
		that.clientUid = generateUIDNotMoreThan1million();	// mis dans la var clientUid de SyraSocket - 5ctr, >3m de possibilités
		var wsProtocole = window.location.protocol=='https:' ? 'wss://' : 'ws://';
		that.location = wsProtocole + document.location.host + "/lidiws?u=" + that.clientUid;
		$log.log('in DashWebSocket clientuid = ' + that.clientUid);
		that.loadConnection = function() {
			that.ws = $websocket(that.location, ['sonar']);

			var channels = Object.keys(Notification.channels);

			//Activate all channels
			for(var i = 0; i < channels.length; i++){
				that.ws.onMessage(getCallback(channels[i]), {filter: Notification.channels[channels[i]].filter});
			}

			function getCallback(ch){
				var channel = ch;
				return function channelCallback(event) {
					var msg = JSON.parse(event.data);
					var handlers = Object.keys(Notification.channels[channel].handlers);
					for(var j = 0 ; j < handlers.length; j++){
						var handle = Notification.channels[channel].handlers[handlers[j]];
						//Call the handler callback function.
						if(handle.scope != undefined){
							handle.scope.$apply(handle.cb(msg));
						}else{
							//If no scope was provided.. might cause angular refresh issues.
							//https://github.com/angular/angular.js/wiki/When-to-use-$scope.$apply()
							handle.cb(msg);
						}
					}
				};
			}

			that.ws.onError(function(event) {
				$log.log('connection Error', event);
			});

			that.ws.onClose(function(event) {
				$log.log('connection closed', event);
				if(!OfysUtils.isDesktop){
					// try to reconnect Mobile devices close websocket connection when the device is locked.
					that.loadConnection();
				}else{
					forceUserReload();
				}
			});

			that.ws.onOpen(function() {
			});

		};

		function forceUserReload(){
			if(model.qv().isExternal){
				window.close();
			}else{
				showDisconected();
				model.stopDashBoardCountInterval();
			}
		}
		that.loadConnection();

		// 4 ctrs, 1.6m de possibilités. C'est suffisant pour nos besoins
		// function generateUIDNotMoreThan1million() {
		//     return ("0000" + (Math.random()*Math.pow(36,4) << 0).toString(36)).slice(-4)
		// }


//		function showDisconected(){
//			var exitModal = new jBox('Modal', {
//				content: "<p style='text-align: center'>Votre session a été désactivée en raison d'inactivité ou d'arrêt d'Ofys.</p>",
//			    maxWidth: $( window ).width() * .4,
//			    preventDefault: true,
//			    closable : false,
//			    closeButton: false,
//			    closeOnClick: false,
//			    closeOnMouseleave: false,
//			    closeOnEscape : false,
//			    closeOnBackgroundClick : false,
//			    closeOnConfirm: false,
//			    confirmButton: 'Recharger la page',
//			    confirm: function(){
//			    	$window.location.reload();
//			    },
//			    title: 'Session fermée'
//			});
//			exitModal.open();
//		}
		function showDisconected(){
			var exitModal = new jBox('Modal', {
			    content: $filter('translate')('OFYS_DISCONNECTED'),
			    onClose: function() {
			    	$window.location.reload();
			    }
			});

			exitModal.open();
		}

		function showErrorMessage(m){
//			$.pgwModal({
//				content: "<p class='alert alert-danger'>" + m + "</p>",
//				maxWidth: $( window ).width() * .7,
//				angular: true,
//				closable : true,
//				closeOnEscape : false,
//				closeOnBackgroundClick : false,
//				title: "Erreur retournée par le serveur d'application"
//			});
		}

		$(document).bind('PgwModal::Close', function() {
			that.loadConnection();
		});

		return {
			clientUid: that.clientUid,
			status: function() {
				return that.ws.readyState;
			},
			sendRequest: function(url, data) {
				if (url === undefined)  {
					throw "cant send to undefined url";
				}
				var request = {
					"url" : url,
					"data" : data,
					"clientUid" : that.clientUid
				}
				that.ws.send(JSON.stringify(request));
			},
			send: function(message) {
				if (angular.isString(message)) {
					that.ws.send(message);
				}
				else if (angular.isObject(message)) {
					message.clientUid = that.clientUid;
					that.ws.send(JSON.stringify(message));
				}
			}
		};

	}]);
})();