//******************************	DSQ B2B Function START Angular
(function(){
	var app = angular.module("b2b", []);

	app.factory('B2BAccessor', ['DashAPI', 'model', 'utils',
		function (DashAPI, model, utils) {
		var accessor = {
			send: function (data, callback, error) {
				return DashAPI.post('/dashboard/b2b/send', data, callback, error);
			},
			save: function (data, callback, error) {
				return DashAPI.post('/dashboard/b2b/save', data, callback, error);
			},
			verifyInscription: function (data, callback, error) {
				return DashAPI.post('/dashboard/b2b/verifyInscription', data, callback, error);
			},
			getInscriptionBasicInfos: function (nam, callback, error) {
				return DashAPI.get('/dashboard/b2b/getInscriptionBasicInfos?nam='+nam, callback, error);
			},
			popoverApiInit: function(scope){
				scope.b2bInscriptionEditPopover = {
					activeEditWindow: true,
					onShow: function(api){
						scope.b2bInscriptionEditPopover.api = api;
						utils.showPopoverOverlay(true);
					},
					onHide:function(){
						utils.showPopoverOverlay(false);
					},
					close:function(){
						scope.b2bInscriptionEditPopover.api && 
						scope.b2bInscriptionEditPopover.api.hide && 
						scope.b2bInscriptionEditPopover.api.hide();
					}
				}

				return scope.b2bInscriptionEditPopover;
			}
		};
		return accessor;
	}]);

	app.directive('b2bInfo', ['PatientAccessor','model', function(PatientAccessor, model){
		return {
			restrict: 'E',
			templateUrl: 'b2bInfo_index.html',
			scope: {
				b2bInformation : '=data',
				qv : "=qv",
				options: "=",
			},
			link: function(scope, element, attrs){
				scope.model = model;
				scope.getDisability2DigitCode = function(index){
					var dis = PatientAccessor.b2bVulnerabilityCodes[PatientAccessor.getB2BCode(index, scope.b2bInformation)];
					return dis ? dis[1] : "";
				};

				scope.getDisabilityDescription = function(index){
					var dis = PatientAccessor.b2bVulnerabilityCodes[PatientAccessor.getB2BCode(index, scope.b2bInformation)];
					 return dis ? dis[3] : "";
				};
			}
		};
	}]);

	app.directive('inscrEdit',
			['Store', '$timeout', 'model','B2BAccessor','PatientUtils','ModificationStatus',
			 '$filter','ModificationStatus','$q','QConfirm','PatientAccessor',
		function(Store, $timeout, model, B2BAccessor, PatientUtils, ModificationStatus,
				 $filter, ModificationStatus, $q, QConfirm, PatientAccessor){
		return {
		restrict: 'E',
		templateUrl: '/dashboard/resources/ofys/inscr/update-b2b.html?v=bh',
		scope: {
			patient: "=",
			options: "=?"
		},
		link: function(scope, element, attrs){
			scope.centerInPage = true;
			PatientAccessor.popoverApiInit(scope);
			scope.editPatientPopoverOptions = {
				showExit: true,
				exit:function(){
					scope.patientEditPopover.close();
				}
			};
			scope.vulenerabilityCodes = _.sortBy(_.values(model.enums().b2bDisabilityCode), 'type');
			scope.isDirty = false;
			scope.isReadOnly = false;
			scope.dontSendToRamq = false;
			var isFormDirty = false;
			scope.formDirty = function(){
				var dirty = scope.isDirty || (scope.b2binscriptionform && scope.b2binscriptionform.$dirty);
				// if(isFormDirty !== dirty){
				// 	if(dirty){
				// 		registerDirty();
				// 	}else{
				// 		unregisterDirty();
				// 	}
				// }
				isFormDirty = dirty;
				return isFormDirty
			}
			scope.setDirty = function(isDirty){
				if(isDirty){
					scope.isDirty = isDirty;
				}else{
					scope.b2binscriptionform && scope.b2binscriptionform.$setPristine();
					scope.isDirty = false;
				}
				scope.formDirty();
			}
			scope.model = model;
			scope.Store = Store;
			//init patient for when its a new patient
			var defaultPatientData = {
				modificationStatus: ModificationStatus.STATUS_NEUTRAL
			};
			var defaultOptions = {
				showExit: true,
			};

			function getDateDynaOptions(){
				return {
					acceptFutureDate: false,
					format: 'YYYY-MM-DD',
				};
			}
			scope.registrationDateDynaDateOptions = getDateDynaOptions();
			scope.endDateDynaDateOptions = getDateDynaOptions();
			scope.followupDateDynaDateOptions = getDateDynaOptions();

			if(!scope.options){
				scope.options = {};
			}
			scope.options =  OfysUtils.extendIfNotDefined(scope.options, angular.copy(defaultOptions));
			scope.printPat= function(){
				// console.log(scope.editB2bInfo);
				B2BAccessor.dry(scope.editB2bInfo, function(res){
					// console.log(res);
					scope.editB2bInfo = res;
				})
			}
			scope.getVulName = function(item){
				return (item.type.substring(1)*1 )+ ": "+ item.i18n;
			}
			scope.setResident = function(rep){
				scope.editB2bInfo.professionnalResident = rep;
				scope.editB2bInfo.idProfessionnalResident = scope.editB2bInfo.professionnalResident.id;
				scope.setDirty(true);
			}
			scope.deleteResident = function(){
				delete scope.editB2bInfo.professionnalResident;
				delete scope.editB2bInfo.idProfessionnalResident ;
				scope.setDirty(true);
			}
			scope.setRep = function(rep){
				scope.editB2bInfo.patientRepresentative = rep;
				scope.editB2bInfo.idPatientRepresentative = rep.id;
				scope.setDirty(true);
			}
			scope.deleteRep = function(rep){
				scope.editB2bInfo.patientRepresentative = rep;
				delete scope.editB2bInfo.idPatientRepresentative;
				scope.setDirty(true);
			}
			scope.cancel = function(){
				if(scope.options.close){
					if(scope.formDirty()){
						QConfirm.open({title: $filter('translate')('documentUnsavedChanges')}, {windowClass:'top-modal'})
						.then(function(save){
							if(save){
								return scope.dontSendToRamq? scope.save(): scope.sendToRAMQ();
							}else{
								return scope.options.close();;
							}
						});
					}else{
						scope.options.close();
					}
				}
			}

			scope.saving = false;
			scope.save = function(){
				if(scope.b2binscriptionform.$dirty){
					scope.editB2bInfo.modificationStatus = ModificationStatus.STATUS_UPDATED;
					scope.editB2bInfo.idPatient = scope.patient.id;
					scope.saving = true;
					return B2BAccessor.save(scope.editB2bInfo, function(res){
						scope.saving = false;
						// console.log(res);
						if(res && res.b2bInformation){
							scope.patient.b2bInformation = res.b2bInformation;
							loadB2BInfo(res);
						}
						scope.setDirty(false);
						model.notice().success($filter('translate')('SaveSuccess'));
					}, function(err){
						console.log(err);
						scope.saving = false;
	
					})
				}
//				if(!scope.patient.treatingProfessionnal)model.notice().fail($filter('translate')('b2bNoTreating'));
				return $q.reject();
			}

			function getRAMQSendObject (){
				var sendData = PatientUtils.getCleanPatient(scope.patient);
				sendData.b2bInformation = scope.editB2bInfo;
				return sendData;
			}
			scope.showMonitor = false;
			scope.sendToRAMQ = function(){
				// console.log(patientToRAMQTransmissionObject(getRAMQSendObject()));;
				if(scope.formDirty() && !scope.saving){
					scope.editB2bInfo.modificationStatus = ModificationStatus.STATUS_UPDATED;
					scope.showMonitor = true;
					return transmitToRAMQ(patientToRAMQTransmissionObject(getRAMQSendObject()))
				}
			}

			function patientToRAMQTransmissionObject(patient){
				var res = {};
				res.source = patient;
				if (res.source != null) {
					res.idPatient = res.source.id;
					res.idTreatingProfessionnal = patient.treatingProfessionnal;
					if(scope.editB2bInfo.idPatientRepresentative != undefined){
						res.idPatientRepresentative = scope.editB2bInfo.idPatientRepresentative;
					}
					res.patientRepresentativeType = scope.editB2bInfo.patientRepresentativeType;
					if(scope.editB2bInfo.idProfessionnalResident != undefined){
						res.idProfessionnalResident = scope.editB2bInfo.idProfessionnalResident;
					}
					res.idSiteFollow = scope.editB2bInfo.idSiteFollow;
					res.siteFollowStartDate = scope.editB2bInfo.siteFollowStartDate;
					res.status = scope.editB2bInfo.status;
					res.category = scope.editB2bInfo.category;
					res.startDate = scope.editB2bInfo.startDate;
					res.endDate = scope.editB2bInfo.endDate;
					res.endReason = scope.editB2bInfo.endReason;
					res.vulnerabilities = angular.copy(scope.editB2bInfo.vulnerabilities);
				}
				return res;
			}
			scope.ramqObject;
			function transmitToRAMQ(ramqObject){
				// console.log(ramqObject);
				scope.ramqObject = ramqObject;
				scope.saving = true;
				return B2BAccessor.send(ramqObject, function(res){
					scope.actions = res.actions;
					// scope.actions[1] = angular.copy(scope.actions[0]);
					// scope.actions[2] = angular.copy(scope.actions[0]);
					// scope.actions[0].questions = [
					// 	{seq:1, message:"1.0 Are you ready?"}, 
					// 	{seq:3, message:"3.0 Should we send it?"},
					// ]
					// scope.actions[2].questions = [
					// 	{seq:1, message:"1.2 Are you ready?"}, 
					// 	{seq:3, message:"3.3 Should we send it?"},
					// 	{seq:4, message:"4.3 Should we send it?"},
					// ]
					scope.saving = false;
					if(scope.actions && scope.actions.length == 1 && scope.actions[0].success){
						scope.setDirty(false);
					}
					// console.log(res);
					return scope.answerQuestions();
					// scope.setDirty(false);
					// scope.editB2bInfo = res;
				}, function(err){
					console.log(err);
					scope.saving = false;
				})
			}
			scope.answerQuestions = function(){
				if(hasQuestions()){
					return askAllActionQuestions(scope.actions, 0).then(function(allTrue){
						if(allTrue == true){
							scope.ramqObject.actions = scope.actions;
							return transmitToRAMQ(scope.ramqObject);
						}
					});
				}

				return $q.resolve(false);
			}

			function hasQuestions(){
				if(scope.actions && scope.actions.length > 0){
					for (var i = 0; i < scope.actions.length; i++) {
						if(scope.actions[i].questions != undefined && scope.actions[i].questions.length > 0){
							return true;
						}
					}
				}
				return false;
			}

			function askAllActionQuestions(actions, i){
				for (; i < actions.length && actions[i].questions == undefined; i++) {
					//ignore all actions with no questions.
				}
				if(actions.length > i){
					return askQuestions(actions[i], 0).then(function(allTrue){
						if(allTrue){
							console.log("Action "+actions[i].type +" all questions with yes response");
							return askAllActionQuestions(actions, i+1)
						}
						return false;
					}, function(allTrue){
						// console.log(arguments);
						console.log("Action "+actions[i].type +" at least one answer with No response. RAMQ does not process No responses.");
						return allTrue;
					});
				}
				return $q.resolve(true);
			}

			function askQuestions(a, i){
				if(a.questions.length > i){
					return QConfirm.open({title: a.questions[i].message, qconfirm: {hideCancel: true}}, {windowClass:'top-modal'}).then(function(isYes){
						if(isYes){
							a.questions[i].response = "O";
							return askQuestions(a, i+1);
						}else{
							a.questions[i].response = "N";
							return $q.reject(false);
						}

					}, function(){
						return $q.reject(false);
					})
				}
				return $q.resolve(true);

			}

			scope.searchingRAMQTreating = false;
			scope.getTreatingFromRAMQ = function(){
				if(!scope.searchingRAMQTreating && scope.patient.healthInsuranceNumber){
					scope.searchingRAMQTreating = true;
					B2BAccessor.getInscriptionBasicInfos(scope.patient.healthInsuranceNumber, function(res){
						scope.patient.treatingFromRAMQ = res;
						// console.log(res);
						scope.searchingRAMQTreating = false;
					}, function(err){
						scope.searchingRAMQTreating = false;
						console.error(err);
					})
				}else if(!scope.patient.healthInsuranceNumber){
					model.notice().warn($filter('translate')('MissingHIN'));
				}
			}
			scope.closeMonitorIfOpen = function(){
				if(scope.showMonitor){
					scope.showMonitor = false;
				}
			}

			scope.toggleMonitor = function(){
				scope.showMonitor = !scope.showMonitor;
			}

			scope.preRegister = function(){
				$.extend(scope.editB2bInfo, {
					status: model.enums().b2bInscriptionStatus.INSCRIT_NON_CONFIRME.value,
					category: model.enums().b2bInscriptionCategory.MF.value,
					startDate: moment().format(OfysUtils.DATEFORMAT),
					idSiteFollow: model.user().session.workSite.id,
					siteFollowStartDate: moment().format(OfysUtils.DATEFORMAT)
				});
				scope.setDirty(true);
			}

			scope.register = function(){
				$.extend(scope.editB2bInfo, {
					status: model.enums().b2bInscriptionStatus.INSCRIT_CONFIRME.value,
					category: model.enums().b2bInscriptionCategory.MF.value,
					startDate: moment().format(OfysUtils.DATEFORMAT),
					idSiteFollow: model.user().session.workSite.id,
					siteFollowStartDate: moment().format(OfysUtils.DATEFORMAT),
					endReason: model.enums().b2bnscriptionEndReason.S_O.value,
					endDate: null,
				});
				scope.setDirty(true);
			}

			scope.unregister = function(){
				$.extend(scope.editB2bInfo, {
					status: model.enums().b2bInscriptionStatus.NON_INSCRIT.value,
					endReason: model.enums().b2bnscriptionEndReason.CR1.value,
					endDate: moment().format(OfysUtils.DATEFORMAT),
				});
				scope.setDirty(true);
			}

			scope.removeRegistration = function(){
				$.extend(scope.editB2bInfo, {
					status: model.enums().b2bInscriptionStatus.NON_INSCRIT.value,
					category: null,
					startDate: null,
					endReason: model.enums().b2bnscriptionEndReason.DELETE_INSCRIPTION.value,
					endDate: null,
					idSiteFollow: null,
					siteFollowStartDate: null,
					vulnerabilities:[{},{},{}],
					patientRepresentative:null,
					patientRepresentativeType:model.enums().b2bPatientRepresentativeType.SO.value
				});
				scope.setDirty(true);
			}

			scope.removeInfo = function(){
				$.extend(scope.editB2bInfo, {
					status: model.enums().b2bInscriptionStatus.NON_INSCRIT.value,
					category: null,
					startDate: null,
					endReason: model.enums().b2bnscriptionEndReason.S_O.value,
					endDate: null,
					idSiteFollow: null,
					siteFollowStartDate: null,
					vulnerabilities:[{},{},{}],
					patientRepresentative:null,
					patientRepresentativeType:model.enums().b2bPatientRepresentativeType.SO.value,
					professionnalResident:null
				});
				scope.setDirty(true);
			}

			var defaultVulnerabilityCode = {
				modificationStatus: ModificationStatus.STATUS_NEUTRAL,
				disCode: model.enums().b2bDisabilityCode.C00.type
			};
			var defaultB2BInfo = {
				modificationStatus: ModificationStatus.STATUS_NEUTRAL,
				version:0,
				tag:0,
				patientRepresentativeType: 0,
				category: 0,
				endReason: 0,
				vulnerabilities: [
					angular.copy(defaultVulnerabilityCode),
					angular.copy(defaultVulnerabilityCode),
					angular.copy(defaultVulnerabilityCode)
				]
			};

			function loadB2BInfo(patient){
				if(scope.patient || patient){ //if existing patient
					patient = patient ? patient : scope.patient;
					var patB2b = angular.copy(patient.b2bInformation);
					if(patB2b.vulnerabilities != undefined && patB2b.vulnerabilities.length === 0){
						delete patB2b.vulnerabilities;// make sure vulenerability codes are initiated.
					}
					scope.editB2bInfo = $.extend(angular.copy(defaultB2BInfo),patB2b);
					for (var i = 0; i < scope.editB2bInfo.vulnerabilities.length; i++) {
						scope.editB2bInfo.vulnerabilities[i] = $.extend(angular.copy(defaultVulnerabilityCode), scope.editB2bInfo.vulnerabilities[i]);
					}

					addParentAsRepresentative(patient)
				}
			}

			function addParentAsRepresentative(patient){
				if(patient && (patient.motherId || patient.fatherId) && patient.age < 14){
					var parentId;
					if(patient.fatherId){
						parentId = patient.fatherId;
					}
					if(patient.motherId){
						parentId = patient.motherId;
					}
					scope.editB2bInfo.idPatientRepresentative = parentId;
					scope.editB2bInfo.patientRepresentativeType = 1;
					PatientAccessor.getByIds([parentId], function(res){
						if(res && res.data && res.data.length > 0){
							scope.editB2bInfo.patientRepresentative = res.data[0];
						}
					});
				}
			}

			scope.$watch(scope.patient, loadB2BInfo);
		}
	};
	}]);

})();

