(function() {
	var ia = angular.module('iaFct', ['ngSanitize']);

	ia.factory('IaAccessor', ['DashAPI','$filter','QuickEdit','$q','model', function(DashAPI, $filter, QuickEdit, $q, model) {
		var OfysId = '50FnBm6MJSMYq3VO7ZTud';

		function defaultSofiaPayConfigs(){
			return {headers:  {'key': OfysId, lang: DashAPI.lang} };
		}

//		var sofiaContext = "http://127.0.0.1:8099/sofiapay";//dev
		var sofiaContext = "/sofiapay";//prod
		var accessor = {
			// inclue STT - donc data = byte[] dans Form
			sendChunk: function(data, d2, callback, error) {
				var config = { headers: { 'Content-Type': undefined }, 'transformRequest': angular.identity };
				return DashAPI.post('/dashboard/ia/ws/sendChunk?idAudio=' + d2.idAudio + "&chunkNo=" + d2.chunkNo + '&isFinalChunk=' + d2.isFinalChunk, data, callback, error, config);
			},
			dictation: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/dictation', data, callback, error);
			},
			improveDictation: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/improveDictation', data, callback, error);
			},
			listGeneratedNote: function(callback, error) {
				return DashAPI.post('/dashboard/ia/ws/listGeneratedNote', {}, callback, error);
			},
			generateNewNote: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/generateNewNote', data, callback, error);
			},
			interviewDictation: function(data, d2, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/interviewDictation?noteType=' + d2.noteType + '&sexPat=' + d2.sexPat + (d2.idPatient ? '&idPatient=' + d2.idPatient : ''), data, callback, error);
			},
			medNoteFromNote: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/medNoteFromNote', data, callback, error);
			},
			// fonction de traitement de texte uniquement. data = text:'TEXTE A ANALYSER'
			improveText: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/improveText', data, callback, error);
			},
			noteInfoClin4Form: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/noteInfoClin4Form', data, callback, error);
			},
			summaryEnc4Prof: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryEnc4Prof', data, callback, error);
			},
			summaryEnc4Pat: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryEnc4Pat', data, callback, error);
			},
			encInfoClin4Form: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/encInfoClin4Form', data, callback, error);
			},
			summaryOfDoc4Prof: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryOfDoc4Prof', data, callback, error);
			},
			summaryOfDoc4Pat: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryOfDoc4Pat', data, callback, error);
			},
			summaryOfLab4Pat: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryOfLab4Pat', data, callback, error);
			},
			summaryFile4Prof: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/summaryFile4Prof', data, callback, error);
			},
			getLastEnc3y: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/getLastEnc3y', data, callback, error);
			},
			lastEnc3y: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/lastEnc3y', data, callback, error);
			},
			generatePatientSummary: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/generatePatientSummary', data, callback, error);
			},
			toFrench: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/toFrench', data, callback, error);
			},
			toEnglish: function(data, callback, error) {
				return DashAPI.post('/dashboard/ia/ws/toEnglish', data, callback, error);
			}, 
			openNew: function (data, callback, error) {
				this.checkSubscription().finally(function (res) {
					var act = { className: "CSofia" };
					var payload = { quickEditData: {allowClose: false,allowSettings: true, qeActData: { className: "CSofia" } }, templateUrl: "qe_sofia_editor_index.html", heading: $filter('translate')('NEW_SOFIA')};
					if(data){
						$.extend(act, data);
						payload.qe = { task: act, parseMessage: true };
					}
					var userPref = model.user().sessionUser.user.userPreferences;
					if(userPref.sofiaLicenceExpiring && userPref.sofiaLicenceDaysToExpire > 0){
						return QuickEdit.open(payload);
					}else{
						return QuickEdit.add(payload);
					}
				});
			},
			fetchSubs: function(){
				var userPref = model.user().sessionUser.user.userPreferences;
				if(userPref && userPref.sofiaAuthToken){
					window.open(sofiaContext + '/api/test/licenses?subscriptionKey=' + userPref.sofiaAuthToken, '_blank');
				}else{
					model.notice().info("Aucune clé associer");
				}
				
			},
			getSubscription:function(data, callback, error, config) {
				config = $.extend(defaultSofiaPayConfigs(), config);
				return DashAPI.get(sofiaContext+'/api/subscription/status?subscriptionKey='+data.sofiaAuthToken, 
					callback, error, config);
			},
			parseAuthToken: function(data, status) {
				var userPref = model.user().sessionUser.user.userPreferences;
				const parsed = KJUR.jws.JWS.parse(data.authToken);
				console.log(parsed);

				var jDateFormat = "YYYY-MM-DDTHH:mm:ss.SSSZ";
				data.auth = parsed.payloadObj;
				data.acceptedAgreementOn = moment(data.acceptedAgreementOn, jDateFormat).format(OfysUtils.DATEFORMAT);
				data.endDate = moment(data.auth.licenseEnd).format(OfysUtils.DATEFORMAT);
				model.user().sofia.subscription = data;

				if(status != null && status.length > 0){
					for (var i = 0; i < status.length; i++) {
						if(status[i].code == "LICENSE_EXPIRING"){
							userPref.sofiaLicenceExpiring = true;
							userPref.sofiaLicenceDaysToExpire = moment(data.end_date,OfysUtils.DATEFORMAT ).diff(moment(), 'days');
						}
						if(status[i].code == "LICENSE_EXPIRED"){
							userPref.sofiaLicenceExpired = true;
						}
					}

				}

				if(!!userPref.sofiaLicenceExpired){
					model.user().sessionUser.user.userPreferences.sofiaEnabled = false;
				}else{
					model.user().sessionUser.user.userPreferences.sofiaEnabled = true;
				}
			},
			checkSubscription: function() {
				var defer = $q.defer();
				var userPref = model.user().sessionUser.user.userPreferences;
				if(userPref == null || userPref.sofiaAuthToken == null){
					defer.reject("No subscription key");
					return defer.promise;
				}

				this.getSubscription(userPref, function (data, status) {
					console.log("Success getSubscription");
					console.log(data);
					accessor.parseAuthToken(data, status);
					defer.resolve(data);
				}, function (res) {
					console.log("Failed getSubscriptionStatus");
					console.log(res);
					model.user().sofia.subscription = null;
					defer.reject(res);
				},{showWarnings:false});

				return defer.promise;
			},
			getPricing:function(data, callback, error) {
				var params = '?licenceType=SOFIA&province='+data.province+'&userType='+data.userType;
				if(data.subscriptionKey != null){
					params += '&subscriptionKey='+data.subscriptionKey;
				}
				return DashAPI.get(sofiaContext+'/api/license/pricing'+params, 
					callback, error, defaultSofiaPayConfigs());
			},
			getPrice:function(data, callback, error) {
				return DashAPI.get(sofiaContext+'/api/license/price?licenseId='+data.licenseId+'&pricingId='+data.pricingId+'&province='+data.province, 
					callback, error, defaultSofiaPayConfigs());
			},
			checkout:function(data, callback, error) {
				return DashAPI.post(sofiaContext+'/api/activate/checkout', data, callback, error,defaultSofiaPayConfigs());
			}
		};
		return accessor;
	}]);

	ia.directive('sofiaEdit', ['DashAPI', '$timeout', 'model', '$q', 'PrefAccessor', 'IaAccessor', 'MessageLink', '$filter', 'PatientFormService', 'ModificationStatus',
		function (DashAPI, $timeout, model, $q, PrefAccessor, IaAccessor, MessageLink, $filter, PatientFormService, ModificationStatus) {
			return {
				restrict: 'E',
				templateUrl: '/dashboard/resources/ofys/ia/sofia_edit.html?v=be',
				link: function (scope, element, attrs) {
					scope.model = model;
					scope.isProd = DashAPI.isProd();
					
					var pageTemplate = {loading: false, loaded: false, init: function() {}};

					var profFeatures = [
						{i18n:'SOFIA_PROF_FEATURE_1'},
						{i18n:'SOFIA_PROF_FEATURE_2'},
						{i18n:'SOFIA_PROF_FEATURE_3'},
						{i18n:'SOFIA_PROF_FEATURE_4'}
					];
					var employeeFeatures = [
						{i18n:'SOFIA_EMPL_FEATURE_1'},
						{i18n:'SOFIA_EMPL_FEATURE_2'},
						{i18n:'SOFIA_EMPL_FEATURE_3'},
						{i18n:'SOFIA_EMPL_FEATURE_4'}
					];
					
					scope.ctrl = {
						features: model.user().isProf ? profFeatures : employeeFeatures,
						sameUserCardInfo: true,
						pageLoading: function (page) {
							scope.ctrl.pages[page].loading = true;
							scope.ctrl.errors = null;
						},
						pageLoadingEnd: function (page) {
							scope.ctrl.pages[page].loading = false;
						},
						renewLicence: function () {
							scope.ctrl.loadPage('pricing');
						},
						loadPage: function (page) {
							scope.ctrl.errors = null;
							scope.ctrl.page = page;
							scope.ctrl.currPage = scope.ctrl.pages[page];
							if (scope.ctrl.pages[page].loaded) {
								return;
							}
							scope.ctrl.pages[page].init();
							scope.ctrl.pages[page].loading = false;
							scope.ctrl.pages[page].loaded = true;
						},
						lang:function(){
							return DashAPI.lang === 'en' ? 'En' : 'Fr';
						},
						conditionsOpened: function(){
							this.userOpenedconditions = true;
						},
						checkConditions: function() {
							if (!scope.ctrl.userOpenedconditions) {
								window.open('https://ofys.ca/fr/conditions_utilisation.html', '_blank');
								this.conditionsOpened();
							}
							scope.ctrl.errors = null;
						},
						// loadPage: function (page) {	
						page: 'home',//home, pricing
						pageList: ['home', 'pricing', 'checkout', 'checkout_outcome', 'intro', 'settings', 'expired'],
						pages: {
							home: $.extend(true,{}, pageTemplate, {
								next: function () {
									scope.ctrl.loadPage('pricing');
								}
							}),
							pricing: $.extend(true,{},pageTemplate, {
								init: function () {
									scope.getPricing();
								},
								previous: function () {
									scope.ctrl.loadPage('home');
								},
								next: function () {
									scope.ctrl.pageLoading('pricing');
									scope.ctrl.priceDetails(scope.ctrl.selectedTier).then(function(){
										scope.ctrl.pageLoadingEnd('pricing');
										scope.ctrl.loadPage('checkout');
									});
								}
							}),
							checkout: $.extend(true,{}, pageTemplate, {
								init: function () {
									if(scope.ctrl.checkout == null){
										scope.ctrl.checkout = {};
									}
									scope.ctrl.checkout.province ="QC";
								},
								previous: function () {
									scope.ctrl.loadPage('pricing');
								},
								next: function () {
									if(!scope.ctrl.pages.checkout.loading){
										if(!scope.ctrl.conditions){
											scope.ctrl.errors = {"code":"IA_CONDITIONS_NOT_ACCEPTED_TITLE","message":'IA_CONDITIONS_NOT_ACCEPTED'};
											return;
										}
										// scope.ctrl.errors = PatientFormService.getFormErrors(scope.ctrl.checkoutFrm,null,"});
										// scope.checkoutFrm.$validate();
										// if(scope.checkoutFrm.$invalid){
											scope.ctrl.pageLoading('checkout');
											scope.ctrl.pay().then(function(){
												scope.ctrl.pageLoadingEnd('checkout');
												scope.ctrl.loadPage('checkout_outcome');
											}, function(){
												scope.ctrl.pageLoadingEnd('checkout');
											}) ;
										// }
									}
								}
							}),
							checkout_outcome: $.extend(true,{}, pageTemplate, {
								previous: function () {
									scope.ctrl.loadPage('pricing');
								},
								next: function () {
									scope.ctrl.loadPage('intro');
								}
							}),
							intro: $.extend(true,{}, pageTemplate, {
								// previous: function () {
								// 	// scope.ctrl.loadPage('home');
								// },
								next: function () {
									// scope.ctrl.loadPage('checkout');
								}
							}),
							expired: $.extend(true,{}, pageTemplate, {
								// previous: function () {
								// 	// scope.ctrl.loadPage('home');
								// },
								next: function () {
									// scope.ctrl.loadPage('checkout');
								}
							}),
							settings: $.extend(true,{}, pageTemplate, {
								init: function () {
									// scope.ctrl.loadPage('home');
								},
								next: function () {
									scope.ctrl.loadPage('pricing');
								}
							}),
						},
						priceDetails: function (tier) {
							if (tier) {
								var defer = $q.defer();
								IaAccessor.getPrice({
									licenseId:tier.id,
									pricingId:tier.selectedPrice.id,
									province: "QC"
								}, function (data) {
									console.log("Success getPrice");
									console.log(data);
									tier.bill = data;
									defer.resolve(data);
								}, defer.reject);
								return defer.promise;
							}
							return $q.reject("No tier selected");
						},
						pay:function() {
							$.extend(scope.ctrl.checkout, {
								//Section information du paiement
								"licenseId": scope.ctrl.selectedTier.id+"",
								"pricingId": scope.ctrl.selectedTier.selectedPrice.id+"",
								"currency": "CAD",
							});
							scope.setSubscriber(scope.ctrl.checkout);
							scope.ctrl.checkout.remoteId = model.user().sessionUser.user.id;
							if(scope.ctrl.sameUserCardInfo){
								scope.ctrl.checkout.cardOwner = scope.ctrl.checkout.username;
								scope.ctrl.checkout.cardEmail = scope.ctrl.checkout.userEmail;
							}

							console.log(scope.ctrl.checkout);
							var defer = $q.defer();
							IaAccessor.checkout(scope.ctrl.checkout, function (data, status) {
								console.log("Success checkout");
								scope.ctrl.checkout.outcome = data;
								IaAccessor.parseAuthToken(data, status);// set subscription key to model
								scope.saveSofiaAuthKey(model.user().sofia.subscription.auth.sub).then(function(){
									console.log("Success saveSofiaAuthKey");
									defer.resolve(data);
								}, function(res){
									defer.reject(res);
								});
								
							}, function (res) {
								scope.ctrl.errors = res.data.status;
								defer.reject(res);
							});

							return defer.promise;
						},
						setSelectedPrice: function (tier, price) {
							tier.selectedPrice = price;
							this.setSelectedTier(tier);
						},
						setSelectedTier: function (tier) {
							scope.ctrl.selectedTier = tier;
						},
						setSelectedTierAndPrice: function (tier,price) {
							this.setSelectedTier(tier);
							this.setSelectedPrice(tier, price);
						}
					};
					const CARD_VALIDATION_REGEX = "^(?:4\\d{12}(?:\\d{3})?|(?:5[1-5]\\d{2}|222[1-9]|22[3-9]\\d|2[3-6]\\d{2}|27[01]\\d|2720)\\d{12}|3[47]\\d{13}|6011\\d{12}|65\\d{14}|64[4-9]\\d{13}|622(?:12[6-9]|1[3-9]\\d|[2-8]\\d{2}|9[01]\\d|92[0-5])\\d{10})$"
					scope.validFn = {
						isValidCardNumber: function(cardNumber){
							if(!cardNumber || !cardNumber.match(CARD_VALIDATION_REGEX)){
								return false;
							}
							let sum = 0;
							let shouldDouble = false;
							for (let i = cardNumber.length - 1; i >= 0; i--) {
								let digit = parseInt(cardNumber.charAt(i));
						
								if (shouldDouble) {
									digit *= 2;
									if (digit > 9) digit -= 9;
								}
								
								sum += digit;
								shouldDouble = !shouldDouble; // Toggle doubling
							}
							return sum % 10 === 0;
						}
						
					}
					
					

					scope.setSubscriber = function (subscribe) {
						if(model.user().sessionUser.user.userPreferences.sofiaAuthToken){
							subscribe.subscruptionId = model.user().sessionUser.user.userPreferences.sofiaAuthToken
						}
						return subscribe;
					}
					scope.saveSofiaAuthKey = function(authKey){
						var userPref = angular.copy(model.user().sessionUser.user.userPreferences);
						var defer = $q.defer();
						if(userPref != null && authKey != null){
							userPref.sofiaAuthToken = authKey;
							userPref.modificationStatus = ModificationStatus.STATUS_UPDATED;
							return PrefAccessor.saveUserPref(userPref, function(res,status){
								model.user().sessionUser.user.userPreferences = res;
								defer.resolve(res);
							}, function(res){
								model.notice().fail($filter('translate')(res.msg));
								defer.reject(res);
							})
						}else{
							var msg = 'PatientSaveInvalidForm';
							model.notice().fail($filter('translate')(msg));
							defer.reject($filter('translate')(msg));
						}
						return defer.promise;
					}

					function init() {
						if(model.user().sofia.subscription == null && model.user().sessionUser.user.userPreferences.sofiaAuthToken != null){
							IaAccessor.checkSubscription().then(doInit, function(){
								doInit();
							});
						}else{
							doInit();
						}
						function doInit(){
							//set pages template
							for (let i = 0; i < scope.ctrl.pageList.length; i++) {
								scope.ctrl.pages[scope.ctrl.pageList[i]].templateUrl = scope.ctrl.pageList[i]+"_sofiaedit.html";
							}
							var userPref = model.user().sessionUser.user.userPreferences;
							// set default page
							if(userPref.sofiaLicenceExpired){
								scope.ctrl.loadPage('expired');
							}else if(model.user().sofia.enabled() ) {
								scope.ctrl.loadPage('intro'); 
							}else{
								scope.ctrl.loadPage('home');
							}
							// scope.ctrl.loadPage('home');
							// scope.ctrl.loadPage('pricing');
							scope.qe.modal.toggleSettings = function () {
								if (scope.ctrl.page !== 'settings') {
									scope.ctrl.rememberPage = scope.ctrl.page;
									scope.ctrl.loadPage('settings');
								} else {
									if(scope.ctrl.rememberPage != null && scope.ctrl.pages[scope.ctrl.rememberPage] != null){
										scope.ctrl.loadPage(scope.ctrl.rememberPage);
									}else{
										scope.ctrl.loadPage('intro');
									}
								}
							}
						}
					}

					scope.fetchSubs = function () {
						IaAccessor.fetchSubs();
					}

					scope.getPricing = function () {
						var requestParams = {
							userType: scope.model.user().isProf?1:2,
							province:"QC"
						};
						if(model.user().sofia.enabled() != null){
							requestParams.subscriptionKey = model.user().sessionUser.user.userPreferences.sofiaAuthToken;
						}
						scope.ctrl.pricing =  IaAccessor.getPricing(requestParams,function (data) {
							console.log("Success getPricing");
							console.log(data);
							scope.ctrl.tiers = data;
							var initialSelectIndex = null;
							for (var i = 0; i < scope.ctrl.tiers.priceTiers.length; i++) {
								scope.ctrl.setSelectedPrice(scope.ctrl.tiers.priceTiers[i], scope.ctrl.tiers.priceTiers[i].pricing[0]);
								if(initialSelectIndex === null && scope.ctrl.tiers.priceTiers[i].available == true){
									initialSelectIndex = i;
								}
							}
							scope.ctrl.setSelectedTier(scope.ctrl.tiers.priceTiers[initialSelectIndex]);
						}
						,function (res) {
							console.log("Failed getPricing");
							console.log(res);
							
							if(!res.data || res.data.status == null){
								scope.ctrl.errors = {code:"SOFIAPAY_SERVICE_DENIAL_ERROR", message:"SOFIAPAY_SERVICE_DENIAL_DETAIL_ERROR"};
							}
						});
					}

					init();

				}
			};
	}]);

	ia.factory('iaService', ['$timeout', '$compile', '$translate', function($timeout, $compile, $translate) {
		var iaScope;
		return {
			setIaScope: function(scope) {
				iaScope = scope;
			},
			startRecording: function(textareaElement, inputText, choice, sexPat, patient, enc) {
				if (iaScope && iaScope.startRecordingViaApi) {
					return iaScope.startRecordingViaApi(textareaElement, inputText, choice, sexPat, patient, enc);
				}
				return null; // Handle case where directive is not yet initialized
			},
			endRecording: function() {
				if (iaScope && iaScope.endRecordingViaApi) {
					return iaScope.endRecordingViaApi();
				}
				return null; // Handle case where directive is not yet initialized
			},
			openTextWindow: function(text) {
				openTextWindow(decodeURIComponent(text));
			},
			insertTextAtCursor: function(textareaElement, text) {
				if (!isInDOM(textareaElement)) {
					openTextWindow(decodeURIComponent(text));
					return;
				}
				if (textareaElement.setSelectionRange) {
					$timeout(function() {
						var start = textareaElement.selectionStart;
						var end = textareaElement.selectionEnd;
						textareaElement.value = textareaElement.value.substring(0, start) + (start == 0 ? '' : ' ') + text + textareaElement.value.substring(end);
						var newEnd = start + (start == 0 ? '' : ' ') + text.length;
						textareaElement.selectionStart = newEnd;
						textareaElement.selectionEnd = newEnd;
						// Trigger a change event
						var event = new Event('input', { bubbles: true });
						textareaElement.dispatchEvent(event);
						// textareaElement.focus();
					}, 0);
				} else if (textareaElement.createTextRange) {
					var range = document.selection.createRange();
					range.collapse(true);
					range.text = text;
					range.select();
					var event = new Event('input', { bubbles: true });
					textareaElement.dispatchEvent(event);
				}
			},
			replaceText: function(textareaElement, text) {
				if (!isInDOM(textareaElement)) {
					openTextWindow(decodeURIComponent(text));
					return;
				}
				$timeout(function() {
					textareaElement.value = text.replaceAll('\\*', '*').replaceAll('\\#', '#').replaceAll('\\[', '[').replaceAll('\\]', ']').replaceAll('\\_', '_');
					// Trigger a change event
					var event = new Event('input', { bubbles: true });
					textareaElement.dispatchEvent(event);
					textareaElement.focus();
				}, 0);
			},
			showModal: function(text) {
				iaScope.text = text;
				var modal = angular.element(`
			        <div class="ia-modal">
			            <div class="ia-modal-content">
			                <div class="draggable-handle-not-used"></div>
			                <div class="textarea-container" ng-class="{ 'locked': readOnly }">
			                <i ng-show="readOnly" class="fa fa-lock lock-icon"></i>
			                <textarea class="ia-texte" ng-readonly="readOnly">{{text}}</textarea>
			                <span class="ia-resp-valid">{{'VOTRE_RESP_DE_VALIDER'|translate}}</span>
			                <div class="button-group">
			                    <button ng-click="copyToClipboard()">{{'copy_app'|translate}}</button>
			                    <button ng-click="closeModal()">{{'Close'|translate}}</button>
			                </div>
			            </div>
			            </div>
			        </div>
			    `);
				var compiledContent = $compile(modal)(iaScope);
				document.body.appendChild(compiledContent[0]);

				iaScope.hasParentText = function() {
					return element[0].nodeName.toLowerCase() !== 'div';	 // les div n'ont pas de texte.
				};

				iaScope.closeModal = function() {
					modal.remove();
				};

				// Copier dans le presse-papier
				iaScope.copyToClipboard = function() {
					var textarea = compiledContent.find('textarea')[0];
					textarea.select();
					document.execCommand('copy');
					modal.remove();
				};
			}

		}

		function isInDOM(element) {
			return document.body.contains(element);
		}

		function openTextWindow(text) {
			OfysUtils.openTextWindow(text);
		}

	}]);

	ia.directive('iaTools', ['model', 'IaAccessor', 'iaService', '$translate', '$timeout', function(model, IaAccessor, iaService, $translate, $timeout) {
		return {
			restrict: 'E',
			templateUrl: '/dashboard/resources/ofys/ia/ia_tools.html?v=bh',
			scope: true,
			link: function(scope, element, attrs) {
				if (scope.model.user().sofia.enabled() !== true) return;

				var noteType = function() {
					return scope.model.prefSettings('user_settings_medNoteType');
				};
				
				model.isDoingRecording = false;	// true que ce soit isRecording ou isPause ou isProcessing;
				model.isRecording = false;
				scope.isPaused = false;
				scope.isProcessing = false;
				var reprendre = $translate.instant('CONTINUE');
				var pause = $translate.instant('PAUSE');
				var terminer = $translate.instant('TERMINER');

				scope.idAudio;	// = model.getSession().idAudio;
				scope.chunkNo = 0;
				let microphone;
				let mediaRecorder;
				const shortSilenceDuration = 300; // ms
				const longSilenceDuration = 2000; // ms
				let lastNonSilenceTime = 0;
				let pauseTime = 0;
				let chunkRecordingDuration = 0;
				const minRecordingDuration = 20000;
				let isRecordingSpeech = false;
				
				scope.pause = function() {
					return scope.isPaused ? reprendre : pause;
				};
				scope.terminer = function() {
					return terminer;
				};
				
				const silenceThreshold = -51; // dB
				function getSilenceThreshold() {
					return silenceThreshold;
				}
				let decibels = 0;
				function setDecibels(d) {
					decibels = d;
				}
				function getDecibels() {
					return decibels;
				}
				
				// Function to start recording via API
				scope.startRecordingViaApi = function(textareaElement, inputText, choice, sexPat, patient, enc) {
					if (model.isRecording == true || scope.isPaused == true || scope.isProcessing == true) {
						model.notice().warn($translate.instant('recordingAlreadyInProgress'));
						return;
					}
					if (mediaRecorder && mediaRecorder.state=='recording') {
						// ne devrait pas arriver!
						console.error("Ne deverait pas passer ici car on commence une session d'enregistrement et mediaRecorder.state=='recording'! ");
						
						try {
							mediaRecorder.stop();
							mediaRecorder = null;
						} catch (error) {
							console.error('Erreur arret mediaRecorder:', error);
						}
					} 
					const audioContextRec = new (window.AudioContext || window.webkitAudioContext)({
					    sampleRate: 16000,
					    latencyHint: 'interactive'
					});
					let analyserRec = audioContextRec.createAnalyser();
					analyserRec.fftSize = 8192; 
					analyserRec.smoothingTimeConstant = 0.2; // Lower value for quicker response to changes
					
					scope.encounter = enc;
					scope.idAudio = undefined;
					scope.stt_note = '';
					scope.chunkNo = 0;
					scope.textCaller = inputText || '';
					//scope.postConsent = postConsent;	// method that should be called if consent is ok - called from interview recording
					scope.choice = choice;
					scope.sexPat = sexPat;
					scope.recordingPatient = patient;
					scope.textareaElement = textareaElement;
					navigator.mediaDevices.getUserMedia({ audio: true })
						.then(stream => {
					        microphone = audioContextRec.createMediaStreamSource(stream);
					        microphone.connect(analyserRec);
							lastNonSilenceTime = Date.now();
							chunkRecordingDuration = 0;
							
							isRecordingSpeech = false;
							let mustSendNextChunk = true;
					        
							// Helper function to create a new MediaRecorder
							function createNewMediaRecorder(stream) {
							    const options = {
							        mimeType: 'audio/webm;codecs=opus',
							        audioBitsPerSecond: 16000,
							        channelCount: 1,
							        sampleRate: 16000
							    };
								if (!mediaRecorder) {
								    mediaRecorder = new MediaRecorder(stream, options);
								    mediaRecorder.onstart = () => {
								        //console.log("New MediaRecorder started");
								        model.isDoingRecording = true;
										model.isRecording = true;
										scope.isPaused = false;
										scope.isProcessing = false;
										scope.$apply();
//										if (!isMediaRecorderRestart) {
//											isMediaRecorderRestart = true;
									        checkAudioLevel();
		        					        drawWaveform(stream, {});
//										}
								    };
								    
								    mediaRecorder.ondataavailable = event => {
							            console.log(`ondataavailable! mustSendNextChunk=${mustSendNextChunk}, isRecordingSpeech=${isRecordingSpeech}, chunkRecordingDuration=${chunkRecordingDuration} ms, data.size=${event.data.size} bytes` );
										if (mustSendNextChunk===false && chunkRecordingDuration==0 && !isDone()) {
											console.log('mustSendNextChunk===false and !isDone(). We ignore the chunk.');
											return;
										}
							            const formData = new FormData();
							            formData.append('audio', event.data, 'audio.webm');
							            var d2 = { 
							                'idAudio': scope.idAudio, 
							                'chunkNo': ++scope.chunkNo,
							                'isFinalChunk': isDone()
							            };
							            sendChunkWithRetry(formData, d2);
								    };
							   	}
							    
							    // Start the new recorder
							    mediaRecorder.start();
							}					        
					        					
					        function checkAudioLevel() {
								if (model.isRecording  && !scope.isPaused) {
								    let dataArray = new Float32Array(analyserRec.fftSize);
								    analyserRec.getFloatTimeDomainData(dataArray);
								    
								    // Calculate RMS (Root Mean Square) value
								    let rms = Math.sqrt(dataArray.reduce((sum, val) => sum + val * val, 0) / dataArray.length);
								    
								    // Convert RMS to dB, with a noise floor
								    let dB = 20 * Math.log10(Math.max(rms, 1e-10));
									// console.log("dB volume = " + dB);
						            // console.log("Silence:" + getIntegerPart(dB));
						            let currentTime = Date.now();
						            setDecibels(dB);
						            if (dB >= silenceThreshold) {
										//console.log("dB > silence threshold -> isRecordingSpeech = true, db = " + getIntegerPart(dB));
										isRecordingSpeech = true;
										chunkRecordingDuration += currentTime - lastNonSilenceTime;
						                lastNonSilenceTime = currentTime;
						            } else {
						                let silenceDuration = currentTime - lastNonSilenceTime;
										//console.log("dB < silence threshold (" + (10 * getIntegerPart(dB)) + "db) isRecordingSpeech=" + isRecordingSpeech);
						                if (isRecordingSpeech) {
							                if (chunkRecordingDuration>minRecordingDuration && silenceDuration>shortSilenceDuration) {
												//console.log("restart recording to create a chunk. chunkRecordingDuration=" + chunkRecordingDuration);
												mustSendNextChunk = true;
							                    restartMediaRecorder();
							                } else if (silenceDuration > longSilenceDuration) {
												// ici la pause est > 3s mais la durée est < 25s. si on a un enreg. > 1 sec mais de moins de 25 sec, on restart pour générer un chunk
												//console.log("silenceDuration > longSilenceDuration. chunkRecordingDuration=" + chunkRecordingDuration);
												mustSendNextChunk = true;
												lastNonSilenceTime = currentTime;
							                    restartMediaRecorder(true);							
											}
										} else if (silenceDuration > longSilenceDuration) {
											// chuck de 2 sec qu'on ignore si silence continue
											//console.log("On ignore ce segment: silenceDuration=" + silenceDuration);
											mustSendNextChunk = false;
											lastNonSilenceTime = currentTime;
							                restartMediaRecorder();
										}
						            }
								} else {
									//console.log("*** model.isRecording == false OU scope.isPaused");									
								}
					            if (isDone()) {
									//console.log("*** isDone() is true");									
								} else {
						            requestAnimationFrame(checkAudioLevel);									
								}
								function restartMediaRecorder(stopRecordingSpeech) {
									chunkRecordingDuration = 0; 
									if (mediaRecorder) {
										if (stopRecordingSpeech===true) {
											isRecordingSpeech = false;												
										}
										mediaRecorder.stop();
										setTimeout(() => {
											if (!isDone() && mediaRecorder.state!='recording') {
												mediaRecorder.start();
											}
										}, 120);		
									}
								}
					        }
					        createNewMediaRecorder(stream);
						})
						.catch(error => console.error('Error accessing media devices.', error));
						
				};

				function getIntegerPart(value) {
				    // Divide the value by 10 and use Math.floor to get the integer part
				    return Math.floor(value / 10);
				}
				
				scope.endRecordingViaApi = function() {
					stopRecording();
				}
				
				function togglePause() {
					if (model.isRecording) {
					    pauseRecordingWithDelay().then(() => {
						  pauseTime = Date.now();
					      model.isRecording = false;
					      scope.isPaused = true;
					      ctx.clearRect(0, 0, canvas.width, canvas.height); // Clear the waveform canvas
					      hideSilenceWarning();
					      //scope.$apply();
					    });						
					} else if (scope.isPaused) {
						var pauseDuration = pauseTime - lastNonSilenceTime;
						lastNonSilenceTime += pauseDuration ;
						mediaRecorder.resume();
						model.isRecording = true;
						scope.isPaused = false;
						drawWaveform(mediaRecorder.stream, {}); // Restart the waveform drawing
						//scope.$apply();
					}
				}

				function stopRecording() {
					scope.conversationOpen = false;
					model.isDoingRecording = false;
					model.isRecording = false;
					scope.isPaused = false;
					scope.isProcessing = true;
					ctx.clearRect(0, 0, canvas.width, canvas.height); // Clear the waveform canvas
					hideSilenceWarning();
					try {
						mediaRecorder.stop();
					} catch (error) {
						console.error('Erreur arret mediaRecorder:', error);
					}
				}

				function isDone() {
					return model.isRecording===false && scope.isPaused===false;
				}
				
				function waitForRecordingState() {
				  return new Promise((resolve) => {
				    const maxAttempts = 10; // Approximately 100ms with 10ms interval
				    let attempts = 0;
				    
				    function checkState() {
				      if (attempts >= maxAttempts) {
				        resolve(false); // Timeout, did not enter 'recording' state
				      } else {
				        attempts++;
				        
				        if (mediaRecorder.state === 'recording') {
				          resolve(true); // Entered 'recording' state
				        } else {
				          setTimeout(checkState, 10); // Check again after 10ms
				        }
				      }
				    }
				    
				    checkState();
				  });
				}
				
				async function pauseRecordingWithDelay() {
				  if (await waitForRecordingState()) {
				    try {
				      mediaRecorder.pause();
				    } catch (error) {
				      console.error('Error pausing MediaRecorder:', error);
				    }
				  } else {
				    console.log('Timeout: MediaRecorder did not enter "recording" state within the expected timeframe.');
				  }
				}				
				// Update sendChunk function to accept formData directly
				function sendChunk(formData, d2) {
					return new Promise((resolve, reject) => {
						IaAccessor.sendChunk(formData, d2,
							function onSuccess(response) {
								resolve(response);
							},
							function onFailure(error) {
								reject(error);
							}
						);
					});
				}

				
				// Add a queue to track pending chunk requests
				scope.pendingChunks = [];
				scope.processingChunk = false;
				
				// function to use a queue
				async function sendChunkWithRetry(formData, d2, maxRetries = 3) {
				    // Add this chunk request to the queue
				    const chunkRequest = { formData, d2, maxRetries };
				    scope.pendingChunks.push(chunkRequest);
				    
					function doProcessNextChunk() {
						// console.log('doSendAndGetTextResul.  scope.processingChunk=' + scope.processingChunk);
						if (scope.processingChunk===false) {
					        processNextChunk();
						} else {
							$timeout(doProcessNextChunk, 200);													
						}
			        }
					doProcessNextChunk();
				}
				
				// Function to process chunks sequentially
				async function processNextChunk() {
				    const logPrefix = '[processNextChunk]'; // Consistent prefix for logs
				
				    try {
				        if (scope.pendingChunks.length === 0) {
				            console.log(`${logPrefix} No more chunks to process. Setting processingChunk to false.`);
				            scope.processingChunk = false;
				
				            // If recording is done and we have an idAudio, get the text result
				            if (scope.idAudio && isDone()) {
				                console.log(`${logPrefix} Recording is done. Fetching text result for idAudio: ${scope.idAudio}`);
				                getTextResult(scope.idAudio);
				                scope.idAudio = undefined;
				            }
				            return;
				        }
				
				        console.log(`${logPrefix} Processing next chunk. Pending chunks left: ${scope.pendingChunks.length}`);
				        scope.processingChunk = true;
				        const { formData, d2, maxRetries } = scope.pendingChunks.shift();
						d2.idAudio = scope.idAudio;	// car possible que le premier idAudio n'était pas dispo quand objet ajoute ds array
						
				        for (let i = 0; i < maxRetries; i++) {
				            try {
				                console.log(`${logPrefix} Attempt ${i + 1}/${maxRetries} to send chunk ${d2.chunkNo}`);
				                const response = await sendChunk(formData, d2);
				
				                if (response.data && response.data.success === false) {
				                    console.error(`${logPrefix} ERR: Chunk ${d2.chunkNo} failed with message: ${response.data.ms}`);
				                } else {
				                    console.log(`${logPrefix} Success: response.idAudio=${response.data.id}, chunkNo=${d2.chunkNo}`);
				                    if (response.data!=undefined) {
										if (response.data.id && response.data.id!=-1) {
											scope.idAudio = response.data.id;
										}
										if (MyNamespace.helpers.isNotEmpty(response.data.note)) {
											scope.stt_note += '\n' + response.data.note;
										}
									} else {
					                    scope.idAudio = undefined;
									}
				                }
				
				                // Process the next chunk in the queue
				                processNextChunk();
				                return;
				            } catch (error) {
				                console.error(`${logPrefix} Attempt ${i + 1}/${maxRetries} failed for chunk ${d2.chunkNo}:`, error);
				
				                if (i === maxRetries - 1) {
				                    console.error(`${logPrefix} All retries exhausted for chunk ${d2.chunkNo}. Moving to next chunk.`);
				                    scope.processingChunk = false;
				                    processNextChunk(); // Move to the next chunk even if this one failed
				                    return;
				                }
				
				                // Exponential backoff before retrying
				                const delay = 1000 * Math.pow(2, i);
				                console.log(`${logPrefix} Retrying in ${delay}ms for chunk ${d2.chunkNo}`);
				                await new Promise(resolve => setTimeout(resolve, delay));
				            }
				        }
				    } catch (unexpectedError) {
				        console.error(`${logPrefix} Unexpected error occurred:`, unexpectedError);
				        scope.processingChunk = false; // Ensure processing is marked as done in case of unexpected errors
				    }
				}
				
				function getGranularEncData(encounter) {
					var extraData = "";
						try {
							if (encounter) {
								var l = encounter;
								var lBp = "";
								if (l.lstBloodPres && l.lstBloodPres.length && l.lstBloodPres.length>0) {
									for (i2 = 0; i2 < l.lstBloodPres.length; i2++) {
										var bp = l.lstBloodPres[i2];
										lBp += 'TA/BP: ' + OfysUtils.default(bp.systolic, '-') + '/' + OfysUtils.default(bp.diastolic, '-')  + ', FC/HR:' + OfysUtils.default(bp.pulse, '-') + ', saturation:' + OfysUtils.default(bp.saturation,'-') + '\n';
									}
								}
								var lTemp = "";
								if (l.lstBodyTemp && l.lstBodyTemp.length && l.lstBodyTemp.length>0) {
									for (i2 = 0; i2 < l.lstBodyTemp.length; i2++) {
										lTemp += 'Temperature:' + OfysUtils.default(l.lstBodyTemp[i2].bodyTemperature, '-') + '\n';
									}
								}
								var lFreq = "";
								if (l.lstFreq && l.lstFreq.length && l.lstFreq.length>0) {
									for (i2 = 0; i2 < l.lstFreq.length; i2++) {
										lFreq += 'frequence respiratoire (FR)/breathing frequency (BF): ' + OfysUtils.default(l.lstFreq[i2].respiration,'-') + '\n';
									}
								}
								//var lMeas = "";
								//if (l.lstMeasurement && l.lstMeasurement.length && l.lstMeasurement.length>0) {
								//	for (i2 = 0; i2 < l.lstMeasurement.length; i2++) {
								//		var m = l.lstMeasurement[i2];
								//		lMeas += 'poids/weight:' + m.descr[1] + ', taille/height:' + m.descr[2] + ', tour de taille/waist measurement:' + m.m.descr[3] + '\n';
								//	}
								//}
								extraData = lBp + lTemp + lFreq;
							}
						} catch (err) {
							console.error('Erreur: ' + err);
						}
					return extraData;
				}
				
				// bon pour splitter le résultat d'une note médicale pour généric et conclusion.
				function splitMedicalReport(report) {
				    const regex = /^(Analyse|Assessment|IMPRESSIONS)\b/i; // Case-insensitive match for the keywords
				    const lines = report.split('\n');
				    let splitIndex = -1;
				
				    // Find the first line that matches the criteria
				    for (let i = 0; i < lines.length; i++) {
				        if (regex.test(lines[i])) {
				            splitIndex = i;
				            break;
				        }
				    }
				
				    if (splitIndex === -1) {
				        return [report, '']; // No matching line found, return the original report and an empty string
				    }
				
				    const firstPart = lines.slice(0, splitIndex).join('\n').trim();
				    const secondPart = lines.slice(splitIndex).join('\n').trim();
				
				    return [firstPart, secondPart];
				}
				
				// bon pour mettre note gén et conclusion dans note. Mais ne fonctionne pas avec toast si note ouverte.
				function updateNotes(enc, stringArray) {
				    const noteTypeToIndex = {};
				
				    // Helper function to get or create the index for a noteType
				    function getNoteIndex(noteType, lstNote) {
				        if (!noteTypeToIndex[noteType]) {
				            const notesOfType = lstNote.filter(note => note.noteType === noteType);
				            if (notesOfType.length > 0) {
				                // Find the note with the greatest id
				                const maxIdNote = notesOfType.reduce((max, note) => note.id > max.id ? note : max);
				                noteTypeToIndex[noteType] = lstNote.indexOf(maxIdNote);
				            } else {
				                noteTypeToIndex[noteType] = -1; // No note found for this type
				            }
				        }
				        return noteTypeToIndex[noteType];
				    }
				
				    const lstNote = enc.lstNote;
					const noteOtherThan100 = [10, 20, 30, 40];
					let idxOT100 = -1;
					var indexOtherThan100 = -1;
					while (indexOtherThan100==-1 && noteOtherThan100.length>++idxOT100) {
				        indexOtherThan100 = getNoteIndex(noteOtherThan100[idxOT100], lstNote);						
					}
			        
				    if (stringArray.length === 1) {
				        // Update the note with noteType 10
				        if (indexOtherThan100 !== -1) {
							var item = lstNote[indexOtherThan100].viewbag.item;
				            item.note = (item.note ? item.note +" " : "") + stringArray[0];
				        } else {
							throw "Aucune note pour mettre le texte.";							
						}
				    } else if (stringArray.length > 1) {
				        // Update the notes with noteType 10 and 100
				        const index100 = getNoteIndex(100, lstNote);
				
				        if (indexOtherThan100 !== -1) {
							var item = lstNote[indexOtherThan100].viewbag.item;
				            item.note = (item.note ? item.note +" " : "") + stringArray[0] + (index100==-1 ? "\n\n" + stringArray[1] : "");
				        } else {
							throw "Aucune note pour mettre le texte.";
						}
				        if (index100 !== -1 ) {
							var item = lstNote[index100].viewbag.item;
				            item.note = (item.note ? item.note +" " : "") + stringArray[1];
				        }
				    }
				}
				
				scope.gettingTextResult = false;
				
				function getTextResult(idAudio) {
				    // Prevent duplicate calls
				    if (scope.gettingTextResult==true || idAudio==undefined) return;
				    
				    scope.isProcessing = true;
				    
				    scope.gettingTextResult = true;
				    
					if (scope.choice === 'D') {
						IaAccessor.dictation({'idAudio': idAudio},
							function onSuccess(response) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								if (response.data && response.data.success === false) {
									model.notice().warn(response.data.ms);
								} else {
									let x = response.data; // object XIaGeneratedNote
									iaService.insertTextAtCursor(scope.textareaElement, x.finalNote);
								}
							},
							function onFailure(res) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								console.error('Error:', res);
							}
						);
					} else if (scope.choice === 'D+') {
						IaAccessor.improveDictation({'idAudio': idAudio},
							function onSuccess(response) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								if (response.data && response.data.success === false) {
									model.notice().warn(response.data.ms);
								} else {
									let x = response.data; // object XIaGeneratedNote
									iaService.insertTextAtCursor(scope.textareaElement, x.finalNote);
								}
							},
							function onFailure(res) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								console.error('Error:', res);
							}
						);
					} else if (scope.choice === 'DG') {
						var extraData = getGranularEncData(scope.encounter);
						IaAccessor.interviewDictation({'idAudio': idAudio, 'text': (extraData.length==0 ? "" : extraData)}, { 'noteType': noteType(), 'sexPat': scope.sexPat, 'idPatient': scope.recordingPatient.id },
							function onSuccess(response) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								let text;
								if (response.data && response.data.success === false) {
									model.notice().warn(response.data.ms);
									return;
								} else {
									let x = response.data; // object XIaGeneratedNote
									text = x.finalNote;
								}
								try {
									var texts = splitMedicalReport(text);
									updateNotes(scope.encounter, texts);							
								} catch (err) {
									iaService.insertTextAtCursor(scope.textareaElement, text);
								}
							},
							function onFailure(res) {
								scope.gettingTextResult = false;
								scope.isProcessing = false;
								console.error('Error:', res);
							}
						);
					}
				}

				scope.togglePause = togglePause;
				scope.stopRecording = stopRecording;

				const canvas = document.getElementById('waveformCanvas');
				const ctx = canvas.getContext('2d');
				warningVisible = false;

				function drawWaveform(stream, options = {}) {
					const {
						amplification = 4,
						verticalOffset = 0,
						lineWidth = 3,
						strokeStyle = '#00ff00',
						silenceThreshold = getSilenceThreshold(),
						silenceTimeout = 3000
					} = options;

					const audioContext = new (window.AudioContext || window.webkitAudioContext)();
					const source = audioContext.createMediaStreamSource(stream);
					const analyser = audioContext.createAnalyser();
					analyser.fftSize = 2048;
					const bufferLength = analyser.frequencyBinCount;
					const dataArray = new Uint8Array(bufferLength);
					source.connect(analyser);

					let silenceTimer = null;

					function renderFrame() {
						if (model.isRecording && !scope.isPaused) {
							requestAnimationFrame(renderFrame);
							
							analyser.getByteTimeDomainData(dataArray);
							// getDecibels est setté dans le checkAudioLevel

							ctx.clearRect(0, 0, canvas.width, canvas.height);

							if (getDecibels() < silenceThreshold && model.isRecording) {
								if (!silenceTimer) {
									silenceTimer = setTimeout(() => {
										if (model.isRecording) {
											showSilenceWarning();
										}
									}, silenceTimeout);
								}
								
							} else {
								
								if (silenceTimer) {
									clearTimeout(silenceTimer);
									silenceTimer = null;
								}
								if (warningVisible) {
									hideSilenceWarning();
								}
								
								ctx.lineWidth = lineWidth;
								ctx.strokeStyle = strokeStyle;
	
								ctx.beginPath();
								const sliceWidth = canvas.width * 1.0 / bufferLength;
								let x = 0;
								for (let i = 0; i < bufferLength; i++) {
									const v = dataArray[i] / 128.0;
	
									// Amplify the waveform
									const y = (canvas.height / 2) + ((v - 1) * (canvas.height / 2) * amplification) - verticalOffset;
	
									if (i === 0) {
										ctx.moveTo(x, y);
									} else {
										ctx.lineTo(x, y);
									}
									x += sliceWidth;
								}
								ctx.stroke();
							}
						}
					}
					renderFrame();
				}

				function showSilenceWarning() {
					document.getElementById('silence-warning').style.display = 'flex';
					warningVisible = true;
				}

				function hideSilenceWarning() {
					document.getElementById('silence-warning').style.display = 'none';
					warningVisible = false;
				}

				iaService.setIaScope(scope);

				scope.$watch('textareaElement', function(newVal) {
					if (newVal) {
						scope.textareaElement = newVal;
					}
				});

				// Add a "working" animation element
				const workingAnimationElement = document.createElement('div');
				workingAnimationElement.className = 'working-animation';
				workingAnimationElement.innerHTML = '<i class="fa fa-spinner fa-pulse"></i>';
				element.find('.floating-icon-container').append(workingAnimationElement);

				scope.$watch('isProcessing', function(newVal) {
					if (newVal) {
						workingAnimationElement.style.display = 'block';
					} else {
						workingAnimationElement.style.display = 'none';
					}
				});
				
			}
		};
	}]);

	ia.directive('addRecordingButton', ['model', 'iaService', 'QConfirm', '$compile', '$timeout', 'IaAccessor', '$translate',
		function(model, iaService, QConfirm, $compile, $timeout, IaAccessor, $translate) {
			return {
				restrict: 'A',
				link: function(scope, element, attrs) {
					scope.model = model;
					if (scope.model.user().sofia.enabled() !== true) return;

					function currentPatient() {
						if (scope.model.patient() && scope.model.patient().currPatient) {
							return scope.model.patient().currPatient;
						} else if (scope.patient) {
							return scope.patient;
						}
					}

					scope.model.iaIsWorking = false;
					var iaIsWorkingLocally = false;
					scope.iaIsWorkingLocally = function(arg) {
						if (arguments.length === 1) {
							scope.model.iaIsWorking = arg;
							iaIsWorkingLocally = arg;
						} else {
							return iaIsWorkingLocally;
						}
					}

					scope.getConsentRecPat = function() {
						return 11;	// consent = true
					}

					function getSexPat() {
						if (scope.model.patient() && scope.model.patient().currPatient) {
							return scope.model.patient().currPatient.gender; // val I, M, F
						}
						return 'I';
					}

					scope.medNoteType = function(b) {
						if (b != undefined) {
							scope.model.prefSettings('user_settings_medNoteType', b);
						} else {
							return scope.model.prefSettings('user_settings_medNoteType');
						}
					}

					scope.contextData = attrs.contextData;

					var isToast = 'toast' == attrs.contextEditor;
					//scope.encounter = scope.$eval(attrs.encounter);

					var textNode;	// la directive est dans la directive toast-editor
					if (isToast) {
						textNode = element[0].children.note;
					} else {
						textNode = element[0];
					}

					// Main container
					var div = document.createElement('div');
					div.className = 'ia-divButtons';
					
					var selectMenuType;
			
					var isInSommaire = 'Encounter' == scope.contextData && scope.def && scope.def.hideNoteTypes === true;
					if ('Encounter' == scope.contextData && !isInSommaire) {
						var div1 = document.createElement('div');
						div1.style.cssText = "padding: 0px 6px 0px 4px;";
						div1.setAttribute('ng-click', 'interviewDictation()');
						div1.setAttribute('title', $translate.instant('RECORD_INTERVIEW'));
						
						var dictationBtn = document.createElement('i');
						dictationBtn.className = 'fa fa-microphone ia-color fa-lg';
						div1.appendChild(dictationBtn);
						div.appendChild(div1);
						
						var div2 = document.createElement('div');
						
						selectMenuType = document.createElement('select');
						selectMenuType.style.cssText = 'width:100%';
						selectMenuType.setAttribute('data-ng-model', 'medNoteType');
						selectMenuType.setAttribute('data-ng-model-options', '{ getterSetter: true }');

						var options = [
							{ value: '102', text: $translate.instant('UserSetting_medNoteType102') },
							{ value: '104', text: $translate.instant('UserSetting_medNoteType104') }
						];

						options.forEach(function(option) {
							var optionElement = document.createElement('option');
							optionElement.value = option.value;
							optionElement.textContent = option.text;
							selectMenuType.appendChild(optionElement);
						});
						div2.appendChild(selectMenuType);

						div.appendChild(div2);
					}

					var div3 = document.createElement('div');

					// Toggle Dropdown Button
					var toggleBtn = document.createElement('div');
					toggleBtn.setAttribute('ng-click', 'toggleDropdown($event)');
					toggleBtn.className = 'ia-toggle-btn';
					toggleBtn.setAttribute('data-ng-class', "{'disabled':model.iaIsWorking}");

					// Superpowers icon
					var superpowersIcon = document.createElement('i');
					superpowersIcon.className = 'fa fa-superpowers ia-color';
					superpowersIcon.setAttribute('data-ng-class', "{'fa-spin': iaIsWorkingLocally()}");
					superpowersIcon.setAttribute('title', $translate.instant('SOFIA_IA'));

					// Caret icon
					var caretIcon = document.createElement('i');
					caretIcon.className = 'fa';
					caretIcon.setAttribute('ng-class', "{'fa-caret-down': !isDropdownOpen, 'fa-caret-up': isDropdownOpen}");

					toggleBtn.appendChild(superpowersIcon);
					toggleBtn.appendChild(caretIcon);

					// Dropdown Items
					var items = [
						{ context: ['all'], click: 'dictation()', text: $translate.instant('DICTATION'),  iconStart: 'fa fa-microphone' },
						{ context: ['all'], click: 'improvedDictation()', text: $translate.instant('IMPROVED_DICTATION'),  iconStart: 'fa fa-microphone' },
						{ context: ['all'], click: 'improve()', text: $translate.instant('IMPROVE') },
						{ context: ['all'], click: 'translateToFrench()', text: $translate.instant('TRANSLATE_FR') },
						{ context: ['all'], click: 'translateToEnglish()', text: $translate.instant('TRANSLATE_EN') },
						{ context: ['Encounter'], click: 'generateMedicalNote("-")', text: $translate.instant('GENERATE_MEDICAL_NOTE'),  iconEnd: 'fa fa-magic' },
						{ context: ['Encounter'], click: 'noteInfoClin4Form("-")', text: $translate.instant('GENERATE_ENC_CLIN_INFO_4FORM') },
					];

					var filteredItems = items.filter((item, index) =>
						(item.context.indexOf(scope.contextData) != -1 && !(scope.def && scope.def.hideNoteTypes === true)) || item.context.indexOf('all') != -1
					);
					
					// Dropdown Menu
					var dropdown = document.createElement('ul');
					dropdown.className = 'ia-dropdown-menu';
					dropdown.style.cssText="width:250px;";
					
					filteredItems.forEach(function(item) {
						var li = document.createElement('li');
						li.setAttribute('ng-click', item.click);
						if (item.iconStart) {
							var sp1 = document.createElement('span');
							var icon = document.createElement('i');
							icon.className = item.iconStart;
							icon.style.cssText='padding-right: 5px;';
							sp1.appendChild(icon);
							li.appendChild(sp1);
						}
						var a = document.createElement('a');
						a.innerHTML = '{{ "' + item.text + '" | translate }}';
						li.appendChild(a);
						if (item.iconEnd) {
							var sp2 = document.createElement('span');
							var icon = document.createElement('i');
							icon.className = item.iconEnd;
							icon.style.cssText='padding-left: 5px;';
							sp2.appendChild(icon);
							li.appendChild(sp2);
						}
						dropdown.appendChild(li);
					});
					toggleBtn.appendChild(dropdown);

					// Compile all elements
					div3.appendChild(toggleBtn);
					div.appendChild(div3);
					
					const dropDownPos = "width: 200px;left: -150px;";
					if (scope.def && scope.def.hideNoteTypes === true) {
						// dans une toast editor de l'edition du commaire
						div.style.cssText = "right: 0px;top: -30px;";
						dropdown.style.cssText = dropDownPos;
					} else if ('Plan' == scope.contextData) {	// est aussi toast... 
						div.style.cssText = "right: 4px;top: 0px;";
						dropdown.style.cssText = dropDownPos;
					} else if ('regenerateNote' == scope.contextData) {	
						dropdown.style.cssText = dropDownPos;
					} else if (isToast) {
						div.style.cssText = "left: 196px;top: -38px;right: unset;height:32px;";
					} else if ('Task' == scope.contextData || 'Message' == scope.contextData) {
						dropdown.style.cssText = dropDownPos;
					} else if ('MessageTab' == scope.contextData) {
						dropdown.style.cssText = "right:0px; left:unset;width: 200px;";
					}
					// Compile the template
					var compiled = $compile(div)(scope);
					element.parent().append(compiled);

					// Utiliser $timeout pour s'assurer que le DOM est mis à jour
					$timeout(function() {
						if (selectMenuType) selectMenuType.value = scope.medNoteType();
						// selectMenu.dispatchEvent(new Event('change'));
					});

					scope.isDropdownOpen = false;

					function isClickOutside(event) {
						return !div.contains(event.target) && !toggleBtn.contains(event.target);
					}

					function closeDropdown(event) {
						if (isClickOutside(event) && scope.isDropdownOpen) {
							scope.isDropdownOpen = false;
							dropdown.parentElement.classList.remove('ia-is-open');
							if (scope.$root && !scope.$root.$$phase) {
								scope.$apply();
							}
						}
					}

					// Listen for the broadcast event
					scope.$on('closeDropdown', function(event, originalEvent) {
						closeDropdown(originalEvent);
					});

					// Also set up a document click listener as a fallback
					angular.element(document).on('click', function(event) {
						closeDropdown(event);
					});

					scope.toggleDropdown = function(event) {
						event.stopPropagation();
						scope.isDropdownOpen = !scope.isDropdownOpen;
						dropdown.parentElement.classList.toggle('ia-is-open', scope.isDropdownOpen);
					};

					// Clean up the document click listener when the directive is destroyed
					scope.$on('$destroy', function() {
						angular.element(document).off('click', closeDropdown);
					});

					scope.improve = function() {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.improveText({ text: textNode.value, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.generateMedicalNote = function(l) {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.medNoteFromNote({ text: textNode.value, noteType: scope.medNoteType(), lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									if (response.data && response.data.success === false) {
										console.error('Error:', response);
										scope.iaIsWorkingLocally(false);
									} else {
										try {
											// see encounter.js, ligne 5328 et 5488 'structured'
											scope.iaIsWorkingLocally(false);
											showModal(response.data, true);
											//const mednote = OfysUtils.parseJson(response.data);
											//if (mednote==null) {
											//	showModal(response.data, true);
											//} else {
											//	showModal(mednote.note, true);
											// ici il faudrait afficher aussi les valeurs structurées 
											// et permettre de désélectionner ceux qu'on ne veut pas intégrer structurés dans la rencontre.
											//}

										} catch (error) {
											console.error('Erreur de parsing:', error);
										}


									}
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					// TODO ouvrier nouveau chat pour send to patient.
					scope.generatePatientSummary = function(l) {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.generatePatientSummary({ text: textNode.value, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};
					scope.noteInfoClin4Form = function(l) {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.noteInfoClin4Form({ text: textNode.value, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.translateToFrench = function() {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.toFrench({ text: textNode.value, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.translateToEnglish = function() {
						if (OfysUtils.isNotEmpty(textNode.value)) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.toEnglish({ text: textNode.value, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.dictation = function() {
						iaService.startRecording(textNode, textNode.value, 'D', getSexPat(), currentPatient());
					};

					scope.improvedDictation = function() {
						iaService.startRecording(textNode, textNode.value, 'D+', getSexPat(), currentPatient());
					};

					scope.interviewDictation = function() {
						if (scope.getConsentRecPat() !== 11) {
							//showModalConsent();
							model.notice().warn($translate.instant('PATIENT_DID_NOT_CONSENT_TO_RECORDING')+$translate.instant('PATIENT_DID_NOT_CONSENT_TO_RECORDING_INFO'));
						} else {
							if (model.isRecording == true || scope.isProcessing == true) {
								model.notice().warn($translate.instant('recordingAlreadyInProgress'));
								return;
							}
							askForConsentGiven();
						}
					};
					function askForConsentGiven(){
						var qconfirmOptions = {title: $translate.instant('consentementObtenu')};
	
						QConfirm.open(qconfirmOptions).then(proceedWithEditCancel);
						function proceedWithEditCancel(proceed){
							if(proceed){
								iaService.startRecording(textNode, textNode.value, 'DG', getSexPat(), currentPatient(), scope.enc);								
							}
						}
					}

					function showModal(text, showReplaceButton) {
						scope.text = text;
						scope.showReplaceButton = showReplaceButton;
						scope.readOnly = false;
						var modal = angular.element(`
					        <div class="ia-modal">
					            <div class="ia-modal-content">
					                <div class="draggable-handle-not-used"></div>
					                <div class="textarea-container" ng-class="{ 'locked': readOnly }">
					                <i ng-show="readOnly" class="fa fa-lock lock-icon"></i>
					                <textarea class="ia-texte" ng-readonly="readOnly">{{text}}</textarea>
					                <span class="ia-resp-valid">{{'VOTRE_RESP_DE_VALIDER'|translate}}</span>
					                <div class="button-group">
					                    <button ng-click="copyToClipboard()">{{'copy_app'|translate}}</button>
					                    <button ng-if="showReplaceButton" ng-click="copyToTextarea()">{{'REPLACE_TEXT'|translate}}</button>
					                    <button ng-click="closeModal()">{{'Close'|translate}}</button>
					                </div>
					            </div>
					            </div>
					        </div>
					    `);
						var compiledContent = $compile(modal)(scope);
						document.body.appendChild(compiledContent[0]);

						// Add draggable functionality
						var modalContent = compiledContent.find('.ia-modal-content')[0];
						var dragHandle = modalContent.querySelector('.draggable-handle');

						if (dragHandle) {
							var isDragging = false;
							var startX, startY, initialLeft, initialTop;

							dragHandle.addEventListener('mousedown', function(event) {
								event.preventDefault();
								isDragging = true;

								var rect = modalContent.getBoundingClientRect();
								startX = event.clientX;
								startY = event.clientY;
								initialLeft = rect.left;
								initialTop = rect.top;

								document.addEventListener('mousemove', handleMouseMove);
								document.addEventListener('mouseup', handleMouseUp);
							});

							function handleMouseMove(event) {
								if (!isDragging) return;

								var deltaX = event.clientX - startX;
								var deltaY = event.clientY - startY;

								var newLeft = initialLeft + deltaX;
								var newTop = initialTop + deltaY;

								var maxX = window.innerWidth - modalContent.offsetWidth;
								var maxY = window.innerHeight - modalContent.offsetHeight;

								newLeft = Math.min(Math.max(newLeft, 0), maxX);
								newTop = Math.min(Math.max(newTop, 0), maxY);

								modalContent.style.left = newLeft + 'px';
								modalContent.style.top = newTop + 'px';
								modalContent.style.transform = 'none'; // Remove the centering transform
							}

							function handleMouseUp() {
								isDragging = false;
								document.removeEventListener('mousemove', handleMouseMove);
								document.removeEventListener('mouseup', handleMouseUp);
							}
						}

						scope.copyToTextarea = function() {
							iaService.replaceText(textNode, text);
							modal.remove();
						};

						// dans la méthode de retour, assigner une nouvelle methode selon ce qu'on veut avoir ou non le bouton "remplacer le texte"
						scope.hasParentText = function() { return true; };

						scope.closeModal = function() {
							modal.remove();
						};

						// Copier dans le presse-papier
						scope.copyToClipboard = function() {
							var textarea = compiledContent.find('textarea')[0];
							textarea.select();
							document.execCommand('copy');
							modal.remove();
						};
					};

				}
			};
		}
	]);

	ia.directive('addAiButton', ['iaService', '$compile', 'IaAccessor', '$translate', '$filter', 'CourrielAccessor',
		function(iaService, $compile, IaAccessor, $translate, $filter, CourrielAccessor) {
			return {
				restrict: 'A',
				link: function(scope, element, attrs) {
					if (scope.model.user().sofia.enabled() != true) return;

					scope.encounter = scope.$eval(attrs.encounter);

					function currentPatient() {
						if (typeof scope.patient === 'function' && scope.model.patient() && scope.model.patient().currPatient) {
							return scope.model.patient().currPatient;
						} else if (scope.patient && typeof scope.patient !== 'function') {
							return scope.patient;
						} else if (typeof scope.getPatient === 'function' && scope.getPatient()) {
							return scope.getPatient();
						} else if (scope.doc && typeof scope.doc !== 'function' && scope.doc.patient) {
							return scope.doc.patient;
						} else if (scope.quickViewData && scope.quickViewData.pat) {
							return scope.quickViewData.pat;
						}
					}

					const CONSENT_UNKNOW = $translate.instant('RECORD_PATIENT_CONSENT_TO_RECORDING');
					const CONSENTED = $translate.instant('PATIENT_CONSENTED_TO_RECORDING');
					const DID_NOT_CONSENT = $translate.instant('PATIENT_DID_NOT_CONSENT_TO_RECORDING');
					const CONSENT_UNCLEAR = $translate.instant('PATIENT_CONSENT_UNCLEAR');
					const IN_FRENCH = $filter('translate')('IN_FRENCH');
					const IN_ENGLISH = $filter('translate')('IN_ENGLISH');
					const LANG = { 'fr': IN_FRENCH, 'en': IN_ENGLISH, '-': '' };
					scope.contextData = attrs.contextData;

					scope.isProf = function() {
						return scope.model.user().isClinician();
					};
					scope.isMedSecretary = function() {
						return scope.model.user().isClinician() !== true && scope.model.user().hasClinicalRights;
					};

					scope.iaEncData = function() {
						var pt = currentPatient();
						if (pt) {
							return pt.iaEncData;
						}
					}

					scope.model.iaIsWorking = false;
					var iaIsWorkingLocally = false;
					scope.iaIsWorkingLocally = function(arg) {
						if (arguments.length === 1) {
							scope.model.iaIsWorking = arg;
							iaIsWorkingLocally = arg;
						} else {
							return iaIsWorkingLocally;
						}
					}

					function getSexPat() {
						var pt = currentPatient();
						if (pt) {
							return pt.gender; // val I, M, F
						}
						return 'I';
					}

					scope.getConsentRecPat = function() {
						var pt = currentPatient();
						if (pt) {
							return 11;
							// return pt.consentRecording;
						}
						return undefined;
					}

					scope.getConsentRecPatDate = function() {
						var pt = currentPatient();
						if (pt) {
							return "\n" + pt.consentRecordingDate;
						}
						return undefined;
					}

					scope.getTitle4ConsentRecPat = function() {
						var pt = currentPatient();
						if (pt) {
							var consentRec = pt.consentRecording;
							if (consentRec == undefined || consentRec === 0) {
								return CONSENT_UNKNOW;
							} else if (consentRec === 11) {
								return CONSENTED + scope.getConsentRecPatDate();
							} else if (consentRec === 12) {
								return DID_NOT_CONSENT + scope.getConsentRecPatDate();
							} else if (consentRec === 13) {
								return CONSENT_UNCLEAR + scope.getConsentRecPatDate();
							}
						}
					}


					function getIdsForDoc() {
						var idPatient;
						var qvId;
						const currentPatientData = scope.docNote || scope.doc ? null : (currentPatient() || null);
						if (scope.docNote) {
							idPatient = scope.docNote.idPatient;
							qvId = scope.docNote.id;
						} else if (scope.doc) {
							idPatient = scope.doc.idPatient;
							qvId = scope.doc.id;
						} else if (currentPatientData) {
							idPatient = currentPatientData.idPatient;
							if (scope.quickViewData && scope.quickViewData.qvActData) {
								qvId = scope.quickViewData.qvActData.id;
							}
						}
						return { idPatient: idPatient, idObj: qvId };
					}

					function getIdsForLab() {
						var idPatient;
						var qvId;
						if (scope.labNote) {
							idPatient = scope.labNote.idPatient;
							qvId = scope.labNote.id;
						} else if (scope.model.patient().currPatient) {
							idPatient = scope.model.patient().currPatient.idPatient;
							if (scope.quickViewData && scope.quickViewData.qvActData) {
								qvId = scope.quickViewData.qvActData.id;
							}
						}
						return { idPatient: idPatient, idObj: qvId };
					}

					scope.hasDocId = function() {
						if (scope.contextData === "Doc") {
							var ids = getIdsForDoc();
							return ids.idObj !== undefined;
						}
						return false;
					}

					// Main container
					var div = document.createElement('div');
					div.className = 'ia-divButtons';

					// Toggle Dropdown Button
					var toggleBtn = document.createElement('div');
					toggleBtn.setAttribute('ng-click', 'toggleDropdown($event)');
					toggleBtn.className = 'ia-toggle-btn';
					toggleBtn.setAttribute('ng-class', "{'disabled':model.iaIsWorking}");

					// Superpowers icon
					var superpowersIcon = document.createElement('i');
					superpowersIcon.className = 'fa fa-superpowers ia-color';
					superpowersIcon.setAttribute('ng-class', "{'fa-spin': iaIsWorkingLocally()}");
					superpowersIcon.setAttribute('title', $translate.instant('SOFIA_IA'));

					// Caret icon
					var caretIcon = document.createElement('i');
					caretIcon.className = 'fa';
					caretIcon.setAttribute('ng-class', "{'fa-caret-down': !isDropdownOpen, 'fa-caret-up': isDropdownOpen}");

					toggleBtn.appendChild(superpowersIcon);
					toggleBtn.appendChild(caretIcon);

					// Dropdown Menu
					var dropdown = document.createElement('ul');
					dropdown.className = 'ia-dropdown-menu';

					scope.getLastEnc3yText = function() {
						return $filter('translate')('LAST_ENC_3Y') + ' (' + scope.iaEncData().dateCreated + ')';
					}
					scope.getTranslatedText = function(ttt, l, iaDate) {
						return $filter('translate')(ttt) + LANG[l] + (iaDate && scope.iaEncData() ? ' (' + scope.iaEncData().dateCreated + ')' : '');
					}
					// Dropdown Items   
					var items = [	// $filter('translate')(
						{ context: ['Encounter'], ngif: "isProf()", click: 'summaryEnc4Prof("fr")', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PROF', 'fr')" },
						{ context: ['Encounter'], ngif: "isProf()", click: 'summaryEnc4Prof("en")', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PROF', 'en')" },
						{ context: ['Encounter'], ngif: "isProf()||isMedSecretary()", click: 'summaryEnc4Pat("fr")', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PAT', 'fr')" },
						{ context: ['Encounter'], ngif: "isProf()||isMedSecretary()", click: 'summaryEnc4Pat("en")', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PAT', 'en')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'summaryEnc4Prof("fr", true)', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PROF', 'fr')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'summaryEnc4Prof("en", true)', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PROF', 'en')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'summaryEnc4Pat("fr", true)', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PAT', 'fr')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'summaryEnc4Pat("en", true)', text: "getTranslatedText('GENERATE_SUMMARY_ENC_4PAT', 'en')" },
						{ context: ['Patient', 'QvPatient'], ngif: "isProf()", click: 'summaryFile4Prof("fr")', text: "getTranslatedText('GENERATE_SUMMARY_FILE_4PROF', 'fr')" },
						{ context: ['Patient', 'QvPatient'], ngif: "isProf()", click: 'summaryFile4Prof("en")', text: "getTranslatedText('GENERATE_SUMMARY_FILE_4PROF', 'en')" },
						{ context: ['Patient', 'QvPatient'], ngif: "(isProf()) && iaEncData()!=undefined", click: 'getLastEnc3y("-")', text: "getTranslatedText('LAST_ENC_3Y','-',true)" },
						{ context: ['Patient', 'QvPatient'], ngif: "isProf()", click: 'lastEnc3y("fr")', text: "getTranslatedText('LAST_ENC_3Y','fr')" },
						{ context: ['Patient', 'QvPatient'], ngif: "isProf()", click: 'lastEnc3y("en")', text: "getTranslatedText('LAST_ENC_3Y','en')" },
						{ context: ['Encounter'], ngif: "isProf()", click: 'encInfoClin4Form("-")', text: "getTranslatedText('GENERATE_ENC_CLIN_INFO_4FORM','-')" },
						{ context: ['EncounterNote'], ngif: "isProf()", click: 'encInfoClin4Form("-", true)', text: "getTranslatedText('GENERATE_ENC_CLIN_INFO_4FORM','-')" },
						{ context: ['Doc'], ngif: "isProf()", click: 'summaryOfDoc4Prof("fr")', text: "getTranslatedText('GENERATE_SUMMARY_DOC_4PROF','fr')" },
						{ context: ['Doc'], ngif: "isProf()", click: 'summaryOfDoc4Prof("en")', text: "getTranslatedText('GENERATE_SUMMARY_DOC_4PROF','en')" },
						{ context: ['Doc'], ngif: "isProf()", click: 'summaryOfDoc4Pat("fr")', text: "getTranslatedText('GENERATE_SUMMARY_DOC_4PAT', 'fr')" },
						{ context: ['Doc'], ngif: "isProf()", click: 'summaryOfDoc4Pat("en")', text: "getTranslatedText('GENERATE_SUMMARY_DOC_4PAT', 'en')" },
						//{ context:['Lab'], ngif:"isProf()||isMedSecretary()", click: 'summaryOfLab4Pat("fr")', text: "getTranslatedText('GENERATE_SUMMARY_LAB_4PAT', 'fr')" },
						//{ context:['Lab'], ngif:"isProf()||isMedSecretary()", click: 'summaryOfLab4Pat("en")', text: "getTranslatedText('GENERATE_SUMMARY_LAB_4PAT', 'en')" },
					];
					var filteredItems = items.filter((item, index) => item.context.indexOf(scope.contextData) != -1);

					filteredItems.forEach(function(item) {
						var li = document.createElement('li');
						li.addEventListener('click', function() {
							scope.$apply(function() {
								scope.isDropdownOpen = false;
								dropdown.parentElement.classList.remove('ia-is-open');
							});
						});
						li.setAttribute('ng-show', item.ngif);
						li.setAttribute('ng-click', item.click);

						var a = document.createElement('a');
						a.setAttribute('ng-bind-html', item.text);

						li.appendChild(a);
						dropdown.appendChild(li);
					});
					//var isPatient = scope.contextData === "Patient" || scope.contextData == 'QvPatient';

					// Compile all elements
					div.appendChild(toggleBtn);
					//if (isPatient) {
						//div.appendChild(consentyBtn);
					//}
					div.appendChild(dropdown);

					if (scope.contextData === 'Patient') {
						div.style.cssText = "top:48px;" + (scope.model.isWeb() ? "right:260px;" : "right:280px;");
						dropdown.style.cssText = "right:0px;";
					} else if (scope.contextData === "Doc") {
						if (scope.hasDocId()) {
							div.style.cssText = "top: unset; margin-top: 4px;right: 48px;";
							dropdown.style.cssText = "right: 0px;";
						} else {
							div.classList.add('hidden');
						}
					} else if (scope.contextData === "Lab") {
						div.style.cssText = "top: unset; margin-top: 10px;right: 16px;";
						dropdown.style.cssText = "right: 0px;";
					} else if (scope.contextData === "QvPatient") {
						div.style.cssText = "top: 2px;height: 20px;left: 312px;width: 49px;";
						//consentBtn.style.cssText = "height: 15px;padding: 0px 4px;margin-left: 4px;";
						dropdown.style.cssText = "right: unset;";
					} else if (scope.contextData === "EncounterNote") {
						div.style.cssText = "top: -5px;left: 140px;right: unset;";
						dropdown.style.cssText = "right: unset;";
					} else if (scope.contextData === "Encounter") {
						div.style.cssText = "top: 5px;right: unset; left: 80px;";
						dropdown.style.cssText = "right: unset;";
						//					} else if (element[0].classList.contains('is-doc')) {
						//						div.style.cssText = "right: -360px;top: -35px;";
					}
					// Compile the template
					var compiled = $compile(div)(scope);

					element.parent().append(compiled);
					scope.isDropdownOpen = false;


					function isClickOutside(event) {
						return !div.contains(event.target) && !toggleBtn.contains(event.target);
					}

					function closeDropdown(event) {
						if (isClickOutside(event) && scope.isDropdownOpen) {
							scope.isDropdownOpen = false;
							dropdown.parentElement.classList.remove('ia-is-open');
							if (!scope.$root.$$phase) {
								scope.$apply();
							}
						}
					}

					// Listen for the broadcast event
					scope.$on('closeDropdown', function(event, originalEvent) {
						closeDropdown(originalEvent);
					});

					// Also set up a document click listener as a fallback
					angular.element(document).on('click', function(event) {
						closeDropdown(event);
					});

					scope.toggleDropdown = function(event) {
						event.stopPropagation();
						scope.isDropdownOpen = !scope.isDropdownOpen;
						dropdown.parentElement.classList.toggle('ia-is-open', scope.isDropdownOpen);
					};

					// Clean up the document click listener when the directive is destroyed
					scope.$on('$destroy', function() {
						angular.element(document).off('click', closeDropdown);
					});

					function sendToPatient(patient, text) {
						CourrielAccessor.openNewToPatient(patient, text);
					};


					scope.summaryFile4Prof = function(l) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryFile4Prof({ id: idPatient, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.getLastEnc3y = function(l) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							scope.iaIsWorkingLocally(true);
							IaAccessor.getLastEnc3y({ idPatient: idPatient, idLink: idPatient, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.lastEnc3y = function(l) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							scope.iaIsWorkingLocally(true);
							IaAccessor.lastEnc3y({ idPatient: idPatient, idLink: idPatient, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									pt.iaEncData = { note: text, dateCreated: moment().format('YYYY-MM-DD') };
									scope.iaIsWorkingLocally(false);
									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.summaryEnc4Prof = function(l, useText) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							var idEnc = scope.editEnc.idAnchor;
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryEnc4Prof({ idPatient: idPatient, idLink: idEnc, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.summaryEnc4Pat = function(l, useText) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							var idEnc = scope.editEnc.idAnchor;
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryEnc4Pat({ idPatient: idPatient, idLink: idEnc, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									sendToPatient(pt, text);
//									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.encInfoClin4Form = function(l, useText) {
						var pt = currentPatient();
						if (pt) {
							var idPatient = pt.idPatient;
							var idEnc = scope.editEnc.idAnchor;
							scope.iaIsWorkingLocally(true);
							IaAccessor.encInfoClin4Form({ idPatient: idPatient, idLink: idEnc, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									showModal(text, false);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.summaryOfDoc4Prof = function(l) {
						var ids = getIdsForDoc();
						if (ids.idPatient && ids.idObj) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryOfDoc4Prof({ idPatient: ids.idPatient, idLink: ids.idObj, lang: l },
								function onSuccess(response) {
									const text = response.data;
									if (scope.docNote.aiData) {
										scope.docNote.aiData.note = text;
									} else {
										scope.docNote.aiData = { 'note': text };
									}
									scope.iaIsWorkingLocally(false);
									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.summaryOfDoc4Pat = function(l) {
						var ids = getIdsForDoc();
						var pt = currentPatient();
						if (pt && ids.idPatient && ids.idObj) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryOfDoc4Pat({ idPatient: ids.idPatient, idLink: ids.idObj, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									sendToPatient(pt, text);
//									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					scope.summaryOfLab4Pat = function(l) {
						var ids = getIdsForLab();
						var pt = currentPatient();
						if (pt && ids.idPatient && ids.idObj) {
							scope.iaIsWorkingLocally(true);
							IaAccessor.summaryOfLab4Pat({ idPatient: ids.idPatient, idLink: ids.idObj, lang: l, sexPat: getSexPat() },
								function onSuccess(response) {
									const text = response.data;
									scope.iaIsWorkingLocally(false);
									sendToPatient(pt, text);
//									showModal(text, false, true);
								},
								function onFailure(res) {
									scope.iaIsWorkingLocally(false);
									console.error('Error:' + res.statusText);
								}
							);
						}
					};

					//scope.consent = function() {
					//	iaService.startRecording(undefined, undefined, 'C', getSexPat(), currentPatient());
					//};

					function showModal(text, showReplaceButton, readOnly) {
						scope.text = text;
						scope.readOnly = readOnly;
						scope.showReplaceButton = showReplaceButton;
						var modal = angular.element(`
					        <div class="ia-modal">
					            <div class="ia-modal-content">
					                <div class="draggable-handle-not-used"></div>
					                <div class="textarea-container" ng-class="{ 'locked': readOnly }">
					                <i ng-show="readOnly" class="fa fa-lock lock-icon"></i>
					                <textarea class="ia-texte" ng-readonly="readOnly">{{text}}</textarea>
					                <span class="ia-resp-valid">{{'VOTRE_RESP_DE_VALIDER'|translate}}</span>
					                <div class="button-group">
					                    <button ng-click="copyToClipboard()">{{'copy_app'|translate}}</button>
					                    <button ng-if="showReplaceButton" ng-click="copyToMessage()">{{'REPLACE_TEXT'|translate}}</button>
					                    <button ng-click="closeModal()">{{'Close'|translate}}</button>
					                </div>
					            </div>
					            </div>
					        </div>
					    `);
						var compiledContent = $compile(modal)(scope);
						document.body.appendChild(compiledContent[0]);

						// Add draggable functionality
						var modalContent = compiledContent.find('.ia-modal-content')[0];
						var dragHandle = modalContent.querySelector('.draggable-handle');

						if (dragHandle) {
							var isDragging = false;
							var startX, startY, initialLeft, initialTop;

							dragHandle.addEventListener('mousedown', function(event) {
								event.preventDefault();
								isDragging = true;

								var rect = modalContent.getBoundingClientRect();
								startX = event.clientX;
								startY = event.clientY;
								initialLeft = rect.left;
								initialTop = rect.top;

								document.addEventListener('mousemove', handleMouseMove);
								document.addEventListener('mouseup', handleMouseUp);
							});

							function handleMouseMove(event) {
								if (!isDragging) return;

								var deltaX = event.clientX - startX;
								var deltaY = event.clientY - startY;

								var newLeft = initialLeft + deltaX;
								var newTop = initialTop + deltaY;

								var maxX = window.innerWidth - modalContent.offsetWidth;
								var maxY = window.innerHeight - modalContent.offsetHeight;

								newLeft = Math.min(Math.max(newLeft, 0), maxX);
								newTop = Math.min(Math.max(newTop, 0), maxY);

								modalContent.style.left = newLeft + 'px';
								modalContent.style.top = newTop + 'px';
								modalContent.style.transform = 'none'; // Remove the centering transform
							}

							function handleMouseUp() {
								isDragging = false;
								document.removeEventListener('mousemove', handleMouseMove);
								document.removeEventListener('mouseup', handleMouseUp);
							}
						}

						scope.copyToTextarea = function() {
							iaService.replaceText(element[0], text);
							modal.remove();
						};

						scope.closeModal = function() {
							modal.remove();
						};

						// Copier dans le presse-papier
						scope.copyToClipboard = function() {
							var textarea = compiledContent.find('textarea')[0];
							textarea.select();
							document.execCommand('copy');
							modal.remove();
						};
					};

				}
			};
		}
	]);
	
	ia.directive('listGeneratedNote', ['$uibModal', 'IaAccessor', 'model', function($uibModal, IaAccessor, model) {
	  return {
	    restrict: 'E',
	    template: `
	      <button type="button" class="btn btn-link" ng-class="{'disabled': isRecordingInProgress()}" ng-click="openNoteModal()" title="{{:translation:'HX_NOTE' | translate}}">
	        <i class="fa fa-list fa-lg"></i>
	      </button>
	    `,
	    link: function(scope) {
			scope.model = model;
	      scope.isRecordingInProgress = function() {
	        return model.isDoingRecording || model.isGeneratingNote || model.isTestingAudio;
	      };
	
	      scope.openNoteModal = function() {
		    scope.isProcessingRequest=true;
	        model.isGeneratingNote = true;
	        IaAccessor.listGeneratedNote(
	          function success(res) {
	            scope.isProcessing = false;
	            if (!res.data || res.data.success === false) {
	              model.notice().warn(res.data?.ms || 'Erreur inconnue.');
	              return;
	            }
	
	            $uibModal.open({
	              templateUrl: '/dashboard/resources/ofys/ia/list-gen-note-modal.html',
	              controller: 'ListGenNoteModalCtrl',
	              size: 'lg',
	              resolve: {
	                notes: () => res.data
	              }
	            });
	          },
	          function error(err) {
	            scope.isProcessingRequest = false;
	            console.error(err);
	          }
	        );
	      };
	    }
	  };
	}]);
	
	ia.directive('sttNote', ['IaAccessor', 'model', function(IaAccessor, model) {
	  return {
	    restrict: 'E',
		template: `
		  <div class="conversation-box" ng-if="conversationOpen"
		       ng-style="conversationStyle">
		    <label style="display: block; font-size: 16px; font-weight: 600; margin-bottom: 4px;">{{:translation:'TXT_ENREGISTRE'|translate}}</label>
		    <textarea ng-model="stt_note" class="form-control no-resize" placeholder="{{:translation:'SHOWING_RECORDING_HERE'|translate}}" 
		              rows="15" readonly stt-autoscroll></textarea>
		  </div>
		  <button type="button" class="btn btn-link" ng-click="openConversation()">
		    <i class="fa fa-commenting-o fa-lg"></i>
		  </button>
		`,
		link: function(scope, element) {
		  scope.conversationOpen = false;
		
		  scope.openConversation = function() {
		    scope.conversationOpen = !scope.conversationOpen;
		
		    const container = element[0].closest('.floating-icon-container');
		    if (container) {
				scope.conversationStyle = {
				  position: 'absolute',
				  bottom: '100%',
				  left: '0',
				  'min-width': '300px',
				  width: '100%',
				  'margin-bottom': '10px',
				  'z-index': 1000
				};
		    }
		  };
		
		  let previousText = '';
		  scope.$watch('stt_note', function(newVal) {
		    if (newVal && newVal !== previousText) {
		      previousText = newVal;
		    }
		  });
	
		}
	  };
	}]);
	
	ia.directive('sttAutoscroll', function() {
	  return {
	    link: function(scope, element) {
	      scope.$watch('stt_note', function() {
	        setTimeout(() => {
	          element[0].scrollTop = element[0].scrollHeight;
	        }, 0);
	      });
	    }
	  };
	});
	
	ia.controller('ListGenNoteModalCtrl', ['$scope', '$uibModalInstance', 'notes', 'IaAccessor', 'model', '$translate', '$sce',
	  function($scope, $uibModalInstance, notes, IaAccessor, model, $translate, $sce) {
	
	  $scope.model = model;
	  $scope.listGenNoteData = notes;
	  $scope.selectedNote = null;
	  $scope.activeTabL = 'interNote';
	  $scope.activeTabR = 'finalNote';
	  $scope.isGenerating = false;
	
		$scope.getSofiaAnalysis = function () {
		  const rawEscaped = $translate.instant('ANALYSE_SOFIA');
		  var textarea = document.createElement("textarea");
		  textarea.innerHTML = rawEscaped;
		  var unescaped = textarea.value;
		
		  return $sce.trustAsHtml(unescaped);
		};
	
	  $scope.selectNote = function(note) {
	    $scope.selectedNote = note;
	    if (note.gabNote && !note.gabNote.raison_de_consultation) {
			var gabNote = OfysUtils.parseJson(note.gabNote);
			if (gabNote && gabNote.info_non_classee.length>0) {
				note.gabNote = gabNote;
			}
		}
	  };
	
	    if (notes && notes.length>0) {
			$scope.selectNote(notes[0]);
		}
		
	  $scope.relaunchGeneration = function() {
	    if (!$scope.selectedNote) return;
	
	    const combinedText = ($scope.selectedNote.interNote || '') + '\n\n' + $translate.instant('AJOUT') + ($scope.selectedNote.interNoteComment || '');
	    $scope.isGenerating = true;
	
	    IaAccessor.generateNewNote(
	      { text: combinedText, textSoumis: $scope.selectedNote.submitted, noteType: $scope.selectedNote.noteType },
	      function onSuccess(res) {
	        if (res && (!res.data || res.data.success === false)) {
	          model.notice().warn(res.data?.ms || 'Erreur inconnue.');
	          return;
	        }
	        if (res && res.data) {
	//          $scope.selectedNote.finalNote = res.data.finalNote;
				$scope.listGenNoteData.unshift(res.data);
				res.data.noteType = $scope.selectedNote.noteType;
				$scope.selectNote(res.data);
				$scope.activeTabL = 'interNote';
				$scope.activeTabR = 'finalNote';
	        } else {
	          model.notice().warn(res.data?.ms || 'Erreur inconnue.');
	          model.notice().warn("No finalNote returned.");
	        }
	        $scope.isGenerating = false;
	        //$scope.$apply();  // Ensure UI updates
	      },
	      function onError(err) {
	        model.notice().warn("Generation failed:", err);
	        $scope.isGenerating = false;
	        //$scope.$apply();  // Ensure UI updates
	      }).finally(function (res) {
	        $scope.isGenerating = false;
		  }
	    );
	  };
	
	  $scope.copyFinalNote = function() {
	    navigator.clipboard.writeText($scope.selectedNote.finalNote || '');
	  };
	
	  $scope.closeModal = function() {
		model.isGeneratingNote = false;
	    $uibModalInstance.dismiss('cancel');
	  };
	  
		$scope.$on('$destroy', function () {
		  $scope.closeModal(); // your cleanup code here
		});
	  
	}]);


	ia.directive('testAudioRecorder', ['$compile', '$translate', 'model', function($compile, $translate, model) {
    return {
      restrict: 'E',
      scope: {
        onRecordingComplete: '&?',
        maxDuration: '=?'
      },
      template: `
        <button type="button" class="btn btn-link" ng-class="{'disabled': isRecordingInProgress()}" ng-click="openModal()" title="{{TEST_MICRO|translate}}">
          <i class="fa fa-cog fa-lg"></i>
        </button>
      `,
      link: function(scope, element) {
        // Set default max duration if not provided
        scope.maxDuration = scope.maxDuration || 25;
		  scope.model = model;
		  scope.isRecordingInProgress = function() {
	        return model.isDoingRecording || model.isGeneratingNote || model.isTestingAudio;
		  };
        
        // Create modal element
        var modalElement = angular.element(`
          <div class="audio-test-modal" ng-show="isModalOpen">
            <div class="modal-backdrop" ng-click="closeModal()"></div>
            <div class="modal-dialog">
              <div class="modal-content">
                <div class="modal-body">
                  <div style="padding-bottom: 10px;" data-ng-bind-template="{{'RECORD_TEST'|translate}}">
                  </div>
                  <div class="audio-recorder">
                    <button 
                      ng-click="toggleRecording()" 
                      ng-class="{'recording': isRecording, 'btn-danger': isRecording, 'btn-success': !isRecording}"
                      class="btn">
                      {{isRecording ? translate('STOP_RECORDING') : (hasRecording ? translate('RECORD_AGAIN') : translate('START_RECORD') )}}
                    </button>
                    
                    <span ng-if="isRecording" style="margin-left: 10px; color: #f44336;">
                      {{translate('Recording')}} {{recordingTime | number:1}}s
                    </span>
                    
                    <div ng-if="isRecording" class="volume-meter" style="margin-top: 10px; height: 10px; background: #eee; border-radius: 3px;">
                      <div class="level" style="height: 100%; width: {{volumeLevel}}%; background: #4CAF50; border-radius: 3px;"></div>
                    </div>
                    
                    <div ng-if="hasRecording" style="margin-top: 15px;">
                      <audio ng-src="{{audioUrl}}" controls style="width: 100%;"></audio>
                    </div>

                    <div ng-if="hasRecording && quality" style="margin-top: 15px; padding: 10px; border-radius: 4px;" 
                        ng-class="{'bg-success': quality === 'good', 'bg-danger': quality === 'poor'}">
                      <strong>{{translate('AUDIO_QUALITY')}}: {{translate(quality)}}</strong>
                      <ul ng-if="quality === 'good'">
                        <li >{{translate('WARNING_AUDIO_GOOD')}}</li>
                      </ul>
                      <ul ng-if="quality === 'poor'">
                        <li ng-if="issues.tooQuiet">{{translate('AUDIO_TOO_QUIET')}}</li>
                        <li ng-if="issues.hasClipping">{{translate('AUDIO_HAS_CLIPPPING')}}</li>
                        <li ng-if="issues.mostlySilence">{{translate('AUDIO_MOSTLY_SILENCE')}}</li>
                      </ul>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-default" ng-click="closeModal()">{{translate('Close')}}</button>
                </div>
              </div>
            </div>
          </div>
        `);
        
        // Compile and append modal to body
        $compile(modalElement)(scope);
        angular.element(document.body).append(modalElement);
        
        model.isTestingAudio = false;
        // Initialize variables
        scope.isModalOpen = false;
        scope.isRecording = false;
        scope.hasRecording = false;
        scope.audioChunks = [];
        scope.audioUrl = null;
        scope.mediaRecorder = null;
        scope.recordingTime = 0;
        scope.recordingTimer = null;
        scope.volumeLevel = 0;
        scope.quality = null;
        scope.issues = {};
        
  		scope.translate = function(key) {
			  return $translate.instant(key);
		};
		
        // References to cleanup
        var audioContext = null;
        var audioStream = null;
        var animationFrameId = null;
        
        // Modal controls
        scope.openModal = function() {
          scope.isModalOpen = true;
          model.isTestingAudio = true;
          angular.element(document.body).addClass('modal-open');
        };
        
        // Complete memory cleanup
        function cleanupResources() {
          model.isTestingAudio = false;			
          // Stop recording if active
          if (scope.mediaRecorder && scope.mediaRecorder.state === 'recording') {
            scope.mediaRecorder.stop();
          }
          
          // Clear recording timer
          if (scope.recordingTimer) {
            clearInterval(scope.recordingTimer);
            scope.recordingTimer = null;
          }
          
          // Cancel any animation frames
          if (animationFrameId) {
            cancelAnimationFrame(animationFrameId);
            animationFrameId = null;
          }
          
          // Stop all media tracks
          if (audioStream) {
            audioStream.getTracks().forEach(track => track.stop());
            audioStream = null;
          }
          
          // Close audio context
          if (audioContext) {
            if (audioContext.state !== 'closed') {
              audioContext.close();
            }
            audioContext = null;
          }
          
          // Revoke object URL
          if (scope.audioUrl) {
            URL.revokeObjectURL(scope.audioUrl);
            scope.audioUrl = null;
          }
          
          // Clear arrays and objects
          scope.audioChunks = [];
          scope.mediaRecorder = null;
          scope.quality = null;
          scope.issues = {};
          
          // Reset state flags
          scope.isRecording = false;
          scope.hasRecording = false;
          scope.recordingTime = 0;
          scope.volumeLevel = 0;
        }
        
        // Close modal and clean up
        scope.closeModal = function() {
          scope.isModalOpen = false;
          angular.element(document.body).removeClass('modal-open');
          
          // Complete memory cleanup
          cleanupResources();
        };
        
        // Toggle recording state
        scope.toggleRecording = function() {
          if (scope.isRecording) {
            stopRecording();
          } else {
            startRecording();
          }
        };

        // Start recording
        function startRecording() {
          // Clean up any previous recording resources
          cleanupResources();
          
          // Audio constraints specifically for Chrome with 16kHz mono Opus
          const constraints = {
            audio: {
              channelCount: 1,
              sampleRate: 16000,
              echoCancellation: true,
              noiseSuppression: true
            }
          };
          
          navigator.mediaDevices.getUserMedia(constraints)
            .then(function(stream) {
              scope.$apply(function() {
                // Store stream for cleanup
                audioStream = stream;
                scope.isRecording = true;
                
                // Create recorder with the specified format
                scope.mediaRecorder = new MediaRecorder(stream, {
                  mimeType: 'audio/webm;codecs=opus',
                  audioBitsPerSecond: 16000
                });
                
                // Collect audio chunks
                scope.mediaRecorder.ondataavailable = function(e) {
                  scope.audioChunks.push(e.data);
                };
                
                // Process recording when complete
                scope.mediaRecorder.onstop = function() {
                  // Only process if we have audio chunks (prevents processing during cleanup)
                  if (scope.audioChunks.length > 0) {
                    // Create blob from recorded chunks
                    const audioBlob = new Blob(scope.audioChunks, { type: 'audio/webm;codecs=opus' });
                    
                    scope.$apply(function() {
                      scope.audioUrl = URL.createObjectURL(audioBlob);
                      scope.hasRecording = true;
                      scope.isRecording = false;
                      
                      // Analyze audio quality
                      analyzeAudioQuality(audioBlob).then(function(results) {
                        // Only update if modal is still open
                        if (scope.isModalOpen) {
                          scope.$apply(function() {
                            scope.quality = results.quality;
                            scope.issues = results.issues;
                          });
                        }
                      });
                      
                      // Call optional callback with the blob
                      if (scope.onRecordingComplete) {
                        scope.onRecordingComplete({ audioBlob: audioBlob });
                      }
                    });
                  }
                  
                  // Stop all tracks
                  if (audioStream) {
                    audioStream.getTracks().forEach(track => track.stop());
                  }
                };
                
                // Start recording
                scope.mediaRecorder.start(100); // Collect data in 100ms chunks
                
                // Set up recording timer
                scope.recordingTimer = setInterval(function() {
                  scope.$apply(function() {
                    scope.recordingTime += 0.1;
                    
                    // Automatically stop if max duration is reached
                    if (scope.recordingTime >= scope.maxDuration) {
                      stopRecording();
                    }
                  });
                }, 100);
                
                // Set up volume meter
                setupVolumeMeter(stream);
              });
            })
            .catch(function(err) {
              console.error("Error accessing microphone:", err);
              alert("Error accessing microphone: " + err.message);
            });
        }
        
        // Set up volume meter with proper memory management
        function setupVolumeMeter(stream) {
          // Close previous audio context if exists
          if (audioContext) {
            if (audioContext.state !== 'closed') {
              audioContext.close();
            }
          }
          
          // Create new audio context
          audioContext = new AudioContext({
            sampleRate: 16000
          });
          
          const analyser = audioContext.createAnalyser();
          const source = audioContext.createMediaStreamSource(stream);
          source.connect(analyser);
          
          analyser.fftSize = 256;
          const bufferLength = analyser.frequencyBinCount;
          const dataArray = new Uint8Array(bufferLength);
          
          function updateVolumeMeter() {
            // Cancel if no longer recording or modal closed
            if (!scope.isRecording || !scope.isModalOpen) {
              cancelAnimationFrame(animationFrameId);
              return;
            }
            
            analyser.getByteFrequencyData(dataArray);
            
            let sum = 0;
            for (let i = 0; i < bufferLength; i++) {
              sum += dataArray[i];
            }
            
            const average = sum / bufferLength;
            const level = Math.min(100, average * 100 / 256);
            
            scope.$apply(function() {
              scope.volumeLevel = level;
            });
            
            // Store animation frame ID for cancellation
            animationFrameId = requestAnimationFrame(updateVolumeMeter);
          }
          
          // Start the animation
          animationFrameId = requestAnimationFrame(updateVolumeMeter);
        }
        
        // Stop recording with proper cleanup
        function stopRecording() {
          if (scope.recordingTimer) {
            clearInterval(scope.recordingTimer);
            scope.recordingTimer = null;
          }
          
          if (scope.mediaRecorder && scope.mediaRecorder.state === 'recording') {
            scope.mediaRecorder.stop();
            scope.isRecording = false;
          }
          
          // Cancel any ongoing animation frame
          if (animationFrameId) {
            cancelAnimationFrame(animationFrameId);
            animationFrameId = null;
          }
        }
        
        // Analyze audio quality with memory-safe context handling
        function analyzeAudioQuality(audioBlob) {
          // Create a new context for analysis to ensure cleanup
          const analyzerContext = new AudioContext({
            sampleRate: 16000
          });
          
          return new Promise((resolve) => {
            const fileReader = new FileReader();
            
            fileReader.onloadend = function() {
              // For audio/webm with Opus, we need to decode it first
              analyzerContext.decodeAudioData(fileReader.result)
                .then(function(buffer) {
                  // Get audio data (mono channel)
                  const channelData = buffer.getChannelData(0);
                  
                  // Calculate average volume (RMS)
                  let sum = 0;
                  let silentSamples = 0;
                  
                  for (let i = 0; i < channelData.length; i++) {
                    sum += channelData[i] * channelData[i];
                    
                    // Count near-silent samples
                    if (Math.abs(channelData[i]) < 0.005) {
                      silentSamples++;
                    }
                  }
                  
                  const rms = Math.sqrt(sum / channelData.length);
                  const silencePercentage = silentSamples / channelData.length * 100;
                  
                  // Check if audio is too quiet
                  const isTooQuiet = rms < 0.008;
                  
                  // Detect clipping (too loud)
                  let clippingSamples = 0;
                  for (let i = 0; i < channelData.length; i++) {
                    if (Math.abs(channelData[i]) > 0.98) {
                      clippingSamples++;
                    }
                  }
                  
                  const hasClipping = clippingSamples > buffer.sampleRate * 0.005;
                  
                  // Additional Opus-specific checks
                  const isMostlySilence = silencePercentage > 80;
                  
                  // Close the analyzer context when done
                  if (analyzerContext.state !== 'closed') {
                    analyzerContext.close();
                  }
                  
                  resolve({
                    quality: !isTooQuiet && !hasClipping && !isMostlySilence ? 'good' : 'poor',
                    issues: {
                      tooQuiet: isTooQuiet,
                      hasClipping: hasClipping,
                      mostlySilence: isMostlySilence
                    },
                    metrics: {
                      rms: rms,
                      clippingPercentage: clippingSamples / channelData.length,
                      silencePercentage: silencePercentage
                    }
                  });
                })
                .catch(function(err) {
                  console.error("Error decoding audio:", err);
                  
                  // Close the analyzer context even on error
                  if (analyzerContext.state !== 'closed') {
                    analyzerContext.close();
                  }
                  
                  resolve({
                    quality: 'error',
                    error: 'Failed to decode audio'
                  });
                });
            };
            
            fileReader.onerror = function() {
              // Close the analyzer context on file read error
              if (analyzerContext.state !== 'closed') {
                analyzerContext.close();
              }
              
              resolve({
                quality: 'error',
                error: 'Failed to read audio file'
              });
            };
            
            fileReader.readAsArrayBuffer(audioBlob);
          });
        }
                
        // Add necessary styles for the modal
        var styleElement = angular.element(`
          <style>
            .audio-test-modal .modal-backdrop {
              position: fixed;
              top: 0;
              right: 0;
              bottom: 0;
              left: 0;
              background-color: rgba(0, 0, 0, 0.5);
              z-index: 1040;
            }
            
            .audio-test-modal .modal-dialog {
              position: fixed;
              top: 50%;
              left: 50%;
              transform: translate(-50%, -50%);
              width: 570px;
              max-width: 95%;
              z-index: 1050;
            }
            
            .audio-test-modal .modal-content {
              background-color: #fff;
              border-radius: 5px;
              box-shadow: 0 5px 15px rgba(0, 0, 0, 0.5);
            }
            
            .audio-test-modal .modal-header {
              padding: 15px;
              border-bottom: 1px solid #e5e5e5;
            }
            
            .audio-test-modal .modal-title {
              margin: 0;
              line-height: 1.42857143;
            }
            
            .audio-test-modal .modal-body {
              padding: 15px;
            }
            
            .audio-test-modal .modal-footer {
              padding: 15px;
              text-align: right;
              border-top: 1px solid #e5e5e5;
            }
            
            .audio-test-modal .close {
              float: right;
              font-size: 21px;
              font-weight: 700;
              line-height: 1;
              color: #000;
              opacity: 0.2;
              background: none;
              border: 0;
              cursor: pointer;
            }
            
            .audio-test-modal .close:hover {
              opacity: 0.5;
            }
            
            .audio-test-modal .recording {
              animation: pulse 1.5s infinite;
            }
            
            @keyframes pulse {
              0% { opacity: 1; }
              50% { opacity: 0.7; }
              100% { opacity: 1; }
            }
            
            .audio-test-modal .bg-success {
              background-color: #dff0d8;
            }
            
            .audio-test-modal .bg-danger {
              background-color: #f2dede;
            }
            
            body.modal-open {
              overflow: hidden;
            }
          </style>
        `);
        
        angular.element(document.head).append(styleElement);
        
        // Clean up all resources when directive is destroyed
        scope.$on('$destroy', function() {
          // Remove DOM elements
          modalElement.remove();
          styleElement.remove();
          
          // Complete resource cleanup
          cleanupResources();
          
          // Ensure body class is removed
          if (scope.isModalOpen) {
            angular.element(document.body).removeClass('modal-open');
          }
        });
      }
    };
  }]);


})();