/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.ofys.data.dataaccess.impl.WebBuilder;
import ca.infodata.ofys.data.middle.dataobjects.XSession;
import ca.infodata.util1.restful.Response;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.util.Map;

public class WebBuilderWithSession
extends WebBuilder {
    private final XSession session;

    public WebBuilderWithSession(WebResource webSrc, String accept, String type, XSession session) {
        super(webSrc, accept, type);
        this.session = session;
    }

    public WebBuilderWithSession(WebResource webSrc, XSession session) {
        super(webSrc);
        if (session == null) {
            throw new NullPointerException("session");
        }
        this.session = session;
    }

    @Override
    public <E> Response<E> get(GenericType<Response<E>> gt) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> E get(Class<E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <E> Response<E> post(GenericType<Response<E>> gt, Object requestEntity) {
        WebBuilderWithSession.addSessionParametersToPost(this.session, requestEntity);
        return super.post(gt, requestEntity);
    }

    @Override
    public <E> E post(Class<E> c, Object requestEntity) {
        WebBuilderWithSession.addSessionParametersToPost(this.session, requestEntity);
        return super.post(c, requestEntity);
    }

    @Override
    public void post(Object requestEntity) {
        WebBuilderWithSession.addSessionParametersToPost(this.session, requestEntity);
        super.post(requestEntity);
    }

    public static void addSessionParametersToPost(XSession session, Object requestEntity) {
        if (requestEntity instanceof Map) {
            Map post = (Map)requestEntity;
            if (session != null) {
                post.put("username", session.getUser().getName() + ";" + session.getId());
                post.put("password", session.getUser().getEncryptedPassword());
                post.put("code_client", session.getClient().getClientCode());
            }
        } else {
            throw new UnsupportedOperationException("Only Map entity is supported for WebBuilderWithSession");
        }
    }
}

