/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.ofys.data.dataaccess.IConnectionInfoProvider;
import ca.infodata.ofys.data.dataaccess.IProxyAccessor;
import ca.infodata.ofys.data.dataaccess.ISessionProvider;
import ca.infodata.ofys.data.dataaccess.impl.BaseAccessor;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClient;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilderWithSession;
import ca.infodata.util1.Pair;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.jersey.core.util.Base64;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class ProxyAccessor
extends BaseAccessor
implements IProxyAccessor {
    private final Gson gson = new Gson();

    public ProxyAccessor(RestfulClient restfulClient, IConnectionInfoProvider connectionInfoProvider, ISessionProvider sessionProvider) {
        super(restfulClient, connectionInfoProvider, sessionProvider);
    }

    protected HttpPost getNewBaseGetRequest() {
        HttpPost baseGetRequest = new HttpPost("/" + BaseAccessor.contextRoot + "/jaxrs/ProxyAccessor/get");
        baseGetRequest.addHeader("Accept", "text/html");
        baseGetRequest.addHeader("Accept", "text/plain");
        return baseGetRequest;
    }

    protected HttpPost getNewBasePostRequest() {
        HttpPost basePostRequest = new HttpPost("/" + BaseAccessor.contextRoot + "/jaxrs/ProxyAccessor/post");
        basePostRequest.addHeader("Accept", "text/html");
        basePostRequest.addHeader("Accept", "text/plain");
        return basePostRequest;
    }

    protected HttpHost getTarget() throws UnknownHostException {
        URL serverUrl = this.getConnectionInfoProvider().get().getServerUrl();
        return new HttpHost(InetAddress.getByName(serverUrl.getHost()), serverUrl.getPort(), serverUrl.getProtocol());
    }

    @Override
    public CloseableHttpResponse get(String proxy, String path) throws Exception {
        CloseableHttpClient client = this.getRestfulClient().getApacheClient();
        HttpPost request = this.getNewBaseGetRequest();
        HashMap<String, String> post = new HashMap<String, String>();
        WebBuilderWithSession.addSessionParametersToPost(this.getSession(), post);
        post.put("proxy", proxy);
        post.put("path", path);
        String json = this.gson.toJson(post);
        request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        CloseableHttpResponse r = client.execute(this.getTarget(), (HttpRequest)request);
        return r;
    }

    @Override
    public CloseableHttpResponse post(String proxy, String path, List<Pair<String, String>> headers, byte[] entity) throws Exception {
        CloseableHttpClient client = this.getRestfulClient().getApacheClient();
        HttpPost request = this.getNewBasePostRequest();
        HashMap<String, String> post = new HashMap<String, String>();
        WebBuilderWithSession.addSessionParametersToPost(this.getSession(), post);
        post.put("proxy", path);
        post.put("path", path);
        post.put("headers", (String)this.toJson(headers));
        String encodedEntity = new String(Base64.encode((byte[])entity), StandardCharsets.UTF_8);
        post.put("entity", encodedEntity);
        String json = this.gson.toJson(post);
        request.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        CloseableHttpResponse r = client.execute(this.getTarget(), (HttpRequest)request);
        return r;
    }

    private JsonArray toJson(List<Pair<String, String>> list) {
        JsonArray jsonArray = new JsonArray();
        for (Pair<String, String> element : list) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty((String)element.first, (String)element.second);
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }
}

