/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.data.dataaccess.impl;

import ca.infodata.dsq.domain.ApprovedRequest;
import ca.infodata.dsq.domain.Code;
import ca.infodata.dsq.domain.Id;
import ca.infodata.dsq.domain.NIU_OTHER_MEDICATION_DM;
import ca.infodata.dsq.domain.NIU_PRESCRIPTION_DM;
import ca.infodata.dsq.domain.NIU_SH;
import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationCriteria;
import ca.infodata.dsq.service.odslds.ServiceDeliveryLocationCriteria;
import ca.infodata.dsq.service.oe.OEC1701Svc.RetractRequestCriteria;
import ca.infodata.dsq.service.ri.FindProviderCriteria;
import ca.infodata.dsq.service.ru.FindCandidateCriteria;
import ca.infodata.dsq.signature.Pkcs7SignatureI;
import ca.infodata.dsq.signature.Signature;
import ca.infodata.dsq.signature.XmlSignatureI;
import ca.infodata.ofys.data.dataaccess.IConnectionInfoProvider;
import ca.infodata.ofys.data.dataaccess.IDSQAccessor;
import ca.infodata.ofys.data.dataaccess.ISessionProvider;
import ca.infodata.ofys.data.dataaccess.impl.BaseAccessor;
import ca.infodata.ofys.data.dataaccess.impl.RestfulClient;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilder;
import ca.infodata.ofys.data.dataaccess.impl.WebBuilderWithSession;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.util1.Pair;
import ca.infodata.util1.date.LocalDate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DSQAccessor
extends BaseAccessor
implements IDSQAccessor {
    private static String getPath() {
        return "/" + contextRoot + "/jaxrs/DSQAccessor";
    }

    public DSQAccessor(RestfulClient restfulClient, IConnectionInfoProvider connectionInfoProvider, ISessionProvider sessionProvider) {
        super(restfulClient, connectionInfoProvider, sessionProvider);
    }

    @Override
    public ReturnObject exportLocalPrescriptionsToDsq1(Signature signature, int idPatient, List<Integer> localPrescriptionIds) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/exportLocalPrescriptionsToDsq1"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        post.put("localPrescriptionIds", localPrescriptionIds);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject exportLocalPrescriptionsToDsq2(Signature signature, int idPatient, Map<Integer, Signature> mapApprovedRequests) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/exportLocalPrescriptionsToDsq2"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        if (mapApprovedRequests instanceof Serializable) {
            post.put("criteria", this.serialize((Serializable)((Object)mapApprovedRequests)));
        } else {
            post.put("criteria", this.serialize(new HashMap<Integer, Signature>(mapApprovedRequests)));
        }
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject exportLocalPrescriptionToDsq1(Signature signature, int idPatient, int localPrescriptionId, boolean confirmedDUPTHPY) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/exportLocalPrescriptionToDsq1"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        post.put("localPrescriptionId", localPrescriptionId);
        post.put("confirmedDUPTHPY", confirmedDUPTHPY);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject exportLocalPrescriptionToDsq2(Signature signature, int idPatient, int localPrescriptionId, boolean async, ApprovedRequest<?> approvedRequest) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/exportLocalPrescriptionToDsq2"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        post.put("localPrescriptionId", localPrescriptionId);
        post.put("async", async);
        post.put("criteria", this.serialize((Serializable)approvedRequest));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findCandidateByCriteria(Signature signature, FindCandidateCriteria criteria) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/findCandidateByCriteria"), "application/octet-stream", "application/json");
        HashMap<String, byte[]> post = new HashMap<String, byte[]>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("criteria", this.serialize((Serializable)criteria));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findCandidateById(Signature signature, int idPatient, boolean useCache) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/findCandidateById"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        post.put("useCache", useCache);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findLocation(Signature signature, Integer healthCareFacilityId, ServiceDeliveryLocationCriteria criteria) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/findLocation"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("healthCareFacilityId", healthCareFacilityId);
        post.put("criteria", this.serialize((Serializable)criteria));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject findProvider(Signature signature, Integer professionnalId, FindProviderCriteria criteria) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/findProvider"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("professionnalId", professionnalId);
        post.put("criteria", this.serialize((Serializable)criteria));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getDevicePrescriptionDetailsOE(Signature signature, Signature signatureNiu, int idPatient, String prescriptionNumber, String prescriptionVersion) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getDevicePrescriptionDetailsOE"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("prescriptionNumber", prescriptionNumber);
        post.put("prescriptionVersion", prescriptionVersion);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getDrugPrescriptionDetailsOE(Signature signature, Signature signatureNiu, int idPatient, String prescriptionNumber, String prescriptionVersion) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getDrugPrescriptionDetailsOE"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("prescriptionNumber", prescriptionNumber);
        post.put("prescriptionVersion", prescriptionVersion);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getDrugPrescriptionDetailsDM(Signature signature, Signature signatureNiu, int idPatient, String prescriptionNumber, String prescriptionVersion) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getDrugPrescriptionDetailsDM"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("prescriptionNumber", prescriptionNumber);
        post.put("prescriptionVersion", prescriptionVersion);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getDrugDispenseDetails(Signature signature, Signature signatureNiu, String dispenseNumber, int idPatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getDrugDispenseDetails"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("dispenseNumber", dispenseNumber);
        post.put("id", idPatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getPrescriptionOrderSummaryServiceOE(Signature signature, Signature signatureNiu, int idPatient, LocalDate startdate, LocalDate enddate, boolean onlyActive) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getPrescriptionOrderSummaryServiceOE"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("startdate1970", this.dayFrom1970(startdate));
        post.put("enddate1970", this.dayFrom1970(enddate));
        post.put("onlyActive", onlyActive);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject dsqSignatureAndDataByPatient(HashMap<Integer, XmlSignatureI> xmlSignatureIForCache, HashMap<Pair<Integer, String>, Pair<Pkcs7SignatureI, XmlSignatureI>> mapPatSign, LocalDate startdate, LocalDate enddate, Integer limit, Integer whatToDo, String clientUid, String channelName) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/dsqSignatureAndDataByPatient"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize(xmlSignatureIForCache, false));
        post.put("criteria", this.serialize(mapPatSign, false));
        post.put("startdate1970", this.dayFrom1970(startdate));
        post.put("enddate1970", this.dayFrom1970(enddate));
        post.put("limit", limit);
        post.put("whatToDo", whatToDo);
        post.put("clientuid", clientUid);
        post.put("channelname", channelName);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getCacheSqimDataByPatient(Integer idpatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getCacheSqimDataByPatient"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idpatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject hasSignatures(Integer idpatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/hasSignatures"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idpatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getPrescriptionOrderSummaryServiceDM(Signature signature, Signature signatureNiu, int idPatient, LocalDate startdate, LocalDate enddate, boolean onlyThoseWithIssue, boolean includeCompletlyDispensed, boolean includePartiallyDispensed, boolean includeNeverDispensed, Integer limit) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getPrescriptionOrderSummaryServiceDM"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("startdate1970", this.dayFrom1970(startdate));
        post.put("enddate1970", this.dayFrom1970(enddate));
        post.put("onlyThoseWithIssue", onlyThoseWithIssue);
        post.put("includeCompletlyDispensed", includeCompletlyDispensed);
        post.put("includePartiallyDispensed", includePartiallyDispensed);
        post.put("includeNeverDispensed", includeNeverDispensed);
        post.put("limit", limit);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject listPatientConsentRefusal(Signature signature, int idPatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/listPatientConsentRefusal"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getRxMxSumFromCache(int idPatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getRxMxSumFromCache"), "application/octet-stream", "application/json");
        HashMap<String, Integer> post = new HashMap<String, Integer>();
        post.put("id", idPatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject hasPatientConsented(Signature signature, int idPatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/hasPatientConsented"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getDrugDispensesSummary(Signature signature, Signature signatureNiu, LocalDate startdate, LocalDate enddate, boolean mostRecentDispenseForEachRxIndicator, int idPatient, Integer limit) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getDrugDispensesSummary"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("startdate", this.dayFrom1970(startdate));
        post.put("enddate", this.dayFrom1970(enddate));
        post.put("mostRecentDispenseForEachRxIndicator", mostRecentDispenseForEachRxIndicator);
        post.put("limit", limit);
        post.put("id", idPatient);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getDrugPrescriptionDispensesSummary(Signature signature, Signature signatureNiu, NIU_PRESCRIPTION_DM niuPrescriptionDM, int idPatient) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getDrugPrescriptionDispensesSummary"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("niuPrescriptionDM", this.serialize((Serializable)niuPrescriptionDM));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getMedicationSummaryServiceDM(Signature signature, Signature signatureNiu, LocalDate administrationEffectiveStartDate, LocalDate administrationEffectiveEndDate, LocalDate amendedInTimeStartDate, LocalDate amendedInTimeEndDate, boolean onlyThoseWithIssue, int idPatient, Integer limit) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getMedicationSummaryServiceDM"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("administrationEffectiveStartDate1970", this.dayFrom1970(administrationEffectiveStartDate));
        post.put("administrationEffectiveEndDate1970", this.dayFrom1970(administrationEffectiveEndDate));
        post.put("amendedInTimeStartDate1970", this.dayFrom1970(amendedInTimeStartDate));
        post.put("amendedInTimeEndDate1970", this.dayFrom1970(amendedInTimeEndDate));
        post.put("limit", limit);
        post.put("onlyThoseWithIssue", onlyThoseWithIssue);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getMedicationDetailServiceDM(Signature signature, Signature signatureNiu, LocalDate administrationEffectiveStartDate, LocalDate administrationEffectiveEndDate, LocalDate amendedInTimeStartDate, LocalDate amendedInTimeEndDate, boolean onlyThoseWithIssue, NIU_OTHER_MEDICATION_DM niuMedicationDM, int idPatient, Integer limit) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getMedicationDetailServiceDM"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("administrationEffectiveStartDate1970", this.dayFrom1970(administrationEffectiveStartDate));
        post.put("administrationEffectiveEndDate1970", this.dayFrom1970(administrationEffectiveEndDate));
        post.put("amendedInTimeStartDate1970", this.dayFrom1970(amendedInTimeStartDate));
        post.put("amendedInTimeEndDate1970", this.dayFrom1970(amendedInTimeEndDate));
        post.put("limit", limit);
        post.put("onlyThoseWithIssue", onlyThoseWithIssue);
        post.put("criteria", this.serialize((Serializable)niuMedicationDM));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject retractPrescriptions1(Signature signature, int idPatient, Map<String, String> mapIds) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/retractPrescriptions1"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        post.put("criteria", this.serialize((Serializable)((Object)mapIds)));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject retractPrescriptions2(Signature signature, int idPatient, HashMap<String, ApprovedRequest<RetractRequestCriteria>> mapApprovedRequests) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/retractPrescriptions2"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        post.put("criteria", this.serialize(mapApprovedRequests));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject retractPrescription1(Signature signature, int idPatient, String prescriptionNiuValue, String prescriptionNiuVersion) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/retractPrescription1"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        post.put("prescriptionNiuValue", prescriptionNiuValue);
        post.put("prescriptionNiuVersion", prescriptionNiuVersion);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject retractPrescription2(Signature signature, int idPatient, String prescriptionNiuValue, String prescriptionNiuVersion, ApprovedRequest<RetractRequestCriteria> approvedRequest) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/retractPrescription2"), "application/octet-stream", "application/json");
        wb.disableStandardRetry();
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        post.put("prescriptionNiuValue", prescriptionNiuValue);
        post.put("prescriptionNiuVersion", prescriptionNiuVersion);
        post.put("criteria", this.serialize((Serializable)approvedRequest));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getLaboList(Signature signature, Signature signatureNiu, int idPatient, LocalDate startDate, LocalDate endDate, Integer limit, String clientUid, String channelName) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getLaboList"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("startDate", this.dayFrom1970(startDate));
        post.put("endDate", this.dayFrom1970(endDate));
        post.put("limit", limit);
        post.put("clientuid", clientUid);
        post.put("channelname", channelName);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getLaboReport(Signature signature, Signature signatureNiu, int idPatient, Code reportType, Id requestId) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getLaboReport"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("dataObject", this.serialize((Serializable)reportType));
        post.put("criteria", this.serialize((Serializable)requestId));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getLaboCumul(Signature signature, Signature signatureNiu, int idPatient, LocalDate startDate, LocalDate endDate, Code orderTest, Integer limit) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getLaboCumul"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("startDate", this.dayFrom1970(startDate));
        post.put("endDate", this.dayFrom1970(endDate));
        post.put("criteria", this.serialize((Serializable)orderTest));
        post.put("limit", limit);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject listImagingExam(Signature signature, Signature signatureNiu, int idPatient, LocalDate startDate, LocalDate endDate, Integer limit, String clientUid, String channelName) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/listImagingExam"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("startDate", this.dayFrom1970(startDate));
        post.put("endDate", this.dayFrom1970(endDate));
        post.put("limit", limit);
        post.put("clientuid", clientUid);
        post.put("channelname", channelName);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getImagingExam(Signature signature, Signature signatureNiu, int idPatient, Id studyIdentifier) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getImagingExam"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("criteria", this.serialize((Serializable)studyIdentifier));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject listPatientDischargeCareSummary(Signature signature, Signature signatureNiu, int idPatient, LocalDate startdate, LocalDate enddate, Boolean mostRecentByTypeIndicator) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/listPatientDischargeCareSummary"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("startdate", this.dayFrom1970(startdate));
        post.put("enddate", this.dayFrom1970(enddate));
        post.put("mostRecentByTypeIndicator", mostRecentByTypeIndicator);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject getPatientDischargeCareDetail(Signature signature, Signature signatureNiu, int idPatient, NIU_SH recordId, Boolean includeHistory) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/getPatientDischargeCareDetail"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("signatureNiu", this.serialize((Serializable)signatureNiu));
        post.put("id", idPatient);
        post.put("criteria", this.serialize((Serializable)recordId));
        post.put("includeHistory", includeHistory);
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }

    @Override
    public ReturnObject continueQuery(Signature signature, int idPatient, QueryContinuationCriteria criteria) {
        WebBuilderWithSession wb = this.buildWebBuilderWithSession(this.getSecureURI(DSQAccessor.getPath() + "/continueQuery"), "application/octet-stream", "application/json");
        HashMap<String, Object> post = new HashMap<String, Object>();
        post.put("signature", this.serialize((Serializable)signature));
        post.put("id", idPatient);
        post.put("criteria", this.serialize((Serializable)criteria));
        ReturnObject response = ((WebBuilder)wb).post(ReturnObject.class, post);
        return response;
    }
}

