/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.web.controller;

import ca.infodata.ofys.client.Application;
import ca.infodata.ofys.client.web.controller.AbstractWebController;
import ca.infodata.ofys.client.web.core.IServerRequest;
import ca.infodata.ofys.client.web.core.routes.GetOrWsPredicate;
import ca.infodata.ofys.client.web.core.routes.POSTPredicate;
import ca.infodata.ofys.client.web.core.routes.PathPredicate;
import ca.infodata.ofys.client.web.core.routes.RouterFunction;
import ca.infodata.ofys.client.web.core.routes.RouterFunctions;
import ca.infodata.ofys.data.middle.dataobjects.XPatient;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2b;
import ca.infodata.ofys.data.middle.dataobjects.b2b.XPatientB2bModifResponse;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.IDataObject;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.ui.dashboard.models.CPatient;
import ca.infodata.ofys.ui.dashboard.models.CPatientB2b;
import ca.infodata.ofys.ui.dashboard.models.CPatientB2bModif;
import ca.infodata.ofys.ui.dashboard.models.CPatientB2bModifResponse;

public class B2bController
extends AbstractWebController {
    @Override
    public RouterFunction<?> getRoutes() {
        return RouterFunctions.routes("/dashboard", RouterFunctions.route(new POSTPredicate("/b2b/send", PathPredicate.PathStrategy.EXACT), this::send, ReturnObject.class), RouterFunctions.route(new POSTPredicate("/b2b/save", PathPredicate.PathStrategy.EXACT), this::save, ReturnObject.class), RouterFunctions.route(new GetOrWsPredicate("/b2b/verifyInscription", PathPredicate.PathStrategy.EXACT), this::verifyInscription, ReturnObject.class), RouterFunctions.route(new GetOrWsPredicate("/b2b/getInscriptionBasicInfos", PathPredicate.PathStrategy.EXACT), this::getInscriptionBasicInfos, ReturnObject.class));
    }

    private ReturnObject send(IServerRequest request) {
        CPatientB2bModif modif = request.getPostBody(CPatientB2bModif.class);
        ReturnObject res = Application.get().getDataAccessors().getB2BAccessor().execute(modif.x());
        if (res.getObj() instanceof XPatientB2bModifResponse) {
            CPatientB2bModifResponse response = new CPatientB2bModifResponse((XPatientB2bModifResponse)res.getObj());
            res.setObj((Object)response);
        }
        return res;
    }

    private ReturnObject save(IServerRequest request) {
        CPatientB2b modif = request.getPostBody(CPatientB2b.class);
        XPatientB2b x = modif.x();
        ReturnObject res = Application.get().getDataAccessors().getB2BAccessor().save((IDataObject)x, true);
        if (res != null && res.getStatus() != null && res.getObj() instanceof XPatient && res.getStatus().isOK()) {
            res.setObj((Object)new CPatient((XPatient)res.getObj()));
        }
        return res;
    }

    private ReturnObject verifyInscription(IServerRequest request) {
        String nam = request.getRequiredQueryParam("nam");
        return Application.get().getDataAccessors().getB2BAccessor().verify(nam);
    }

    private ReturnObject getInscriptionBasicInfos(IServerRequest request) {
        String nam = request.getRequiredQueryParam("nam");
        return Application.get().getDataAccessors().getB2BAccessor().getInscriptionBasicInfos(nam);
    }
}

