/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.modules.dsq.internal;

import ca.infodata.dsq.service.dm.DMQRYCSvc.QueryContinuationResult;
import ca.infodata.dsq.service.sommhosp.list.PatientDischargeCareSummary;
import ca.infodata.ofys.client.modules.dsq.DsqCallback;
import ca.infodata.ofys.client.modules.dsq.internal.GetCandidateController;
import ca.infodata.ofys.client.modules.dsq.internal.ListDischargeCareSummaryController;
import ca.infodata.ofys.client.web.core.IWebSocketChannel;
import ca.infodata.ofys.client.web.core.ServerResponses;
import ca.infodata.ofys.data.middle.dataobjects.CDsqDmeObjectList;
import ca.infodata.ofys.data.middle.dataobjects.Messages;
import ca.infodata.ofys.data.middle.dataobjects.interfaces.ReturnObject;
import ca.infodata.ofys.status.IStatus;
import ca.infodata.ofys.status.MultiStatus;
import ca.infodata.ofys.status.Status;
import ca.infodata.ofys.status.StatusException;
import ca.infodata.ofys.ui.dashboard.models.CDSQResult;
import ca.infodata.ofys.ui.dashboard.models.CDsqRequest;
import ca.infodata.ofys.ui.dashboard.models.CPatientDischargeCareSummary;
import ca.infodata.ofys.ui.dashboard.models.Utils;
import ca.infodata.util1.StringUtils;
import ca.infodata.util1.date.IPartialDate;
import ca.infodata.util1.date.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListDischargeCareSummaryControllerWeb {
    private static final Logger logger = Logger.getLogger(ListDischargeCareSummaryControllerWeb.class.getName());
    private static final String channelName = "dsq.sommhosp.search";
    private Integer idPatient;
    private IWebSocketChannel wsChannel;
    private ListDischargeCareSummaryController controller;

    public ListDischargeCareSummaryControllerWeb(Integer idPatient, IWebSocketChannel channel, GetCandidateController findCandidateAction) {
        this.idPatient = idPatient;
        this.wsChannel = channel;
        this.controller = new ListDischargeCareSummaryController(idPatient, findCandidateAction){

            @Override
            public void callback(DsqCallback<QueryContinuationResult> dsqCallback) {
                ListDischargeCareSummaryControllerWeb.this.callback(dsqCallback);
            }
        };
    }

    public void list(CDsqRequest dsqRequest) {
        if (dsqRequest == null) {
            throw new NullPointerException("dsqRequest");
        }
        if (dsqRequest.patientId == null) {
            throw new NullPointerException("dsqRequest.patientId");
        }
        if (!dsqRequest.patientId.equals(this.idPatient)) {
            throw new IllegalArgumentException("dsqRequest.patientId != controller.patient.id");
        }
        try {
            this.controller.setStart(CDsqRequest.parseLocalDateSafe(dsqRequest.start));
            this.controller.setEnd(CDsqRequest.parseLocalDateSafe(dsqRequest.end));
            this.controller.setMostRecentByTypeIndicator(dsqRequest.mostRecentByTypeIndicator);
            MultiStatus status = this.controller.valid();
            if (status.isOK()) {
                this.controller.list();
            } else {
                ServerResponses.sendJsonToClient(this.wsChannel, channelName, new ReturnObject(status));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while listing SH", e);
            this.sendErrorMessage(Messages.getString((String)"UNE_ERREUR_INNATENDUE_EST_SURVENUE", (String[])new String[0]));
        }
    }

    protected void callback(DsqCallback<QueryContinuationResult> callback) {
        LocalDate start = this.controller.getStart();
        LocalDate end = this.controller.getEnd();
        CDsqDmeObjectList ol = new CDsqDmeObjectList.Builder().setIdPatient(this.idPatient.intValue()).setStartdate(start == null ? null : Integer.valueOf(start.dayFrom1970)).setEnddate(end == null ? null : Integer.valueOf(end.dayFrom1970)).setMostRecentByTypeIndicator(this.controller.getMostRecentByTypeIndicator()).setMethod(CDsqDmeObjectList.METHODS.listPatientDischargeCareSummary).setResult((QueryContinuationResult)callback.result).build();
        ReturnObject ro = new ReturnObject();
        MultiStatus ms = new MultiStatus();
        CDSQResult r = new CDSQResult();
        r.setCriteria(ol);
        if (ol.result != null) {
            List list = ol.result.dischargeCareSummaries;
            for (String warning : ol.result.dischargeCareSummariesWarnings) {
                ms.add((IStatus)new Status(IStatus.Severity.WARNING, warning));
            }
            Collections.sort(list, new Comparator<PatientDischargeCareSummary>(){

                @Override
                public int compare(PatientDischargeCareSummary o1, PatientDischargeCareSummary o2) {
                    return -o1.effectiveTimeEnd.compareTo((IPartialDate)o2.effectiveTimeEnd);
                }
            });
            String timeOfRequest = null;
            if (ol.timeOfDsqRequest > 0L) {
                timeOfRequest = Utils.longTodateStr(ol.timeOfDsqRequest, "yyyy-MM-dd HH:mm:ss");
            }
            ArrayList<CPatientDischargeCareSummary> clist = new ArrayList<CPatientDischargeCareSummary>(list.size());
            for (PatientDischargeCareSummary d : list) {
                clist.add(new CPatientDischargeCareSummary(d, timeOfRequest));
            }
            r.setList(clist);
        }
        ro.setObj(r);
        String message = callback.message;
        if (callback.exception != null) {
            if (StringUtils.isBlank((CharSequence)message)) {
                message = StringUtils.isNotBlank((String)callback.exception.getMessage()) ? callback.exception.getMessage() : callback.exception.getClass().getSimpleName();
            }
            if (callback.exception instanceof StatusException) {
                StatusException statusException = (StatusException)((Object)callback.exception);
                ms.setSeverity(statusException.getStatus().getSeverity());
            } else {
                ms.setSeverity(IStatus.Severity.ERROR);
            }
        } else {
            ms.setSeverity(IStatus.Severity.OK);
        }
        if (StringUtils.isNotBlank((String)message)) {
            ms.setMessage(message);
        }
        ro.setStatus(ms);
        ServerResponses.sendJsonToClient(this.wsChannel, channelName, ro);
    }

    private void sendErrorMessage(String message) {
        MultiStatus ms = new MultiStatus();
        ms.setSeverity(IStatus.Severity.ERROR);
        ms.setMessage(message);
        ReturnObject ro = new ReturnObject();
        ro.setStatus(ms);
        ServerResponses.sendJsonToClient(this.wsChannel, channelName, ro);
    }
}

