/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.ofys.client.job;

import ca.infodata.ofys.client.job.IJob;
import ca.infodata.ofys.client.job.IJobExecutor;
import ca.infodata.ofys.client.job.JobStatus;
import ca.infodata.util1.StringUtils;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobExecutorImpl
implements IJobExecutor {
    protected static final Logger logger = Logger.getLogger(JobExecutorImpl.class.getName());
    protected ScheduledThreadPoolExecutor executor;

    public JobExecutorImpl() {
        this.executor = new ScheduledThreadPoolExecutor(16, new ThreadFactoryBuilder().setNameFormat("job-%d").setDaemon(true).setPriority(5).build());
    }

    public JobExecutorImpl(ScheduledThreadPoolExecutor executor) {
        if (executor == null) {
            throw new NullPointerException("executor");
        }
        this.executor = executor;
    }

    @Override
    public Future<Void> schedule(IJob<Void> job) throws Exception {
        if (job == null) {
            throw new IllegalArgumentException("cannot schedule null job");
        }
        try {
            JobDelegate delegate = new JobDelegate(job);
            Future<Void> future = this.executor.submit(delegate);
            job.changeStatus(JobStatus.SUBMITED);
            return future;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error submitting job. Rethrowing exceptin. job=" + StringUtils.safeToString((Logger)logger, job), e);
            throw e;
        }
    }

    @Override
    public Future<Void> schedule(IJob<Void> job, long delay, TimeUnit unit) throws Exception {
        return this.executor.schedule(job, delay, unit);
    }

    @Override
    public Future<Void> scheduleAtFixedRate(IJob<Void> job, long initialDelay, long period, TimeUnit unit) throws Exception {
        return this.executor.scheduleAtFixedRate(job, initialDelay, period, unit);
    }

    @Override
    public void dispose() {
        this.executor.shutdown();
    }

    protected static class JobDelegate
    implements Callable<Void> {
        private IJob<Void> job;

        public JobDelegate(IJob<Void> job) {
            this.job = job;
        }

        @Override
        public Void call() throws Exception {
            this.job.changeStatus(JobStatus.RUNNING);
            try {
                this.job.call();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error executing job " + StringUtils.safeToString((Logger)logger, this.job), e);
            }
            finally {
                this.job.changeStatus(JobStatus.DONE);
            }
            return null;
        }
    }
}

