/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.datatypes;

import com.hivemq.client.internal.mqtt.datatypes.MqttSharedTopicFilterImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttTopicFilterImpl;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.NotNull;
import com.hivemq.client.internal.shaded.org.jetbrains.annotations.Nullable;
import com.hivemq.client.internal.util.Checks;
import com.hivemq.client.mqtt.datatypes.MqttSharedTopicFilterBuilder;
import com.hivemq.client.mqtt.datatypes.MqttTopicFilterBuilder;
import java.util.function.Function;

public abstract class MqttTopicFilterImplBuilder<B extends MqttTopicFilterImplBuilder<B>> {
    @Nullable
    StringBuilder stringBuilder;

    MqttTopicFilterImplBuilder() {
    }

    MqttTopicFilterImplBuilder(@NotNull String baseTopicFilter) {
        this.stringBuilder = new StringBuilder(baseTopicFilter);
    }

    MqttTopicFilterImplBuilder(@NotNull MqttTopicFilterImpl topicFilter) {
        this.stringBuilder = new StringBuilder(topicFilter.getTopicFilterString());
    }

    @NotNull
    abstract B self();

    @NotNull
    public B addLevel(@Nullable String topicLevel) {
        Checks.notEmpty(topicLevel, "Topic level");
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder(topicLevel);
        } else {
            this.stringBuilder.append('/').append(topicLevel);
        }
        return this.self();
    }

    @NotNull
    public B singleLevelWildcard() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
        } else {
            this.stringBuilder.append('/');
        }
        this.stringBuilder.append('+');
        return this.self();
    }

    @NotNull
    public B multiLevelWildcard() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder(1);
        } else {
            this.stringBuilder.append('/');
        }
        this.stringBuilder.append('#');
        return this.self();
    }

    public static class SharedNested<P>
    extends SharedBase<SharedNested<P>>
    implements MqttSharedTopicFilterBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super MqttSharedTopicFilterImpl, P> parentConsumer;

        SharedNested(@Nullable String shareName, @NotNull Function<? super MqttSharedTopicFilterImpl, P> parentConsumer) {
            super(shareName);
            this.parentConsumer = parentConsumer;
        }

        SharedNested(@Nullable String shareName, @NotNull String baseTopicFilter, @NotNull Function<? super MqttSharedTopicFilterImpl, P> parentConsumer) {
            super(shareName, baseTopicFilter);
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        SharedNested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public P applyTopicFilter() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class SharedDefault
    extends SharedBase<SharedDefault>
    implements MqttSharedTopicFilterBuilder.Complete {
        public SharedDefault(@Nullable String shareName) {
            super(shareName);
        }

        SharedDefault(@Nullable String shareName, @NotNull String baseTopicFilter) {
            super(shareName, baseTopicFilter);
        }

        SharedDefault(@NotNull MqttSharedTopicFilterImpl sharedTopicFilter) {
            super(sharedTopicFilter);
        }

        @Override
        @NotNull
        SharedDefault self() {
            return this;
        }
    }

    public static abstract class SharedBase<B extends SharedBase<B>>
    extends MqttTopicFilterImplBuilder<B> {
        @NotNull
        private String shareName;

        SharedBase(@Nullable String shareName) {
            this.shareName = Checks.notNull(shareName, "Share name");
        }

        SharedBase(@Nullable String shareName, @NotNull String baseTopicFilter) {
            super(baseTopicFilter);
            this.shareName = Checks.notNull(shareName, "Share name");
        }

        SharedBase(@NotNull MqttSharedTopicFilterImpl sharedTopicFilter) {
            super(sharedTopicFilter);
            this.shareName = sharedTopicFilter.getShareName();
        }

        @NotNull
        public B share(@Nullable String shareName) {
            this.shareName = Checks.notNull(shareName, "Share name");
            return (B)((SharedBase)this.self());
        }

        @NotNull
        public MqttSharedTopicFilterImpl build() {
            Checks.state(this.stringBuilder != null, "At least one topic level must be added.");
            String string = this.stringBuilder.toString();
            Checks.state(!string.isEmpty(), "Topic must be at least one character long.");
            return MqttSharedTopicFilterImpl.of(this.shareName, string);
        }
    }

    public static class Nested<P>
    extends Base<Nested<P>>
    implements MqttTopicFilterBuilder.Nested.Complete<P> {
        @NotNull
        private final Function<? super MqttTopicFilterImpl, P> parentConsumer;

        public Nested(@NotNull Function<? super MqttTopicFilterImpl, P> parentConsumer) {
            this.parentConsumer = parentConsumer;
        }

        @Override
        @NotNull
        Nested<P> self() {
            return this;
        }

        @Override
        @NotNull
        public SharedNested<P> share(@Nullable String shareName) {
            if (this.stringBuilder == null) {
                return new SharedNested<P>(shareName, this.parentConsumer);
            }
            return new SharedNested<P>(shareName, this.stringBuilder.toString(), this.parentConsumer);
        }

        @Override
        @NotNull
        public P applyTopicFilter() {
            return this.parentConsumer.apply(this.build());
        }
    }

    public static class Default
    extends Base<Default>
    implements MqttTopicFilterBuilder.Complete {
        public Default() {
        }

        Default(@NotNull String baseTopicFilter) {
            super(baseTopicFilter);
        }

        Default(@NotNull MqttTopicFilterImpl topicFilter) {
            super(topicFilter);
        }

        @Override
        @NotNull
        Default self() {
            return this;
        }

        @Override
        @NotNull
        public SharedDefault share(@Nullable String shareName) {
            if (this.stringBuilder == null) {
                return new SharedDefault(shareName);
            }
            return new SharedDefault(shareName, this.stringBuilder.toString());
        }
    }

    public static abstract class Base<B extends Base<B>>
    extends MqttTopicFilterImplBuilder<B> {
        Base() {
        }

        Base(@NotNull String baseTopicFilter) {
            super(baseTopicFilter);
        }

        Base(@NotNull MqttTopicFilterImpl topicFilter) {
            super(topicFilter);
        }

        @NotNull
        public MqttTopicFilterImpl build() {
            Checks.state(this.stringBuilder != null, "At least one topic level must be added.");
            String string = this.stringBuilder.toString();
            Checks.state(!string.isEmpty(), "Topic must be at least one character long.");
            return MqttTopicFilterImpl.of(string);
        }
    }
}

