/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.util1;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class CustomProperties
implements Map<String, String> {
    private final InternalProperties properties;
    private final Map<String, String> commentMap;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public CustomProperties(CustomProperties properties) {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.properties = new InternalProperties(properties.properties.map);
        this.commentMap = new HashMap<String, String>(properties.commentMap);
    }

    public CustomProperties(Map<String, String> underlyingMap) {
        if (underlyingMap == null) {
            throw new NullPointerException("underlyingMap");
        }
        this.properties = new InternalProperties(underlyingMap);
        this.commentMap = new HashMap<String, String>();
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        Set<Map.Entry<String, String>> entrySet = this.properties.entrySet();
        return entrySet;
    }

    @Override
    public String get(Object key) {
        return (String)this.properties.get(key);
    }

    public String getProperty(Object key) {
        return (String)this.properties.get(key);
    }

    public String getProperty(Object key, String defaultValue) {
        String val = (String)this.properties.get(key);
        return val == null ? defaultValue : val;
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        Set<Object> keySet = this.properties.keySet();
        return keySet;
    }

    @Override
    public String put(String key, String value) {
        return (String)this.properties.put(key, value);
    }

    public String setProperty(String key, String value) {
        return (String)this.properties.put(key, value);
    }

    public void setComment(String key, String comment) {
        this.commentMap.put(key, comment);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.properties.putAll((Map<? extends Object, ? extends Object>)m);
    }

    @Override
    public String remove(Object key) {
        return (String)this.properties.remove(key);
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public String toString() {
        return this.properties.toString();
    }

    @Override
    public Collection<String> values() {
        Collection<Object> values = this.properties.values();
        return values;
    }

    public boolean contains(Object value) {
        return this.properties.contains(value);
    }

    @Override
    public int hashCode() {
        return this.properties.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.properties.equals(obj);
    }

    public void load(Reader reader) throws IOException {
        this.properties.load(reader);
    }

    public void load(InputStream inStream) throws IOException {
        this.properties.load(inStream);
    }

    public void loadFromXML(InputStream in) throws IOException, InvalidPropertiesFormatException {
        this.properties.loadFromXML(in);
    }

    public void list(PrintStream out) {
        this.properties.list(out);
    }

    public void list(PrintWriter out) {
        this.properties.list(out);
    }

    public void store(Writer writer, String comments) throws IOException {
        this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comments, false);
    }

    public void store(OutputStream out, String comments) throws IOException {
        this.store0(new BufferedWriter(new OutputStreamWriter(out, "8859_1")), comments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bw, String comments, boolean escUnicode) throws IOException {
        if (comments != null) {
            CustomProperties.writeComments(bw, comments);
        }
        bw.write("#" + new Date().toString());
        bw.newLine();
        CustomProperties customProperties = this;
        synchronized (customProperties) {
            for (Map.Entry<String, String> e : this.entrySet()) {
                String comment = this.commentMap.get(e.getKey());
                if (comment != null) {
                    CustomProperties.writeComments(bw, comment);
                }
                String key = e.getKey();
                String val = e.getValue();
                key = this.saveConvert(key, true, escUnicode);
                val = this.saveConvert(val, false, escUnicode);
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(CustomProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(CustomProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(CustomProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(CustomProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        bw.write("#");
        int len = comments.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = CustomProperties.toHex(c >> 12 & 0xF);
                uu[3] = CustomProperties.toHex(c >> 8 & 0xF);
                uu[4] = CustomProperties.toHex(c >> 4 & 0xF);
                uu[5] = CustomProperties.toHex(c & 0xF);
                bw.write(new String(uu));
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    private static class InternalProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final Map<Object, Object> map;

        protected InternalProperties(Map underlyingMap) {
            this.map = underlyingMap;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Object clone() {
            throw new RuntimeException(new CloneNotSupportedException());
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public Object get(Object key) {
            return this.map.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<Object> keySet() {
            return this.map.keySet();
        }

        @Override
        public Object put(Object key, Object value) {
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map<? extends Object, ? extends Object> m) {
            this.map.putAll(m);
        }

        @Override
        public Object remove(Object key) {
            return this.map.remove(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public String toString() {
            return this.map.toString();
        }

        @Override
        public Collection<Object> values() {
            return this.map.values();
        }

        @Override
        public String getProperty(String key) {
            return (String)this.map.get(key);
        }

        @Override
        public String getProperty(String key, String defaultValue) {
            Object value = this.get(key);
            if (value == null) {
                return defaultValue;
            }
            return (String)value;
        }

        @Override
        public Enumeration<?> propertyNames() {
            return Collections.enumeration(this.map.keySet());
        }

        @Override
        public synchronized Object setProperty(String key, String value) {
            return this.put(key, value);
        }

        @Override
        public Set<String> stringPropertyNames() {
            Set<Object> keys = this.map.keySet();
            return keys;
        }

        @Override
        public synchronized boolean contains(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public synchronized Enumeration<Object> elements() {
            return Collections.enumeration(this.map.values());
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(this.map.keySet());
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof InternalProperties)) {
                return false;
            }
            InternalProperties other = (InternalProperties)obj;
            return !(this.map == null ? other.map != null : !this.map.equals(other.map));
        }
    }
}

